<?php
class AgentModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs			= null;
	private $year		= NO_STRING;		// 検索年
	private $month		= NO_STRING;		// 検索月
	private $agentCode	= NO_STRING;		// エージェントコード

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// 変数宣言部
		$date = NO_STRING;

		if($this -> getPosParameter(PARAM_DATE) == NO_STRING) {		// 日付未指定（最新日付）

			// 現在の日時を取得
			$date = getdate();

			$this -> year		= $date[PARAM_YEAR];	// 検索年
			$this -> month		= $date[PARAM_MON];		// 検索月

		} else {													// 日付指定

			// 日付の分割
			$date = explode(DELIMIT_HYPHEN, $this -> getPosParameter(PARAM_DATE));

			$this -> year		= $this -> getColumnData($date, NO_COUNT);		// 検索年
			$this -> month		= $this -> getColumnData($date, VAL_INT_1);		// 検索月
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn	= false;
		$rs		= null;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// エージェントが存在する
		if($this -> getUserData(PARAM_AGENT_CODE) != NO_STRING) {
			$rtn = true;
			$this -> setType(TYPE_DETAIL);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索月の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispSearchDate() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$cnt			= NO_COUNT;
		$currentDate	= NO_STRING;
		$lists			= array();

		// 月数のループ（とりあえず1年）
		for($cnt = NO_COUNT; $cnt < VAL_INT_12; $cnt++) {

			$date = date('Y-m', strtotime('-' . $cnt  . ' month'));

			$lists[] = array(PARAM_DATA_KEY	=> date('Y-m', strtotime('-' . $cnt  . ' month'))
						, PARAM_DATA_VALUE	=> date('Y-m', strtotime('-' . $cnt  . ' month')));
		}

		echo $this -> dispListOption($lists, $this -> getPosParameter(PARAM_DATE));
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoAgentCommissionHeader() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$currencies	= null;

		$currencies			= $this -> getCurrencyList();
		$this -> currencies	= array();

		// データの存在確認
		if($this -> isLoopData($currencies)) {
			foreach($currencies as $currency) {
				$rtn .= '<th class="w10p">' . $currency[PARAM_DATA_VALUE] . '</th>';

				// データストック用
				$this -> currencies[$currency[PARAM_DATA_VALUE]] = array();
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoAgentCommissionList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$lists			= array();
		$fees			= null;
		$commissionData	= NO_STRING;
		$title			= NO_STRING;
		$row			= null;
		$totalRow		= array();

		// まずはデータを入れなおす
		foreach($this -> rs as $row) {

			// キーデータ
			$fee		= $row[COLUMN_M_F_ID];
			$walletType	= $row[COLUMN_WALLET_TYPE];
			$currency	= $row[COLUMN_CURRENCY];

			$lists[$fee][$walletType][$currency] = $row;
		}

		if($this -> isLoopData($lists)) {

			foreach($lists as $fee) {

				foreach($fee as $walletType => $currency) {

					$commissionData = NO_STRING;

					foreach($this -> currencies as $key => $val) {

						$row = $this -> getColumnData($currency, $key);

						if($row != NO_STRING) {
							$title = $this -> getColumnData($row, COLUMN_FEE_NAME) . '(' . $this -> getColumnData($row, COLUMN_COMMISION_TYPE) . ')';
						}

						$data = intval($this -> getColumnData($row, COLUMN_FIX) + $this -> getColumnData($row, COLUMN_PERCENT));

						if(isset($totalRow[$key])) {
							$totalRow[$key] += $data;
						} else {
							$totalRow[$key] = $data;
						}


						// データの取り出し
						$commissionData	.=  '<td class="r">' . $this -> getAmountString($data, $key) . '</td>';
					}

					$rtn	.= '<tr>'
							. '<td>' . $title . '</td>'
									. $commissionData
									. '</tr>';
				}
			}

			// 合計行の取得
			$rtn .= '<tr class="sum">'
					. '<th>合計</th>';

			foreach($this -> currencies as $key => $val) {
				$rtn .= '<td class="r">' . $this -> getAmountString($totalRow[$key], $key) . '</td>';
			}

			$rtn .= '</tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションデータ取得用パラメータ取得
	* @parameter	: なし
	* @return		: コミッションデータ取得用パラメータ
	-------------------------------------------------------------------------*/
	public function getSelectData() {

		// 変数宣言部
		$params	= array();

		$params[] = $this -> getUserData(PARAM_AGENT_CODE);
		$params[] = $this -> year;
		$params[] = $this -> month;

		return $params;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}
}
?>