<?php
require_once(SYSTEM_LOGICS . 'deposit/model.php');

class LogicDeposit extends DepositModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType() == TYPE_CONFIRM) {				// アップロードのファイルデータのロード
					// 何もしない
				} else if($this -> getType() == TYPE_COMPLETE) {		// アップロードのファイルデータの登録

					$this -> load($this -> getTmpPath());
					$this -> regist();
					$this -> lists();
				} else if($this -> getType() == TYPE_DETAIL) {			// 詳細の表示
					$this -> select();
					$this -> restore();
				} else if($this -> getType() == TYPE_EXPORT) {			// アップロードファイルの取得
					$this -> selectFileName();
					$this -> lists();
				} else if($this -> getType() == TYPE_EXPORT_ERROR) {	// エラーファイルの取得
					$this -> selectFileName();
					$this -> lists();
				} else if($this -> getType() == TYPE_EXPORT_COMMON) {	// エラーファイルの取得
                    $this -> lists();
                    $this -> exportData();

				} else if($this -> getType() == TYPE_UPDATE) {			// 更新処理
					$this -> update();
					$this -> select();
					$this -> restore();
					$this -> insertActivity();
				}else if($this -> getType() == TYPE_DELETE) {			// 更新処理
					$this -> insertActivity();
					$this -> deleteTransaction();
					$this -> lists();
				} else {
					$this -> lists();
				}

				$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_DEPOSIT', array($this -> getWhere_new())));
		$this -> setTotal($this -> accessSelect('LIST_DEPOSIT_TOTAL', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金詳細の表示
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
		$this -> setDetail($this -> accessSelect('SELECT_DEPOSIT', $this -> getDetailDatas()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: アップロードデータのロード
	* @parameter	: ロードファイルのパス
	* @return		: なし
	-------------------------------------------------------------------------*/
	function load($path) {

		// ファイルのロード
		$tmpFile = fopen($path, 'r');

		// CSV配列へ変換
		while ($csv[] = fgetcsv($tmpFile, VAL_INT_1024)) {}

		// 配列 $csv の文字コードをSJIS-winからUTF-8に変換
// 		mb_convert_variables(CHAR_SET_UTF_8, CHAR_SET_AUTO, $csv);
// 		mb_convert_variables(CHAR_SET_UTF_8, CHAR_SET_SJIS, $csv);

		// タイトル行の削除
		$csv = array_splice($csv, VAL_INT_1);

		$this -> setCsv($csv);

		fclose($tmpFile);
	}

	/*-------------------------------------------------------------------------
	* @function_name: アップロードデータの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {

		// 変数宣言部
		$csv		= $this -> getCsv();
		$params		= null;
		$newFName	= $this -> getNewFilename();
		$account	= NO_STRING;
		$currency	= NO_STRING;
		$amount		= NO_STRING;
		$flg		= true;
		$cnt 		= NO_COUNT;

		foreach($csv as $row) {

			// エラーでは無い行のみインサート
			if(count($row) == VAL_INT_10 && $row[VAL_INT_8] == NO_COUNT) {

				$account	= $row[NO_COUNT];
				$currency	= $row[VAL_INT_1];
				$amount		= $row[VAL_INT_2];

				// 手数料設定
				$fee = $this -> getFee($amount, $currency, $account);

				// 登録用パラメータの作成
				$params		= array();
				$params[]	= $row[NO_COUNT];												// 口座番号
				$params[]	= $this -> currencyToInt($row[VAL_INT_2], $row[VAL_INT_1]);		// 入金金額
				$params[]	= $row[VAL_INT_1];												// 通貨
				$params[]	= $row[VAL_INT_3];												// 入金日
				$params[]	= $row[VAL_INT_4];												// 入金銀行
				$params[]	= $row[VAL_INT_5];												// メッセージ
				$params[]	= $row[VAL_INT_6];												// コメント
				$params[]	= $this -> getAdminUserData(COLUMN_USER_ACCOUNT);				// アップロードファイル名
				$params[]	= basename($this -> getTmpPath());								// 担当ユーザ
				$params[]	= $newFName;													// 新ファイル名
				$params[]	= $this -> currencyToInt($fee, $currency);						// 手数料
				$params[]	= $this -> getErrFlg();											// エラーフラグ
				$params[]	= VAL_INT_2;													// 一旦保留にしておく
				$params[]	= $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);	// 取引番号
				$params[]	= date("Y-m-d H:i:s");											// date/time

				if($cnt == NO_COUNT) {
					if(!$this -> accessModify('INSERT_DEPOSIT', $params)) {
						
						$flg = false;
						break;
					}
					$this -> accessModify('INSERT_ACTIVITY', array($this -> getAdminUserData(PARAM_UID)
															, $_SERVER[PARAM_REMOTE_ADDR]
															, $_SERVER[PARAM_HTTP_USER_AGENT]
															, VAL_INT_15
															, $params[14]
															, 'Created/Imported transaction '.'['.$params[13].']'.'['.$params[8].']'));

					// コミッションの登録
					$this -> registCommision(VAR_DEPOSIT
											, $this -> getAgentCode()
											, $row[NO_COUNT]
											, $currency
											, $fee);

					$cnt++;

				} else {
					$this -> accessModify('INSERT_DEPOSIT', $params, false);

					$this -> accessModify('INSERT_ACTIVITY', array($this -> getAdminUserData(PARAM_UID)
															, $_SERVER[PARAM_REMOTE_ADDR]
															, $_SERVER[PARAM_HTTP_USER_AGENT]
															, VAL_INT_15
															, $params[14]
															, 'Created/Imported transaction '.'['.$params[13].']'.'['.$params[8].']'));

					$this -> registCommision(VAR_DEPOSIT
											, $this -> getAgentCode()
											, $row[NO_COUNT]
											, $currency
											, $fee);
				}
			}
		}

		// リロード対策
		if($flg) {

			// 即時入金バッチを流す
			$this -> changeDepositType();

			// 最後にファイル名の変更
			rename($this -> getTmpPath(), SYSTEM_DOCUMENT_DOPOSIT . $newFName . '.csv');
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function selectFileName() {

		// 変数宣言部
		$rs			= null;
		$oldName	= NO_STRING;
		$newName	= NO_STRING;

		$rs = $this -> accessSelect('SELECT_DEPOSIT', $this -> getDetailDatas());

		if($this -> isLoopData($rs)) {
			$oldName = $this -> getColumnData($rs[NO_COUNT], COLUMN_OLD_FILENAME);
			$newName = $this -> getColumnData($rs[NO_COUNT], COLUMN_NEW_FILENAME);
		}

		$this -> setOldFileName($oldName);
		$this -> setNewFileName($newName);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {

		$this -> accessModify('UPDATE_DEPOSIT_COMMENT', $this -> getUpdateParams(), false);

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	function deleteTransaction() {
		$this -> accessModify('COPY_DEPOSIT_TRANSACTION', $this -> getDetailDatas());
		$this -> accessModify('DELETE_DEPOSIT_TRANSACTION', $this -> getDetailDatas());

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
	}

    function makeExportData(){
        $rtn  = NO_STRING;

        $rtn = (
        		$this -> lang == "en" ?
        		"Import Date,Transaction Number,Account Number,Account Category,Currency,Amount,Fee,Bank Name,Processing Date,Import File,Error,Check,Administrator's Note\n" :
        		'インポート日時,取引番号,口座番号,口座カテゴリー,通貨,金額,手数料,銀行名,処理日時,インポートファイル名,エラー,チェック,管理者メモ' . "\n"
        		);

        $rtn .= $this -> getExportDetails();

        return $rtn;
    }

    /*-------------------------------------------------------------------------
    * @function_name: exportData
    * @parameter	:
    * @return		:
    -------------------------------------------------------------------------*/
    function exportData(){
        $fileName = 'Deposit Processing_' . str_replace("/", "", 
                $this -> getDataPost(PARAM_S_FROM, true, true, true) . '-' 
                . $this -> getDataPost(PARAM_S_TO, true, true, true)
            ) . '_' . $this -> getDataPost(PARAM_CURRENCY, true, true, true);

        header('Content-Encoding: UTF-8');
        header("Content-type: text/csv; charset=UTF-8");
        header('Content-Disposition: attachment; filename="' . $fileName . '.csv"');
        header('Content-Transfer-Encoding: binary');

        echo "\xEF\xBB\xBF";
        echo trim($this -> makeExportData());
        exit();
    }

    /*-------------------------------------------------------------------------
    * @function_name: insertActivity
    * @parameter	:
    * @return		:
    -------------------------------------------------------------------------*/

    function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}
}
?>
