<?php
require_once('config.php');

class APIGetUserInfo extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;
		$account	= null;
		$rs 		= array();

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'U' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			$account = $this -> getRowData($this -> getAccountCommon($this -> account));

			$rs[PARAM_USER_NAME]		= $this -> getColumnData($account, COLUMN_USER_NAME);
			$rs[PARAM_ACCOUNT_TYPE] 	= $this -> getColumnData($account, COLUMN_ACCOUNT_TYPE);
			$rs[PARAM_TEL]				= $this -> getColumnData($account, COLUMN_TEL);
			$rs[PARAM_LAST_NAME]		= $this -> getColumnData($account, COLUMN_LAST_NAME);
			$rs[PARAM_FIRST_NAME]		= $this -> getColumnData($account, COLUMN_FIRST_NAME);
			$rs[PARAM_BIRTH]			= $this -> getColumnData($account, COLUMN_BIRTH_STRING);
			$rs[PARAM_COUNTRY]			= $this -> getColumnData($account, COLUMN_COUNTRY);
			$rs[PARAM_STATE]			= $this -> getColumnData($account, COLUMN_STATE);
			$rs[PARAM_CITY]				= $this -> getColumnData($account, COLUMN_CITY);
			$rs[PARAM_ZIP_CODE]			= $this -> getColumnData($account, COLUMN_ZIP_CODE);
			$rs[PARAM_ADDRESS]			= $this -> getColumnData($account, COLUMN_ADDRESS);
			$rs[PARAM_CEO_FIRST_NAME]	= $this -> getColumnData($account, COLUMN_CEO_FIRST_NAME);
			$rs[PARAM_CEO_LAST_NAME]	= $this -> getColumnData($account, COLUMN_CEO_LAST_NAME);
			$rs[PARAM_SITE_NAME]		= $this -> getColumnData($account, COLUMN_SITE_NAME);
			$rs[PARAM_SITE_URL]			= $this -> getColumnData($account, COLUMN_SITE_URL);

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'
								, 'account'		=> $rs));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {}
}

$api = new APIGetUserInfo();
$api -> action();
?>