<?php
class ModelClassEx extends Checker {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $type		= NO_STRING;	// タイプ
	private $lang		= NO_STRING;	// コントロール言語
	private $action		= NO_STRING;	// アクション

	// ------------------ ページャ系 ------------------//
	private $targetPage	= NO_COUNT;		// 表示ページ
	private $exportData	= NO_STRING;	// エクスポートデータ
	// ------------------ ページャ系 ------------------//

	// ------------------ 手数料系 ------------------//
	private $fee		= NO_STRING;	// 手数料
	private $fee2		= NO_STRING;	// 手数料2
	private $agent1		= NO_STRING;	// エージェントコード1
	private $agent2		= NO_STRING;	// エージェントコード2
	private $rate		= NO_STRING;	// レート
	// ------------------ 手数料系 ------------------//

	/*-------------------------------------------------------------------------
	* @function_name: モデル基底クラスのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();

		// 取得言語を設定（多言語対応）
		if(isset($_SERVER)) {
			if($_SERVER[VAR_URI]) {

				$arr = explode(DELIMIT_SLASH, $_SERVER[VAR_URI]);

				if(count($arr) > VAL_INT_1) {
					if($arr[VAL_INT_1] == 'api') {
						$this -> lang = VAR_DEFAULT_LANGAGE;
					} else {
						$this -> lang = $arr[VAL_INT_1];
						$this -> sanitizeString($this -> lang);
					}

				} else {
					$this -> lang = VAR_DEFAULT_LANGAGE;
				}
			}
		} else {
			$this -> lang = VAR_DEFAULT_LANGAGE;
		}

		// Getがある場合
		if($this -> getDataGet(PARAM_TYPE) != NO_STRING) {
			$this -> type	= $this -> getDataGet(PARAM_TYPE);
		}

		// Postがある場合Post優先
		if($this -> getDataPost(PARAM_TYPE) != NO_STRING) {
			$this -> type	= $this -> getDataPost(PARAM_TYPE);
		}

		$this -> action	= $this -> getDataPost(CONTROL_ACTION);

		// ------------------ ページャ系 ------------------//
		if(intval($this -> getDataPost(PARAM_TARGET_PAGE))		== NO_COUNT
			&& intval($this -> getDataGet(PARAM_TARGET_PAGE))	== NO_COUNT) {	// ページ未指定
			$this -> targetPage = VAL_INT_1;

		} else {															// ページ指定

			// まずは、GET
			if(intval($this -> getDataGet(PARAM_TARGET_PAGE)) != NO_COUNT) {
				$this -> targetPage = intval($this -> getDataGet(PARAM_TARGET_PAGE));
			}

			// ポストの方が優先される
			if(intval($this -> getDataPost(PARAM_TARGET_PAGE)) != NO_COUNT) {
				$this -> targetPage = intval($this -> getDataPost(PARAM_TARGET_PAGE));
			}
		}
		// ------------------ ページャ系 ------------------//
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @detail		: メンバの値を設定等々に使用
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function init() {}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @detail		: データの正当性をチェックする
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {}

	/*-------------------------------------------------------------------------
	* @function_name: ディレクトリ内ファイル削除
	* @detail		: ディレクトリ内のファイルを全て削除する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function directoryCleanUp($path) {

		// 変数宣言部
		$file;
		$handle;

		// ディレクトリの取得
		$handle = opendir($path);

		// ファイルの削除
		while(FALSE !== ($file = readdir($handle))) {

			if(is_file($path . '/' . $file)) {	// ファイルの場合

				// 以前のデータ削除
				unlink($path . '/' . $file);
			}
		}

		// ハンドルの削除
		closedir($handle);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ポストデータの取得
	* @parameter	: POSTデータID
	* @return		: POSTデ^タ
	-------------------------------------------------------------------------*/
	function getPosParameter($pId) {

		// 変数宣言部
		$rtn = NO_STRING;

		if(isset($_POST[$pId])) {
		    $rtn = $this -> sqlSanitation($_POST[$pId]);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ポストデータの設定
	* @parameter	: POSTデータID、POSTデータ値
	* @return		: POSTデ^タ
	-------------------------------------------------------------------------*/
	function setPosParameter($pId, $val) {
		$_POST[$pId] = $val;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロール値情報の取得
	* @parameter	: なし
	* @return		: コントロール値
	-------------------------------------------------------------------------*/
	function getLangage() {
		return $this -> lang;
	}

	/*-------------------------------------------------------------------------
	* @function_name: タイプの取得
	* @parameter	: なし
	* @return		: タイプ
	-------------------------------------------------------------------------*/
	function getType() {
		return $this -> type;
	}

	/*-------------------------------------------------------------------------
	* @function_name: タイプの設定
	* @parameter	: タイプ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setType($type = NO_STRING) {
		$this -> type = $type;
	}

	/*-------------------------------------------------------------------------
	* @function_name: アクションの取得
	* @parameter	: なし
	* @return		: アクション
	-------------------------------------------------------------------------*/
	function getAction() {
		return $this -> action;
	}

	/*-------------------------------------------------------------------------
	* @function_name: アクションの設定
	* @parameter	: アクション
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setAction($action = NO_STRING) {
		$this -> action = $action;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取得ページの取得
	* @parameter	: なし
	* @return		: 取得ページ
	-------------------------------------------------------------------------*/
	function getTargetPage() {
		return $this -> targetPage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取得ページの設定
	* @parameter	: 取得ページ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setTargetPage($targetPage) {
		$this -> targetPage = $targetPage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料1の取得
	* @parameter	: なし
	* @return		: 手数料1
	-------------------------------------------------------------------------*/
	function getFeeEx() {
		return $this -> fee;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料2の取得
	* @parameter	: なし
	* @return		: 手数料2
	-------------------------------------------------------------------------*/
	function getFee2Ex() {
		return $this -> fee2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコード1の取得
	* @parameter	: なし
	* @return		: エージェントコード1
	-------------------------------------------------------------------------*/
	function getAgent1Ex() {
		return $this -> agent1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコード2の取得
	* @parameter	: なし
	* @return		: エージェントコード2
	-------------------------------------------------------------------------*/
	function getAgent2Ex() {
		return $this -> agent2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: レートの取得
	* @parameter	: なし
	* @return		: レート
	-------------------------------------------------------------------------*/
	function getRateEx() {
		return $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料1の設定
	* @parameter	: 手数料1
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setFeeEx($fee) {
		$this -> fee = $fee;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料2の設定
	* @parameter	: 手数料2
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setFee2Ex($fee2) {
		return $this -> fee2 = $fee2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコード1の設定
	* @parameter	: エージェントコード1
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setAgent1Ex($agent1) {
		return $this -> agent1 = $agent1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコード2の設定
	* @parameter	: エージェントコード2
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setAgent2Ex($agent2) {
		return $this -> agent2 = $agent2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: レートの設定
	* @parameter	: レート
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setRateEx($rate) {
		return $this -> rate = $rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの作成（ページ数チェック付）
	* @parameter	: レート
	* @return		: なし
	-------------------------------------------------------------------------*/
	function getPagerCommon($curPage
							, $totalPage
							, $num
							, $toLink = NO_STRING
							, $export = false) {

		if($curPage > $totalPage) {
			$this -> setTargetPage($totalPage);
		}

		return 	$this -> getPagerCommonCore($this -> targetPage
											, $totalPage
											, $num
											, $toLink = NO_STRING
											, $export);
	}

	/*-------------------------------------------------------------------------
	* @function_name: エクスポートデータの取得
	* @parameter	: なし
	* @return		: CSVデータ
	-------------------------------------------------------------------------*/
	function getExportDataCommon() {
		return $this -> exportData;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エクスポートデータの設定
	* @parameter	: CSVデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setExportDataCommon($data) {
		$this -> exportData = $data;
	}
}
?>