<?php
require_once('config.php');
require_once('GetPlatinumCardAuthToken.php');

class APIGetPlemiumCardLoading extends System {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $result		= NO_STRING;
	private $amount		= NO_COUNT;

	/*-------------------------------------------------------------------------
	 * @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		ob_start();
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部

		try {

			// トークンの取得
			$objAuth		= new APIGetPlemiumCardAuthToken();
			$token			= $objAuth -> getToken();
			$cardId			= $this -> getPosParameter(PARAM_CARD_HOLDER_ID);
			$row			= $this -> getCardCommon($cardId);
			$proxy			= $this -> getColumnData($row, COLUMN_PROXY);
			$this -> amount	= $this -> getPosParameter(PARAM_AMOUNT);
			//transaction id的取得
			$refId		    = $this -> getPosParameter('refId');

			$balanceUrl = PLATINUM_CARD_ROOT_URL . 'users/' . $cardId . '/cards/' . $proxy . '/load';

			$curl = curl_init($balanceUrl); // 初期化！

			// 送信データ
			$params = array("transactionAmount" 	=> $this -> amount
							, "agentId"	=> "1508229"
							, "refId"	=> $refId
			);
			
// 			$params = array(
// 					'userid'			=> '1218675'
// 					, 'proxy'			=> '246654418652051'
// 					,
// 					'CardLoadRequest'	=> array(
// 							'sourceTxnId'			=> '50001'
// 							, 'transactionAmount'	=> '50000'
// 							, 'amount'	=> '500'
// 							, 'currencyCode'		=> 'USD'
// 							, 'channelType'			=> '1'
// 							, 'refId'				=> '112'
// // 							, 'agentId'				=> '707109'
// // 							, 'sourceTxnDateTime'	=> '2015-02-04T00:00:00.000+05:00'
// // 							, 'sourceName'			=> 'ProgramPartner'
// // 							, 'comments'			=> 'Card load'
// 					)

// 				$params = '{"transactionAmount": "500"}';
// 			);

			$options = array(
				CURLOPT_URL					=> $balanceUrl
				, CURLOPT_HTTPHEADER		=> array('Developerid:' . PLATINUM_CARD_DEVELOPER_ID
														, 'Developerpassword:' . PLATINUM_CARD_DEVELOPER_PASSWORD
														, 'X-Method-Override:login'
														, 'AuthenticationToken:' . $token
														, 'Content-Type:application/json'
// 														, 'Content-Type: text/javascript; charset=utf-8'
				)
				, CURLOPT_POSTFIELDS		=> json_encode($params)
				, CURLOPT_POST				=> true
				, CURLINFO_HEADER_OUT		=> true
				, CURLOPT_RETURNTRANSFER	=> true
			);

			curl_setopt_array($curl, $options);

			$result2		= curl_exec($curl);
			$result		= json_decode($result2, true);
			$this -> result = $result;

			//LOG写入
			$dir = "Logs/VPC_LOG_".date("Y-m-d");
			if(!is_dir($dir))
			{
				mkdir($dir);
				chmod($dir,0777);
			}

			$log = "Log_".date("Y-m-d H:i:s").'.log';//文件名及路径,在当前目录下新建aa.txt文件 
			$fopen = fopen($dir."/".$log,   'a+');//新建文件命令 
			fputs($fopen,   "--------------------------".date("Y-m-d H:i:s")."LOG---------------------------\r\n");
			fputs($fopen,   $result2."\r\n");
			fclose($fopen); 

			curl_close($curl);

		} catch (Exception $e) {
			ob_end_clean();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {
		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高の取得
	 * @parameter	: カード残高
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getResultJson() {

		// 変数宣言部
		$rtn = array(PARAM_RESULT => NO_STRING);
// print_r($this -> result);
		if($this -> getColumnData($this -> result, PARAM_STATUS) == 'Success') {	// 成功
			$rtn[PARAM_RESULT] = PARAM_SUCCESS;
		} else {																	// 失敗
			$rtn[PARAM_RESULT] = PARAM_FAIL;
		}

		$rtn['refId'] = $this -> getColumnData($this -> result, 'refId');		//get transactionId from vendor response

		return  json_encode($rtn);
	}
}

$api = new APIGetPlemiumCardLoading();
$api -> action();
echo $api -> getResultJson();
?>
