<?php
require_once('config.php');

class APICardBalance extends System {

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	function action() {

		// 変数宣言部
		$rtn			= array(PARAM_RESULT => NO_COUNT);
		$xml			= NO_STRING;
		$cardHolderId	= $this -> getDataPost(PARAM_CARD_HOLDER_ID);

		try {

			if($cardHolderId == NO_STRING) {
				throw new Exception(NO_STRING);
			}

			$xml =	'<CardInquiry><Cardholderid>' . $cardHolderId . '</Cardholderid></CardInquiry>';
			// 			$xml =	'<CardInquiry><Cardholderid>400000542107</Cardholderid></CardInquiry>';

			// 送信データの生成
			$post = array('Username'			=> VAR_CARD_API_USER_NAME
					, 'Password'		=> VAR_CARD_API_PASSWORD
					, 'APISigniture'	=> 'CardInquiry'
					, 'MessageID'		=> $this -> getSequenceNo(CARD_MESSAGE_ID)
					, 'Data'			=> $xml
			);

			// ポスト送信
			$url = VAR_CARD_API_URL;

			$client = new SoapClient($url);
			$result = $client -> Process($post);

			$result = simplexml_load_string($result -> ProcessResult);
			$result = get_object_vars($result);

			// エラーがないか確認する
			if($this -> getColumnData($result, 'ErrorCode') == '0000') {	// 取得成功

				$result = $this -> getColumnData($result, 'CardInquiry');

				if(is_object($result)) {

					$result = get_object_vars($result);
					$result = $this -> getColumnData($result, 'cardinfo');

					if(is_object($result)) {

						$result = get_object_vars($result);
						$result = $this -> getColumnData($result, 'AvailBal');

						$rtn[PARAM_RESULT] = $this -> intToCurrency(intval($result), USD);
					}
				}

			} else {													// 取得失敗
			}

		} catch(Exception $e) {
			return $rtn;
		}

		return  $rtn;
	}
}
?>
