/**
 * anton、
 */

var updateStatus = (lang == "en" ? "Do you want to update the status?" 
    : "ステータスを変更しますか")

var downloadButton = (lang == "en" ? "Download" 
    : "ダウンロード");

var deleteButton = (lang == "en" ? "Delete" 
    : "削除");

var approveButton = (lang == "en" ? "Approved" 
    : "承認済");

var functionSelection = (lang == "en" ? "Select Function" 
    : "機能の選択");

var statusAndFunctionSelect = (lang == "en" ? "Please Select Status and Function" 
    : "ステータスと機能を選択してください");

var noDownloadFile = (lang == "en" ? "There is no downloading file." 
    : "ダウンロードするファイルがありません。");

var deleteRejectedKyc = (lang == "en" ? "Do you want to Delete all KYCs that have been rejected?" 
    : "否認されたKYCを全部を削除しますか？");

var noRejectedKyc = (lang == "en" ? "There is no rejected KYC." 
    : "拒否されたKYC書類はありません。");

var approveAllFinalStats = (lang == "en" ? "Are you going to approve all the final review statuses?" 
    : "すべての最終審査状況を [承認済み] に変更しますか?");

var noKycInFinalRevStat = (lang == "en" ? "There is no KYC in final review status" 
    : "最終審査状況のKYC書類はありません。");    

/**
 * サブミットを行う
 */
$(function() {
	$('#from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	if($('#from').val() == '') {
		$('#from:text').datepicker().datepicker('setDate', nowStr);
	}

	if($('#to').val() == '') {
		$('#to:text').datepicker().datepicker('setDate','today');
	}

	if($('#s_from').val() == '') {
		$('#s_from:text').datepicker().datepicker('setDate', nowStr);
	}

	if($('#s_to').val() == '') {
		$('#s_to:text').datepicker().datepicker('setDate','today');
	}

	$("#btnSearch").click(function() {
		$('#type').val('');
		$('#type_search').val('search');
		$('#searchForm').submit();
	});

	$('#btnList').click(function() {
		$('#type').val('');
		submitForm();
	});

	$('#btnStatus').click(function() {
		$('#type').val('status');
		submitForm();
	});

	$('#btnCommit').click(function() {
		$('#type').val('commit');
		submitForm();
	});

	$('#btnUpdateAll').click(function() {
		$('#type').val('updateAll');
		submitForm();
	});

	$('#btnProcessing').click(function() {
		$('#type').val('pending');
		submitForm();
	});

	$('#btnSaveImage').click(function() {
		$('#ImageType').val('SaveImage');
		$('#imageForm').submit();
	});

	$('#detailSave').click(function() {
		$('#acForm').attr('action','');
		getForm().attr('target', '');
		$('#type').val('detailSave');
		$('#acForm').submit();
	});


    $('#btn-verify').click(function(){
        if(confirm(updateStatus)){
            $('#type').val('Vertify');
            $('#acForm').submit();
        }
    });


	$('#category').change(function(){
		var category = $('#category option:selected').attr('value');
		// alert(category);
		$('#action').empty();
		if(category == 'approved'){
			$('#action').append("<option value='download'>"+downloadButton+"</option>");
		} else if (category == 'reject') {
			$('#action').append("<option value='delete'>"+deleteButton+"</option>");
		} else if (category == 'final_review') {
			$('#action').append("<option value='approve'>"+approveButton+"</option>");
		} else if (category == 'checked') {
			$('#action').append("<option value='download'>"+downloadButton+"</option>");
		} else if (category == 'all') {
			$('#action').append("<option value='download'>"+downloadButton+"</option>");
		} else {
			$('#action').append("<option value='default'>"+functionSelection+"</option>");
		}
	});

	$('#btnProceed').click(function(){
		var category = $('#category option:selected').attr('value')
		var action = $('#action option:selected').attr('value')

		if(category == 'approved' && action == 'download'){
			downloadApproved();
		}else if (category == 'reject' && action == 'delete'){
			deleteRejected();
		}else if (category == 'final_review' && action == 'approve'){
			approveFinal();
		}else if (category == 'checked' && action == 'download'){
			downloadChecked();
		}else if (category == 'all' && action == 'download'){
			downloadAll();
		}else{
			popUpError();
		}
	});

	$("#checkall").click(function() {
        $('input[name="selectAll[]"]').prop("checked",this.checked);
    });
    var $subBox = $("input[name='selectAll[]']");
    $subBox.click(function(){
        $("#checkall").prop("checked",$subBox.length == $("input[name='selectAll[]']:checked").length ? true : false);
    });

    $("#statuses").click(function() {
        $('input[name="statuses[]"]').prop("checked",this.checked);
    });
    var $subBox = $("input[name='statuses[]']");
    $subBox.click(function(){
        $("#statuses").prop("checked",$subBox.length == $("input[name='statuses[]']:checked").length ? true : false);
    });

	$('img').bind('click',{ imgId: $(this).attr('id') }, function (evt) {
		$(window).scrollTop(0);
	});
});

/**
 * サブミットを行う（詳細画面の表示）
 */

 function popUpError(){
	 alert(statusAndFunctionSelect);
 }
 function downloadApproved(){
	 getApproved = false;
	 $("select[name='status[]']").each(function(){
		 valstr = $(this).val();
		 tmp    = valstr.split("_");
		 if(tmp[1] == '1'){
			 $("input[name='download[]'][value='"+tmp[0]+"']").prop("checked",true);
			 getApproved = true;
		 }

	 });
	 if(getApproved){
		 $('#ImageType').val('DownloadImage');
		 $('#imageForm').submit();
	 }else{
		 alert(noDownloadFile);
	 }
 }

 function deleteRejected(){
	 canDelete = false;
	 $("select[name='status[]']").each(function(){
		 valstr = $(this).val();
		 tmp    = valstr.split("_");
		 if(tmp[1] == '2'){
			 canDelete = true;
			 return false;
		 }
	 });
	 if(canDelete){
		 if(confirm(deleteRejectedKyc)){
			 $('#ImageType').val('DeleteImage');
			 $('#imageForm').submit();
		 }
	 }else{
		 alert(noRejectedKyc);
	 }
 }

function approveFinal(){
	canApprove = false;
	$("select[name='status[]']").each(function(){
		valstr = $(this).val();
		tmp    = valstr.split("_");
		if(tmp[1] == '4'){
			$(this).val(tmp[0] + "_1");
			canApprove = true;
		}
	});
	if(canApprove){
		if(confirm(approveAllFinalStats)){
			$('#ImageType').val('SaveImage');
			$('#imageForm').submit();
		}
	}else{
		alert(noKycInFinalRevStat);
	}
}

function downloadChecked(){
	getChecked = false;
	$('input[name="download[]"]').each(function(){
		if($(this).prop("checked")){
			getChecked = true;
		}
	});
	if(getChecked){
		$('#ImageType').val('DownloadImage');
		$('#imageForm').submit();
	}else{
		alert(noDownloadFile);
	}

}

function downloadAll(){
	$('input[name="download[]"]').prop("checked",true);
	$('#ImageType').val('DownloadImage');
	$('#imageForm').submit();
}
function actionDetail(uAccount) {
	$('#acForm').attr('action','');
	$('#type').val('detail');
	$('#detail_account').val(uAccount);
	$('#account_id').val(uAccount);
	getForm().attr("target","_blank");
	submitForm();
}

$(function(){
    var wholewidth=$("#whole").width();
    $("footer").css("width",wholewidth);
})

/**
 * サブミットを行う（ステータスの更新）
 */
function actionStatus(kId, status) {
	$('#k_id').val(kId);
	$('#status').val(status);
	submitForm();
}
