<?php
require_once(SITE_LOGICS . 'menu/model.php');

class LogicMenu extends MenuModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	public function adsLogic(){
	    header("Content-type:text/json;");
	    
	    if($this -> getColumnData($_SERVER, "REQUEST_METHOD") != "POST")
	        throw new Exception();
	    
	    $account = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));
	    
	    $expirationDate = strtotime("2022-04-01");
	    
	    $result = $this -> accessSelect("SELECT_DEPOSIT_CDS_FOR_CHECKING", 
	        [$this -> getUserData(PARAM_USER_ACCOUNT)]);
	    	    
	    $language = strtolower($this -> getLangage());
	    
	    $siteSessionPopupAdvertisement = isset($_SESSION[SITE_USER_DATA]['adv_popup_session']);
	    
	    $adStatus = (
	        !$this -> isLoopData($this -> getRowData($result)) &&
	        $expirationDate > strtotime(date("Y-m-d")) &&
	        in_array($language, ["en", "ja"]) && 
	        !$siteSessionPopupAdvertisement
        );
	    
	    if(!$siteSessionPopupAdvertisement && !$this -> isLoopData($this -> getRowData($result)))
	        $_SESSION[SITE_USER_DATA]["adv_popup_session"] = VAL_INT_1;
	    
        echo json_encode([
            "accountType" => $this -> getColumnData($account, PARAM_ACCOUNT_TYPE),
            "adStatus" => $adStatus
        ]);
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>