<?php
require_once(SITE_LOGICS . 'card_pin/model.php');

class LogicCardPin extends CardPinModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() == TYPE_SEND) {		// 確認メール送信
			$this -> send();
			$this -> update();

		} else {									// その他
			$this -> lists();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function lists() {}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function send() {

		// データの取得（メールアドレス）
		$user = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));

		// PIN確認メールの送信
		$this -> sendMailByTmp('card_pin_confirm.xml'
								, $this -> getSendParams()
								, $this -> getColumnData($user, COLUMN_MAIL)
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function update() {
		$this -> accessModify('UPDATE_CARD_PIN_TIME', $this -> getUpdateParams());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>