<?php
require_once(SYSTEM_LOGICS . 'admin_function/model.php');

class LogicAdminFunction extends AdminFunctionModelClass {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			// 初期化
			$this -> init();
			// 処理
			$this -> biz();
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ロジック
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function biz() {
		if($this -> getType() == TYPE_COMPLETE) {				// 登録時
			$this -> insertActivity();
			$this -> regist();
			$this -> lists();
		} else if($this -> getType() == TYPE_UPDATE) {			// 更新時
			$this -> insertActivity();
			$this -> update();
			$this -> detail();
			$this -> setType(TYPE_DETAIL);
		} else if($this -> getType() == TYPE_DETAIL || $this -> getType() == TYPE_EDIT) {			// 詳細表示
			$this -> detail();
		} else {
			$this -> lists();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ニュースリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_FUNCTION', array()));
	}


	/*-------------------------------------------------------------------------
	 * @function_name: 詳細の取得
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function detail() {
		$this -> setResult($this -> accessSelect('DETAIL_FUNCTION', array($this -> getFlId())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ニュースの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_FUNCTION', $this -> getRegistData());
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}


	/*-------------------------------------------------------------------------
	 * @function_name: ニュースの更新
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function update() {
		// var_dump($this -> getUpdateData());
		// die();
		$this -> accessModify('UPDATE_FUNCTION', $this -> getUpdateData());
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());

	}

	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity());
	}
}
?>
