<?php
require_once('config.php');

class APILoginLogin extends System {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $userId		= NO_STRING;
	private $password	= NO_STRING;
	private $account	= null;

	/*-------------------------------------------------------------------------
	 * @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログイン
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature	= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> userId		= $this -> getDataPost(PARAM_USER_ID);
			$this -> password	= $this -> getDataPost(PARAM_PASSWORD);

			// シグネチャの確認
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'L' . $this -> userId);
			}

			// エラーチェック
			$this -> validate();

			// 1行目のデータを再設定
			$this -> account = $this -> getRowData($this -> account);

			// 返却データの設定
			$rtn[PARAM_UID] 			= $this -> getColumnData($this -> account, COLUMN_UID);
// 			$rtn[PARAM_USER_ID]			= $this -> getColumnData($this -> account, COLUMN_USER_NAME);
			$rtn[PARAM_USER_ACCOUNT]	= $this -> getColumnData($this -> account, COLUMN_USER_ACCOUNT);
// 			$rtn[PARAM_MAIL]			= $this -> getColumnData($this -> account, COLUMN_MAIL);
// 			$rtn[PARAM_ACCOUNT_NUMBER]	= $this -> getColumnData($this -> account, COLUMN_ACCOUNT_NUMBER);
			$rtn[PARAM_NAME]			= $this -> getColumnData($this -> account, COLUMN_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($this -> account, COLUMN_LAST_NAME);
// 			$rtn[PARAM_AGENT_CODE]		= $this -> getColumnData($this -> account, COLUMN_AGENT_CODE);
// 			$rtn[PARAM_LANGUAGE]		= $this -> getColumnData($this -> account, COLUMN_USE_LANGUAGE);
			$rtn['result']				= 'OK';
			$rtn['messages']			= 'I_COMPLETE_PROCESS';

			echo json_encode($rtn);

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {

			// ユーザ名のチェック
			if(!$this -> checkNull($this -> userId)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// ユーザパスワードのチェック
			if(!$this -> checkNull($this -> password)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// ログイン失敗規定回数10以上のチェック
			if(!$this -> checkLoginFail($this -> userId)) {
				throw new Exception('E_ERROR_LOGIN_FAIL_COUNT');
			}

			// ユーザの存在確認
			$this -> account = $this -> checkUser($this -> userId, $this -> password);

			if(count($this -> account) == VAL_INT_1) {	// ユーザ存在

				// ログイン成功で回数をリセット
				$this -> clearFailCounter($this -> userId);

			} else {									// ユーザ存在せず

				// 認証しているか否か
				if(!$this -> existVerification($this -> userId, $this -> password)) {	// メール未認証
					throw new Exception('E_NOT_VERIFICATION_MAIL');
				}

				// 失敗リストの加算
				$this -> incrementFailCounter($this -> userId);

				throw new Exception('E_CAN_NOT_LOGIN');
			}

		} catch (Exception $e) {
			throw  $e;
		}
	}
}

$api = new APILoginLogin();
$api -> action();
?>