<?php
require_once('config.php');

class APIGetAccountBalance extends System {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $userAccount	= NO_STRING;

	/*-------------------------------------------------------------------------
	 * @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$list		= array();
		$result		= NO_STRING;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> userAccount	= $this -> getDataPost(PARAM_USER_ACCOUNT);

			// シグネチャの確認
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'B' . $this -> userAccount);
			}

			// エラーチェック
			$this -> validate();

			// 通貨データの取得
			$currencies = $this -> getCurrencyList();

			// 通貨データが存在した場合
			if($this -> isLoopData($currencies)) {

				foreach($currencies as $currency) {
					$list[] = $currency[PARAM_DATA_KEY];
				}

				$result = implode(DELIMIT_COMMA, $list);
			}

			// 返却データの設定
			$rtn[PARAM_CURRENCY]	= $result;
			$rtn['result']			= 'OK';
			$rtn['messages']		= 'I_COMPLETE_PROCESS';

			echo json_encode($rtn);

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
					, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {
		} catch (Exception $e) {
			throw  $e;
		}
	}
}

$api = new APIGetAccountBalance();
$api -> action();
?>
