<?php
class ExchangeModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $amount				= NO_COUNT;			// 金額
	private $fromCurrency		= NO_STRING;		// From通貨
	private $toCurrency			= NO_STRING;		// To通貨
	private $fromAmount			= NO_STRING;		// From金額
	private $toAmount			= NO_STRING;		// To金額
	private $amountType			= NO_COUNT;			// 金額種別
	private $fromBalance		= NO_STRING;		// From残高
	private $toBalance			= NO_STRING;		// To残高
	private $exFromCurrency		= NO_STRING;		// 両替From通貨
	private $exToCurrency		= NO_STRING;		// 両替To通貨
	private $rate				= NO_STRING;		// レート
	private $exAmount			= NO_STRING;		// 両替金額
	private $originalAmount		= NO_STRING;		// オリジナル金額

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> amount				= $this -> getDataPost(PARAM_AMOUNT);					// 金額
		$this -> exAmount			= $this -> getDataPost(PARAM_EX_AMOUNT);				// 換金額
		$this -> fromCurrency		= $this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY);	// From通貨
		$this -> toCurrency			= $this -> getDataPost(PARAM_TRANSFER_TO_CURRENCY);		// To通貨
		$this -> fromAmount			= $this -> getDataPost(PARAM_FROM_AMOUNT);				// From通貨
		$this -> toAmount			= $this -> getDataPost(PARAM_TO_AMOUNT);				// To通貨
		$this -> amountType			= $this -> getDataPost(PARAM_AMOUNT_TYPE);				// 金額タイプ
		$this -> rate				= $this -> getDataPost(PARAM_RATE);						// 換金レート
		$this -> originalAmount		= $this -> getDataPost(PARAM_ORIGINAL_AMOUNT);			// オリジナル金額

		// 確認画面から戻った時の対応（データ入れ替え）
		if($this -> getType()		== TYPE_BACK
			&& $this -> amountType	!= NO_COUNT) {	// 引き落とし口座)
			$tmp				= $this -> amount;
			$this -> amount		= $this -> exAmount;
			$this -> exAmount	= $tmp;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn			= true;
		$exc			= array();
		$fromCurrency	= NO_STRING;
		$toCurrency		= NO_STRING;
		$divFlg			= false;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 口座ステータスチェック
		if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_EXCHANGE)) {
			throw new Exception(VAL_INT_99);
		}

		if($this -> getType()		== TYPE_CONFIRM
			|| $this -> getType()	== TYPE_COMPLETE) {				// 入力画面

			// 入力チェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return;
			}

			// 通貨同一チェック
			if($this -> toCurrency == $this -> fromCurrency) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_CURRENCY', array());
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return;
			}

			// 数値の正規表現
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return;
			}

			// 数値のマイナスチェック
			if($this -> amount <= NO_COUNT) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE', array($this -> amount));
				$rtn = false;
			}


			// 変換通貨の取得
			if($this -> amountType == NO_COUNT) {

				$fromCurrency	= $this -> fromCurrency;
				$toCurrency		= $this -> toCurrency;

			} else {
				$fromCurrency	= $this -> toCurrency;
				$toCurrency		= $this -> fromCurrency;
				$divFlg			= true;
			}

			// 最低値と最高値の設定
			if(!$this -> checkRangeCurrency($this -> amount
											, $fromCurrency
											, NO_COUNT
											, 9999999)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return;
			}

			// レートの取得
			$exc = $this -> getExchangeCommon($this -> amount
												, $fromCurrency
												, $toCurrency
												, true
												, $divFlg
												, NO_STRING
												, $this -> getUserData(PARAM_USER_ACCOUNT));
			
			// 変換後の金額
			// チェック用のデータ
			if($this -> amountType == NO_COUNT) {	// 引き落とし口座
				$check				= $this -> amount;
				$this -> exAmount	= $exc[PARAM_AMOUNT];
				$this -> fromAmount	= $this -> amount;
				$this -> toAmount	= $exc[PARAM_AMOUNT];

			} else {								// 入金口座
				$check				= $exc[PARAM_AMOUNT];
				$this -> exAmount	= $this -> amount;
				$this -> fromAmount	= $exc[PARAM_AMOUNT];
				$this -> toAmount	= $this -> amount;
			}

			$this -> rate			= $exc[PARAM_RATE];
			$this -> originalAmount	= $exc[PARAM_ORIGINAL_AMOUNT];

			if($this -> amountType == NO_COUNT) {	// 引き落とし口座

				// IWalletが損しない為の処理
				if($this -> toAmount > ($this -> fromAmount * $this -> rate)) {
					$digit = $this -> getDigit($toCurrency);

					$this -> toAmount -= (VAL_INT_1 / $digit);
				}
			} else {								// 入金額指定の場合

				// IWalletが損しない為の処理
				if($this -> fromAmount < ($this -> toAmount / $this -> rate)) {
					$digit = $this -> getDigit($this -> fromCurrency);

					$this -> fromAmount += (VAL_INT_1 / $digit);
				}
			}

			// 残高の取得
			$this -> fromBalance	= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> fromCurrency);
			$this -> toBalance		= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> toCurrency);

			// 残高のチェック
			if($this -> fromBalance < $check) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> fromCurrency, $this -> formatCurrency($check, $this -> fromCurrency)));
				$rtn = false;
			} elseif(($this -> fromBalance - $this -> fromAmount) < 0) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> fromCurrency, $this -> formatCurrency($this -> fromAmount, $this -> fromCurrency)));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return;
			}

		} else if($this -> getType() == TYPE_SAVE) {		// 保存時

			// 必須項目
			// debit口座のチェック
			if(!$this -> checkNull($this -> fromCurrency)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_DETAIL);
				return;
			}

			// 残高のチェック
			$balance			= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> fromCurrency);


			$this -> currency	= $this -> getColumnData($row, COLUMN_CURRENCY);
			$amount				= $this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> currency);

			// 手数料の算出
			$fee				= $this -> getFeeCommon(VAR_TRANSFER
														, $this -> amount
														, $this -> currency
														, $this -> getColumnData($row, COLUMN_FROM_ACCOUNT)
														, $this -> getColumnData($row, COLUMN_TO_ACCOUNT));

			// バランスと（送金額 + 手数料）のチェック
			$exchange		= $this -> getExchangeCommon($amount, $this -> currency
																, $this -> fromCurrency
																, false
																, true
																, NO_STRING
													            , $this -> getUserData(PARAM_USER_ACCOUNT));
			$this -> amount	= $this -> amount[PARAM_AMOUNT];
			$this -> fee	= $fee[$this -> currency . VAL_INT_1];
			$this -> fee2	= $fee[$this -> currency . VAL_INT_2];
			$total			= $this -> amount + $this -> fee;
			$this -> agent1	= $fee[PARAM_AGENT_CODE . VAL_INT_1];
			$this -> agent2	= $fee[PARAM_AGENT_CODE . VAL_INT_2];
			$this -> rate	= $fee[PARAM_RATE];

			if($balance < $total) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> fromCurrency, $this -> formatCurrency($exchange[PARAM_AMOUNT], $this -> fromCurrency)));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_DETAIL);
			}
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: メール送信用（認証時）のデータ取得関数
	* @parameter	: なし
	* @return		: メール送信用（認証時）データ配列
	-------------------------------------------------------------------------*/
	public function getSendInfoParams($transaction_number) {

		// 変数宣言部
		$request	= null;
		$rtn		= array();
		$row		= null;

		
		$exchange	= $this -> getExchangeRecordCommon($transaction_number);
		$row		= $this -> getRowData($exchange);
		$rtn[] 		= $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
		$rtn[]		= $this -> getUserNameCommon($this -> getColumnData($row, COLUMN_FROM_ACCOUNT));
		$rtn[]	 	= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
		$rtn[]      = $this -> getColumnData($row, COLUMN_CREATE_TIME);
		$rtn[] 		= $this -> getColumnData($row, COLUMN_FROM_MAIL);


		return $rtn;
	}


	/*-------------------------------------------------------------------------
	 * @function_name: ユーザアカウントの取得
	 * @parameter	: なし
	 * @return		: ユーザアカウント
	 -------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> getUserData(PARAM_USER_ACCOUNT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: From金額の取得
	* @parameter	: なし
	* @return		: From金額
	-------------------------------------------------------------------------*/
	public function dispFromAmount() {
		echo $this -> formatCurrency($this -> fromAmount, $this -> fromCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: To金額の取得
	* @parameter	: なし
	* @return		: To金額
	-------------------------------------------------------------------------*/
	public function dispToAmount() {
		echo $this -> formatCurrency($this -> toAmount, $this -> toCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: From金額の取得
	* @parameter	: なし
	* @return		: From金額
	-------------------------------------------------------------------------*/
	public function echoFromAmount() {
		echo $this -> fromAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: To金額の取得
	* @parameter	: なし
	* @return		: To金額
	-------------------------------------------------------------------------*/
	public function echoToAmount() {
		echo $this -> toAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: From金額の取得
	* @parameter	: なし
	* @return		: From金額
	-------------------------------------------------------------------------*/
	public function getFromAmount() {
		return $this -> fromAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: To金額の取得
	* @parameter	: なし
	* @return		: To金額
	-------------------------------------------------------------------------*/
	public function getToAmount() {
		return $this -> toAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function getAmount() {
		return $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	public function getRate() {
		return $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function dispAmount() {
		echo $this -> formatCurrency($this -> amount, $this -> fromCurrency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 両替金額取得
	 * @parameter	: なし
	 * @return		: 両替金額
	 -------------------------------------------------------------------------*/
	public function dispExAmount() {
		echo $this -> formatCurrency($this -> exAmount, $this -> toCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 両替金額取得
	* @parameter	: なし
	* @return		: 両替金額
	-------------------------------------------------------------------------*/
	public function echoExAmount() {
		echo $this -> exAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 両替金額取得
	* @parameter	: なし
	* @return		: 両替金額
	-------------------------------------------------------------------------*/
	public function getExAmount() {
		return $this -> exAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: From通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoFromCurrency() {
		echo $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To通貨の取得
	 * @parameter	: なし
	 * @return		: 通貨
	 -------------------------------------------------------------------------*/
	public function echoToCurrency() {
		echo $this -> toCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: From通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getFromCurrency() {
		return $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: To通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getToCurrency() {
		return $this -> toCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 両替From通貨の取得
	 * @parameter	: なし
	 * @return		: 通貨
	 -------------------------------------------------------------------------*/
	public function echoExFromCurrency() {
		echo $this -> exFromCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 両替To通貨の取得
	 * @parameter	: なし
	 * @return		: 通貨
	 -------------------------------------------------------------------------*/
	public function echoExToCurrency() {
		echo $this -> exToCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispFromCurrency() {
		echo $this -> dispCurrencyOptionList($this -> fromCurrency, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨の取得
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	public function dispToCurrency() {
		echo $this -> dispCurrencyOptionList($this -> toCurrency, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function getOriginalAmount() {
		return $this -> originalAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoOriginalAmount() {
		echo $this -> originalAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 両替後From残高の取得
	 * @parameter	: なし
	 * @return		: 両替後残高
	 -------------------------------------------------------------------------*/
	public function echoExFromBalance() {

		echo $this -> formatCurrency($this -> fromBalance - $this -> fromAmount, $this -> fromCurrency);
		return ;

		if($this -> amountType == NO_COUNT) {
			echo $this -> formatCurrency($this -> fromBalance - $this -> exAmount, $this -> fromCurrency);
		} else {
			echo $this -> formatCurrency($this -> fromBalance - $this -> amount, $this -> fromCurrency);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 両替後To残高の取得
	 * @parameter	: なし
	 * @return		: 両替後残高
	 -------------------------------------------------------------------------*/
	public function echoExToBalance() {

		echo $this -> formatCurrency($this -> toBalance + $this -> toAmount, $this -> toCurrency);
		return ;

		if($this -> amountType == NO_COUNT) {
			echo $this -> formatCurrency($this -> toBalance + $this -> amount, $this -> toCurrency);
		} else {
			echo $this -> formatCurrency($this -> toBalance + $this -> exAmount, $this -> toCurrency);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 金額タイプの取得
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	public function echoAmountType($type) {
		if($this -> amountType == $type) {
			echo 'checked';
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 金額タイプの取得
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	public function echoCAmountType() {
		echo $this -> amountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額タイプの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function getCAmountType() {
		return $this -> amountType;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From残高の取得
	 * @parameter	: なし
	 * @return		: From残高
	 -------------------------------------------------------------------------*/
	public function echoFromBalance() {
		echo $this -> formatCurrency($this -> fromBalance, $this -> fromCurrency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To残高の取得
	 * @parameter	: なし
	 * @return		: To残高
	 -------------------------------------------------------------------------*/
	public function echoToBalance() {
		echo $this -> formatCurrency($this -> toBalance, $this -> toCurrency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨の取得
	 * @parameter	: なし
	 * @return		: 通貨
	 -------------------------------------------------------------------------*/
	public function echoCurrency() {
		echo $this -> exFromCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	public function echoRate() {
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}
}
?>