<?php
class DeletedTransactionModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 出金リスト
	private $total						= NO_COUNT;		// リスト総合計

	// ------------------ 検索系 ------------------//
	private $sTransactionNumber 		= NO_STRING;	// 取引番号
	private $sFrom						= NO_COUNT;		// 登録時刻（開始日）（検索項目）
	private $sTo						= NO_COUNT;		// 登録時刻（終了）（検索項目）
	private $sCurrency					= NO_COUNT;		// 通貨（検索項目）
	private $sMinAmount					= NO_COUNT;		// 送金額（最少）（検索項目）
	private $sMaxAmount					= NO_COUNT;		// 送金額（最大）（検索項目）
	private $sType						= NO_COUNT;		// 取引タイプ（検索項目）
	private $sWithdrawAccountName		= NO_COUNT;		// 出金口座名義（検索項目）
	private $sWithdrawAccountNumber		= NO_COUNT;		// 出金口座番号（検索項目）
	private $sDepositAccountName		= NO_COUNT;		// 入金口座名義（検索項目）
	private $sDepositAccountNumber		= NO_COUNT;		// 入金口座番号（検索項目）
	private $sAgent						= NO_COUNT;		// エージェント（検索項目）
	private $statuses					= NO_STRING;	// 処理タイプ

	/**
	 *
	 * anton
	 *
	 */
	public $lang						= NO_STRING;
	// ------------------ 検索系 ------------------//

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// ------------------ 検索系 ------------------//
		$this -> sTransactionNumber		= $this -> getDataPost(PARAM_TRANSACTION_NUMBER); 			// 取引番号
		// ------------------ 検索系 ------------------//

		$this -> lang					= $this -> getLangage();
		$this -> transactionNumber		= $this -> getDataPost('revert_number');
		$this -> revertType		= $this -> getDataPost('revert_type');
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('ADHT', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('ADHT', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: なし
	* @return		: 検索条件
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtn	= array();
		$page	= NO_STRING;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 取引番号（検索項目）
		if($this -> sTransactionNumber != NO_STRING) {
			$rtn[] = ' trans.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}


		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

        if($this -> getType() == TYPE_EXPORT){
            $page = '';
        }

		// 検索条件の結合
		if(count($rtn) > NO_COUNT) {
			return array(DELIMIT_AND . implode(DELIMIT_AND, $rtn), $page);
		} else {
			return array(NO_STRING, $page);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$tType			= NO_STRING;
		$deposit		= NO_STRING;
		$withdraw		= NO_STRING;
		$depositCur		= NO_STRING;
		$withdrawCur	= NO_STRING;
		$debitCur		= NO_STRING;
		$debitAmount	= NO_STRING;
		$pStatus		= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> rs, $cnt);

			foreach($this -> rs as $row) {
				// 処理種別
				if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_1) {													// 入金

					$tType			= VAL_STR_DEPOSIT;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金

					$tType			= VAL_STR_WITHDARAW;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
					$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';

				}else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
				        && $this -> getColumnData($row, COLUMN_TYPE)		  == VAL_INT_11) {		// 通常出金
				        
				        $tType			= VAL_STR_DORMANCY;
				        $depositCur		= NO_STRING;
				        $withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
				        $debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
				        $debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);
				        
				        $deposit		= NO_STRING;				        
				        $withdraw		= NO_STRING;
				}else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
					&& $this -> getColumnData($row, COLUMN_TYPE)				== VAR_WITHDRAW_TYPE_CARD) {		// 通常出金

						$tType			= VAL_STR_WITHDRAW_CARD;
						$depositCur		= NO_STRING;
						$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
						$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
						$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

						$deposit		= NO_STRING;
						$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 通貨両替

					$tType			= VAL_STR_EXCHANGE;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金

					$tType			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_3) {												// 口座振替（出金）

					$tType			= VAL_STR_TRANSFER;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 引落（出金）

					$tType			= VAL_STR_REQUEST;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_7
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {				// 出金差戻し

					$tType 			= VAL_STR_WITHDRAW_REFUND;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_11) {				// 出金差戻し

					$tType 			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE), $withdrawCur);

				} else {
					$tType = NO_STRING;
				}

				// 処理ステータス
				if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == NO_COUNT) {			// ユーザ側操作
					$pStatus = 'User';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_1) {	// 管理者側操作
					$pStatus = 'Admin';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_2) {	// API操作
					$pStatus = 'API';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_3) {	// API操作
					$pStatus = 'Batch';
				} else {
					$pStatus = '&nbsp;';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_TIME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td>' . $this -> getAdminNameByUid($this -> getColumnData($row, COLUMN_UID)) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</td>'
							. '<td>' . $tType . '</td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . '">'. $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NAME) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . '</td>'
							. '<td>' . $withdrawCur . '</td>'
							. '<td class="r">' . $withdraw . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_FEE), $withdrawCur) . '</td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . '">'. $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NAME) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . '</td>'
							. '<td>' . $depositCur . '</td>'
							. '<td class="r">' . $deposit . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_FEE), $depositCur) . '</td>'
							. '<td>' . $pStatus . '</td>'
							. '<td><input type="button" id="btnDelete" value="'.($this -> lang == "en" ? "REVERT" : "元に戻す").'" class="btn bg-gray font12 hi22 px80" onclick="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER).'\', \''.$this -> getColumnData($row, COLUMN_TRANSACTION_TYPE). '\', \'_blank\');"></td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="14">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}
	public function getResult() {
		return $this -> rs;
	}
	public function gettransactionNumber() {
		return 	$this -> transactionNumber;
	}
	public function getrevertType() {
		return $this -> revertType;
	}


	/*-------------------------------------------------------------------------
	 * @function_name: 出金リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setTotal($count) {
		$this -> total = $count;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> total)
				, $this -> total
				, NO_STRING
				, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: なし
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索通貨の取得
	* @parameter	: なし
	* @return		: 検索通貨
	-------------------------------------------------------------------------*/
	function echoSCurrency() {
		echo $this -> sCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索最小値の取得
	* @parameter	: なし
	* @return		: 検索最小値
	-------------------------------------------------------------------------*/
	function echoSMinAmount() {
		echo $this -> sMinAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索最大値の取得
	* @parameter	: なし
	* @return		: 検索最大値
	-------------------------------------------------------------------------*/
	function echoSMaxAmount() {
		echo $this -> sMaxAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金口座名義の取得
	* @parameter	: なし
	* @return		: 出金口座名義
	-------------------------------------------------------------------------*/
	function echoSWithdrawAccountName() {
		echo $this -> sWithdrawAccountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金口座番号の取得
	* @parameter	: なし
	* @return		: 出金口座番号
	-------------------------------------------------------------------------*/
	function echoSWithdrawAccountNumber() {
		echo $this -> sWithdrawAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金口座名義の取得
	* @parameter	: なし
	* @return		: 入金口座名義
	-------------------------------------------------------------------------*/
	function echoSDepositAccountName() {
		echo $this -> sDepositAccountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金口座番号の取得
	* @parameter	: なし
	* @return		: 入金口座番号
	-------------------------------------------------------------------------*/
	function echoSDepositAccountNumber() {
		echo $this -> sDepositAccountNumber;
	}



    /*-------------------------------------------------------------------------
	 * @function_name: makeExportData
	* @parameter	:
	* @return		: string - export data csv format
	-------------------------------------------------------------------------*/
    public function getExportDetails(){
        // 変数宣言部
		$rtn			= NO_STRING;
		$tType			= NO_STRING;
		$deposit		= NO_STRING;
		$withdraw		= NO_STRING;
		$depositCur		= NO_STRING;
		$withdrawCur	= NO_STRING;
		$debitCur		= NO_STRING;
		$debitAmount	= NO_STRING;
		$pStatus		= NO_STRING;


		if($this -> isLoopData($this -> rs)) {


			// データの数だけループを回す
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> rs, $cnt);

			foreach($this -> rs as $row) {
				// 処理種別
				if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_1) {													// 入金

					$tType			= VAL_STR_DEPOSIT;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金

					$tType			= VAL_STR_WITHDARAW;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
					$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
					&& $this -> getColumnData($row, COLUMN_TYPE)				== VAR_WITHDRAW_TYPE_CARD) {		// 通常出金

						$tType			= VAL_STR_WITHDRAW_CARD;
						$depositCur		= NO_STRING;
						$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
						$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
						$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

						$deposit		= NO_STRING;
						$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 通貨両替

					$tType			= VAL_STR_EXCHANGE;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金

					$tType			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_3) {												// 口座振替（出金）

					$tType			= VAL_STR_TRANSFER;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 引落（出金）

					$tType			= VAL_STR_REQUEST;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_7
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {				// 出金差戻し

					$tType 			= VAL_STR_WITHDRAW_REFUND;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_11) {				// 出金差戻し

					$tType 			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE), $withdrawCur);

				} else {
					$tType = NO_STRING;
				}

				// 処理ステータス
				if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == NO_COUNT) {			// ユーザ側操作
					$pStatus = 'User';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_1) {	// 管理者側操作
					$pStatus = 'Admin';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_2) {	// API操作
					$pStatus = 'API';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_3) {	// API操作
					$pStatus = 'Batch';
				} else {
					$pStatus = '&nbsp;';
				}

				$rtn	.= $this -> getColumnData($row, COLUMN_TRANSACTION_TIME) . ','
                           . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . ','
						   . $tType . ','
                           . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NAME) . ','
                           . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . ','
                           . $withdrawCur . ','
                           . str_replace(",","",$withdraw) . ','
                           . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_FEE), $withdrawCur)) . ','
                           . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NAME) . ','
                           . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . ','
                           . $depositCur . ','
                           . str_replace(",","",$deposit) . ','
                           . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_FEE), $depositCur)) . ','
                           . $pStatus . ','
							. "\n";
			}
		} else {
			$rtn = '';
		}

		return $rtn;
    }

	function revertTransaction(){
	    $transaction = NO_STRING;
	    
		switch($this -> revertType){
		    case VAL_INT_1:
		        $transaction 	= 'deposit';
		        break;
		    case VAL_INT_2:
		        $transaction 	= 'withdraw';
		        break;
		    case VAL_INT_3:
		        $transaction 	= 'transfer';
		        break;
		    case VAL_INT_5:
		        $transaction 	= 'request';
		        break;
		}
		
		$tableName = "t_{$transaction}";
		$tableNameDeleted = "t_{$transaction}_deleted";
		$res = $this -> accessSelect('SELECT_DELETED_TRANSACTION', [$this -> transactionNumber, $tableNameDeleted]);
		
		$transData = $this -> getRowData($res);
		$transData = array_keys($transData);
		$columnNames = [];
		
		foreach($transData as $fieldName){
		    if($fieldName == "date_deleted" || $fieldName == "u_id")
		        continue;
		    
		    $columnNames[] = $fieldName;
		}
		
		$columnNames = implode(', ', $columnNames);
		
		if(count($res)== NO_COUNT){
			//$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
		}else{
			$this -> accessModify('COPY_DELETED_TRANSACTION', [$this -> transactionNumber, $tableNameDeleted, $tableName, $columnNames]);
			$this -> accessModify('DELETE_DELETED_TRANSACTION', [$this -> transactionNumber, $tableNameDeleted]);
			$this -> popUpSessionMessage(INFO, 'I_COMPLETE_PROCESS', []);
		}

	}

	function getActivity(){

		$rtn = array();
		$type = $this -> getType();

		if($type == TYPE_DELETE){
			$message = "Reverted transaction number [{$this -> transactionNumber}]";
		}

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 24;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;

	}


}
?>
