<?php
require_once('config.php');
require_once('CheckUserInfoBase.php');

class APIUpdateUserInfo extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $account	= NO_STRING;
	private $country	= NO_STRING;
	private $state		= NO_STRING;
	private $city		= NO_STRING;
	private $address	= NO_STRING;
	private $zipCode	= NO_STRING;
	private $tel		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$row		= null;
		$params		= null;

		try {

			// パラメータの設定
			$this -> signature	= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account	= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> country	= $this -> getDataPost(PARAM_COUNTRY);
			$this -> state		= $this -> getDataPost(PARAM_STATE);
			$this -> city		= $this -> getDataPost(PARAM_CITY);
			$this -> address	= $this -> getDataPost(PARAM_ADDRESS);
			$this -> zipCode	= $this -> getDataPost(PARAM_ZIP_CODE);
			$this -> tel		= $this -> getDataPost(PARAM_TEL);

			// シグネチャの確認
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'U' . $this -> account);
			}

			// エラーチェック
			$base = new APICheckUserInfoBase();
			$base -> action();

			// メール送信用にデータを取得しておく
			$row	= $this -> getRowData($this -> getAccountCommon($this -> account));

			// パラメータの設定
			$params		= array();
			$params[]	= $this -> account;	// iwallet口座番号
			$params[] 	= $this -> state;	// 都道府県
			$params[] 	= $this -> city;	// 市町村
			$params[] 	= $this -> zipCode;	// 郵便番号
			$params[] 	= $this -> address;	// 番地1
			$params[] 	= NO_STRING;		// 番地2
			$params[] 	= $this -> tel;		// 電話番号
			$params[] 	= $this -> country;	// 国

			// データの登録
			$this -> accessModify('UPDATE_USER_PROFILE', $params);

			// CRM連携（更新）
			$crmId = $this -> getCRMIDCommon($this -> account);

			$params		= array();
			$params[]	= $crmId;			// CRM ID
			$params[] 	= $this -> country;	// 国
			$params[] 	= $this -> state;	// 都道府県
			$params[] 	= $this -> city;	// 市町村
			$params[] 	= $this -> address;	// 番地1
			$params[] 	= $this -> zipCode;	// 郵便番号
			$params[] 	= $this -> tel;		// 電話番号

			$this -> crmUpdateRecords($params);

			// 旧データの取得
			$params		= array();
			$params[] = $this -> account;															// 口座番号
			$params[] = $this -> getNameCommon($this -> account);									// 氏名
			$params[] = $this -> dispCountryCommon($this -> country);								// 新国
			$params[] = $this -> state;																// 新州・都道府県
			$params[] = $this -> city;																// 新市区町村
			$params[] = $this -> address;															// 新住所
			$params[] = $this -> zipCode;															// 新郵便番号
			$params[] = $this -> tel;																// 新電話番号
			$params[] = $this -> getCurrentTimeCommon();											// 現在時刻
			$params[] = $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_COUNTRY));	// 旧国
			$params[] = $this -> getColumnData($row, COLUMN_STATE);									// 州・都道府県
			$params[] = $this -> getColumnData($row, COLUMN_CITY);									// 市区町村
			$params[] = $this -> getColumnData($row, COLUMN_ADDRESS);								// 住所
			$params[] = $this -> getColumnData($row, COLUMN_ZIP_CODE);								// 郵便番号
			$params[] = $this -> getColumnData($row, COLUMN_TEL);									// 電話番号

			// メールの送信（ユーザ側）
			$this -> sendMailByTmp('change_profile_for_user.xml'
									, $params
									, $this -> getColumnData($row, COLUMN_MAIL)
									, VAR_CS_MAIL_ADDRESS);

			// メールの送信（管理者側）
			$this -> sendMailByTmp('change_profile_for_admin.xml'
									, $params
									, VAR_NOTICE_MAIL_ADDRESS
									, VAR_NOTICE_MAIL_ADDRESS);

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {}
}

$api = new APIUpdateUserInfo();
$api -> action();
?>