<?php
require_once(SYSTEM_LOGICS . 'account_duplicate_com/model.php');

class LogicAccountDuplicateCom extends AccountDuplicateComModelClass{

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			// 初期データ処理
			if($this -> init()){			    
			    $this -> enhanceColumn();
				
			}else if($this -> getType() == TYPE_EXPORT_COMMON){
				$this -> restore();
				$this -> enhanceColumn();
				$this -> makeExportData();
			}else if($this -> getType() == TYPE_DELETE){
				$this -> restore();
				$this -> enhanceColumn();
				$this -> deleteJsonElement();
			}else{
				$this -> restore();
				$this -> enhanceColumn();
			}
		} catch (Exception $e) {
			throw $e;
		}
	}

	function enhanceColumn(){	    
	    $jobject = json_decode($this -> getDupJson());
	    	    
	    if($this -> isLoopData($jobject)){
	        $nocountry = 0;
	        foreach($jobject as $k){
	            if((!isset($k -> country) || $k -> country == null) || 
	                (!isset($k -> ipAddress) || $k -> ipAddress == null)){
	               $sc = $this -> accessSelect('SELECT_SPECIFIC_COLUMN_AND_TABLE', 
	                   array(COLUMN_COUNTRY.", create_ip_address as ".COLUMN_IP_ADDRESS, 
	                       't_user', "AND user_account = {$this->getUserAccount()}"));  
	               $k -> country = $this -> getColumnData($sc[0], COLUMN_COUNTRY);  
	               $k -> ipAddress = $this -> getColumnData($sc[0], COLUMN_IP_ADDRESS);
	               $nocountry++;
	            }
	        }
	        	 
	        if($nocountry > 0){	            
	            $jsondata = json_encode($jobject);
	            $jsondata = str_replace("\\t", "\\\\t", $jsondata);
	            
	            $this -> setDupJson($jsondata);
	            $this -> accessModify('UPDATE_USER_DUP_SOURCE', 
	                array($jsondata, $this -> getUserAccount()), 
	                false);
	        }
	    }
	}
	
	/**
	 * (ed)
	 */
	function deleteJsonElement(){
		/* header("Content-type: text/plain"); */
		$dups = json_decode($this -> getDupJson());
		
		foreach($dups as $k => $v){
			$elements = (array) $v;
			if(in_array($this -> getChildAccount(), $elements)){
				unset($dups[$k]);
				break;
			}
		}
		
		$dups = array_values($dups);
		
		if($this -> isLoopData($dups)){
			$modified = json_encode($dups);
			$this -> accessModify('UPDATE_CHILD_DUPLICATE', [$modified, $this -> getUserAccount()], false);
			$this -> setDupJson($modified);
		}else{
			/**
			 * one last pop
			 */
			$this -> accessModify('UPDATE_CHILD_DUPLICATE', [$modified, $this -> getUserAccount()], false);
			
			/**
			 * remove the suspected account from Potential Duplicate Account list.
			 */
			$this -> accessModify('UPDATE_USER_THRESHOLD', [0, NO_STRING, $this -> getUserAccount()], false);
			header("Location: account_duplicate");
		}
	}
}
?>