<?php
require_once(SYSTEM_LOGICS . 'login/model.php');

class LogicLogin extends LoginModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {
				$this -> regist();	// ログイン履歴を登録
				$this -> update();	// 最終ログイン日時を更新

				header('Location: /en/menu');
				exit();
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録処理
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_ACTIVITY', array($this -> getAdminUserData(PARAM_UID)
															, $_SERVER[PARAM_REMOTE_ADDR]
															, $_SERVER[PARAM_HTTP_USER_AGENT]
															, VAL_INT_10
															, date("Y-m-d H:i:s")
															, 'Logged In'));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新処理
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('UPDATE_LAST_LOGIN_TIME', array($this -> getAdminUserData(PARAM_UID)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>