<?php

/*-------------------------------------------------------------------------
* @ 画面定数定義
-------------------------------------------------------------------------*/

class Checker extends Chiket {

	/*-------------------------------------------------------------------------
	* @function_name: コンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのNULL判定
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkNull($data) {
		if($data == NO_STRING) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ長さチェック
	* @parameter	: チェックデータ、最低長、最高長
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkLength($data
						, $min
						, $max) {

		// 変数宣言部
		$len = mb_strlen($data, CHAR_SET_UTF_8);	// データの長さ
		// 文字列の長さチェック
		if($len < $min
			|| $len > $max) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ範囲チェック
	* @parameter	: チェックデータ、最低、最高
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkRange($data
						, $min
						, $max) {

		// 変数宣言部
		$len = floatval($data);	// データの長さ

		// 文字列の長さチェック
		if($len < $min
			|| $len > $max) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ範囲チェック
	* @parameter	: 金額、通貨、最低値、最高値(USD)
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkRangeCurrency($data
								, $currency
								, $min = NO_COUNT
								, $max) {

		// 変数宣言部
		$minValue	= NO_COUNT;
		$exchange	= NO_COUNT;

		// 最低値
		if($min == NO_COUNT) {	// 指定していない場合
			$minValue = VAL_INT_1 / $this -> getDigit($currency);

		} else {				// 指定している場合
			$minValue = $min;
		}

		// 最高値(USD)
		$exchange	= $this -> getExchangeCommon($max, USD, $currency);
		$max		= $exchange[PARAM_AMOUNT];

		// レンジチェック
		if($data		< $minValue
			|| $data	> $max) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（半角英数）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAscii($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（中文）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAsciiCN($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII_CN, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（パスワード）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringPassword($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_PASSWORD, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（パスワード第二チェック）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringPasswordSecond($data) {

		// 半角英数の正規表現チェック
// 		if (!preg_match(PREG_PASSWORD_SECOND_LOWER, $data)) {
// 			return false;
// 		}

		if (!preg_match(PREG_PASSWORD_SECOND_UPPER, $data)) {
			return false;
		}

		if (!preg_match(PREG_PASSWORD_SECOND_NUMBER, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（URL）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringURL($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_URL, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（アルファベット）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAlphabet($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ALPHABET, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（アルファベットとスペース）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAlphabetAndSpace($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ALPHABET_SPACE, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（都道府県、市区町村）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAsciiStateAndCity($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII_STATE_CITY, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（半角英数とスペース）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAsciiAndSpace($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII_SPACE, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（半角数字）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringNumber($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_NUMBER, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（半角数字少数なし）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringNumberOnly($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_PASSWORD_SECOND_NUMBER, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（郵便番号）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringNumberZipCode($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_NUMBER_ZIP_CODE, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（電話番号）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringNumberTel($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_NUMBER_TEL, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（メールアドレス）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringMailAddress($data) {
	    return filter_var($data, FILTER_VALIDATE_EMAIL);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（住所）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringAddress($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII_ADDRESS, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（住所）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringWithdraw($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII_WITHDRAW, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: データ正規表現チェック（メッセージ）
	 * @parameter	: チェックデータ
	 * @return		: 成功:TRUE、失敗:FALSE
	 -------------------------------------------------------------------------*/
	function checkStringMessage($data) {

		// メッセージのチェック
		if (mb_strpos($data, "\"") !== false) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ正規表現チェック（KYC書類拡張子）
	* @parameter	: チェックデータ
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringExtension($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_ASCII_EXTENSION, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ可能性のチェック
	* @parameter	: 場所
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkAvailability($location, $callback = null){
	    switch($location){
	        case "site":
	        case "system":
	            break;
	        default:{
	            echo "Unknown Location: {$location}";
	            return true;
	        }
	    }
	    
	    $maintenanceMode = $this -> getSettingConfiguration("maintenance_mode_{$location}");
	    
	    if($maintenanceMode){
	        $whitelistedIpAddress = explode(",", $maintenanceMode -> exceptIpAddress);
	        
	        if($maintenanceMode -> enabled){
	            if(!in_array($this -> getColumnData($_SERVER, "REMOTE_ADDR"), $whitelistedIpAddress)){
	                if($callback != null)
	                   $callback();
	                
	                return false;
	            }
	        }
	    }
	    
	    return true;
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: 管理者ユーザ存在チェック
	* @parameter	: ユーザ名、ユーザパスワード
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function checkAdminUser($userName, $userPass) {

        // 変数宣言部
		$param = array();

        //get account via user name
        $param[]    = $userName;
        $res        = $this -> getRowData($this -> accessSelect('SELECT_LOGIN_BY_USER_NAME', $param));
        $password   = $this ->getColumnData($res, 'password');

        //verify password
        if(password_verify($userPass.VAL_STR_AUTH_HASH_SECRET_KEY, $password)) {
            $param = array();

            // パラメータ設定
    		$param[] = $userName;
    		$param[] = $password;
    		$param[] = WHITE_LABEL_ID;

    		return $this -> accessSelect('SELECT_ADMIN_LOGIN', $param);
        }

        return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一般ユーザ存在チェック
	* @parameter	: ユーザ名、ユーザパスワード
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function checkUser($userName, $userPass) {

		// 変数宣言部
		$param = array();

        //get account via user name
        $param[]    = $userName;
        $res        = $this -> getRowData($this -> accessSelect('SELECT_LOGIN_BY_USER_NAME', $param));
        $password   = $this ->getColumnData($res, 'password');

        //verify password
        if(password_verify($userPass.VAL_STR_AUTH_HASH_SECRET_KEY, $password)) {
            $param = array();

            // パラメータ設定
    		$param[] = $userName;
    		$param[] = $password;
    		$param[] = WHITE_LABEL_ID;

    		return $this -> accessSelect('SELECT_LOGIN', $param);
        }

        return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 現在のパスワードチェック
	* @parameter	: 口座番号、パスワード
	* @return		: 存在する：TRUE、存在しない：FALSE
	-------------------------------------------------------------------------*/
	function checkPassword($account, $password) {

		// 変数宣言部
		$rtn	= true;
		$rs 	= null;
		$row 	= null;
		$pass 	= NO_STRING;

		$rs = $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($account));

		if(count($rs) != VAL_INT_1) {
			$rtn = false;
		}

		$row	= $this -> getRowData($rs);
		$pass	= $this -> getColumnData($row, COLUMN_PASSWORD);

		if(!password_verify($password.VAL_STR_AUTH_HASH_SECRET_KEY, $pass)) {
			$rtn = false;
		}

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: ユーザ存在チェック
	* @parameter	: ユーザID
	* @return		: 存在する：TRUE、存在しない：FALSE
	-------------------------------------------------------------------------*/
	function checkSiteUserId($userName) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs 	= null;

		// パラメータ設定
		$param[] = $userName;

		return $this -> accessSelect(SELECT_LOGIN_ID, $param);

		if(count($rs) != VAL_INT_1) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザの存在チェック
	* @parameter	: メールアドレス、ユーザパスワード
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function checkSiteUser($mailAddress, $userPass) {

		// 変数宣言部
		$param = array();

		// パラメータ設定
		$param[] = $mailAddress;
		$param[] = $userPass;

		return $this -> accessSelect(CHECK_LOGIN_SITE_USER, $param);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザの存在チェック
	* @parameter	: メールアドレス
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function checkMailAddress($mailAddress) {

		// 変数宣言部
		$rtn 	= true;
		$param	= array();
		$rs 	= null;

		// パラメータ設定
		$param[] = $mailAddress;

		// データの取得
		$rs = $this -> accessSelect('EXIST_SITE_USER_MAIL_ADDRESS', $param);

		if(count($rs) > NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザの存在チェック
	* @parameter	: メールアドレス、口座番号
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function checkMailAddressAnother($mailAddress, $userAccount) {

		// 変数宣言部
		$rtn 	= true;
		$param	= array();
		$rs 	= null;

		// パラメータ設定
		$param[] = $mailAddress;
		$param[] = $userAccount;

		// データの取得
		$rs = $this -> accessSelect('EXIST_SITE_USER_MAIL_ADDRESS_ANOTHER', $param);

		if(count($rs) > NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの重複チェック
	* @parameter	: メールアドレス
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkExistMailAddress($mailAddress) {

		// 変数宣言部
		$rtn 	= true;
		$param	= array();
		$rs 	= null;

		// パラメータ設定
		$param[] = $mailAddress;

		// データの取得
		$rs = $this -> accessSelect('LIST_SITE_USER_MAIL_ADDRESS', $param);

		if(count($rs) > NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードチェック
	* @parameter	: エージェントコード
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkExistAgentCode($agent) {

		// 変数宣言部
		$rtn 	= true;
		$param	= array();
		$rs 	= null;

		// パラメータ設定
		$param[] = $agent;

		// データの取得
		$rs = $this -> accessSelect('SELECT_AGENT_CODE', $param);

		if(count($rs) == NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザのログインチェック
	* @parameter	: なし
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkSiteUserLogin() {

		// 変数宣言部
		$rtn = true;

		if(!isset($_SESSION)) {
			return false;
		}

		if(!isset($_SESSION[SITE_USER_DATA])) {
			return false;
		}

		// サイトユーザデータのセッションが存在するか確認
		if($this -> isLoopData($_SESSION[SITE_USER_DATA])) {

			// サイトユーザデータが正常に設定されているか
			if(!isset($_SESSION[SITE_USER_DATA][PARAM_UID])
				|| !isset($_SESSION[SITE_USER_DATA][PARAM_USER_ACCOUNT])) {
				$rtn = false;
			}
		} else {
			$rtn = false;
		}

		$res = $this -> getRowData($this -> accessSelect('SELECT_USER_STATUS', array($_SESSION[SITE_USER_DATA][PARAM_USER_ACCOUNT])));
		$status = $this -> getColumnData($res, 'status');

		if($status==VAL_INT_5){
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 管理者ユーザのログインチェック
	* @parameter	: なし
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkAdminUserLogin() {

		// 変数宣言部
		$rtn = true;

		if(!isset($_SESSION)) {
			return false;
		}

		if(!isset($_SESSION[USER_DATA])) {
			return false;
		}

		// サイトユーザデータのセッションが存在するか確認
		if($this -> isLoopData($_SESSION[USER_DATA])) {

			// サイトユーザデータが正常に設定されているか
			if(!isset($_SESSION[USER_DATA][PARAM_UID])
			|| !isset($_SESSION[USER_DATA][PARAM_USER_ID])) {
				$rtn = false;
			}
		} else {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザの存在チェック
	* @parameter	: サイトユーザUID
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function checkSiteUserForUid($uid) {

		// 変数宣言部
		$param = array();

		// パラメータ設定
		$param[] = $uid;

		return $this -> accessSelect('CHECK_LOGIN_UID', $param);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 日付のチェックを行う
	* @parameter	: なし
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkDate($y, $m, $d) {
		return checkdate($m
						, $d
						, $y);
	}


	/*-------------------------------------------------------------------------
	* @function_name: 日付のチェックを行う
	* @parameter	: なし
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkNumber($val) {

		if(is_numeric($val)) {
			return true;
		} else {
			return false;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザのセッションチェック
	* @parameter	: なし
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkSiteUserSession() {

		if(!isset($_SESSION[SITE_USER_DATA])) {
			return false;
		}

		if(!isset($_SESSION[SITE_USER_DATA][PARAM_POST_UID])) {
			return false;
		}

		if(!isset($_SESSION[SITE_USER_DATA][PARAM_POST_EMAIL])) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 文字数のチェック
	* @parameter	: なし
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkStringLength($data, $len) {

		// 変数宣言部
		$rtn = true;

		if(mb_strlen($data) != $len) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料設定時の全適用重複登録不可
	* @parameter	: チェックデータ
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkMstFeesTargetAll($data) {

		// 変数宣言部
		$rtn	= true;
		$rs		= null;

		// 全適用での登録の場合
		if($data == NO_COUNT) {

			// 全適用の取得
			$rs = $this -> accessSelect('LIST_FEES_BY_TARGET_TYPE', array(NO_COUNT));

			// 存在したらエラー
			if(count($rs) > NO_COUNT) {
				$rtn = false;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料設定時の全適用重複登録不可
	* @parameter	: チェックデータ
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkMstFeesTargetName($data, $fId) {

		// 変数宣言部
		$rtn	= true;
		$rs		= null;

		// 手数料データの取得
		$rs = $this -> accessSelect('LIST_FEES_BY_TARGET_TYPE_NAME', array($data));

		// 存在の確認
		if(count($rs) > NO_COUNT) {

			if($fId == NO_STRING) {													// 登録の場合エラー
				$rtn = false;
			} else if($fId != $this -> getColumnData($rs[NO_COUNT], COLUMN_F_ID)) {	// IDが違ったらエラー
				$rtn = false;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 親エージェントコード登録チェック
	* @parameter	: チェックデータ
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkParentAgentCode($code) {

		// 変数宣言部
		$rtn	= true;
		$rs		= null;
		$row	= null;

		// データの取得
		$rs = $this -> accessSelect('SELECT_AGENT_AGENT_CODE', array($code));

		// データの存在確認
		if(count($rs) == NO_COUNT) {
			$rtn = false;
		}

		if($rtn) {

			$row = $rs[NO_COUNT];

			// 親エージェントじゃないと登録できない
// 			if($this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE) != NO_STRING) {
// 				$rtn = false;
// 			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座番号の存在チェック
	 * @parameter	 : 口座番号
	 * @return		 : 結果セット
	 -------------------------------------------------------------------------*/
	function checkExistAccount($accountNumber) {

		// 変数宣言部
		$param 	= array();
		$rs		= null;

		// パラメータ設定
		$param[] = $accountNumber;

		$rs =  $this -> accessSelect('CHECK_EXIST_ACCOUNT', $param);

		if(count($rs) != VAL_INT_1) {
			return false;
		} else {
			return true;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座番号の存在チェック
	 * @parameter	: メールアドレス
	 * @return		: 結果セット
	 -------------------------------------------------------------------------*/
	function checkExistAccountFromMailAddress($mail) {

		// 変数宣言部
		$param 		= array();
		$rs			= null;
		$rtn		= array();

		// パラメータ設定
		$param[] = $mail;

		$rs		=  $this -> accessSelect('CHECK_EXIST_ACCOUNT_FROM_MAIL_ADDRESS', $param);
		$row	= $this -> getRowData($rs);

		$rtn[COLUMN_USER_ACCOUNT] 	= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
		$rtn[COLUMN_USER_NAME]		= $this -> getColumnData($row, COLUMN_USER_NAME);
		$rtn[PARAM_ACCOUNT_TYPE]		= $this -> getColumnData($row, PARAM_ACCOUNT_TYPE);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログインの失敗回数チェック
	* @parameter	: ユーザ名
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkLoginFail($uName) {

		// 変数宣言部
		$rtn		= true;
		$rs			= null;
		$row		= null;
		$timeDiff	= NO_COUNT;

		$rs = $this -> accessSelect('SELECT_LOGIN_FAIL', array($uName));

		if($this -> isLoopData($rs)) {

			$row = $this -> getRowData($rs);

			$timeDiff = intval($this -> getColumnData($row, COLUMN_DIFF_TIME));

			// 24時間以内
			if($timeDiff <= 86400) {
				$rtn = false;
			}
		}

		return $rtn;
	}

    /*-------------------------------------------------------------------------
	* @function_name: CheckWithdrawMinimum
	* @parameter	:  $withdrawCurrency, $amount
	* @return		: bool: if withdrawal amount is greater than minimum (50USD),
	*                 return true; else, return false
	-------------------------------------------------------------------------*/
    function CheckWithdrawMinimum($withdrawCurrency, $amount) {
        $rtn				= true;
        $exchange			= null;
        $exchangeAmount     = NO_COUNT;

        $exchange = $this -> getExchangeCommon($amount, $withdrawCurrency, 'USD');

        $exchangeAmount = ($withdrawCurrency != 'USD') ? $exchange[PARAM_ORIGINAL_AMOUNT] : $amount;

        if ($exchangeAmount < VAL_INT_MINIMUM_WITHDRAW_AMOUNT) {
            $rtn = false;
        }

        return $rtn;
    }

	/*-------------------------------------------------------------------------
	* @function_name: 出金制限のチェック
	* @parameter	: 口座番号、通貨、金額
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkWithdrawLimit($account
								, $currency	= USD
								, $amount	= NO_COUNT) {

		// 変数宣言部
		$rtn				= true;
		$rs					= null;
		$row				= null;
		$exchange			= null;
		$withdrawCurrency	= NO_STRING;
		$withdrawAmount		= NO_COUNT;
		$total				= NO_COUNT;

		// 口座種別を確認する
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		// 無制限の場合は、成功
		if($this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_3) {
			return $rtn;
		}

		// 出金データを取得する
		$rs = $this -> accessSelect('SELECT_USER_BALANCES_BY_WITHDRAW_LIMIT', array($account));

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {

				// データ
				$withdrawCurrency	= $this -> getColumnData($row, COLUMN_CURRENCY);
				$withdrawAmount		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCurrency);

				// 通貨を統一する
				$exchange = $this -> getExchangeCommon($withdrawAmount, $withdrawCurrency, VAR_WITHDRAW_LIMIT_CURRENCY);

				$total += $exchange[PARAM_AMOUNT];

				if($total >= VAR_WITHDRAW_LIMIT_AMOUNT) {
					$rtn = false;
					break;
				}
			}
		}

		// まだリミットに達していない
		if($rtn) {

			$amount = $this -> intToCurrency($amount, $currency);

			// 通貨を統一する
			$exchange = $this -> getExchangeCommon($amount, $currency, VAR_WITHDRAW_LIMIT_CURRENCY);

			$total += $exchange[PARAM_AMOUNT];

			if($total >= VAR_WITHDRAW_LIMIT_AMOUNT) {
				$rtn = false;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一回あたりの送金額のチェック
	* @parameter	: 口座番号、通貨、金額
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkWithdrawLimitOneTimes($account
										, $currency	= USD
										, $amount	= NO_COUNT) {

		// 変数宣言部
		$rtn				= true;
		$rs					= null;
		$row				= null;
		$exchange			= null;
		$total				= NO_COUNT;

		// 口座種別を確認する
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		// 通貨を統一する
		$exchange	= $this -> getExchangeCommon($amount, $currency, USD, false, true);
		$total		= $exchange[PARAM_AMOUNT];

		if($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE) == VAL_INT_1) {	// 法人口座の場合（$50万）

			if($total > VAR_WITHDRAW_LIMIT_AMOUNT_ONE_TIMES_CORPRATION) {
				$rtn = false;
			}

		} else {																// その他（$5万）
			if($total > VAR_WITHDRAW_LIMIT_AMOUNT_ONE_TIMES_PARSON) {
				$rtn = false;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態のチェック
	* @parameter	: 口座番号、処理内容
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkAccountStatus($account, $proc) {

		// 変数宣言部
		$rtn = true;
		$rs = null;
		$row = null;

		// 口座情報を取得
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);
		$array = array(VAR_TRANSACTION_EXCHANGE, VAR_TRANSACTION_WITHDRAW, VAR_TRANSACTION_REQUEST_WITHDRAW, VAR_TRANSACTION_REQUEST_DEPOSIT, VAR_TRANSACTION_REQUEST_DEPOSIT, VAR_TRANSACTION_TRANSFER_WITHDRAW);
		// Currency exchange, withdrawal,  Withdrawal (List applied), Withdrawal (withdrawal request), Direct debit (withdrawal)

		if(in_array($proc, $array)) {

			if($this -> getColumnData($row, COLUMN_STATUS) == VAR_ACCOUNT_STATUS_DOMANT || $this -> getColumnData($row, COLUMN_STATUS) == VAR_ACCOUNT_STATUS_NORMAL_DOMANT || $this -> getColumnData($row, COLUMN_STATUS) == VAR_ACCOUNT_STATUS_EXEC_DOMANT) { // 休止は不可
				$rtn = false;
			}

		} else if($proc == VAR_TRANSACTION_TRANSFER_DEPOSIT) {	// Direct debit (deposit)

			if(($this -> getColumnData($row, COLUMN_STATUS) == VAR_ACCOUNT_STATUS_TEMPORARILY) || ($this -> getColumnData($row, COLUMN_STATUS) == VAR_ACCOUNT_STATUS_DELETE)) {	// 仮登録は不可
				$rtn = false;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座間送金時のチェックを行う
	* @parameter	: From口座番号、To口座番号、通貨、金額、引落し通貨
	* @return		: 結果セット（成功時：0、失敗時：その他）
	-------------------------------------------------------------------------*/
	function checkTransfer($from
							, $to
							, $currency
							, $amount
							, $debit) {

		// 変数宣言部
		$result			= array();
		$currencies 	= $this -> getCurrencyList();
		$flg			= true;
		$fromFee		= NO_COUNT;
		$toFee			= NO_COUNT;
		$rate			= VAL_INT_1;
		$debitAmount	= NO_COUNT;

		$result[PARAM_RESULT] = NO_COUNT;

		// 制限口座のチェック
		if(!$this -> checkWithdrawLimit($from
										, $currency
										, $this -> currencyToInt($amount, $currency))) {
			$result[PARAM_RESULT] = VAL_INT_3;
			return $result;
		}

		// From口座番号のチェック（必須）
		if(!$this -> checkNull($from)) {
			$result[PARAM_RESULT] = VAL_INT_3;
			return $result;
		}

		// From口座の存在チェック
		if(!$this -> checkExistAccount($from)) {
			$result[PARAM_RESULT] = VAL_INT_3;
			return $result;
		}

		// To口座番号のチェック
		if(!$this -> checkNull($to)) {
			$result[PARAM_RESULT] = VAL_INT_1;
			return $result;
		}

		if(!$this -> checkExistAccount($to)) {
			$result[PARAM_RESULT] = VAL_INT_1;
			return $result;
		}

		// 同一口座チェック（口座番号）
		if($from == $to) {
			$result[PARAM_RESULT] = VAL_INT_99;
			return $result;
		}

		// 通貨のチェック
		if(!$this -> checkNull($currency)) {
			$result[PARAM_RESULT] = VAL_INT_99;
			return $result;
		}

		// 通貨の存在確認
		if($this -> isLoopData($currencies)) {

			$flg = false;

			foreach($currencies as $val) {

				// 通貨のチェック
				if(strtoupper($this -> getColumnData($val, PARAM_DATA_KEY)) == strtoupper($currency)) {
					$flg = true;
					break;
				}
			}

			if(!$flg) {
				$result[PARAM_RESULT] = VAL_INT_99;
				return $result;
			}

		} else {
			$result[PARAM_RESULT] = VAL_INT_99;
			return $result;
		}

		// 引落し通貨のチェック
		if(!$this -> checkNull($debit)) {
			$result[PARAM_RESULT] = VAL_INT_99;
			return $result;
		}

		// 通貨の存在確認
		if($this -> isLoopData($currencies)) {

			$flg = false;

			foreach($currencies as $val) {

				// 通貨のチェック
				if(strtoupper($this -> getColumnData($val, PARAM_DATA_KEY)) == strtoupper($debit)) {
					$flg = true;
					break;
				}
			}

			if(!$flg) {
				$result[PARAM_RESULT] = VAL_INT_99;
				return $result;
			}

		} else {
			$result[PARAM_RESULT] = VAL_INT_99;
			return $result;
		}

		// 金額のチェック
		if(!$this -> checkNull($amount)) {
			$result[PARAM_RESULT] = VAL_INT_2;
			return $result;
		}

		// 正規表現チェック（半角数字）
		if(!$this -> checkStringNumber($amount)) {
			$result[PARAM_RESULT] = VAL_INT_2;
			return $result;
		}

		// 通貨が違えば両替
		if($currency != $debit) {
			$exchange		= $this -> getExchangeCommon($amount, $currency, $debit, false, true, NO_STRING, $from);
			$debitAmount	= $exchange[PARAM_AMOUNT];
			$rate			= $exchange[PARAM_RATE];

		} else {
			$debitAmount	= $amount;
			$rate			= VAL_INT_1;
		}

		// 手数料取得
		$fee = $this -> getFeeCommon(VAR_TRANSFER
										, $debitAmount
										, $debit
										, $from
										, $to
										, $currency
										, $amount);
// print_r($fee);
		// 最小金額を算出
		$digit	= $this -> getDigit($debit);
		$low	= VAL_INT_1 / $digit;

		// 送金元手数料設定
		if($fee[$debit . VAL_INT_1] > NO_COUNT) {

			// 小数点を桁数で切り捨て
			$fromFee 	= floor($fee[$debit . VAL_INT_1] * $digit);
			$fromFee	= $fromFee / $digit;

			// 0の場合は最低金額を設定
			if($fromFee < $low) {
				$fromFee = $low;
			}
		} else {
			$low = NO_COUNT;
		}

		// 送金先手数料設定
		if($fee[$currency . VAL_INT_2] > NO_COUNT) {

			$digit	= $this -> getDigit($currency);

			// 異通貨で手数料が発生している場合
			if($currency != $debit) {

				$toFee	= $fee[$currency . VAL_INT_2];

				// 小数点を桁数で切り捨て
				$toFee 	= floor($toFee * $digit);
				$toFee	= $toFee / $digit;

			} else {

				// 小数点を桁数で切り捨て
				$toFee 	= floor($fee[$debit . VAL_INT_2] * $digit);
				$toFee	= $toFee / $digit;
			}

			// 最小金額を算出

			$low	= VAL_INT_1 / $digit;

			// 0の場合は最低金額を設定
			if($toFee < $low) {
				$toFee = $low;
			}

		} else {
			$toFee = NO_COUNT;
		}

		// 残高取得
		$balance = $this -> getBalanceCommon($from, $debit);

		// 最低送金額のチェック
		if($amount < $low) {
			$result[PARAM_RESULT] = VAL_INT_2;
			return $result;
		}

		// 残高チェック
		if($balance < ($debitAmount + $fromFee)) {
			$result[PARAM_RESULT] = VAL_INT_2;
			return $result;
		} else {

			$result[PARAM_AMOUNT]	= $debitAmount;
			$result[PARAM_FROM_FEE]	= $fromFee;
			$result[PARAM_TO_FEE]	= $toFee;
			$result[PARAM_RATE]		= $rate;

			return $result;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国のスペルチェック
	* @parameter	: 国名
	* @return		: 結果セット（成功時：true、失敗時：false）
	-------------------------------------------------------------------------*/
	function checkCountrySpell($country) {

		// 変数宣言部
		$rtn = false;
		$countries = $this -> getCountyList();

		// データが存在する場合
		if($this -> isLoopData($countries)) {

			foreach($countries as $val) {

				if($this -> getColumnData($val, PARAM_DATA_VALUE) == $country) {
					$rtn = true;
					break;
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 最低額のチェック
	* @parameter	: 通貨、金額（切り捨て処理も行う）
	* @return		: 結果セット（成功時：true、失敗時：false）
	-------------------------------------------------------------------------*/
	function checkMinimum($currency, &$amount) {

		// 変数宣言部
		$rtn		= true;
		$digit		= $this -> getDigit($currency);	// 通貨の桁数
		$minimum	= NO_COUNT;

		// まずは、金額の切り捨て処理を行う
		$amount	= floor(bcmul($amount, $digit, 2));
		$amount	= bcdiv($amount, $digit, 2);

		// 最低額の算出
		$minimum = bcdiv(VAL_INT_1, $digit, 2);

		// 最低額未満の場合エラー
		if($minimum > $amount) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のチェック
	* @parameter	: 通貨
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkCurrency($currency) {

		// 変数宣言部
		$rtn	= true;
		$test	= NO_STRING;

		$test = $this-> dispCurrencyCommon($currency);

		if($test == '無効') {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済シグネチャのチェック
	* @parameter	: 口座番号、シグネチャ、ユーザ口座番号（参照）
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkSettlementSignature($pnum
										, $signature
										, &$userAccount) {

		// 変数宣言部
		$rtn	= true;
		$rs		= null;
		$row	= null;
		$sig	= NO_STRING;

		// シグネチャ生成用のデータを取得する
		$rs		= $this -> accessSelect('SELECT_API_SIGNATURE_BY_A_ID', array($pnum));
		$row	= $this -> getRowData($rs);
		$sig = hash('sha256'
					, $this -> getColumnData($row, COLUMN_USER_NAME)
					. $this -> getColumnData($row, COLUMN_PASSWORD)
					. $this -> getColumnData($row, COLUMN_A_ID));

		if($sig != $signature) {
			$rtn = false;
		} else {
			$userAccount = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: IPアドレスのチェック
	* @parameter	: 番組コード
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkSettlementIpAddress($pnum, $validationProperty, &$isDisabled = false) {
		// 変数宣言部
		$rtn		= true;

		// シグネチャ生成用のデータを取得する
		$row	     = $this -> getRowData($this -> accessSelect('SELECT_API_SIGNATURE_BY_A_ID', array($pnum)));
		$ip		     = $this -> getColumnData($row, COLUMN_IP_ADDRESS);
		$allowSet    = $this -> getColumnData($row, COLUMN_WHITELIST_SETTING);
		$ips	     = explode(DELIMIT_COMMA, $ip);

        //error_log paths
        $logPath 		= SYSTEM_PATH.DIRECTORY_SEPARATOR.'documents'.DIRECTORY_SEPARATOR.'error_log';
        $serverLogPath 	= $logPath.DIRECTORY_SEPARATOR.'Visitor_server_params';

        //check if directory exists if not, create directory
        if(!file_exists($serverLogPath)) 
            mkdir($serverLogPath, 0777, true);

        //log the transaction details
        error_log(date("[Y-m-d H:i:s]")."\r\n".print_r($_SERVER,true)."\r\n", 3, $serverLogPath.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
        chmod($serverLogPath.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

		// 接続IPアドレス
		$connecter = $this -> getColumnData($_SERVER, PARAM_HTTP_REFERER);

		// リファラがなければ、エラー
		if($connecter == NO_STRING) {	// リファラなし
			$connecter = $this -> getColumnData($_SERVER, 'REMOTE_ADDR');

			if($connecter == NO_STRING) 
				return false;
			
		} else {						// リファラあり
			$connecter = parse_url($connecter);
			$connecter = gethostbyname($this -> getColumnData($connecter, PARAM_HOST));
		}

		$rtn = false;
		
		if($this -> checkJSONString($allowSet)){
		    $allowSet = json_decode($allowSet);
		    
		    if(isset($allowSet -> {$validationProperty})){
		        if($allowSet -> {$validationProperty}){
		            if($this -> isLoopData($ips))
		                $rtn = in_array($connecter, $ips);
		        }else
		            $isDisabled = ["exception" => "The {$validationProperty} setting is disabled"];
		    }else{
		        switch($validationProperty){
		            case "mandatory":
		                if($this -> isLoopData($ips))
		                    $rtn = in_array($connecter, $ips);
		                break;
		            default:
		                $isDisabled = ["exception" => "Invalid Validation Property"];
		                break;
		        } 
		    }
		        
		}else
		    $isDisabled = ["exception" => "Invalid Setting Data"];

		return $rtn;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: Domainのチェック
	 * @parameter	: 番組コード
	 * @return		: 成功:TRUE、失敗:FALSE
	 -------------------------------------------------------------------------*/
	function checkSettlementDomain($pnum, $validationProperty, &$isDisabled = false) {
	    // 変数宣言部
	    $rtn		= true;
	    
	    // シグネチャ生成用のデータを取得する
	    $row	     = $this -> getRowData($this -> accessSelect('SELECT_API_SIGNATURE_BY_A_ID', array($pnum)));
	    $domain      = $this -> getColumnData($row, COLUMN_DOMAINS);
	    $allowSet    = $this -> getColumnData($row, COLUMN_WHITELIST_SETTING);
	    $domains	 = explode(DELIMIT_COMMA, $domain);
	    
	    //error_log paths
	    $logPath 		= SYSTEM_PATH.DIRECTORY_SEPARATOR.'documents'.DIRECTORY_SEPARATOR.'error_log';
	    $serverLogPath 	= $logPath.DIRECTORY_SEPARATOR.'Visitor_server_params';
	    
	    //check if directory exists if not, create directory
	    if(!file_exists($serverLogPath)) 
	        mkdir($serverLogPath, 0777, true);
	    
	    //log the transaction details
	    error_log(date("[Y-m-d H:i:s]")."\r\n".print_r($_SERVER,true)."\r\n", 3, $serverLogPath.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
	    chmod($serverLogPath.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
	    
	    // 接続IPアドレス
	    $connecter = $this -> getColumnData($_SERVER, PARAM_HTTP_REFERER);
	    
	    // リファラがなければ、エラー
	    if($connecter == NO_STRING) {	// リファラなし
	        $connecter = $this -> getColumnData($_SERVER, 'REMOTE_ADDR');
	        
	        if($connecter == NO_STRING) 
	            return false;
	        
	    } else {						// リファラあり
	        $connecter = parse_url($connecter);
	        $connecter = $this -> getColumnData($connecter, PARAM_HOST);
	    }
	    
	    $rtn = false;
	    
	    if($this -> checkJSONString($allowSet)){
	        $allowSet = json_decode($allowSet);
	        
	        if($allowSet -> {$validationProperty}){
	            if($this -> isLoopData($domains))
	                $rtn = in_array($connecter, $domains);
	        } else 
	            $isDisabled = ["exception" => "The {$validationProperty} setting is disabled"];
	    }else
	        $isDisabled = ["exception" => "Invalid Setting Data"];
	    
	    return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CHIDとカード番号の存在チェック
	* @parameter	: CHID、カード番号
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkExistCHIDAndCardNumber($chid, $card) {

		// 変数宣言部
		$rs = null;

		// データの取得
		$rs = $this -> accessSelect('SELECT_USER_CARD_BY_CHID_CARD_NUMBER', array($chid, $card));

		if($this -> isLoopData($rs)) {	// 存在する
			return false;
		} else {						// 存在しない
			return true;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: CHIDとカード番号の存在チェック
	* @parameter	: CHID、カード番号
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkSignature($sig, $str) {

		if($sig != hash('sha256', $str)) {
			throw new Exception('E_WRONG_SIGNATURE');
		}
	}
	
    /*-------------------------------------------------------------------------
	* @function_name: JSON表現の確認
	* @parameter	: String
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkJSONString($string){
	    return is_string($string)
    	    && is_array(json_decode($string, true))
    	    && (json_last_error() == JSON_ERROR_NONE) ? true : false;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 無制限会員のチェック
	* @parameter	: 口座番号
	* @return		: 無制限会員:TRUE、その他:FALSE
	-------------------------------------------------------------------------*/
	function checkUnlimitedStatus($account) {

		// 変数宣言部
		$rtn			= false;
		$accountData	= $this -> getRowData($this -> getAccountCommon($account));

		if($this -> getColumnData($accountData, COLUMN_STATUS) == VAL_INT_3
			|| $this -> getColumnData($accountData, COLUMN_STATUS) == VAL_INT_7) {
			$rtn = true;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通常账户判断
	* @parameter	: 口座番号
	* @return		: 無制限会員:TRUE、その他:FALSE
	-------------------------------------------------------------------------*/
	function checkUsuallyStatus($account) {

		// 変数宣言部
		$rtn			= false;
		$accountData	= $this -> getRowData($this -> getAccountCommon($account));

		if($this -> getColumnData($accountData, COLUMN_STATUS) == VAL_INT_2) {
			$rtn = true;
		}

		return $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: CUP入金1時間のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkCUPDeposit1Hour($account) {

		// 変数宣言部
		$rtn = true;
		$row = null;
		$params = array();

		$params[] = $account;
		$params[] = date("Y-m-d H:i:s",strtotime('-1 hour'));

		// 一時データを取得する
		$row = $this -> getRowData($this -> accessSelect('COUNT_CUP_DEPOSIT_TEMPORARY_1_HOUR', $params));

			if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAR_CUP_PERHOUR_LIMIT_AMOUNT) {
				$rtn = false;
            }
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CUP入金24時間のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkDepositByCUP24Hour($account) {

		// 変数宣言部
		$rtn = true;
		$row = null;

		// 一時データを取得する
		$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_CUP_24_HOUR', array($account)));

			if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAR_CUP_DAY_LIMIT_TIMES) {
				$rtn = false;
            }
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CUP入金30日のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkDepositByCUP1Days($account, $dep = NO_COUNT) {

		// 変数宣言部
		$rtn	= true;
		$row	= null;
		$amount	= NO_COUNT;

		// 一時データを取得する
		$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_CUP_AMOUNT_1_DAY', array($account)));

		// 決済合計金額の取得
		$amount = $this -> intToCurrency(intval($this -> getColumnData($row, COLUMN_COUNTER)), CNY) + $dep;

		/*echo "<br>";
		var_dump($amount);
		die();
        */

		$_SESSION['nowAmount'] = $amount;

			if($amount >= VAR_CUP_DAY_LIMIT_AMOUNT) {
				$rtn = false;
            }
		return $rtn;
	}



	/*-------------------------------------------------------------------------
	* @function_name: CUP入金1時間のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkCashFlowDeposit1Hour($account) {

		// 変数宣言部
		$rtn = true;
		$row = null;
		$params = array();

		$params[] = $account;
		$params[] = date("Y-m-d H:i:s",strtotime('-1 hour'));

		// 一時データを取得する
		$row = $this -> getRowData($this -> accessSelect('COUNT_CASHFLOW_DEPOSIT_TEMPORARY_1_HOUR', $params));

		// 1時間のチェックを行う
		if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAL_INT_5) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: vip会員のチェック
	* @parameter	: 口座番号
	* @return		: vip会員:TRUE、その他:FALSE
	-------------------------------------------------------------------------*/
	function checkVIPStatus($account) {

		// 変数宣言部
		$rtn			= false;
		$accountData	= $this -> getRowData($this -> getAccountCommon($account));

		if($this -> getColumnData($accountData, COLUMN_GPS_ACCOUNT_FLG) == VAL_INT_1) {
			$rtn = true;
		}

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: カード入金24時間のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkDepositByCard24Hour($account) {

		// 変数宣言部
		$rtn = true;
		$row = null;

		// 一時データを取得する
		if($this -> getType() == CASHFLOW_DEPOSIT_INPUT){
			$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_CASHFLOW_24_HOUR', array($account)));
		}elseif ($this -> getType() == TYPE_ZANETA_INPUT) {
			$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_ZANETAPAY_24_HOUR', array($account)));
		}

		if(!isset($_SESSION['account_Category'])){
			$rtn = false;
		}else if($_SESSION['account_Category'] == 'vip'){
			// 24時間のチェックを行うvip限制
			if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAR_CASHFLOW_LIMIT_TIMES_VIP) {
				$rtn = false;
			}
		}else if($_SESSION['account_Category'] == 'normal'){
			// 24時間のチェックを行うvip限制
			if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAR_CASHFLOW_LIMIT_TIMES_NORMAL) {
				$rtn = false;
			}
		}
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金30日のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkDepositByCard30Days($account, $dep = NO_COUNT) {

		// 変数宣言部
		$rtn	= true;
		$row	= null;
		$amount	= NO_COUNT;

		// 一時データを取得する
		if($this -> getType() == CASHFLOW_DEPOSIT_INPUT){
			$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_CASHFLOW_30_DAY', array($account)));
		}elseif ($this -> getType() == TYPE_ZANETA_INPUT) {
			$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_ZANETAPAY_30_DAY', array($account)));
		}
		// 決済合計金額の取得
		//$amount = $this -> intToCurrency(intval($this -> getColumnData($row, COLUMN_COUNTER)), USD) + $dep;

		//分别获取各个货币的入金金额
		$USD = $this -> intToCurrency(intval($this -> getColumnData($row, USD)), USD) + $dep;
		$EURAmount = $this -> intToCurrency(intval($this -> getColumnData($row, EUR)), USD) + $dep;
		$GBPAmount = $this -> intToCurrency(intval($this -> getColumnData($row, GBP)), USD) + $dep;
		$JPYAmount = $this -> intToCurrency(intval($this -> getColumnData($row, JPY)), USD) + $dep;

		//汇率换算，所有的币种换算成美元后的入金金额
		if($EURAmount != 0){
			$EURAmount = $this -> getExchangeCommon($EURAmount, EUR, USD, true, true);
			$EUR = $EURAmount[PARAM_AMOUNT];
		}else{
			$EUR = 0;
		}
		if($GBPAmount != 0){
			$GBPAmount = $this -> getExchangeCommon($GBPAmount, GBP, USD, true, true);
			$GBP = $GBPAmount[PARAM_AMOUNT];
		}else{
			$GBP = 0;
		}
		if($JPYAmount != 0){
			$JPYAmount = $this -> getExchangeCommon($JPYAmount, JPY, USD, true, true);
			$JPY = $JPYAmount[PARAM_AMOUNT];
		}else{
			$JPY = 0;
		}

		// 決済合計金額の取得
		$amount = $EUR + $USD + $GBP + $JPY;

		$_SESSION['nowAmount'] = $amount;
		if(!isset($_SESSION['account_Category'])){
			$rtn = false;
		}else if($_SESSION['account_Category'] == 'vip'){
			// 30日のチェックを行うvip限制
			if($amount >= VAR_CASHFLOW_LIMIT_AMOUNT_VIP) {
				$rtn = false;
			}
		}else if($_SESSION['account_Category'] == 'normal'){
			// 30日のチェックを行うvip限制
			if($amount >= VAR_CASHFLOW_LIMIT_AMOUNT_NORMAL) {
				$rtn = false;
			}
		}
		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: カード入金30日のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkCUPMoneyInExceed($amount) {
		// 変数宣言部
		$rtn	= true;

		//计算入金金额的美元数

		$resultAmount = $_SESSION['nowAmount'] + $amount;

		if($_SESSION['account_Category'] == 'vip'){
			// 1日のチェックを行うvip限制
			if($resultAmount >= VAR_CUP_DAY_LIMIT_AMOUNT_VERTIFY) {
				$rtn = false;
			}
		}else{
			// 1日のチェックを行うvip限制
			if($resultAmount >= VAR_CUP_DAY_LIMIT_AMOUNT_NOVERTIFY) {
				$rtn = false;
			}
		}
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金30日のチェック
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkMoneyInExceed($amount, $currency) {
		// 変数宣言部
		$rtn	= true;

		//计算入金金额的美元数
		if($currency == USD){
			//如果入金币种为美元，直接加
			$resultAmount = $_SESSION['nowAmount'] + $amount;
		}else{
			//非美元，换算成美元
			// まずは金額をUSDに合わせる
			$exChange = $this -> getExchangeCommon($amount, $currency, USD, true, true);
			$exChangeAmount = $exChange[PARAM_AMOUNT];
			$resultAmount = $_SESSION['nowAmount'] + $exChangeAmount;
		}

		if($_SESSION['account_Category'] == 'vip'){
			// 30日のチェックを行うvip限制
			if($resultAmount >= VAR_CASHFLOW_LIMIT_AMOUNT_VIP) {
				$rtn = false;
			}
		}else{
			// 30日のチェックを行うvip限制
			if($resultAmount >= VAR_CASHFLOW_LIMIT_AMOUNT_NORMAL) {
				$rtn = false;
			}
		}
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSリミットチェック
	* @parameter	: 口座番号、決済種別
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkGPSLimit($userAccount
							, $method
							, &$errType) {

		// 変数宣言部
		$account	= null;		// 口座情報
		$rs			= null;		// レスポンスデータ
		$cntCard	= NO_COUNT;	// クレジットカードカウンタ
		$cntBank	= NO_COUNT;	// 銀行カウンタ
		$amtCard	= NO_COUNT;	// クレジットカード合計額
		$amtBank	= NO_COUNT;	// 銀行合計額
		$arrMethod	= NO_COUNT;	// メソッドの分割
		$kind		= NO_COUNT;	// リミット
		$limit		= NO_COUNT;	// リミット

		// 口座情報を取得する
		$account = $this -> getRowData($this -> getAccountCommon($userAccount));

		$arrMethod = $this -> makeArrayByPowerCommon($this -> getColumnData($account, COLUMN_GPS_KIND_OF_PAYMENT));

		// メソッドに対応しているか否か
		if($method == PARAM_GPS_VISA){								// VISA決済
			if($this -> getColumnData($arrMethod, NO_COUNT) == NO_COUNT) {
				$errType = VAL_INT_1;
				return false;
			}
		} else if($method == PARAM_GPS_GIFTCARD) {					// MasterCard決済
			if($this -> getColumnData($arrMethod, VAL_INT_1) == NO_COUNT) {
				$errType = VAL_INT_1;
				return false;
			}

		} else if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金決済
			if($this -> getColumnData($arrMethod, VAL_INT_2) == NO_COUNT) {
				$errType = VAL_INT_1;
				return false;
			}
		}

		// 通常若しくは、無制限でないと入金無理
		if(!($this -> getColumnData($account, PARAM_STATUS)			== VAL_INT_2
				|| $this -> getColumnData($account, PARAM_STATUS)	== VAL_INT_3)) {	// 通常以外は処理できない
			return false;
		}

		$kind = intval($this -> getColumnData($account, COLUMN_GPS_ACCOUNT_FLG));

		if($kind == VAL_INT_1) {		// VIP口座の場合

			// 24時間リミット用のデータを取得する
			$rs = $this -> accessSelect('LIST_GPS_RESPONSE_24_HOUR', array($userAccount));

			// データリセット
			$cntCard	= NO_COUNT;	// クレジットカードカウンタ
			$cntBank	= NO_COUNT;	// 銀行カウンタ
			$amtCard	= NO_COUNT;	// クレジットカード合計額
			$amtBank	= NO_COUNT;	// 銀行合計額

			if($this -> isLoopData($rs)) {

				foreach($rs as $row) {

					if($row[COLUMN_PAYMENT_METHOD] == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
						$cntBank += $row[COLUMN_COUNTER];														// 銀行カウンタ
						$amtBank += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// 銀行合計額

					} else {
						$cntCard += $row[COLUMN_COUNTER];														// クレジットカードカウンタ
						$amtCard += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// クレジットカード合計額
					}
				}
			}

			// 24時間リミット
			if(($cntCard + $cntBank) >= VAL_INT_8) {			// 8回以上はダメ
				return false;
			}

			// 回数リミットの取得（デイリー）
			$limit = $this -> getGPSCountLimit($method, $kind);

			if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
				if($cntBank >= $limit) {
					return false;
				}

			} else {
				if($cntCard >= $limit) {
					return false;
				}
			}

			// 金額リミットの取得
			$limit = $this -> getGPSAmountLimit($method, $kind);

			// 15日リミット（送金）
			if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 15日チェックは銀行送金だけ

				// 15日リミット用のデータを取得する
				$rs = $this -> accessSelect('LIST_GPS_RESPONSE_15_DAY', array($userAccount));

				// データリセット
				$cntCard	= NO_COUNT;	// クレジットカードカウンタ
				$cntBank	= NO_COUNT;	// 銀行カウンタ
				$amtCard	= NO_COUNT;	// クレジットカード合計額
				$amtBank	= NO_COUNT;	// 銀行合計額

				if($this -> isLoopData($rs)) {

					foreach($rs as $row) {

						if($row[COLUMN_PAYMENT_METHOD] == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
							$cntBank += $row[COLUMN_COUNTER];														// 銀行カウンタ
							$amtBank += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// 銀行合計額

						} else {
							$cntCard += $row[COLUMN_COUNTER];														// クレジットカードカウンタ
							$amtCard += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// クレジットカード合計額
						}
					}
				}

				if($amtBank >= $limit) {
					return false;
				}
			}

			// 30日リミット（送金）
			if($method != PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 30日チェックは銀行送金だけ

				// 30日リミット用のデータを取得する
				$rs = $this -> accessSelect('LIST_GPS_RESPONSE_30_DAY', array($userAccount));

				// データリセット
				$cntCard	= NO_COUNT;	// クレジットカードカウンタ
				$cntBank	= NO_COUNT;	// 銀行カウンタ
				$amtCard	= NO_COUNT;	// クレジットカード合計額
				$amtBank	= NO_COUNT;	// 銀行合計額

				if($this -> isLoopData($rs)) {

					foreach($rs as $row) {

						if($row[COLUMN_PAYMENT_METHOD] == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
							$cntBank += $row[COLUMN_COUNTER];														// 銀行カウンタ
							$amtBank += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// 銀行合計額

						} else {
							$cntCard += $row[COLUMN_COUNTER];														// クレジットカードカウンタ
							$amtCard += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// クレジットカード合計額
						}
					}
				}

				if($amtCard >= $limit) {
					return false;
				}
			}

		} else {

			// 24時間リミット用のデータを取得する
			$rs = $this -> accessSelect('LIST_GPS_RESPONSE_24_HOUR', array($userAccount));

			// データリセット
			$cntCard	= NO_COUNT;	// クレジットカードカウンタ
			$cntBank	= NO_COUNT;	// 銀行カウンタ
			$amtCard	= NO_COUNT;	// クレジットカード合計額
			$amtBank	= NO_COUNT;	// 銀行合計額

			if($this -> isLoopData($rs)) {

				foreach($rs as $row) {

					if($row[COLUMN_PAYMENT_METHOD] == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
						$cntBank += $row[COLUMN_COUNTER];														// 銀行カウンタ
						$amtBank += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// 銀行合計額

					} else {
						$cntCard += $row[COLUMN_COUNTER];														// クレジットカードカウンタ
						$amtCard += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// クレジットカード合計額
					}
				}
			}


			// 24時間リミット
			if(($cntCard + $cntBank) >= VAL_INT_6) {			// 6回以上はダメ
				return false;
			}

			// 回数リミットの取得（デイリー）
			$limit = $this -> getGPSCountLimit($method, $kind);

			if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
				if($cntBank >= $limit) {
					return false;
				}

			} else {
				if($cntCard >= $limit) {
					return false;
				}
			}

			// 金額リミットの取得
			$limit = $this -> getGPSAmountLimit($method, $kind);

			// 15日リミット（送金）
			if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 15日チェックは銀行送金だけ

				// 15日リミット用のデータを取得する
				$rs = $this -> accessSelect('LIST_GPS_RESPONSE_15_DAY', array($userAccount));

				// データリセット
				$cntCard	= NO_COUNT;	// クレジットカードカウンタ
				$cntBank	= NO_COUNT;	// 銀行カウンタ
				$amtCard	= NO_COUNT;	// クレジットカード合計額
				$amtBank	= NO_COUNT;	// 銀行合計額

				if($this -> isLoopData($rs)) {

					foreach($rs as $row) {

						if($row[COLUMN_PAYMENT_METHOD] == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
							$cntBank += $row[COLUMN_COUNTER];														// 銀行カウンタ
							$amtBank += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// 銀行合計額

						} else {
							$cntCard += $row[COLUMN_COUNTER];														// クレジットカードカウンタ
							$amtCard += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// クレジットカード合計額
						}
					}
				}

				if($amtBank >= $limit) {
					return false;
				}
			}

			// 30日リミット（送金）
			if($method != PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 30日チェックは銀行送金だけ

				// 30日リミット用のデータを取得する
				$rs = $this -> accessSelect('LIST_GPS_RESPONSE_30_DAY', array($userAccount));

				// データリセット
				$cntCard	= NO_COUNT;	// クレジットカードカウンタ
				$cntBank	= NO_COUNT;	// 銀行カウンタ
				$amtCard	= NO_COUNT;	// クレジットカード合計額
				$amtBank	= NO_COUNT;	// 銀行合計額

				if($this -> isLoopData($rs)) {

					foreach($rs as $row) {

						if($row[COLUMN_PAYMENT_METHOD] == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {
							$cntBank += $row[COLUMN_COUNTER];														// 銀行カウンタ
							$amtBank += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// 銀行合計額

						} else {
							$cntCard += $row[COLUMN_COUNTER];														// クレジットカードカウンタ
							$amtCard += $this -> intToCurrency($row[COLUMN_AMOUNT], VAR_GPAYSAFE_CARD_CURRENCY);	// クレジットカード合計額
						}
					}
				}

				if($amtCard >= $limit) {
					return false;
				}
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: GPSリミットチェック
	 * @parameter	: 口座番号、決済種別
	 * @return		: 成功:true、失敗:false
	 -------------------------------------------------------------------------*/
	function checkGPSEmpltyLimit($userAccount) {}

	/*-------------------------------------------------------------------------
	* @function_name: 年齢制限のチェック
	* @parameter	: 国コード、年、月、日
	* @return		: 成功:true、失敗:false
	-------------------------------------------------------------------------*/
	function checkLimitAge($country
							, $year
							, $month
							, $day) {

		// 変数宣言部
		$rtn	= true;
		$limit	= NO_COUNT;
		$row	= null;

		// 国別年齢制限を取得する
		$limit = $this -> getLimitAageCommon($country);

		// 制限が設けられていたら確認する
		if($limit > NO_COUNT) {

			$row = $this -> getRowData($this -> accessSelect('SELECT_LIMIT_YEAR_DIFF', array( $year, $month, $day, $limit)));

			// 年齢がマイナスだった場合はエラー
			if(intval($this -> getColumnData($row, COLUMN_DIFF_TIME)) < NO_COUNT) {
				$rtn	= false;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: データ正規表現チェック（半角数字少数なし）
	 * @parameter	: チェックデータ
	 * @return		: 成功:TRUE、失敗:FALSE
	 -------------------------------------------------------------------------*/
	function checkStringIntOnly($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_INT_NUMBER_ONLY, $data)) {
			return false;
		}

		return true;
	}

    /*-------------------------------------------------------------------------
	 * @function_name: checkChineseStringOnly
	 * @parameter	: $data
	 * @return		: bool: true if Chinese string only, false if not.
	 -------------------------------------------------------------------------*/
	function checkChineseStringOnly($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_STRING_CHINESE_ONLY, $data)) {
			return false;
		}

		return true;
	}

    /*-------------------------------------------------------------------------
	 * @function_name: checkKatakanaStringOnly
	 * @parameter	: $data
	 * @return		: bool: true if Katakana string only, false if not.
	 -------------------------------------------------------------------------*/
	function checkKatakanaStringOnly($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_STRING_KATAKANA_ONLY, $data)) {
			return false;
		}

		return true;
	}

    /*-------------------------------------------------------------------------
	 * @function_name: checkLocalBank
	 * @parameter	: $bankName
	 * @return		: bool: true if bank is allowed, false if not.
	 -------------------------------------------------------------------------*/
    function checkLocalBank($bankName){
        $banksAllowed = array(
            "cmb"
        );

        if(!in_array($bankName, $banksAllowed)) {
            return false;
        }

        return true;
    }

	/*-------------------------------------------------------------------------
	 * @function_name: 检查入金小数点
	 * @parameter	: チェックデータ
	 * @return		: 成功:TRUE、失敗:FALSE
	 -------------------------------------------------------------------------*/
	function checkCurrencyNumber($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_NUMBER_CURRENCY, $data)) {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 检查入金小数点
	 * @parameter	: チェックデータ
	 * @return		: 成功:TRUE、失敗:FALSE
	 -------------------------------------------------------------------------*/
	function checkCurrencyNumberJP($data) {

		// 半角英数の正規表現チェック
		if (!preg_match(PREG_NUMBER_CURRENCY_JP, $data)) {
			return false;
		}

		return true;
	}
	/*-------------------------------------------------------------------------
	 * @function_name: 用户属性检查
	 * @parameter	: チェックデータ
	 * @return		: 成功:TRUE、失敗:FALSE
	 -------------------------------------------------------------------------*/
	 function checkAccountType($mail){

	 		// 変数宣言部
		$rtn = true;
		// from口座の情報取得
		$rs = $this -> accessSelect('SELECT_ACCOUNT_TYPE', array($mail));

		// 個人口座の場合
		if(count($rs) == VAL_INT_1) {
			$rtn = true;
		} else {
			$rtn = false;
		}

		return $rtn;
	 }


     /*-------------------------------------------------------------------------
 	 * @function_name: checkMaxStringLength
 	 * @parameter	: $string - string to be checked
 	 * @return		: Boolean: if is less than or equal to 512 return true else false
 	 -------------------------------------------------------------------------*/
 	 function checkMaxStringLength($string){
        $rtn = true;

        if(strlen($string) > 512) {
            $rtn = false;
        }

        return $rtn;
 	 }

     /*-------------------------------------------------------------------------
 	 * @function_name: checkWithdrawCurrency
 	 * @parameter	: $currency - currency to be checked; $solution - current withdrawal solution being used
 	 * @return		: Boolean: if currency is available for the current solution, return true else false
 	 -------------------------------------------------------------------------*/
     function checkWithdrawCurrency($currency, $solution){
        $rtn = true;

        $currencyArray = VAL_ARRAY_ALLOWED_WITHDRAWAL_CURRENCY;
				if(array_key_exists($currency, $currencyArray)){
					if(!in_array($solution,$currencyArray[$currency])){
	            $rtn = false;
	        }
				} else{
					$rtn = false;
				}


        return $rtn;
     }

     /*-------------------------------------------------------------------------
 	 * @function_name: checkDepositAmountLimit30Days
 	 * @parameter	: $depositMethod - deposit method used; $account - account number of user
 	 * @return		: Boolean: if exceeds limit return false else true
 	 -------------------------------------------------------------------------*/
     function checkDepositAmountLimit30Days($depositMethod, $account){
         $rtn = true;

         if($depositMethod == 'CLEARSETTLE'){
             // 一時データを取得する
      		$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_CLEARSETTLE_30_DAY', array($account)));

            $amount = $this -> intToCurrency(intval($this -> getColumnData($row, EUR)), EUR);

            if($_SESSION['account_Category'] == 'vip'){
    			// 30日のチェックを行うvip限制
    			if($amount >= VAR_CASHFLOW_LIMIT_AMOUNT_VIP) {
    				$rtn = false;
    			}
    		}else if($_SESSION['account_Category'] == 'normal'){
    			// 30日のチェックを行うvip限制
    			if($amount >= VAR_CASHFLOW_LIMIT_AMOUNT_NORMAL) {
    				$rtn = false;
    			}
    		}

            return $rtn;
         }
     }

     /*-------------------------------------------------------------------------
 	* @function_name: checkClearsettleDeposit1Hour
 	* @parameter	: account - user account
 	* @return		: 成功:TRUE、失敗:FALSE
 	-------------------------------------------------------------------------*/
 	function checkClearsettleDeposit1Hour($account) {

 		// 変数宣言部
 		$rtn = true;
 		$row = null;
 		$params = array();

 		$params[] = $account;
 		$params[] = date("Y-m-d H:i:s",strtotime('-1 hour'));

 		// 一時データを取得する
 		$row = $this -> getRowData($this -> accessSelect('COUNT_CLEARSETTLE_DEPOSIT_TEMPORARY_1_HOUR', $params));

 		// 1時間のチェックを行う
 		if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAL_INT_5) {
 			$rtn = false;
 		}

 		return $rtn;
 	}

    /*-------------------------------------------------------------------------
	* @function_name: checkDepositSuccessLimit24Hour
	* @parameter	: $account - user account; $method - deposit method
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkDepositSuccessLimit24Hour($account, $method) {

		// 変数宣言部
		$rtn = true;
		$row = null;

		// 一時データを取得する
		$row = $this -> getRowData($this -> accessSelect('COUNT_DEPOSIT_SUCCESS_LIMIT_24_HOUR', array($account, $method)));
		if(!isset($_SESSION['account_Category'])){
			$rtn = false;
		}else if($_SESSION['account_Category'] == 'vip'){
			// 24時間のチェックを行うvip限制
			if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAR_CASHFLOW_LIMIT_TIMES_VIP) {
				$rtn = false;
			}
		}else if($_SESSION['account_Category'] == 'normal'){
			// 24時間のチェックを行うvip限制
			if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAR_CASHFLOW_LIMIT_TIMES_NORMAL) {
				$rtn = false;
			}
		}
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: checkAdminUserAccess
	* @parameter	: $functionCode (string) - function code; $allowedAccess (array) - deposit method
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkAdminUserAccess($functionCode, $allowedAccess) {
		// 変数宣言部
		$rtn 					= true;
		$functionDetails 		= null;
		$adminAccessDetails 	= null;
		$adminFunctionAccess	= array();
		$functionId				= NO_STRING;

		//get function details based on function code
		$rs = $this -> accessSelect('SELECT_ADMIN_FUNCTION_VIA_CODE', array($functionCode));

		//check if there is a record
		if($this -> isLoopData($rs)) {
			$functionDetails = $this -> getRowData($rs);
			$functionId      = $this -> getColumnData($functionDetails, 'fl_id');
		} else {
			return false;
		}

		//get admin access details
		$rs = $this -> accessSelect('SELECT_ADMIN_USER', array($this -> getAdminUserData(PARAM_USER_ACCOUNT)));

		//check if there is a record
		if($this -> isLoopData($rs)) {
			$adminAccessDetails = $this -> getRowData($rs);
			$adminFunctionAccess = unserialize($this -> getColumnData($adminAccessDetails, COLUMN_FUNC_ACCESS));
		} else {
			return false;
		}

		//check if user has access
		$hasFunctionAccess 	= in_array($functionId, array_keys($adminFunctionAccess));

		//check if user has function
		if(!array_key_exists($functionId, $adminFunctionAccess)) {
			return false;
		}

		$hasAccessLevel 	= (count(array_intersect($allowedAccess, $adminFunctionAccess[$functionId])) == count($allowedAccess)) ? true : false;

		$rtn = ($hasFunctionAccess && $hasAccessLevel) ? true : false;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: checkNavTabAccess
	* @parameter	: $categoryCode (string) - function code
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkNavTabAccess($categoryCode) {
		// 変数宣言部
		$rtn 					= false;	//set initially to false
		$adminAccessDetails 	= null;
		$functionDetails 		= null;
		$adminFunctionAccess	= null;

		//get admin access details
		$rs = $this -> accessSelect('SELECT_ADMIN_USER', array($this -> getAdminUserData(PARAM_USER_ACCOUNT)));

		//check if there is a record
		if($this -> isLoopData($rs)) {
			$adminAccessDetails = $this -> getRowData($rs);
			$adminFunctionAccess = array_keys(unserialize($this -> getColumnData($adminAccessDetails, COLUMN_FUNC_ACCESS)));

		} else {
			return false;
		}

		//get function details based on function code
		$functionDetails = $this -> accessSelect('SELECT_ADMIN_FUNCTION_VIA_CATEGORY_CODE', array($categoryCode));

		//check if there is a record
		if($this -> isLoopData($functionDetails)) {
			foreach($functionDetails as $detail) {
				//check if function id is in
				if(in_array($this -> getColumnData($detail, COLUMN_FUNC_ID), $adminFunctionAccess)) {
					$rtn = true;
					break;
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: checkIs2FAValidated
	* @parameter	:
	* @return		: true if session variable 2fa_validated is true. else, false
	-------------------------------------------------------------------------*/
	function checkIs2FAValidated() {
		if(!isset($_SESSION['2fa_validated']) || $_SESSION['2fa_validated'] == 'not validated') {
			return false;
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: check2FAEnabled
	* @parameter	: $userAccount; $function
	* @return		: true if 2fa is enabled for the user account on the current function.
	* 				  else false
	-------------------------------------------------------------------------*/
	function check2FAEnabled($userAccount, $function) {
		$enable = $this -> getRowData($this -> accessSelect('SELECT_2FA_ENABLE', array($userAccount)));

		//check if the current function is 1 (enabled)
		if($this -> getColumnData($enable, $function) == '1') {
			return true;
		}

		return false;
	}

	/*-------------------------------------------------------------------------
	* @function_name: checkExistPattern
	* @parameter	: $pattern
	* @return		: false if pattern name already exist else true
	-------------------------------------------------------------------------*/
		function checkExistPattern($pattern) {

		// 変数宣言部
		$param 	= array();
		$rs		= null;

		// パラメータ設定
		$param[] = $pattern;

		$rs =  $this -> accessSelect('CHECK_EXIST_PATTERN', $param);

		if(count($rs) > NO_COUNT) {
			return true;
		} else {
			return false;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: checkWithdrawStatusUpdated
	* @parameter	: $transactionNumber
	* @return		: true if the transaction has been updated
	* 				  else false
	-------------------------------------------------------------------------*/
	function checkWithdrawStatusUpdated($transactionNumber) {
		$withdrawData = $this -> getRowData($this -> accessSelect('SELECT_WITHDRAW_BY_TRANSACTION_NUMBER', array($transactionNumber)));

		$status = $this -> getColumnData($withdrawData, COLUMN_STATUS);

		if($status != '0') {
			return true;
		}

		return false;
	}

	/*-------------------------------------------------------------------------
	* @function_name: alreadyRegistered()
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function alreadyRegistered($userAccount) {
		$rtn 	= false;
		$rs 	= NO_COUNT;
		$rs 	= $this -> accessSelect('SELECT_API_SIGNATURE_BY_USER_ACCOUNT', array($userAccount));
		
		if(count($rs) > NO_COUNT){
			$rtn = true;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: zanetapay 1 hour checker
	* @parameter	: 口座番号
	* @return		: 成功:TRUE、失敗:FALSE
	-------------------------------------------------------------------------*/
	function checkZanetapayDeposit1Hour($account) {

		// 変数宣言部
		$rtn = true;
		$row = null;
		$params = array();

		$params[] = $account;
		$params[] = date("Y-m-d H:i:s",strtotime('-1 hour'));

		// 一時データを取得する
		$row = $this -> getRowData($this -> accessSelect('COUNT_ZANETAPAY_DEPOSIT_TEMPORARY_1_HOUR', $params));

		// 1時間のチェックを行う
		if(intval($this -> getColumnData($row, COLUMN_COUNTER)) >= VAL_INT_5) {
			$rtn = false;
		}

		return $rtn;
	}

	//class end
}
?>
