<?php
class CardPinModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 結果セット
	private $user						= null;			// ユーザデータ
	private $card						= null;			// カードデータ
	private $userAccount				= NO_STRING;	// 口座番号
	private $aId						= NO_STRING;	// カード申請ID
	private $cardNumber					= NO_STRING;	// カード番号
	private $year						= NO_STRING;	// 生年月日（年）
	private $month						= NO_STRING;	// 生年月日（月）
	private $day						= NO_STRING;	// 生年月日（日）

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// データを取得する
		$this -> userAccount	= $this -> getUserData(PARAM_USER_ACCOUNT);		// ログイン口座番号
		$this -> aId			= $this -> getPosParameter(PARAM_A_ID);			// 申請ID
		$this -> cardNumber		= $this -> getPosParameter(PARAM_CARD_NUMBER);	// カード番号
		$this -> year			= $this -> getPosParameter(PARAM_YEAR);			// 生年月日（年）
		$this -> month			= $this -> getPosParameter(PARAM_MONTH);		// 生年月日（月）
		$this -> day			= $this -> getPosParameter(PARAM_DAY);			// 生年月日（日）

		// 直アクセスの場合
		if($this -> getType()		== TYPE_CONFIRM
			|| $this -> getType()	== TYPE_INPUT) {
			$this -> aId	= $this -> getDataGet(PARAM_A_ID); // 申請ID
			$this -> card	= $this -> getRowData($this -> accessSelect('SELECT_CARD_APPLY', array($this -> aId)));

			$this -> userAccount = $this -> getColumnData($this -> card, COLUMN_USER_ACCOUNT);
		}


		// ユーザデータの取得
		$this -> user	= $this -> getRowData($this -> getAccountCommon($this -> userAccount));

		// 所持カードの取得
		$this -> rs		= $this -> getCardActiveList($this -> userAccount);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function dispHoldCards() {

		// 変数宣言部
		$list	= array();


		foreach($this -> rs as $row) {

			$list[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_A_ID)
							, PARAM_DATA_VALUE	=> '**** **** **** ' . substr($this -> getColumnData($row, COLUMN_CARD_NUMBER), -4)
			);
		}

		echo $this -> dispListOption($list, $this -> aId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispYear() {
		$this -> dispBirthYearList($this -> year);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispMonth() {
		$this -> dispBirthMonthList($this -> month);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispDay() {
		$this -> dispBirthDayList($this -> day);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード番号の取得
	* @parameter	: なし
	* @return		: カード番号
	-------------------------------------------------------------------------*/
	public function echoCardNumber() {
		echo $this -> cardNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: PINの取得
	* @parameter	: なし
	* @return		: PIN
	-------------------------------------------------------------------------*/
	public function echoPin() {
		echo $this -> getColumnData($this -> card, COLUMN_PIN);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
// 			throw new Exception(NO_STRING);
		}

		if($this -> getType() == TYPE_INPUT) {				// 入力画面の場合
			if($this -> getColumnData($this -> card, COLUMN_DIFF_TIME) >= VAL_INT_3) {
				$this -> setType(TYPE_ERROR);
			}
		} else if($this -> getType() == TYPE_CONFIRM) {		// 確認画面の場合

			// 生年月日（年）のチェック
			if(intval($this -> year) != $this -> getColumnData($this -> user, COLUMN_BIRTH_YEAR)) {
				$rtn = false;
			}

					// 生年月日（月）のチェック
			if(intval($this -> month) != $this -> getColumnData($this -> user, COLUMN_BIRTH_MONTH)) {
				$rtn = false;
			}

			// 生年月日（日）のチェック
			if(intval($this -> day) != $this -> getColumnData($this -> user, COLUMN_BIRTH_DAY)) {
				$rtn = false;
			}

			// カード番号のチェック
			if($this -> cardNumber != $this -> getColumnData($this -> card, COLUMN_CARD_NUMBER)) {
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				$this -> popMessageCommon(ERROR, 'E_ERROR_SAME_DATA', array(VAL_STR_INPUT_DATA));
			}

		} else if($this -> getType() == TYPE_SEND) {		// メール送信前チェック

			if($this -> aId == NO_STRING) {
				$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_SELECT', array(VAL_STR_CARD));
				$this -> setType(NO_STRING);
			}

		} else {											// カードを所持しているか否か

			if(!$this -> isLoopData($this -> rs)) {
				$this -> setType(PARAM_FAIL);
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信のデータ取得関数
	* @parameter	: なし
	* @return		: メール送信データ配列
	-------------------------------------------------------------------------*/
	public function getSendParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[]	= $this -> getColumnData($this -> user, COLUMN_USER_ACCOUNT);					// 口座番号
		$rtn[]	= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME)
					. DELIMIT_SPACE . $this -> getColumnData($this -> user, COLUMN_LAST_NAME);	// 名前
		$rtn[]	= $this -> aId;																	// カード申請ID

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ取得関数
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getUpdateParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> aId;								// 申請ID

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}
}
?>