<?php
$page_title = "身分證明文件(KYC)上傳";
include_once('template/base_head.php');
?>
			<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href="/tc/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
<?php include_once('template/base_sidebar_setting.php'); ?>
			</aside>
			<!-- /サイドバー -->
			<!-- メインカラム -->
			<div id="colMain">
				<div class="mainIn">
<?php include_once('template/base_nav.php'); ?>
					<article>
						<div class="article-heading">
							<h2><?php echo $page_title; ?></h2>
						</div>
						<?php $this -> echoMessage(); ?>
						<p class="pb30 settingT respM">請上傳您的KYC資料(身分證明及住址證明)。<br>
						<span class="red">※文件格式JPG, JPEG, PDF, PNG 或 GIF，大小5MB以内。</span><br>
						<span class="red">※一次最多可以上傳到10個KYC文件（[5]標識證明，[5]地址證明)。</span><br>
						<span class="red">※ 請確保列在您的KYC上的地址（地址證明）與您的iWallet賬戶中註冊的地址相同。這包括房屋/建築物編號和建築物名稱。</span><br>
						<span class="red">※為了避免未來交易時產生驗證延遲的情況，請確保您在iWallet帳戶上註冊的名字與您的身分或地址證明文件（KYC）上的名稱完全一致。 您將可能被要求提供其他文件供參考使用。</span>
						</p>
					<?php
					if($this -> canUpload()){
					?>
						<form id="acForm" action="" method="post" enctype="multipart/form-data">
						<?php if($this -> canUploadPI(0)){ ?>
						<p class="pb10 respM"><strong>【身分證明】</strong><br>
						<span class="fontS">請在此上傳您的護照、駕照等證明。更多詳細資訊，請參照“KYC基準”。</span></p>
							<table class="table col bdr default odd kycT fontM mb30 ma90sp">
								<?php $this -> dispInputs(0); ?>
							</table>
						<?php } ?>
						<?php if($this -> canUploadPI(1)){ ?>
							<p class="kycT respM pb10"><strong>【住址證明】</strong><br>
							<span class="fontS">請在此上傳您的公共事業費用帳單等資料。更多詳細資訊，請參照“KYC基準”。</span></p>
							<table class="table col bdr default odd kycT fontM mb30 ma90sp">
								<?php $this -> dispInputs(1); ?>
							</table>
							<?php } ?>

							<p class="kycT respM pb10 red">※如果您提交的資料沒有通過我們的審查，可能會要求您再次提供其他資料。</p>
							<p class="kycT mb20"><input type="button" id="btnKyc" value="上傳" class="btn bg-grad px120 calign"></p>

							<input type="hidden" value="" id="type" name="type" />
							<input type="hidden" value="settting_kyc" id="action" name="action" />
							<input type="hidden" value="0" id="img_1_flg" name="img_1_flg" />
							<input type="hidden" value="0" id="img_2_flg" name="img_2_flg" />
							<input type="hidden" value="0" id="img_3_flg" name="img_3_flg" />
							<input type="hidden" value="1" id="img_4_flg" name="img_4_flg" />
							<input type="hidden" value="1" id="img_5_flg" name="img_5_flg" />
							<input type="hidden" value="1" id="img_6_flg" name="img_6_flg" />
							<input type="hidden" value="" id="k_id" name="k_id" />
						</form>
						<hr class="mb20">
						<h3>KYC文件上傳</h3>
                     	<table class="table col bdr default odd fontXS calign" style="margin-top: 10px;">
                        <colgroup>
							<col width="50%">
						</colgroup>
                        <tr>
                        	<th>文件稽核狀況</th>
                            <td><?php echo $this -> getStatus(); ?></td>
                        </tr>
                        </table>
                        <?php
							$validateStatus = $this -> getValidateStatus();
							if($validateStatus == '8' || $validateStatus == '18'){
						?>
							<p class="red" style="margin-top: 10px;">※文件稽核狀況　當KYC文件不合格的情况下，我們會將不合格的詳細原因發送至您的注册郵箱，如果您未收到郵件，請與【客戶支援】聯系。</p>
						<?php
							}
						?>
                        <br>
                        <h3>上傳文件稽核狀況</h3>
                        <table class="table col bdr default odd fontXS calign" style="margin-top: 5px;">
                        	<tr>
                            	<th class="w25p">上傳日期</th>
								<th class="w20p">文件類型</th>
								<th class="w20p">文件名</th>
                            </tr>
                            <?php $this -> dispKYCList(); ?>
                        </table>
					<?php
						}else{
					?>
						<hr class="mb20">
						<h3>KYC文件上傳</h3>
                        <p style="margin-top: 10px;" class="red">您的KYC文件正在稽核中或檔案已稽核完了，現在無法再次上傳。</p>
                     	<table class="table col bdr default odd fontXS calign" style="margin-top: 10px;">
                        <colgroup>
							<col width="50%">
						</colgroup>
                        <tr>
                        	<th>文件稽核狀況</th>
                            <td><?php echo $this -> getStatus(); ?></td>
                        </tr>
                        </table>
                        <p class="red" style="margin-top: 10px;">※文件稽核狀況　當KYC文件不合格的情况下，我們會將不合格的詳細原因發送至您的注册郵箱，如果您未收到郵件，請與【客戶支援】聯系。</p>
                        <br>
                        <h3>上傳文件稽核狀況</h3>
                        <table class="table col bdr default odd fontXS calign" style="margin-top: 5px;">
                        	<tr>
                            	<th class="w25p">上傳日期</th>
								<th class="w20p">文件類型</th>
								<th class="w20p">文件名</th>
                            </tr>
                            <?php $this -> dispKYCList(); ?>
                        </table>

					<?php
						}
					?>
					</article>
				</div>
			</div>
			<!-- /メインカラム -->
		</div>
<?php include_once('template/base_foot.php'); ?>
	</div>
	<script src="../js/setting.js"></script>
</body>
</html>
