<?php
class Message {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $messagesObj;	// メッセージクラス

	/*-------------------------------------------------------------------------
	* @function_name: 共通基底クラスコンストラクタ
	* @detail		: 設定ファイルを読込みます
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct($filePath) {

		// 変数宣言部
		$xml;	// XMLファイルデータ

		try {

			// メッセージファイルの存在確認
			if(file_exists($filePath) == FALSE) {
				throw new Exception("File[" + $filePath + "] Can not be opened" , -1);
			}

			// メッセージファイルロード
			if(!($xml = simplexml_load_file($filePath))) {
				throw new Exception("File [" + $filePath + "] Can not be loaded", -1);
			}

			$this -> messagesObj = $xml;

		} catch(Exception $e) {
			throw new Exception("File [" + $filePath + "] Can not be loaded", -1);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @detail		: 対象のメッセージを取得を取得します
					　置換項目がある場合は、置換します
	* @parameter	: $level[エラーレベル], $key[キー値]
	* @return		: メッセージに対応する値（存在しない場合は空白文字）
	-------------------------------------------------------------------------*/
	function getMessageValue($level, $key, $elmArr) {

		// 変数宣言部
		$elementCnt = 1;	// 項目数のカウンタ
		$msg;				// メッセージ

		// メッセージを取得する
		$msg = (string)$this -> messagesObj -> $level -> $key;

		// 置換項目がある場合へ置換する
		foreach($elmArr as $value) {
			$msg = str_replace("__MEGELM" . sprintf("%02d", $elementCnt) . "__" , $value, $msg);
			$elementCnt++;
		}

		// 設定値の返却
		return $msg;
	}
}
?>