<?php
$page_title = "Card Application List";
include_once('template/base_head.php');
?>
			<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href=""><img src="../img/logo.png" alt="iWallet"></a></h1>
				<div class="aside-heading">
					<div class="btns">
						<input type="button" id="btnSearchAll" value="All" class="btn bg-default px50 hi22">&nbsp;
						<input type="button" id="btnSearchToday" value="Today" class="btn bg-default px50 hi22">&nbsp;
						<input type="button" id="btnSearch" value="Search" class="btn bg-default px50 hi22">
					</div>
				</div>
				<form id="searchForm" action="" method="post">
					<table class="conditions fontS w100p">
						<colgroup>
							<col class="w40p">
							<col class="w60p">
						</colgroup>
						<tr>
							<th>Email Address</th>
							<td><input type="text" id="s_email" name="s_email" value="<?php $this -> echoSEmail(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>Account Number</th>
							<td><input type="text" id="s_account" name="s_account" value="<?php $this -> echoSUserAccount(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>Agent</th>
							<td><input type="text" id="s_agent_code" name="s_agent_code" value="<?php $this -> echoSAgent(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>Username</th>
							<td><input type="text" id="s_name" name="s_name" value="<?php $this -> echoSName(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>Card Type</th>
							<td>
								<select id="s_card_type" name="s_card_type" class="w100p">
									<option value="">--- All ---</option>
									<?php $this -> dispSCardType(); ?>
								</select>
							</td>
						</tr>
						<tr>
						<th>Card Status</th>
							<td>
								<select id="s_card_status" name="s_card_status" class="w100p">
									<option value="">--- All ---</option>
									<?php $this -> dispSCardStatus(); ?>
								</select>
							</td>
						</tr>
						<tr>
							<th>Card Number</th>
							<td><input type="text" id="s_card_number" name="s_card_number" value="<?php $this -> echoSCardNumber(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<th>CHID</th>
							<td><input type="text" id="s_chid" name="s_chid" value="<?php $this -> echoSChid(); ?>" class="w100p"></td>
						</tr>
						<tr>
							<td colspan="2">
								<span class="th">Date of Application</span>
								<?php $this -> dispSOpenFlg(); ?>
								<input type="text" id="s_from" name="s_from" value="<?php $this -> echoSFrom(); ?>" class="px80"> - <input type="text" id="s_to" name="s_to" value="<?php $this -> echoSTo(); ?>" class="px80">
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<span class="th">Processing Date</span>
								<?php $this -> dispSProcessFlg(); ?>
								<input type="text" id="s_process_from" name="s_process_from" value="<?php $this -> echoSProcessFrom(); ?>" class="px80"> - <input type="text" id="s_process_to" name="s_process_to" value="<?php $this -> echoSProcessTo(); ?>" class="px80">
							</td>
						</tr>
					</table>
					<p class="calign"><input type="button" id="btnCreate" value="Create New" class="btn bg-grad hi25 px100"></p>
					<input type="hidden" value="" id="s_type" name="type" />
				</form>
			</aside>
			<!-- /サイドバー -->
			<!-- メインカラム -->
			<div id="colMain">
				<div class="mainIn">
					<?php include_once('template/base_nav.php'); ?>
					<article>
						<form id="acForm" action="" method="post">
							<div class="article-heading">
								<h2><?php echo $page_title; ?></h2>
								<?php $this -> dispPager(); ?>
							</div>
							<?php $this -> echoMessage(); ?>
							<table class="table col bdr default odd w100p fontXS calign">
								<tr>
									<th class="w10p">Date of Application</th>
									<th class="w10p">Account Name</th>
									<th class="w15p">Name</th>
									<th class="w5p">Account Number</th>
									<th class="w10p">Card Type</th>
									<th class="w15p">Card Number</th>
									<th class="w5p">PIN</th>
									<th class="w10p">CHID</th>
									<th class="w10p">Date of Last Process</th>
									<th class="w5p">Status</th>
									<th class="w5p">Details</th>
								</tr>
								<?php $this -> echoList(); ?>
							</table>
							<input type="hidden" value="action" id="type" name="type" />
							<input type="hidden" value="deposit" name="action" />
							<input type="hidden" id="a_id" name="a_id" />
							<input type="hidden" value="" id="detail_account" name="detail_account" />
							<div class="article-bottom">
								<?php $this -> dispPager(); ?>
							</div>
						</form>
					</article>
				</div>
			</div>
			<!-- /メインカラム -->

		</div>
<?php include_once('template/base_foot.php'); ?>
	</div>
	<script src="../js/card_apply.js"></script>
</body>
</html>
