/**
 * サブミットを行う
 */

 var deleteTransaction = (lang == "en" ? "Delete the transaction?"
     : "取引を削除しますか？");

$(function() {
	$('#btnSearch').click(function() {
		$('#s_type').val('search');
		submitForm('searchForm');
	});

	$('#btnImport').click(function() {
		$('#type').val('import');
		submitForm();
	});

	$('#btnConfirm').click(function() {
		$('#type').val('confirm');
		submitForm();
	});

	$('#btnList').click(function() {
		$('#type').val('');
		submitForm();
	});

	$('#btnComplete').click(function() {
		$('#type').val('complete');
		submitForm();
	});

	$('#btnSave').click(function() {
		$('#type').val('update');
		submitForm();
	});

	$('#btnSearchAll').click(function() {
		$('#s_type').val('search');
		$('#s_from:text').datepicker().datepicker('setDate', nowStr);
		$('#s_to:text').datepicker().datepicker('setDate', 'today');
		$('#s_email').val('');
		$('#s_account').val('');
		$('#s_file_name').val('');
		$('#s_currency').val('');
		$('#s_min_amount').val('');
		$('#s_max_amount').val('');
		$('#transaction_number').val('');
		$('#s_bank').val('');
		$('#s_process_flg').prop('checked', true);
		submitForm('searchForm');
	});

	$('#btnSearchToday').click(function() {
		$('#s_type').val('search');
		$('#s_from:text').datepicker().datepicker('setDate', 'today');
		$('#s_to:text').datepicker().datepicker('setDate', 'today');
		$('#s_email').val('');
		$('#s_account').val('');
		$('#s_file_name').val('');
		$('#s_currency').val('');
		$('#s_min_amount').val('');
		$('#s_bank').val('');
		$('#s_max_amount').val('');
		$('#transaction_number').val('');
		$('#s_process_flg').prop('checked', true);
		submitForm('searchForm');
	});

	$('#s_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

    $("#btnExportCommonHigh, #btnExportCommonLow").click(function() {
    $('#s_type').val('export_common');
    submitForm('searchForm');
    });

	if($('#s_from').val() == '') {

		var nowDate	= new Date();
		var month	= nowDate.getMonth();
		var year	= nowDate.getFullYear();

		if(month < 9) {
			month = "0" + (month + 1);
		} else {
			month++;
		}

		var thisStr = year + '/' + month + '/01';

		$('#s_from:text').datepicker().datepicker('setDate', thisStr);
	}

	if($('#s_to').val() == '') {
		$('#s_to:text').datepicker().datepicker('setDate','today');
	}
});

/**
 * 詳細表示
 */
function actionDetail(dId, target) {
	$('#acForm').attr('action','');
	$('#type').val('detail');
	$('#d_id').val(dId);

	// ターゲットがない場合
	if(target != undefined) {
		getForm().attr('target', target);
	} else {
		getForm().attr('target', '');
	}

	submitForm();
}

/**
 * ダウンロード
 */
function fileDownload(dId) {
	$('#type').val('export');
	$('#d_id').val(dId);
	submitForm();
}

/**
 * ダウンロード（エラー）
 */
function fileDownloadError(dId) {
	$('#type').val('export_error');
	$('#d_id').val(dId);
	submitForm();
}

// Help2Pay
$('.H2P').click(function() {
$('#method').val('H2P');
$('#type').val('h2p_input');
submitForm();
});

$('#btnH2PSend').click(function() {
$('#btnH2PSend').prop('disabled', true);
$('#type').val('h2p_confirm');
submitForm();
});

$('#btnBackH2PInput').click(function() {
	$('#acForm').attr('action', '');
	$('#method').val('H2P');
	$('#type').val('h2p_input');
	submitForm();
});

$('#btnCompleteH2P').click(function() {
	$('#type').val('h2p_send');
	submitForm();
});

$('#btnDelete').click(function(){
	if(confirm(deleteTransaction)){
		$('#type').val('delete');
		$('#acForm').submit();
	}
});

function TranslateAmount(){
	var cur=$("#currency").children('option:selected').val();
	if(cur=="JPY"){
		$("#li01").html("1000");
		$("#li02").html("3000");
		$("#li03").html("5000");
		$("#li04").html("10000");
		$("#li05").html("30000");
		for(i=1;i<=5;i++){
			$("#li0"+i).removeClass('selected');
		}
		$("#"+selectId).addClass('selected');
		$("#amount").val($("#"+selectId).html());
	}else{
		$("#li01").html("10");
		$("#li02").html("30");
		$("#li03").html("50");
		$("#li04").html("100");
		$("#li05").html("300");
		for(i=1;i<=5;i++){
			$("#li0"+i).removeClass('selected');
		}
		$("#"+selectId).addClass('selected');
		$("#amount").val($("#"+selectId).html());
	}
}
