<?php
class TotalModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs				= null;			// エージェントリスト
	private $date			= NO_STRING;	// 検索日
	private $currency		= NO_STRING;	// 検索通貨
	private $tranactionType	= NO_STRING;	// 検索処理タイプ

	// ------------------ 検索系 ------------------//
	private $sEmail			= NO_STRING;	// メールアドレス
	private $sName			= NO_STRING;	// 名前
	private $sAgentCode		= NO_STRING;	// エージェントコード
	private $sFrom			= NO_STRING;	// 開始日
	private $sTo			= NO_STRING;	// 終了日

	/**
	 *
	 * anton
	 *
	 */
	private $lang			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> date			= $this -> getDataPost(PARAM_DATE);					// 検索日
		$this -> currency		= $this -> getDataPost(PARAM_CURRENCY);				// 検索通貨
		$this -> tranactionType	= $this -> getDataPost(PARAM_TRANSACTION_TYPE);		// 検索処理タイプ

		// ------------------ 検索系 ------------------//
		$this -> sEmail		= $this -> getDataPost(PARAM_S_EMAIL);					// メールアドレス
		$this -> sName		= $this -> getDataPost(PARAM_S_NAME);					// 名前
		$this -> sAgentCode	= $this -> getDataPost(PARAM_S_AGENT_CODE);				// エージェントコード
		$this -> sFrom		= $this -> getDataPost(PARAM_S_FROM);					// 開始日
		$this -> sTo		= $this -> getDataPost(PARAM_S_TO);						// 終了日
		
		$this -> lang 		= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('AGGT', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('TDTL', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_CONFIRM) {
			//check access
			if(!$this -> checkAdminUserAccess('TDTL', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sEmail != NO_STRING) {		// メールアドレス
			$rtnParams[] = ' agents.mail = (\')' . $this -> sEmail . '(\') ';
		}

		if($this -> sName != NO_STRING) {		// 名前
			$rtnParams[] = ' (agents.last_name = (\')' . $this -> sName . '(\') OR agents.first_name = (\')' . $this -> sName . '(\')) ';
		}

		if($this -> sAgentCode != NO_STRING) {	// エージェントコード
			$rtnParams[] = ' agents.agent_code = (\')' . $this -> sAgentCode . '(\') ';
		}

		if($this -> sFrom != NO_STRING) {		// 開始日
			$rtnParams[] = ' agents.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
		}

		if($this -> sTo != NO_STRING) {			// 終了日
			$rtnParams[] = ' agents.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhereByDate() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> date;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhereByDateCurrencyType() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> date;
		$rtn[] = $this -> currency;

		return $rtn;
	}



	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$currencies	= null;
		$currency	= NO_STRING;
		$date		= NO_STRING;
		$lists		= array();


		if($this -> isLoopData($this -> rs)) {

			// 通貨データの取得
			$currencies = $this -> getCurrencyList();

			// データを日付単位に入れ直す
			foreach($this -> rs as $row) {

				$date		= $this -> getColumnData($row, COLUMN_PROCESS_DATE);
				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY);

				$lists[$date][$currency] = $row;
			}
	

			// ヘッダ部分の取得
			$rtn .= '<tr>'
					. '<th class="w5p">'.VAL_STR_TOTAL_TARGETD.'</th>';

			foreach($currencies as $cur) {
				$rtn .= (
						$this -> lang == "en" ? 
						'<th class="w5p">Number of cases in' . $cur[PARAM_DATA_VALUE] . '</th>'
						. '<th class="w5p">Amount in ' . $cur[PARAM_DATA_VALUE] . '</th>' :
						'<th class="w5p">' . $cur[PARAM_DATA_VALUE] . ' 件数</th>'
						. '<th class="w5p">' . $cur[PARAM_DATA_VALUE] . ' 金額</th>'
						);
			}
			$rtn .= '</tr>';


			// データの数だけループを回す
			foreach($lists as $date => $row) {

				$rtn	.= '<tr>'
							. '<td><a href="#" id="date_' . $date . '" >' . $date . '</a></td>';

				foreach($currencies as $cur) {


					if(isset($row[$cur[PARAM_DATA_VALUE]])) {

						$rowData = $row[$cur[PARAM_DATA_VALUE]];

						$count =	$this -> getColumnData($rowData, COLUMN_DEPOSIT_COUNT)
									+ $this -> getColumnData($rowData, COLUMN_WITHDRAW_APPLY_COUNT)
									+ $this -> getColumnData($rowData, COLUMN_WITHDRAW_COUNT)
									+ $this -> getColumnData($rowData, COLUMN_TRANSFER_COUNT)
									+ $this -> getColumnData($rowData, COLUMN_FEE_COUNT)
									+ $this -> getColumnData($rowData, COLUMN_EXCHANGE_COUNT);

						$data =		$this -> getColumnData($rowData, COLUMN_DEPOSIT_TOTAL)
									- $this -> getColumnData($rowData, COLUMN_WITHDRAW_APPLY_TOTAL)
									- $this -> getColumnData($rowData, COLUMN_WITHDRAW_TOTAL)
									+ $this -> getColumnData($rowData, COLUMN_TRANSFER_TOTAL)
									- $this -> getColumnData($rowData, COLUMN_FEE_TOTAL)
									+ $this -> getColumnData($rowData, COLUMN_EXCHANGE_TOTAL);

						$rtn	.= 	'<td class="r">' . $this -> formatCurrency($count, NO_STRING) . '</td>'
									. '<td class="r">' . $this -> getAmountString($data, $cur[PARAM_DATA_KEY]) . '</td>';
					} else {
						$rtn	.= 	'<td class="r">' . NO_COUNT . '</td>'
									. '<td class="r">' . $this -> getAmountString(NO_COUNT, $cur[PARAM_DATA_KEY]) . '</td>';

					}
				}

				$rtn	.= '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="12">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoListDate() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$currency	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			foreach($this -> rs as $row) {

				$currency = $this -> getColumnData($row, COLUMN_CURRENCY);

				$rtn	.= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_PROCESS_DATE) . '</td>'
						. '<td>' .$currency  . '</td>'
						. '<td class="r"><a id="detail-' . $currency . '-' . COLUMN_DEPOSIT_COUNT . '" href="#">' . $this -> formatCurrency($this -> getColumnData($row, COLUMN_DEPOSIT_COUNT), NO_STRING) . '</a></td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_TOTAL), $currency) . '</td>'
						. '<td class="r"><a id="detail-' . $currency . '-' . COLUMN_WITHDRAW_APPLY_COUNT . '" href="#">' . $this -> formatCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_APPLY_COUNT), NO_STRING) . '</a></td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_APPLY_TOTAL), $currency) . '</td>'
						. '<td class="r"><a id="detail-' . $currency . '-' . COLUMN_WITHDRAW_COUNT . '" href="#">' . $this -> formatCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_COUNT), NO_STRING) . '</a></td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_TOTAL), $currency) . '</td>'
						. '<td class="r"><a id="detail-' . $currency . '-' . COLUMN_TRANSFER_COUNT . '" href="#">' . $this -> formatCurrency($this -> getColumnData($row, COLUMN_TRANSFER_COUNT), NO_STRING) . '</a></td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_TRANSFER_TOTAL), $currency) . '</td>'
						. '<td class="r"><a id="detail-' . $currency . '-' . COLUMN_FEE_COUNT . '" href="#">' . $this -> formatCurrency($this -> getColumnData($row, COLUMN_FEE_COUNT), NO_STRING) . '</a></td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE_TOTAL), $currency) . '</td>'
						. '<td class="r"><a id="detail-' . $currency . '-' . COLUMN_EXCHANGE_COUNT . '" href="#">' . $this -> formatCurrency($this -> getColumnData($row, COLUMN_EXCHANGE_COUNT), NO_STRING) . '</a></td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_EXCHANGE_TOTAL), $currency) . '</td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_EXCHANGE_FEE), $currency) . '</td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_COMMISION), $currency) . '</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="16">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoListDateCurrency() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$currency		= NO_STRING;
		$processType	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			foreach($this -> rs as $row) {

				$currency = $this -> getColumnData($row, COLUMN_CURRENCY);

				switch ($this -> getColumnData($row, COLUMN_PROCESS_TYPE)) {
					case NO_COUNT:
						$processType = '入金';
						break;
					case VAL_INT_1:
						$processType = '出金申請';
						break;
					case VAL_INT_2:
						$processType = '出金';
						break;
					case VAL_INT_3:
						$processType = '口座振替';
						break;
					case VAL_INT_4:
						$processType = '引き落し';
						break;
					case VAL_INT_5:
						$processType = '通貨両替';
						break;
					default:
						break;
				}

				$rtn	.= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_PROCESS_DATE) . '</td>'
						. '<td>' . $processType  . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER)  . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT)  . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY)  . '</td>'
						. '<td class="r">' .$this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY))  . '</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="5">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 日付の取得
	* @parameter	: なし
	* @return		: 日付
	-------------------------------------------------------------------------*/
	public function echoDate() {
		echo $this -> date;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理種別の取得
	* @parameter	: なし
	* @return		: 処理種別
	-------------------------------------------------------------------------*/
	public function getTransactionType() {
		return $this -> tranactionType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェント一覧の設定
	* @parameter	: エージェント一覧
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING);
	}
}
?>