<?php

/*-------------------------------------------------------------------------
* @ 画面定数定義
-------------------------------------------------------------------------*/
class Common extends HtmlBuilder {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $action		= NO_STRING;
	private $msgsCommon	= array();

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数群コンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {

		// スーパークラスコンストラクタ呼び出し
		parent::__construct();

		// 機能名を取得する
		$this -> setAction($this -> getDataPost(CONTROL_ACTION));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 機能名の取得
	* @parameter	: なし
	* @return		: 機能名
	-------------------------------------------------------------------------*/
	function getAction() {
		return $this -> action;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 機能名の設定
	* @parameter	: 機能名
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setAction($action) {
		$this -> action = $action;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GETデータの取得
	* @parameter	: キー
	* @return		: value値
	-------------------------------------------------------------------------*/
	function getDataGet($key, 
	    bool $sanitize = false, 
	    bool $pathSanitizer = false, 
	    bool $headerSanitizer = false, 
	    bool $sqlSanitation = false) {

		// 変数宣言部
		$rtn = NO_STRING;

		if(isset($_GET)) {
			if(isset($_GET[$key])) {
				$rtn = $_GET[$key];
				
				if($sanitize){
				    if(is_string($rtn))
				        $this -> sanitizeString($rtn, false, $pathSanitizer, $headerSanitizer, $sqlSanitation);
				    else
				        $this -> sanitizeArrayContent($rtn, $pathSanitizer, $headerSanitizer, $sqlSanitation);
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: POSTデータの取得
	* @parameter	: キー
	* @return		: value値
	-------------------------------------------------------------------------*/
	function getDataPost($key, 
	    bool $sanitize = false, 
	    bool $pathSanitizer = false, 
	    bool $headerSanitizer = false, 
	    bool $sqlSanitation = false) {

		// 変数宣言部
		$rtn = NO_STRING;

		if(isset($_POST)) {
			if(isset($_POST[$key])) {
				$rtn = $_POST[$key];
				
				if($sanitize){
				    if(is_string($rtn))
				        $this -> sanitizeString($rtn, false, $pathSanitizer, $headerSanitizer, $sqlSanitation);
				    else
				        $this -> sanitizeArrayContent($rtn, $pathSanitizer, $headerSanitizer, $sqlSanitation);
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTMLの取得（システム機能）
	* @parameter	: キー
	* @return		: ファイル名
	-------------------------------------------------------------------------*/
	function getSystemHTML($key) {

		// 変数宣言部
		$rtn = NO_STRING;

		$lang = $this -> getLangage();

		//anton
		if($lang == "en"){

			$template = "template";
			$tmp_file = SYSTEM_PATH . $this -> getLangage() . DELIMIT_SLASH . $template . DELIMIT_SLASH . $key;

			if(file_exists($tmp_file)){ // ロードファイル名の取得(直ファイル名のから取得)
				$rtn = SYSTEM_PATH
				. $this -> getLangage()
				. DELIMIT_SLASH
				. $template
				. DELIMIT_SLASH . $key;
			}else {										// ロードファイル名の取得(設定ファイルから取得)
				$rtn = SYSTEM_PATH
				. $this -> getLangage()
				. DELIMIT_SLASH
				. $template . DELIMIT_SLASH
				. $this -> getConfigValue(SECTION_DIR_PATH_SYSTEM, $key);
			}
		}else{
			// オリジナル
			if(file_exists(SYSTEM_TEMPLATE_PATH . $key)) {	// ロードファイル名の取得(直ファイル名のから取得)
				$rtn = SYSTEM_TEMPLATE_PATH . $key;
			} else {										// ロードファイル名の取得(設定ファイルから取得)
				$rtn = SYSTEM_TEMPLATE_PATH . $this -> getConfigValue(SECTION_DIR_PATH_SYSTEM, $key);
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTMLの取得（システム機能）
	* @parameter	: キー
	* @return		: ファイル名
	-------------------------------------------------------------------------*/
	function getUserHTML($key) {

		// 変数宣言部
		$rtn = NO_STRING;

		// ロードファイル名の取得
		$rtn = PROJECT_ROOT
				. DELIMIT_SLASH . $this -> getLangage()
				. DELIMIT_SLASH . SITE_MULTI_TEMPLATE
				. DELIMIT_SLASH . $this -> getConfigValue(SECTION_DIR_PATH_SITE, $key);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージ追加関数
	* @parameter	: メッセージ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function popUpSessionMessage($level, $msgId, $paramArr) {

		// 変数宣言部
		$msgArr = array();	// メッセージ設定配列

		// セッションにデータを詰め込み直す
		if(isset($_SESSION)
			&& isset($_SESSION[MSG_ARRAY])) {
			$msgArr = $_SESSION[MSG_ARRAY];
		}

		// 配列が存在するか確認して、セッションにデータを詰め込む
		if(is_array($msgArr)) {
			$msgArr[] = array($level, $this -> getMessage($level, $msgId, $paramArr));
		} else {
			$msgArr = array(array($level, $this -> getMessage($level, $msgId, $paramArr)));
		}

		$_SESSION[MSG_ARRAY] = $msgArr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージ追加関数
	* @parameter	: メッセージ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function popMessageCommon($level, $msgId, $paramArr) {


		// 変数宣言部
		$msgArr = array();	// メッセージ設定配列

		// 配列が存在するか確認して、セッションにデータを詰め込む
			$this -> msgsCommon[] =	array($level
											, $this -> getMessage($level
																	, $msgId
																	, $paramArr));
	}

	public function getPendingWithdrawalTransactions(){	    
	    return $this -> accessSelect("LIST_FLAT3_PENDING_WITHDRAWALS", 
	        [$this -> getUserData(PARAM_USER_ACCOUNT)]);
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージHTMLを取得
	* @parameter	: なし
	* @return		: メッセージ出力HTML
	-------------------------------------------------------------------------*/
	public function getMessageHTMLString() {

		// 変数宣言部
		$msgArr = null;	// メッセージ設定配列

		// セッションにデータを詰め込み直す
		if(isset($_SESSION[MSG_ARRAY])) {
			$msgArr = $_SESSION[MSG_ARRAY];
		}

		// 配列が存在するか確認して、セッションにデータを詰め込む
		if(is_array($msgArr)) {
			$msgArr = $this -> getMessageHTML($msgArr);
		} else {
			return NO_STRING;
		}

		// セッションデータの消去
		$_SESSION[MSG_ARRAY] = array();

		return $msgArr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージHTMLを取得
	* @parameter	: なし
	* @return		: メッセージ出力HTML
	-------------------------------------------------------------------------*/
	public function getMyMessages() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$error		= array();
		$warning	= array();
		$info		= array();

		// 		メールアドレスが無効です。<br/>
		// 		ダメダメ
		//

		// データが存在する場合
		if($this -> isLoopData($this -> msgsCommon)) {

			foreach($this -> msgsCommon as $msg) {
				if($msg[NO_COUNT] == ERROR) {			// エラー
					$error[]	= $msg[VAL_INT_1];
				} else if($msg[NO_COUNT] == WARNING) {	// 警告
					$warning[]	= $msg[VAL_INT_1];
				} else if($msg[NO_COUNT] == INFO) {		// 情報
					$info[]		= $msg[VAL_INT_1];
				}
			}
		}

		// セッション確認
		if(isset($_SESSION[MSG_ARRAY])
			&& $this -> isLoopData($_SESSION[MSG_ARRAY])) {

			foreach($_SESSION[MSG_ARRAY] as $msg) {
				if($msg[NO_COUNT] == ERROR) {			// エラー
					$error[]	= $msg[VAL_INT_1];
				} else if($msg[NO_COUNT] == WARNING) {	// 警告
					$warning[]	= $msg[VAL_INT_1];
				} else if($msg[NO_COUNT] == INFO) {		// 情報
					$info[]		= $msg[VAL_INT_1];
				}
			}

			$_SESSION[MSG_ARRAY] = array();
		}


		if($this -> isLoopData($error)) {
			$rtn .= '<p class="alert alert-danger alert-dismissible" role="alert">'
					. '<strong><span class="fa fa-warning fa-lg"></span> Error!</strong>'
					. implode(DELIMIT_BR, $error)
					. '</p>';
		}

		if($this -> isLoopData($warning)) {
			$rtn .= '<p class="alert alert-warning alert-dismissible" role="alert">'
					. '<strong><span class="fa fa-warning fa-lg"></span> Warning!</strong>'
					. implode(DELIMIT_BR, $warning)
					. '</p>';
		}

		if($this -> isLoopData($info)) {
			$rtn .= '<p class="alert alert-info alert-dismissible" role="alert">'
					. '<strong><span class="fa fa-warning fa-lg"></span> Info!</strong>'
					. implode(DELIMIT_BR, $info)
					. '</p>';
		}
/// サクセスバージョンもあり！

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージHTMLを取得
	* @parameter	: なし
	* @return		: メッセージ出力HTML
	-------------------------------------------------------------------------*/
	private function getMessageHTML($msgArr) {

		// 変数宣言部
		$colorCssName	= NO_STRING;	// メッセージの色出力CSS名
		$rtnStr			= NO_STRING;	// 返り値用文字列

		foreach($msgArr as $value) {

			if($value[NO_COUNT] == ERROR) {
				$colorCssName = 'red';
			} else if($value[NO_COUNT] == WARNING) {
				$colorCssName = 'yellow';
			} else {
				$colorCssName = 'blue';
			}

			$rtnStr .= '<p class="' . $colorCssName . '"><span class="fa fa-times-circle fa-lg"></span>' . $value[VAL_INT_1] . '</p>';
		}

		echo $rtnStr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージをエコーする
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function echoMessage() {
		echo $this -> getMessageHTMLString();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数セッションメッセージを表示する
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispMessagesCommon() {
		echo $this -> getMyMessages();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータをセッションへ設定する
	* @parameter	: ユーザデータ結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function putSessionUserData($rs) {

		// 変数宣言部
		$userData	= array();	// ユーザデータ配列
		$row 		= null;		// ユーザデータ1行レコード

		// レコードの取得
		$row = $rs[NO_COUNT];

		// ユーザデータ配列の設定
		$userData[PARAM_UID] 			= $this -> getColumnData($row, COLUMN_UID);
		$userData[PARAM_USER_ID]		= $this -> getColumnData($row, COLUMN_USER_NAME);
		$userData[PARAM_USER_ACCOUNT]	= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
		$userData[PARAM_MAIL]			= $this -> getColumnData($row, COLUMN_MAIL);
		$userData[PARAM_ACCOUNT_NUMBER] = $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER);
		$userData[PARAM_NAME]			= $this -> getColumnData($row, COLUMN_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);
		$userData[PARAM_AGENT_CODE]		= $this -> getColumnData($row, COLUMN_AGENT_CODE);
		$userData[PARAM_LANGUAGE]		= $this -> getColumnData($row, COLUMN_USE_LANGUAGE);

		// セッションへユーザデータセット
		$_SESSION[SITE_USER_DATA] = $userData;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 管理者ユーザデータをセッションへ設定する
	* @parameter	: ユーザデータ結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function putSessionAdminUserData($rs) {

		// 変数宣言部
		$userData	= array();	// ユーザデータ配列
		$row 		= null;		// ユーザデータ1行レコード

		// レコードの取得
		$row = $rs[NO_COUNT];

		// ユーザデータ配列の設定
		$userData[PARAM_UID] 			= $this -> getColumnData($row,COLUMN_UID);
		$userData[PARAM_USER_ID]		= $this -> getColumnData($row,COLUMN_USER_NAME);
		$userData[PARAM_USER_ACCOUNT]	= $this -> getColumnData($row,COLUMN_USER_ACCOUNT);
		$userData[PARAM_FIRST_NAME]		= $this -> getColumnData($row,COLUMN_FIRST_NAME);
		$userData[PARAM_LAST_NAME]		= $this -> getColumnData($row,COLUMN_LAST_NAME);

		// セッションへユーザデータセット
		$_SESSION[USER_DATA] = $userData;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータをセッションを削除する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function destroySessionUserData() {
		if($this -> isLoopData($this -> getSessionUserDatas())) {
			unset($_SESSION[SITE_USER_DATA]);
			$_SESSION[SITE_USER_DATA] = null;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 管理者ユーザデータをセッションを削除する
	* @parameter	: ユーザデータ結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function destroySessionAdminUserData() {
		if($this -> isLoopData($this -> getSessionAdminUserDatas())) {
			unset($_SESSION[USER_DATA]);
			$_SESSION[USER_DATA] = null;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メンバーを入金オプションに許可する機能
	 * @parameter	: なし
	 * @return		: 配列
	 -------------------------------------------------------------------------*/
	private function grantDepositSolution(){
	    $grant = $this -> getSettingConfiguration("grant_deposit_solution");
	    
	    if($grant)
	        return $grant;
	    
	    return NO_STRING;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: ユーザデータを取得する
	 * @parameter	: なし
	 * @return		: ユーザデータ
	 -------------------------------------------------------------------------*/
	private function getSessionUserDatas() {

		// 変数宣言部
		$rtn = array();

		// サイトユーザデータの存在確認
		if(isset($_SESSION[SITE_USER_DATA])) {
			$rtn = $_SESSION[SITE_USER_DATA];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザデータを取得する
	* @parameter	: なし
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	private function getSessionAdminUserDatas() {

		// 変数宣言部
		$rtn = array();

		// サイトユーザデータの存在確認
		if(isset($_SESSION[USER_DATA])) {
			$rtn = $_SESSION[USER_DATA];
		}

		return $rtn;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 設定コンフィグレーション
	 * @parameter	: 設定ID
	 * @return		: 物
	 -------------------------------------------------------------------------*/
	public function getSettingConfiguration($settingId){
	    $result = $this -> getRowData($this -> accessSelect("SELECT_DEV_SETTING", [$settingId]));
	    
	    if($this -> isLoopData($result)){
	        $enabled = $this -> getColumnData($result, "dev_setting_enabled");
	        
	        if($enabled){
	            $confData = $this -> getColumnData($result, "dev_setting_value");
	            
	            if($this -> checkJSONString($confData))
	                return json_decode($confData);
	        }
	    }

	    return null;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータを取得する
	* @parameter	: なし
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function getUserData($key) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$datas	= null;

		// セッションデータの取得
		$datas = $this -> getSessionUserDatas();

		if(isset($datas[$key])) {
			$rtn	= $datas[$key];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 管理者ユーザデータを取得する
	* @parameter	: なし
	* @return		: 管理者ユーザデータ
	-------------------------------------------------------------------------*/
	public function getAdminUserData($key) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$datas	= null;

		// セッションデータの取得
		$datas = $this -> getSessionAdminUserDatas();

		if(isset($datas[$key])) {
			$rtn	= $datas[$key];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の作成
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function createAccount() {

		// 変数宣言部
		$range	= null;
		$rtn	= NO_COUNT;
		$cnt	= NO_COUNT;

		$rtn = $this -> shuffleAccount();

		// データのシャッフル
		while($this -> existAccount($rtn)) {
			$cnt++;

			$rtn = $this -> shuffleAccount($cnt);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号のシャッフル
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function shuffleAccount($cnt = NO_COUNT) {

		// 変数宣言部

		$part1 = range(VAR_MIN_ACCOUNT_NUMBER, VAR_MAX_ACCOUNT_NUMBER);
		$part2 = range(VAR_MIN_ACCOUNT_NUMBER, VAR_MAX_ACCOUNT_NUMBER);
		shuffle($part1);
		shuffle($part2);

		return $part1[$cnt] . $part2[$cnt];
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの作成
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function createAgentCode() {

		// 変数宣言部
		$range	= null;
		$rtn	= NO_COUNT;
		$cnt	= NO_COUNT;

		$range	= array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
						, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
						, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

		shuffle($range);

		// データの生成
		for($cnt = NO_COUNT; $cnt < VAL_INT_8; $cnt++) {
			$rtn .= $range[$cnt];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの作成
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function createPassword() {

		// 変数宣言部
		$range	= null;
		$rtn	= NO_COUNT;
		$cnt	= NO_COUNT;

		$range	= array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
						, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
						, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

		shuffle($range);

		// データの生成
		for($cnt = NO_COUNT; $cnt < VAL_INT_10; $cnt++) {
			$rtn .= $range[$cnt];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 確認コードの作成
	* @parameter	: なし
	* @return		: 確認コード
	-------------------------------------------------------------------------*/
	public function createConfirmCode() {

		// 変数宣言部
		$range	= null;
		$rtn	= NO_COUNT;
		$cnt	= NO_COUNT;

		$range	= array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');

		shuffle($range);

		// データの生成
		for($cnt = NO_COUNT; $cnt < VAL_INT_4; $cnt++) {
			shuffle($range);
			$rtn .= $range[$cnt];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の存在確認
	* @parameter	: なし
	* @return		: true:存在する、false:存在しない
	------------------------------------------------------------------------*/
	public function existAccount($account) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs		= null;

		// パラメータの設定
		$param[] = $account;

		// データの取得
		$rs = $this -> accessSelect('SELECT_ACCOUNT', $param);

		if(count($rs) == NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の存在確認
	* @parameter	: なし
	* @return		: true:存在する、false:存在しない
	------------------------------------------------------------------------*/
	public function existAccountByUID($uId) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs		= null;

		// パラメータの設定
		$param[] = $uId;

		// データの取得
		$rs = $this -> accessSelect('SELECT_ACCOUNT_BY_UID', $param);

		if(count($rs) == NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール認証の確認
	* @parameter	: なし
	* @return		: true:その他、false:メール認証されていない
	------------------------------------------------------------------------*/
	public function existVerification($id, $pw) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs		= null;
		$row	= null;

		//get account via user name
		$res        = $this -> getRowData($this -> accessSelect('SELECT_LOGIN_BY_USER_NAME', array($id)));
		$password   = $this -> getColumnData($res, 'password');

		// パラメータの設定
		$param[] = $id;
		$param[] = $password;

		if(count($res) == NO_COUNT) {
			$rtn = true;
		} else {
			//verify password
			if(password_verify($pw.VAL_STR_AUTH_HASH_SECRET_KEY, $password)) {
				// データの取得
				$rs = $this -> accessSelect('SELECT_USER_BY_ID_PW', $param);

				if(count($rs) == NO_COUNT) {
					$rtn = true;
				} else {

					$row = $this -> getRowData($rs);

					if($this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_1) {
						$rtn = false;
					} else {
						$rtn = true;
					}
				}
			} else {
				$rtn = true;
			}
		}

		return $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の存在確認（口座番号かメルアド）
	* @parameter	: なし
	* @return		: true:存在する、false:存在しない
	------------------------------------------------------------------------*/
	public function existAccountOrEmail(&$search) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs		= null;

		// パラメータの設定
		$param[] = $search;

		// データの取得
		$rs = $this -> accessSelect('SELECT_ACCOUNT_BY_EMAIL_OR_ACCOUNT', $param);

		if(count($rs) == NO_COUNT) {
			$rtn = false;
		} else {

			// データの上書き
			$search = $this -> getColumnData($this -> getRowData($rs), COLUMN_USER_ACCOUNT);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードホルダーIDの存在確認
	* @parameter	: なし
	* @return		: true:存在する、false:存在しない
	------------------------------------------------------------------------*/
	public function existCardHolderId($cId) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs		= null;

		// パラメータの設定
		$param[] = $cId;

		// データの取得
		$rs = $this -> accessSelect('SELECT_USER_CARDS', $param);

		if(count($rs) == NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*------------------------Mikko 2019-----------------------------------------
	* @function_name: existUserLink
	* @parameter	: $userlink, detailAccount
	* @return		: true, false
	------------------------------------------------------------------------*/
	public function existUserLink($userLink, $detailAccount) {

		// 変数宣言部
		$rtn	= true;
		$param	= array();
		$rs		= null;

		// パラメータの設定
		$param[0] = $userLink;
		$param[1] = $detailAccount;

		// データの取得
		$rs = $this -> accessSelect('SELECT_ACCOUNT_LINK', $param);

		if(count($rs) == NO_COUNT) {
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索キーより口座番号を取得する
	* @parameter	: なし
	* @return		: 結果の口座番号
	------------------------------------------------------------------------*/
	public function searchUserAccountCommon($key) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$param	= array();
		$rs		= null;


		// パラメータの設定
		$param[] = $key;

		// データの取得
		$rs = $this -> accessSelect('SELECT_ACCOUNT_BY_EMAIL_OR_ACCOUNT', $param);

		if(count($rs) > NO_COUNT) {
			$rtn = $rs[NO_COUNT][COLUMN_USER_ACCOUNT];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトユーザのUIDを作成する
	* @parameter	: なし
	* @return		: UID
	------------------------------------------------------------------------*/
	public function createUId() {
		return md5(time() . uniqid(rand(), 1));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	------------------------------------------------------------------------*/
	public function dispCurrencyCommon($key) {

		$rtn 	= '無効';
		$val	= $this -> getValueByList($this -> getCurrencyList(), $key);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	------------------------------------------------------------------------*/
	public function dispCountryCommon($key) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getCountyList(), $key);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC認証テータスの取得
	* @parameter	: なし
	* @return		: KYC認証テータス
	------------------------------------------------------------------------*/
	public function dispKYCStatusCommon($flg) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getKYCFlgList(), $flg);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザステータスの取得
	* @parameter	: なし
	* @return		: 文字列
	------------------------------------------------------------------------*/
	public function dispUserStatusCommon($status) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getStatusList(), $status);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 文字列
	------------------------------------------------------------------------*/
	public function dispUserAccountTypeCommon($type) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getAccountTypeList(), $type);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 確認書類種別の取得
	* @parameter	: なし
	* @return		: 文字列
	------------------------------------------------------------------------*/
	public function dispIdentityTypeCommon($type) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getIdentityTypeList(), $type);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータスの取得
	* @parameter	: なし
	* @return		: 出金ステータス
	------------------------------------------------------------------------*/
	public function dispWithdrawStatusCommon($type) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getWithdrawStatusList(), $type);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータスの取得
	* @parameter	: なし
	* @return		: 出金ステータス
	------------------------------------------------------------------------*/
	public function dispRequestStatusListCommon($type) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getRequestStatusList(), $type);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 操作の取得
	* @parameter	: なし
	* @return		: 操作
	------------------------------------------------------------------------*/
	public function dispTransactionListCommon($type) {

		$lang = $this -> getLangage();

		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getTransactionListCommon(), $type);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: WLの取得
	* @parameter	: なし
	* @return		: WL
	------------------------------------------------------------------------*/
	public function dispWhiteLabelNameCommon($id) {

		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn 	= ($lang == "en" ? "Invalid" : '無効');
		$val	= $this -> getValueByList($this -> getWhiteLabelList(), $id);

		if($val != NO_STRING) {
			$rtn = $val;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 配列から該当するキーの値を取得する
	* @parameter	: 検索配列、キー
	* @return		: 結果
	------------------------------------------------------------------------*/
	public function getValueByList($lists, $key) {

		// 変数宣言部
		$rtn = NO_STRING;

		if(is_array($lists)) {
			foreach ($lists as $values) {
				if($key == $values[PARAM_DATA_KEY]) {
					$rtn = $values[PARAM_DATA_VALUE];
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの取得
	* @parameter	: 開始ページ
	* @return		: ページャ
	------------------------------------------------------------------------*/
	public function dispPagerCommon($start = VAL_INT_1) {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = 'ここにページャ(共通項目なので後回し)';

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨一覧の取得
	* @parameter	: なし
	* @return		: 通貨一覧
	------------------------------------------------------------------------*/
	public function getCurrencyList() {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;

		// 国マスタデータを取得する
		$rs = $this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array());

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME));
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国一覧の取得
	* @parameter	: 言語
	* @return		: 口座種別リスト
	------------------------------------------------------------------------*/
	public function getCountyList($lang = 'en') {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;

		// 国マスタデータを取得する
		$rs = $this -> accessSelect('LIST_MST_COUNTRY', array($lang));

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_COUNTRY_CODE)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_COUNTRY));
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: WL一覧の取得
	* @parameter	: なし
	* @return		: WL一覧
	------------------------------------------------------------------------*/
	public function getWhiteLabelList() {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;

		// 国マスタデータを取得する
		$rs = $this -> accessSelect('LIST_MST_WHITE_LABEL', array());

		if($this -> isLoopData($rs)) {

			$lang = $this -> getLangage();

			foreach($rs as $row) {
				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_WL_ID)
						, PARAM_DATA_VALUE	=> ($this -> getColumnData($row, COLUMN_WL_NAME) == "IWL本部" && $lang == "en" ? "IWL Headquarters"
								: $this -> getColumnData($row, COLUMN_WL_NAME)));
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別リスト
	------------------------------------------------------------------------*/
	public function getAccountTypeList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_PERSONAL);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_CORPORATE);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の取得
	* @parameter	: なし
	* @return		: 口座状態リスト
	------------------------------------------------------------------------*/
	public function getStatusList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_INVALID);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_TEMPORARY_REGIST);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => VAL_STR_NORMAL);
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE => VAL_STR_UNLIMITED);
		$rtn[] = array(PARAM_DATA_KEY => '4'
						, PARAM_DATA_VALUE => VAL_STR_PAUSE);
		$rtn[] = array(PARAM_DATA_KEY => '5'
						, PARAM_DATA_VALUE => VAL_STR_CLOSE);
		$rtn[] = array(PARAM_DATA_KEY => '6'
						, PARAM_DATA_VALUE => VAL_STR_NORMAL_PAUSE);
		$rtn[] = array(PARAM_DATA_KEY => '7'
						, PARAM_DATA_VALUE => VAL_STR_EXEC_PAUSE);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の取得
	* @parameter	: なし
	* @return		: 口座状態リスト
	------------------------------------------------------------------------*/
	public function getKYCFlgList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> '0'
						, PARAM_DATA_VALUE	=> VAL_STR_UNAUTHENTICATED);
		$rtn[] = array(PARAM_DATA_KEY		=> '1'
						, PARAM_DATA_VALUE	=> VAL_STR_AUTHENTICATED);
		$rtn[] = array(PARAM_DATA_KEY		=> '2'
						, PARAM_DATA_VALUE	=> VAL_STR_DENIAL);
		$rtn[] = array(PARAM_DATA_KEY		=> '3'
						, PARAM_DATA_VALUE	=> VAL_STR_PROCESSING);
		$rtn[] = array(PARAM_DATA_KEY		=> '4'
						, PARAM_DATA_VALUE => VAL_STR_LACK_OF_DOCUMENTS);

		// 変数宣言部
		/*$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAR_KYC_DEFAULT_SELECT);

		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_AUTHENTICATED);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => VAL_STR_DENIAL);
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE => VAR_KYC_STR_SAVE);*/
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 確認書類タイプリストの取得
	* @parameter	: なし
	* @return		: 確認書類タイプリスト
	------------------------------------------------------------------------*/
	public function getIdentityTypeList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_IDENTITY);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_ADDRESS_VERIFICATION);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => VAL_STR_CORPORATE_REGISTRY);
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE => VAL_STR_CORPORATE_ARTICLES);
		$rtn[] = array(PARAM_DATA_KEY => '4'
						, PARAM_DATA_VALUE => VAL_STR_SURVIVING_PROOF);
		$rtn[] = array(PARAM_DATA_KEY => '5'
						, PARAM_DATA_VALUE => VAL_STR_SHAREHOLDERS);
		$rtn[] = array(PARAM_DATA_KEY => '6'
						, PARAM_DATA_VALUE => VAL_STR_OTHER_ADD);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 確認書類タイプリストの取得
	* @parameter	: なし
	* @return		: 確認書類タイプリスト
	------------------------------------------------------------------------*/
	public function getWithdrawStatusList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_APPLY);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_REMITTANCE_ACCEPTED);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => VAL_STR_REMITTANCE_ALREADY);
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE => VAL_STR_DEFICIENCIES_CHECKING);
		$rtn[] = array(PARAM_DATA_KEY => '4'
						, PARAM_DATA_VALUE => VAL_STR_REFUND);
		$rtn[] = array(PARAM_DATA_KEY => '5'
						, PARAM_DATA_VALUE => VAL_STR_CANCELLATION);
		$rtn[] = array(PARAM_DATA_KEY => '6'
						, PARAM_DATA_VALUE => VAL_STR_CANCEL);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし状態リストの取得
	* @parameter	: なし
	* @return		: 引き落とし状態
	------------------------------------------------------------------------*/
	public function getRequestStatusList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_APPLY);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_STATUS_COMP);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => VAL_STR_STATUS_REFUND);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし対象の取得
	* @parameter	: なし
	* @return		: 引き落とし対象リスト
	------------------------------------------------------------------------*/
	public function getRequestTypeList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> '1'
						, PARAM_DATA_VALUE	=> VAL_STR_REQUESTER);
		$rtn[] = array(PARAM_DATA_KEY		=> '2'
						, PARAM_DATA_VALUE	=> VAL_STR_PAYER);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料設定の適用フラグの取得
	* @parameter	: なし
	* @return		: 手数料設定の適用フラグ
	------------------------------------------------------------------------*/
	public function getMstFeeAppFlgList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> '0'
						, PARAM_DATA_VALUE	=> VAL_STR_APPLIES_BOTH);
		$rtn[] = array(PARAM_DATA_KEY		=> '1'
						, PARAM_DATA_VALUE	=> VAL_STR_APPLY_TO_LEFT);
		$rtn[] = array(PARAM_DATA_KEY		=> '2'
						, PARAM_DATA_VALUE	=> VAL_STR_APPLY_TO_RIGHT);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引タイプリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function getTransactionTypeList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> '1'
						, PARAM_DATA_VALUE	=> VAL_STR_DEPOSIT);
		$rtn[] = array(PARAM_DATA_KEY		=> '2'
						, PARAM_DATA_VALUE	=> VAL_STR_NORMAL_WITHDRAW);
		$rtn[] = array(PARAM_DATA_KEY		=> '3'
						, PARAM_DATA_VALUE	=> VAL_STR_EXCHANGE);
		$rtn[] = array(PARAM_DATA_KEY		=> '4'
						, PARAM_DATA_VALUE	=> VAL_STR_TRANSFER);
		$rtn[] = array(PARAM_DATA_KEY		=> '5'
						, PARAM_DATA_VALUE	=> VAL_STR_REQUEST);
		$rtn[] = array(PARAM_DATA_KEY		=> '6'
						, PARAM_DATA_VALUE	=> VAL_STR_FEE);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理タイプリストの取得
	* @parameter	: なし
	* @return		: 処理タイプリスト
	*
	* anton
	------------------------------------------------------------------------*/
	public function getProcessTypeList() {

		// 変数宣言部
		$rtn = array();

		$lang = $this -> getLangage();

		$rtn[] = array(PARAM_DATA_KEY => '0'
				, PARAM_DATA_VALUE => ($lang == "en" ? "User" : "ユーザー"));
		$rtn[] = array(PARAM_DATA_KEY => '1'
				, PARAM_DATA_VALUE => ($lang == "en" ? "Admin" : "アドミン"));
		$rtn[] = array(PARAM_DATA_KEY => '2'
				, PARAM_DATA_VALUE => 'API');
		$rtn[] = array(PARAM_DATA_KEY => '3'
				, PARAM_DATA_VALUE => ($lang == "en" ? "Batch" : "バッチ"));
		$rtn[] = array(PARAM_DATA_KEY => '4'
				, PARAM_DATA_VALUE => ($lang == "en" ? "Bank" : "銀行"));
		$rtn[] = array(PARAM_DATA_KEY => '5'
				, PARAM_DATA_VALUE => ($lang == "en" ? "Card" : "カード"));
		$rtn[] = array(PARAM_DATA_KEY => '6'
				, PARAM_DATA_VALUE => ($lang == "en" ? "Credit" : "クレジット"));

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一括バッチ送金の取得
	* @parameter	: なし
	* @return		: 一括バッチ送金リスト
	------------------------------------------------------------------------*/
	public function getTransferBatchList() {

		// 変数宣言部
		$rtn = array();

		$lang = $this -> getLangage();

		// anton
		$prohibit = ($lang == "en" ? "Not Authorized" : "不許可"); // ふきょか
		$authorize = ($lang == "en" ? "Authorized" : "許可");

		// anton
		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => $prohibit);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => $authorize);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一括バッチ送金の取得
	* @parameter	: なし
	* @return		: 一括バッチ送金リスト
	------------------------------------------------------------------------*/
	public function getTransferList() {

		// 変数宣言部
		$rtn = array();

		$lang = $this -> getLangage();

		// anton
		$enabled 	= ($lang == "en" ? "Enabled" : "不許可"); // ふきょか
		$disabled 	= ($lang == "en" ? "Disabled" : "許可");

		// anton
		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => $enabled);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => $disabled);

		return $rtn;
	}

	public function getTestAccountList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => 'Live');
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => 'Test');

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPS口座種別リストの取得
	* @parameter	: なし
	* @return		: GPS口座種別リスト
	------------------------------------------------------------------------*/
	public function getGPSAccountList() {

		// anton
		$lang = $this -> getLangage();



		$normal = ($lang == "en" ? "Normal Account " : "Normal口座");
		$vip = ($lang == "en" ? "VIP Account" : "VIP口座");

		// 変数宣言部
		$rtn = array();

		// anton
		$rtn[] = array(PARAM_DATA_KEY		=> NO_COUNT
						, PARAM_DATA_VALUE	=> $normal);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_INT_1
						, PARAM_DATA_VALUE	=> $vip);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一括バッチ送金の取得
	* @parameter	: なし
	* @return		: 一括バッチ送金リスト
	------------------------------------------------------------------------*/
	public function getSippingFlgList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_SIPPING_REGISTRY_ADDRESS);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_SIPPING_ANOTHER_ADDRESS);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード申請状況の取得
	* @parameter	: なし
	* @return		: カード申請状況リスト
	------------------------------------------------------------------------*/
	public function getCardProgressList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE	=> VAL_STR_NOT_PROGRESS);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESSING);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESS_NOT_VERI);
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESS);
		$rtn[] = array(PARAM_DATA_KEY => '4'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESS_SUCCESS_SMALL);
		$rtn[] = array(PARAM_DATA_KEY => '5'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESS_SUCCESS_MIDDLE);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード申請状況（管理者用）の取得
	* @parameter	: なし
	* @return		: カード申請状況リスト
	------------------------------------------------------------------------*/
	public function getCardProgressAdminList() {
		$lang = $this -> getLangage();
		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE	=> VAL_STR_NOT_PROGRESS);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESSING);
		$rtn[] = array(PARAM_DATA_KEY => '2'
				, PARAM_DATA_VALUE	=> ($lang == "en" ? "Re-checking" : '再審査'));
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE	=> VAL_STR_PROGRESS);
		$rtn[] = array(PARAM_DATA_KEY => '4'
				, PARAM_DATA_VALUE	=> ($lang == "en" ? "Nup Completed" : 'Nup完了'));
		$rtn[] = array(PARAM_DATA_KEY => '5'
				, PARAM_DATA_VALUE	=> ($lang == "en" ? "UP Completed" : 'UP完了'));
		$rtn[] = array(PARAM_DATA_KEY => '6'
				, PARAM_DATA_VALUE	=> ($lang == "en" ? "No display/hide" : '非表示'));

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード種別の取得
	* @parameter	: なし
	* @return		: カード種別リスト
	------------------------------------------------------------------------*/
	public function getCardTypeList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => 'BB_USD');
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => 'BB_EUR');
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE => 'Sub-USD');
		$rtn[] = array(PARAM_DATA_KEY => '4'
						, PARAM_DATA_VALUE => 'Sub-EUR');
		$rtn[] = array(PARAM_DATA_KEY => '5'
						, PARAM_DATA_VALUE => 'DW_EUR');
		$rtn[] = array(PARAM_DATA_KEY => '5'
						, PARAM_DATA_VALUE => 'CUP-RMB');

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード種別の取得
	* @parameter	: なし
	* @return		: カード種別リスト
	------------------------------------------------------------------------*/
	public function getDepositMethodListCommon() {

		// 変数宣言部
		$account = $this->getUserData(PARAM_USER_ACCOUNT);
		$rs			= $this -> getAccountCommon($account);
		$row		= $this -> getRowData($rs);

		$accountType = $this -> getColumnData($row, COLUMN_ACCOUNT_TYPE);
		
		$grantDeposit = $this -> grantDepositSolution();
		
		if(strlen($grantDeposit) != NO_COUNT)
		    $grantDeposit = json_decode($grantDeposit);
				    
		$rtn = array();

		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> LBTF3)){
			$rtn[] = array(
			    'name'		=> VAL_STR_LBTF3_NAME,
				'logo'		=> VAL_STR_LBTF3_LOGO,
				'method'	=> VAL_STR_LBTF3_METHOD,
				'fee'		=> VAL_STR_LBTF3_FEE,
				'lang' 		=> VAL_STR_LBTF3_DISPLAY_LANG);
		}
		
		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> CCD) || $accountType == 0){		
    		$rtn[] = array(
    		    'name'		  => VAL_STR_CCDEPOSIT_NAME,
    			'logo'   	  => VAL_STR_CCDEPOSIT_LOGO,
    			'method'      => VAL_STR_CCDEPOSIT_METHOD,
    			'fee'		  => VAL_STR_CCDEPOSIT_FEE,
    			'lang' 	      => VAL_STR_CCDEPOSIT_DISPLAY_LANG);
		}

		$rtn[] = array(
		    'name'		    => VAL_STR_JPV_NAME,
			'logo'   	    => VAL_STR_JPV_LOGO,
			'method'		=> VAL_STR_JPV_METHOD,
			'fee'			=> VAL_STR_JPV_FEE,
			'lang' 	     	=> VAL_STR_JPV_DISPLAY_LANG);

// temporarily disabled
// 		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> CPS) || $accountType == 0){
// 			$rtn[] = array(
// 			    'name'			=> VAL_STR_CPS_NAME,
// 				'logo'			=> VAL_STR_CPS_LOGO,
// 				'fee'			=> VAL_STR_CPS_FEE,
// 				'method'		=> VAL_STR_CPS_METHOD,
// 				'lang' 			=> VAL_STR_CPS_DISPLAY_LANG);
// 		}

// 		$rtn[] = array(
// 		    'name'			=> VAL_STR_H2P_NAME,
// 			'logo'			=> VAL_STR_H2P_LOGO,
// 			'fee'			=> VAL_STR_H2P_FEE,
// 			'method'		=> VAL_STR_H2P_METHOD,
// 			'lang' 			=> VAL_STR_H2P_DISPLAY_LANG);


		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> BIT)){
			$rtn[] = array(
			    'name'		=> VAL_STR_BIT_NAME,
				'logo'		=> VAL_STR_BIT_LOGO,
				'method'	=> VAL_STR_BIT_METHOD,
				'fee'		=> VAL_STR_BIT_FEE,
				'lang' 		=> VAL_STR_BIT_DISPLAY_LANG);
		}

		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> CUP)){
	 		$rtn[] = array(
	 		    'name'			=> VAL_STR_CUP_NAME,
	 			'logo'			=> VAL_STR_CUP_LOGO,
	 			'fee'			=> VAL_STR_CUP_FEE,
	 			'method'		=> VAL_STR_CUP_METHOD,
	 			'lang' 			=> VAL_STR_CUP_DISPLAY_LANG);
		}

		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> LBTC)){
			$rtn[] = array(
			    'name'			=> VAL_STR_LBTC_NAME,
    			'logo'			=> VAL_STR_LBTJ_LOGO,
    			'method'		=> VAL_STR_LBTC_METHOD,
                'fee'			=> VAL_STR_LBTC_FEE,
    			'lang' 			=> VAL_STR_LBTC_DISPLAY_LANG);
		}

		if(in_array($this->getUserData(PARAM_USER_ACCOUNT), $grantDeposit -> IBT)){
			$rtn[] = array(
			    'name'			=> VAL_STR_IBT_NAME,
				'logo'			=> VAL_STR_IBT_LOGO,
				'method'		=> VAL_STR_IBT_METHOD,
				'lang' 			=> VAL_STR_IBT_DISPLAY_LANG);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: カード種別の取得
	 * @parameter	: なし
	 * @return		: カード種別リスト
	 ------------------------------------------------------------------------*/
	public function getDepositMethodListAdminCommon() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_GPS_VISA
				, PARAM_DATA_VALUE			=> VAL_STR_DEPOSIT_VISA);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_GPS_GIFTCARD
				, PARAM_DATA_VALUE			=> VAL_STR_DEPOSIT_MASTERCARD);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_GPS_VAL_INSTANTBANKTRANSFER
						, PARAM_DATA_VALUE	=> VAL_STR_DEPOSIT_INSTANTBANKTRANSFER);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_CUP_NAME
						, PARAM_DATA_VALUE	=> VAL_STR_CUP_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_VSMS_NAME
						, PARAM_DATA_VALUE	=> VAL_STR_VSMS_NAME);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 請求名称の取得
	* @parameter	: なし
	* @return		: 請求名称リスト
	------------------------------------------------------------------------*/
	public function getDepositInvoiceNameListCommon() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> NO_STRING
						, PARAM_DATA_VALUE	=> VAL_STR_DEPOSIT_BANK);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_GPS_VISA
						, PARAM_DATA_VALUE	=> VAL_GPS_DEPOSIT_INVOICE_NAME_VISA);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_GPS_GIFTCARD
						, PARAM_DATA_VALUE	=> VAL_GPS_DEPOSIT_INVOICE_NAME_MASTER);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_GPS_VAL_INSTANTBANKTRANSFER
						, PARAM_DATA_VALUE	=> VAL_GPS_DEPOSIT_INVOICE_NAME_BANK);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料リスト
	------------------------------------------------------------------------*/
	public function getFeeListCommon() {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;
		$row	= null;

		$rs = $this -> accessSelect('LIST_FEE_NAMES', array());

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_F_ID)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_FEE_TYPE_NAME));
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料リスト
	------------------------------------------------------------------------*/
	public function getTransactionListCommon() {

		// 変数宣言部
		$rtn	= array();

		$rtn[] = array(PARAM_DATA_KEY => '10'
						, PARAM_DATA_VALUE => 'ログイン');
		$rtn[] = array(PARAM_DATA_KEY => '11'
						, PARAM_DATA_VALUE => 'ログアウト');
		$rtn[] = array(PARAM_DATA_KEY => '12'
						, PARAM_DATA_VALUE => 'Internal Transfer');
		$rtn[] = array(PARAM_DATA_KEY => '13'
						, PARAM_DATA_VALUE => 'Batch Transfer');
		$rtn[] = array(PARAM_DATA_KEY => '14'
						, PARAM_DATA_VALUE => 'User Detail');
		$rtn[] = array(PARAM_DATA_KEY => '15'
						, PARAM_DATA_VALUE => 'Deposit');
		$rtn[] = array(PARAM_DATA_KEY => '16'
						, PARAM_DATA_VALUE => 'Withdraw');
		$rtn[] = array(PARAM_DATA_KEY => '17'
						, PARAM_DATA_VALUE => 'API Registration');
		$rtn[] = array(PARAM_DATA_KEY => '18'
						, PARAM_DATA_VALUE => 'Commission Setting');
		$rtn[] = array(PARAM_DATA_KEY => '19'
						, PARAM_DATA_VALUE => 'Exchange Fee Setting');
		$rtn[] = array(PARAM_DATA_KEY => '20'
						, PARAM_DATA_VALUE => 'Agent');
		$rtn[] = array(PARAM_DATA_KEY => '21'
						, PARAM_DATA_VALUE => 'Notice');
		$rtn[] = array(PARAM_DATA_KEY => '22'
						, PARAM_DATA_VALUE => 'KYC');
		$rtn[] = array(PARAM_DATA_KEY => '23'
						, PARAM_DATA_VALUE => 'Account Administration');
		$rtn[] = array(PARAM_DATA_KEY => '24'
						, PARAM_DATA_VALUE => 'Deleted Transactions');
		$rtn[] = array(PARAM_DATA_KEY => '25'
						, PARAM_DATA_VALUE => 'Request');
		$rtn[] = array(PARAM_DATA_KEY => '26'
						, PARAM_DATA_VALUE => 'Advertisements');
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 言語の取得
	* @parameter	: なし
	* @return		: 言語リスト
	------------------------------------------------------------------------*/
	public function getLanguageListCommon() {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;
		$row	= null;

		$rs = $this -> accessSelect('LIST_MST_LANGUAGE', array());

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_LANG_KEY)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_VALUE));
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: シーケンス発行
	* @parameter	: なし
	* @return		: true:成功、false:失敗
	-------------------------------------------------------------------------*/
	function getSequenceNo($sqKey) {

		// 変数宣言部
		$result		= null;		// 結果セット
		$seqParam	= NO_COUNT;	// シーケンス番号

		// 开启事物
		$this -> beginTransaction();
		// 現在のシーケンス番号を取得
		$result = $this -> accessSelect('SELECT_SEQUENCE', array($sqKey));

		// シーケンス番号のインクリメント
		if(count($result) > 0) {
			$seqParam = $result[NO_COUNT]['seq_param'];
			$seqParam++;

			// 新規シーケンス番号を登録
			$this -> accessModify('UPDATE_SEQUENCE', array($sqKey, $seqParam), false);
		}
		// 关闭事物
		$this -> endTransaction();

		return $seqParam;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果セットのデータを取得する
	* @parameter	: 1行データ、カラム名
	* @return		: データ
	-------------------------------------------------------------------------*/
	function getColumnData($row, $key) {
		return parent::getColumnData($row, $key);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 合計ページの取得
	* @parameter	: 1ページあたりの表示数、合計数
	* @return		: 合計ページ
	-------------------------------------------------------------------------*/
	function getTotalPageCommon($each, $total) {

		// 変数宣言部
		$rtn = NO_COUNT;

		// 0除算対応
		if(intval($each) == NO_COUNT) {
			$each = VAL_INT_1;
		}

		if($total == NO_COUNT) {	// 合計数が0の場合
			$rtn = VAL_INT_1;
		} else {					// その他
			$rtn = floor(($total - VAL_INT_1) / $each) + VAL_INT_1;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨を整数へ変換する
	* @parameter	: データ、通貨
	* @return		: 変化後整数
	-------------------------------------------------------------------------*/
	function currencyToInt($data, $currency) {
		return floor(bcmul($data, $this -> getDigit($currency), 2));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨を整数へ変換する
	* @parameter	: データ、通貨
	* @return		: 変化後整数
	-------------------------------------------------------------------------*/
	function intToCurrency($data, $currency) {

		// 変数宣言部
		$digit	= $this -> getDigit($currency);
		$rtn	= bcdiv($data, $digit, 4);
		$rtn	= floor(bcmul($rtn , $digit, 2));
		$rtn	= bcdiv($rtn, $digit, 2);

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 通貨の基準桁を取得
	* @parameter	: 通貨
	* @return		: 桁
	-------------------------------------------------------------------------*/
	function getDigit($currency) {

		// 変数宣言部
		$rtn = VAL_INT_1;

		switch($currency) {
			case JPY:
				$rtn = DIGIT_JPY;
				break;
			case USD:
				$rtn = DIGIT_USD;
				break;
			case EUR:
				$rtn = DIGIT_EUR;
				break;
			case GBP:
				$rtn = DIGIT_GBP;
				break;
			case HKD:
				$rtn = DIGIT_HKD;
				break;
			case SGD:
				$rtn = DIGIT_SGD;
				break;
			case CNY:
				$rtn = DIGIT_CNY;
				break;
			case IDR:
				$rtn = DIGIT_IDR;
				break;
			case PHP:
				$rtn = DIGIT_PHP;
				break;
			case MYR:
				$rtn = DIGIT_MYR;
				break;
			case THB:
				$rtn = DIGIT_THB;
				break;
			case VND:
				$rtn = DIGIT_VND;
				break;

			case PERCENT:
				$rtn = DIGIT_PERCENT;
				break;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の基準桁数を取得
	* @parameter	: 通貨
	* @return		: 桁数
	-------------------------------------------------------------------------*/
	function getDigitCount($currency) {

		// 変数宣言部
		$rtn = NO_COUNT;

		switch($currency) {
			case JPY:
				$rtn = DIGIT_COUNT_JPY;
				break;
			case USD:
				$rtn = DIGIT_COUNT_USD;
				break;
			case EUR:
				$rtn = DIGIT_COUNT_EUR;
				break;
			case GBP:
				$rtn = DIGIT_COUNT_GBP;
				break;
			case HKD:
				$rtn = DIGIT_COUNT_HKD;
				break;
			case SGD:
				$rtn = DIGIT_COUNT_SGD;
				break;
			case CNY:
				$rtn = DIGIT_COUNT_CNY;
				break;
			case IDR:
				$rtn = DIGIT_COUNT_IDR;
				break;
			case PHP:
				$rtn = DIGIT_COUNT_PHP;
				break;
			case MYR:
				$rtn = DIGIT_COUNT_MYR;
				break;
			case THB:
				$rtn = DIGIT_COUNT_THB;
				break;
			case VND:
				$rtn = DIGIT_COUNT_VND;
				break;
			case PERCENT:
				$rtn = DIGIT_COUNT_PERCENT;
				break;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料タイプを取得
	* @parameter	: from口座タイプ、to口座タイプ
	* @return		: 手数料タイプ
	-------------------------------------------------------------------------*/
	function getFeeWalletType($from, $to) {

		// 変数宣言部
		$rtn = NO_COUNT;

		if($from	== NO_COUNT
			&& $to	== VAL_INT_1) {			// 個人→法人
			$rtn = VAL_INT_3;
		} else if($from		== NO_COUNT
					&& $to	== NO_COUNT) {	// 個人→個人
			$rtn = VAL_INT_4;
		} else if($from		== VAL_INT_1
					&& $to	== NO_COUNT) {	// 法人→個人
			$rtn = VAL_INT_5;
		} else if($from		== VAL_INT_1
					&& $to	== VAL_INT_1) {	// 法人→個人
			$rtn = VAL_INT_6;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示用の金額を取得する
	* @parameter	: 金額、通貨
	* @return		: 表示用の通貨
	-------------------------------------------------------------------------*/
	function getAmountString($amount, $currency) {

		// 変数宣言部
		$rtn 	= NO_COUNT;
		$data 	= NO_COUNT;

		// 数値を通貨へ変換する
		$data = $this -> intToCurrency($amount, $currency);

		// 桁数の表示
		$rtn = $this -> formatCurrency($data, $currency);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示用の金額を生成する
	* @parameter	: 金額、通貨
	* @return		: 表示用の通貨
	-------------------------------------------------------------------------*/
	function formatCurrency($amount, $currency) {

		// 変数宣言部
		$rtn 	= NO_COUNT;
		$digit	= NO_COUNT;

        //convert $amount into float
        $amount = floatval($amount);

		// 桁数を取得
		$digit = $this -> getDigitCount($currency);

		// 桁数の表示
		$rtn = number_format($amount, $digit);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションデータの取得（デフォルトデータ）
	* @parameter	: なし
	* @return		: 手数料データ一覧
	-------------------------------------------------------------------------*/
	function getDefaultCommisionData() {
		return $this -> accessSelect('LIST_AGENT_COMMISION', array(NO_STRING));
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションデータの取得
	* @parameter	: なし
	* @return		: 手数料データ一覧
	-------------------------------------------------------------------------*/
	function getCommisionDataCommon($agent) {
		return $this -> accessSelect('LIST_AGENT_COMMISION', array($agent, NO_STRING));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金済口座履歴の取得
	 * @parameter	: なし
	 * @return		: 送金済口座履歴
	 -------------------------------------------------------------------------*/
	function getTransferHistoryData($account) {
		return $this -> accessSelect('LIST_TRANSFER_HISTORY', array($account));
	}

	/*-------------------------------------------------------------------------
	* @function_name: レートの取得の取得
	* @parameter	: From通貨、To通貨
	* @return		: レート
	-------------------------------------------------------------------------*/
	function getRateCommon($from
							, $to
							, &$original	= null
							, $datetime		= NO_STRING
							, $account		= NO_STRING
							, $asCurExId	= false) {

		// 変数宣言部
		$rtn		= NO_STRING;
		$rs			= null;
		$row		= null;
		$wlId		= NO_COUNT;

		// アカウント情報を取得
		if($asCurExId){
			$row = $this -> getRowData($this -> accessSelect('LIST_EXCHANGE_FEE_PATTERNS_NAME', array($account)));
			if($this -> isLoopData($row)) {		// データが存在する
				$wlId = $this -> getColumnData($row, COLUMN_M_F_ID);
			}

		}else{
			$row = $this -> getRowData($this -> getAccountCommon($account));
			if($this -> isLoopData($row)) {		// データが存在する
				$wlId = $this -> getColumnData($row, COLUMN_EXCHANGE_COMMISION_ID);
			}
		}

		// レートの取得
		if($datetime == NO_STRING) {		// レート日付指定なし
			$rs = $this -> accessSelect('SELECT_EXCHANGE_RATE', array($from
																		, $to
																		, $wlId));

		} else {							// レート日付指定あり
			$rs = $this -> accessSelect('SELECT_EXCHANGE_RATE_HISTORY_DATETIME', array($from
																						, $to
																						, $datetime
																						, $wlId));
		}

		if($this -> isLoopData($rs)) {
			$rtn = $this -> getColumnData($rs[NO_COUNT], COLUMN_RATE);

			if($original !== null) {
				$original = $this -> getColumnData($rs[NO_COUNT], COLUMN_ORIGINAL_RATE);
			}

		} else {
			$rtn		= VAL_INT_1;
			$original	= VAL_INT_1;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 為替変換の取得
	* @parameter	: 金額、From通貨、To通貨、為替両替フラグ、日付指定、口座番号（マークアップ取得）
	* @return		: array(amount => 変換後の金額、rate => レート)
	-------------------------------------------------------------------------*/
	function getExchangeCommon($amount
								, $from
								, $to
								, $exFlg	= false
								, $divFlg	= false
								, $datetime	= NO_STRING
								, $account	= NO_STRING
								, $asCurExId = false) {

		// 変数宣言部
		$rtn		= array();
		$rs			= NO_STRING;
		$originalRs	= NO_STRING;
		$digit		= NO_COUNT;
		$rate		= NO_COUNT;
		$oriRate	= NO_COUNT;
		$profit		= NO_COUNT;
        $amount     = floatval($amount);

		// 桁を取得する
		$digit = $this -> getDigit($to);

		// レートを取得する
		if($divFlg) {	// 割り算フラグの場合

			$rate		= $this -> getRateCommon($to
													, $from
													, $oriRate
													, $datetime
													, $account
													, $asCurExId);

			if($to == $from) {
				$rate		= VAL_INT_1;
				$oriRate	= VAL_INT_1;
			}

			$rs			= $amount / $rate;
			$originalRs	= $amount / $oriRate;

		} else {		// 通常レートの計算
			$rate		= $this -> getRateCommon($from
													, $to
													, $oriRate
													, $datetime
													, $account
													, $asCurExId);
			$rs			= $amount * $rate;
			$originalRs	= $amount * $oriRate;
		}

		// 桁を落として、整形する
		$rs			= floor($rs * $digit);
		$rs			= $rs / $digit;
		$originalRs = floor($originalRs * $digit);
		$originalRs	= $originalRs / $digit;

		// 金額に満たない場合は最少単位を加算する
		if(($rs / $rate) < $amount) {

			$rs			= floor($rs * $digit);
			$originalRs	= floor($originalRs * $digit);

			// 為替両替の場合は、iwalletが対象なのでマイナスする
			if(!$exFlg) {
				$rs			= $rs + VAL_INT_1;
				$originalRs	= $originalRs + VAL_INT_1;
			}

			$rs			= $rs / $digit;
			$originalRs	= $originalRs / $digit;

			// 最低金額に満たない場合は最低金額
			if($rs == NO_COUNT) {
				$rs			= VAL_INT_1 / $digit;
				$originalRs	= VAL_INT_1 / $digit;
			}
		}

		// 収益計算
		if($rs >= $originalRs) {
			$profit = $rs - $originalRs;
		} else {
			$profit = $originalRs - $rs;
		}

		// 返却データ
		$rtn[PARAM_AMOUNT]			= $rs;
		$rtn[PARAM_RATE]			= $rate;
		$rtn[PARAM_ORIGINAL_AMOUNT]	= $originalRs;
		$rtn[PARAM_ORIGINAL_RATE]	= $oriRate;
		$rtn[PARAM_PROFIT]			= $profit;

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 口座データの取得
	* @parameter	: 口座番号
	* @return		: 口座データ結果セット
	-------------------------------------------------------------------------*/
	function getAccountCommon($account) {
		return $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($account));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: getAPISignatureCommon
	 * @parameter	: aid
	 * @return		: array
	 -------------------------------------------------------------------------*/
	function getAPISignatureCommon($aid) {
	    return $this -> accessSelect('SELECT_API_SIGNATURE_BY_A_ID', array($aid));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座データの取得
	* @parameter	: メールアドレス
	* @return		: 口座データ結果セット
	-------------------------------------------------------------------------*/
	function getAccountByEmailCommon($email) {
		return $this -> accessSelect('SELECT_USER_BY_ACCOUNT_OR_EMAIL', array($email));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座データの取得
	* @parameter	: 口座番号
	* @return		: 口座データ結果セット
	------------------------------------------------------------------------*/
	function getAccountByAgentCodeCommon($agenCode) {
		return $this -> accessSelect('SELECT_USER_BY_AGENT_CODE', array($agenCode));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 1行データの取得
	* @parameter	: 結果セット、行番号
	* @return		: 1行データ
	-------------------------------------------------------------------------*/
	function getRowData($rs, $index = NO_COUNT) {

		// 変数宣言部
		$rtn = array();

		if(is_array($rs)
			&& isset($rs[$index])) {
			$rtn = $rs[$index];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 大元のエージェントを取得する
	* @parameter	: エージェントコード
	* @return		: 大元口座番号
	-------------------------------------------------------------------------*/
	function getBaseAgent($agentCode) {

		// 変数宣言部
		$rtn = $agentCode;

		// 親が存在する
		if($rtn != NO_STRING) {

			// 大元を取得する
			while(true) {

				$rs = $this -> getAccountByAgentCodeCommon($rtn);

				if(!$this -> isLoopData($rs)) {
					break;
				} else {

					$row = $this -> getRowData($rs);

					if($this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE) == NO_STRING) {	// 親がいない
						$rtn = $this -> getColumnData($row, COLUMN_AGENT_CODE);
						break;
					} else {																	// 親がいる
						$rtn = $this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE);
					}
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションを取得する
	* @parameter	: エージェントコード、手数料タイプ、口座種別
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function getCommisionCommon($agentCode
								, $type
								, $walletType) {


		if($agentCode == NO_STRING) {	// 大元の手数料を取得（エージェントなし）
			$rs = array();
		} else {						// 大元の手数料を取得
			$rs = $this -> getAccountByAgentCodeCommon($agentCode);
		}

		if(!$this -> isLoopData($rs)
			|| $agentCode == NO_STRING) {	// データが無かったりエージェントが存在しない場合は全適用
			$commision = $this -> accessSelect('SELECT_COMMISION_BY_ALL_APPLICATION', array($type, $walletType));

		} else {

			$row			= $this -> getRowData($rs);
			$commisionId	= $this -> getColumnData($row, COLUMN_COMMISION_ID);
// print_r($row);
			if($commisionId		== NO_STRING
				|| $commisionId	== NO_COUNT) {	// 全適用の場合
				$commision = $this -> accessSelect('SELECT_COMMISION_BY_ALL_APPLICATION', array($type, $walletType));

			} else {						// 個別適用の場合
				$commision = $this -> accessSelect('SELECT_COMMISION_BY_F_ID', array($commisionId
																					, $type
																					, $walletType));
			}
		}

		return $commision;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: 手数料タイプ、処理金額、通貨、口座1、口座2
	* @return		: array(amount => 変換後の金額、rate => レート)
	-------------------------------------------------------------------------*/
	/**
	 *
	 * modified - anton
	 *
	 */
	function getFeeCommon($type
		, $amount
		, $currency
		, $account1
		, $account2			= NO_COUNT
		, $debitCurrency	= USD
		, $toAmount			= NO_COUNT) {

		// 変数宣言部
		$rtn			= array();
		$rs				= null;
		$rs2			= null;
		$row			= null;
		$row2			= null;
		$walletType		= NO_STRING;
		$agent			= NO_STRING;
		$walletType2	= NO_STRING;
		$agent2			= NO_STRING;
		$tmpAccount		= NO_STRING;
		$commisionId	= NO_STRING;
		$commision		= null;
		$commision2		= null;
		$defAmount		= NO_COUNT;
		$toFee			= NO_COUNT;

		// 一旦金額は退避
		$defAmount = $amount;

		/**
		 *
		 * For Internal Transfer Transaction
		 * - anton
		 *
		 */
		$accountUsedForRates = $account1;

		// まずは金額をUSDに合わせる
		// modified - anton
		$amount = $this -> getExchangeCommon($amount, $currency, USD, true, true, NO_STRING, $account1);
		$amount = $amount[PARAM_AMOUNT];

		// ユーザデータの取得
		if($type == VAR_TRANSFER) {

			$rs			= $this -> getAccountCommon($account1);
			$rs2		= $this -> getAccountCommon($account2);
			$row		= $this -> getRowData($rs);
			$row2		= $this -> getRowData($rs2);

			$walletType	= $this -> getFeeWalletType($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE),
					$this -> getColumnData($row2, COLUMN_ACCOUNT_TYPE));


		} else {
			$rs			= $this -> getAccountCommon($account1);
			$row		= $this -> getRowData($rs);

			//　anton 2019/04/02
			$potnum = $this -> getColumnData($row, COLUMN_ACCOUNT_TYPE);
			$walletType	= (is_numeric($potnum) ? $potnum : 0) + VAL_INT_1;

		}

				// 個別データを取得する
		$agent 		= $this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE);

		// コミッションの取得
		$commision	= $this -> getCommisionCommon($agent
				, $type
				, $walletType);

		if($type == VAR_TRANSFER) { // 口座送金の場合

			$rs				= $this -> getAccountCommon($account2);
			$row			= $this -> getRowData($rs);
			$walletType2	= $this -> getColumnData($row, COLUMN_ACCOUNT_TYPE) + VAL_INT_1;
			$agent2 		= $this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE);


			// コミッションの取得
			$commision2 = $this -> getCommisionCommon($agent2
					, $type
					, $walletType);
		}

		$rtn[$currency . VAL_INT_1]	= NO_COUNT;
		$rtn[$currency . VAL_INT_2]	= NO_COUNT;
		$rtn[USD . VAL_INT_1]		= NO_COUNT;

		// 手数料の計算
		if(!$this -> isLoopData($commision)) {	// 手数料が存在しない場合は、なし
			$rtn[$currency . VAL_INT_1]	= NO_COUNT;
			$rtn[USD . VAL_INT_1]		= NO_COUNT;
		} else {

			$row = $this -> getRowData($commision);

			// 適用フラグの取得
			$appFlg = $this -> getColumnData($row, COLUMN_APP_FLG);

			if($appFlg == VAL_INT_2) {	// 右に適用（受取側）の場合は計算はしない
				$rtn[$currency . VAL_INT_1]	= NO_COUNT;
			} else {

				if($this -> getColumnData($row, COLUMN_FEE_FLG) == NO_COUNT) { 			// 固定値の場合

					$fee						= $this -> getColumnData($row, COLUMN_FIX);
					$fee						= $this -> intToCurrency($fee, USD);
					$rtn[USD . VAL_INT_1]		= $fee;
					// modified - anton
					$fee						= $this -> getExchangeCommon($fee, USD, $currency, false, false, NO_STRING, $account1);
					$rtn[$currency . VAL_INT_1]	= $fee[PARAM_AMOUNT];

				} else if($this -> getColumnData($row, COLUMN_FEE_FLG) == VAL_INT_1) {	// パーセンテージの場合
					$parcent	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_PERCENT), PERCENT);
					$min		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_MIN_VALUE), USD);
					$max		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_MAX_VALUE), USD);

					// 					$pData = ($amount * $parcent) / VAL_INT_100;

					if($currency == USD) {	// USD基準なので、USDの場合は何もしない
						// Percentage-Data
						$pData = ($amount * $parcent) / VAL_INT_100;
					} else {					// その他の通貨の場合

						// 両替
						// 						$pData	= $this -> getExchangeCommon($defAmount, $currency, USD, true, true);
						// 						$pData	= $this -> getColumnData($pData, PARAM_AMOUNT);

						$pData	= ($amount * $parcent) / VAL_INT_100;
					}

					if($min > $pData) {			// 最低値の方が大きい場合
						// modification - anton
						$fee					= $this -> getExchangeCommon($min, USD, $currency, false, false, NO_STRING, $account1); // anton
						$rtn[USD . VAL_INT_1]	= $min;

						$fee					= $fee[PARAM_AMOUNT];
					} else if($max < $pData) {	// 最高値の方が小さい場合
						$fee					= $this -> getExchangeCommon($max, USD, $currency, false, false, NO_STRING, $account1); // anton
						$fee					= $fee[PARAM_AMOUNT];
						$rtn[USD . VAL_INT_1]	= $max;
					} else {					// 最高値と最低値の間の場合
						$fee					= ($defAmount * $parcent) / VAL_INT_100;
						$rtn[USD . VAL_INT_1]	= ($amount * $parcent) / VAL_INT_100;
					}

					$rtn[$currency . VAL_INT_1]	= $fee;
				} else {																// 両方計算の場合

					// 固定値計算
					$fee						= $this -> getColumnData($row, COLUMN_FIX);
					$fee						= $this -> intToCurrency($fee, USD);
					$rtn[USD . VAL_INT_1]		= $fee;
					$fee						= $this -> getExchangeCommon($fee, USD, $currency, false, false, NO_STRING, $account1); // anton
					$feeTmp						= $fee[PARAM_AMOUNT];

					// パーセンテージ計算
					$parcent	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_PERCENT), PERCENT);
					$min		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_MIN_VALUE), USD);
					$max		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_MAX_VALUE), USD);

					$pData = ($amount * $parcent) / VAL_INT_100;

					if($min > $pData) {			// 最低値の方が大きい場合
						$fee					= $this -> getExchangeCommon($min, USD, $currency, false, false, NO_STRING, $account1); // anton
						$rtn[USD . VAL_INT_1]	= $min;
						$feeTmp					+= $fee[PARAM_AMOUNT];

					} else if($max < $pData) {	// 最高値の方が小さい場合
						$fee					= $this -> getExchangeCommon($max, USD, $currency, false, false, NO_STRING, $account1); // anton
						$rtn[USD . VAL_INT_1]	= $max;
						$feeTmp					+= $fee[PARAM_AMOUNT];

					} else {					// 最高値と最低値の間の場合

						$feeTmp					+= ($defAmount * $parcent) / VAL_INT_100;
					}

					// 合算した分を返却
					$rtn[$currency . VAL_INT_1]	= $feeTmp;
				}
			}
		}

		if($type == VAR_TRANSFER) { // 口座送金の場合
			// まずは金額をUSDに合わせる
			// 			$amount = $this -> getExchangeCommon($defAmount, $currency, USD, true, true);
			// 			$amount = $amount[PARAM_AMOUNT];

			if(!$this -> isLoopData($commision2)) {	// 手数料が存在しない場合は、なし

				$rtn[$currency . VAL_INT_2]			= NO_COUNT;
				$rtn[$debitCurrency . VAL_INT_2]	= NO_COUNT;
			} else {
				$row = $this -> getRowData($commision2);

				// 適用フラグの取得
				$appFlg = $this -> getColumnData($row, COLUMN_APP_FLG);

				// print_r($row);
				if($appFlg == VAL_INT_1) {	// 左に適用（送金側）の場合は計算はしない
					$rtn[$currency . VAL_INT_2]			= NO_COUNT;
					$rtn[$debitCurrency . VAL_INT_2]	= NO_COUNT;
				} else {					// 右に適用の場合
					if($this -> getColumnData($row, COLUMN_FEE_FLG) == NO_COUNT) {	// 固定値の場合

						$fee						= $this -> getColumnData($row, COLUMN_FIX);
						$fee						= $this -> intToCurrency($fee, USD);
						$fee						= $this -> getExchangeCommon($fee, USD, $currency, false, false,
								NO_STRING, $account2);
						$rtn[$currency . VAL_INT_2]	= $fee[PARAM_AMOUNT];


					} else {														// パーセンテージの場合
						$parcent	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_PERCENT), PERCENT);
						$min		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_MIN_VALUE), USD);
						$max		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_MAX_VALUE), USD);

						$accountUsedForRates = $account2;

						if($debitCurrency == USD) {	// USD基準なので、USDの場合は何もしない
							$pData = ($toAmount * $parcent) / VAL_INT_100;
						} else {					// その他の通貨の場合

							// 両替
							$pData	= $this -> getExchangeCommon($toAmount, $debitCurrency, USD, true, true, NO_STRING, $account2);
							$pData	= $this -> getColumnData($pData, PARAM_AMOUNT);
						}

						if($min > $pData) {			// 最低値の方が大きい場合
							$fee = $this -> getExchangeCommon($min, USD, $currency, false, false, NO_STRING, $account2);

							$fee = $fee[PARAM_AMOUNT];

							$toFee	= $this -> getExchangeCommon($min, USD, $debitCurrency, false, false, NO_STRING, $account2);
							$toFee	= $toFee[PARAM_AMOUNT];

						} else if($max < $pData) {	// 最高値の方が小さい場合
							$fee	= $this -> getExchangeCommon($max, USD, $currency, false, false, NO_STRING, $account2);
							$fee	= $fee[PARAM_AMOUNT];

							$toFee	= $this -> getExchangeCommon($max, USD, $debitCurrency, false, false, NO_STRING, $account2);
							$toFee	= $toFee[PARAM_AMOUNT];

						} else {
							$fee	= ($toAmount * $parcent) / VAL_INT_100;
							$toFee	= ($toAmount * $parcent) / VAL_INT_100;
							$fee	= ($amount * $parcent) / VAL_INT_100;
							$pData	= ($toAmount * $parcent) / VAL_INT_100;
						}

						$rtn[$debitCurrency . VAL_INT_2] 	= $pData;
						$rtn[$currency . VAL_INT_2]			= $toFee;
					}
				}
			}
		}

		// 端数の繰り上げ処理
		if(floor(bcmul($rtn[$currency . VAL_INT_1], $this -> getDigit($currency), 2)) < bcmul($rtn[$currency . VAL_INT_1], $this -> getDigit($currency), 2)) {
			$rtn[$currency . VAL_INT_1] = $this -> intToCurrency(floor(bcmul($rtn[$currency . VAL_INT_1], $this -> getDigit($currency), 2)) + VAL_INT_1, $currency);
		}


		if(floor(bcmul($rtn[$currency . VAL_INT_2], $this -> getDigit($currency), 2)) < bcmul($rtn[$currency . VAL_INT_2], $this ->  getDigit($currency), 2)) {
			$rtn[$currency . VAL_INT_2] = $this -> intToCurrency(floor(bcmul($rtn[$currency . VAL_INT_2], $this -> getDigit($currency), 2)) + VAL_INT_1, $currency);
		}

		// 端数の繰り上げ処理
		if(isset($rtn[$debitCurrency . VAL_INT_2])) {

			if(floor(bcmul($rtn[$debitCurrency . VAL_INT_2], $this -> getDigit($debitCurrency), 2)) < bcmul($rtn[$debitCurrency . VAL_INT_2], $this -> getDigit($debitCurrency), 2)) {
				$rtn[$debitCurrency . VAL_INT_2] = $this -> intToCurrency(floor(bcmul($rtn[$debitCurrency . VAL_INT_2], $this -> getDigit($debitCurrency), 2)) + VAL_INT_1, $debitCurrency);
			}
		}

		// modified - anton
		$rtn[PARAM_RATE] = $this -> getRateCommon(USD, $currency, $oriTemp, NO_STRING, $accountUsedForRates);

		$rtn[PARAM_AGENT_CODE . VAL_INT_1] = $agent;
		$rtn[PARAM_AGENT_CODE . VAL_INT_2] = $agent2;
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座残高の取得
	* @parameter	: 口座番号、通貨
	* @return		: 口座残高
	-------------------------------------------------------------------------*/
	function getBalanceCommon($account, $currency) {

		// 変数宣言部
		$rtn	= NO_COUNT;
		$lists	= null;

		// 残高データの取得
		$lists = $this -> getBalanceListCommon($account);

		return $this -> intToCurrency($this -> getColumnData($lists, $currency), $currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座残高リストの取得
	* @parameter	: 口座番号
	* @return		: 口座残高
	-------------------------------------------------------------------------*/
	function getBalanceListCommon($account) {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;

		$rs = $this -> accessSelect('SELECT_USER_BALANCES', array($account));

		/*foreach($rs as $row){
			var_dump($row);
			echo "<br>";
		}
		exit();*/
		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {

				// データを詰め込む
				$rtn[$this -> getColumnData($row, COLUMN_CURRENCY)] = $this -> getColumnData($row, COLUMN_BALANCE);
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: リクエストデータの取得
	* @parameter	: リクエストID
	* @return		: リクエストデータ結果セット
	-------------------------------------------------------------------------*/
	function getRequestCommon($rId) {
		return $this -> accessSelect('LIST_REQUEST_BY_R_ID', array($rId));
	}

	/*-------------------------------------------------------------------------
	* @function_name: リクエストデータの取得
	* @parameter	: リクエストID
	* @return		: リクエストデータ結果セット
	-------------------------------------------------------------------------*/
	function getExchangeRecordCommon($transaction_number) {
		return $this -> accessSelect('LIST_EXCHANGE_BY_E_ID', array($transaction_number));
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションの登録
	* @parameter	:
	* @return		: なし
	-------------------------------------------------------------------------*/
	function insertCommisionCommon($agentCode
									, $type
									, $currency
									, $amount
									, $cFlg = true) {

		// 変数宣言部
		$params = array();

		// パラメータの設定
		$params[] = $agentCode;
		$params[] = $type;
		$params[] = $currency;
		$params[] = $amount;

// 		$this -> accessModify('INSERT_COMMISION', $params, $cFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信を行う
	* @parameter	: 送信先メールアドレス、件名、本文
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendMail($address
						, $title
						, $body
						, $from = NO_STRING
						, $file = null) {

		// 変数宣言部
		$formAdd	= NO_STRING;
		$dispName	= NO_STRING;

		// 文字化け対応
		mb_language('ja');
		mb_internal_encoding('UTF-8');

		// 送信アドレスが指定されていたらそこからメールを送信する
		if($from != NO_STRING) {
			$formAdd = $from;

			$dispName = $this -> getMailDisplayNameCommon($formAdd);

			if($dispName != NO_STRING)
				$formAdd = $dispName . '<' . $from . '>';

		} else {
			$formAdd = VAR_EC_MAIL_ADDRESS;
		}
		ini_set('error_reporting', E_ALL & ~E_STRICT);

		mb_language('uni');

		$awsMangoMailer = new AWSMangoMailer();
		$awsMangoMailer -> setAltName(isset($dispName) ? $dispName : NO_STRING);
		
		$messageId = $awsMangoMailer -> sendEmail(
		    [$address], 
		    trim($title), 
		    $body,
		    "UTF-8");
		
		// returns false if there's something wrong with the mailer;
		if (!$messageId) {
		    
    		$errorLogPath 		= SYSTEM_PATH.'documents'.DIRECTORY_SEPARATOR.'error_log';
    		$mailErrorPath 		= $errorLogPath.DIRECTORY_SEPARATOR.'mail_error';
    
    		// check if directory exists if not, create directory
    		if(!file_exists($errorLogPath)) 
    			mkdir($errorLogPath, 0777, true);
    
    		if(!file_exists($mailErrorPath)) 
    			mkdir($mailErrorPath, 0777, true);
    
    		$content = date("[Y-m-d H:i:s]")
            		."\r\nTo:".$address
            		."\r\nSubject: ".$title
            		."\r\nBody: ".$body."\r\n\r\n\r\n\r\n\r\n";
    		
    		//log the email details
    		error_log($content, 3, $mailErrorPath.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号より、メールアドレスを取得する
	* @parameter	: 口座番号
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function getEMailCommon($account) {

		// 変数宣言部
		$rs		= null;
		$row	= null;

		// ユーザデータ取得
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		return $this -> getColumnData($row, COLUMN_MAIL);
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信を行う（テンプレートを読み込むラッパー）
	* @parameter	: テンプレート名、パラメータ、送信先メールアドレス
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendMailById($tmpName, $params, $account, $from = NO_STRING) {

		// 変数宣言部
		$mail = NO_STRING;

		$mail = $this -> getEMailCommon($account);

		$this -> sendMailByTmp($tmpName, $params, $mail, $from);
	}

	function getMailTemplate($tmpName, $params, $lang = "ja"){
	    $path	= MAIL_TEMPLATES . $tmpName;
	    $cnt	= VAL_INT_1;
	    
	    // XMLファイルの存在確認
	    if(!file_exists($path)) 
	        return false;
	        
        // xmlファイルロード
	    if(!($xml = simplexml_load_file($path)))
	        return false;
	        
        if(NO_STRING == ($title = $xml -> title) || NO_STRING == ($body = $xml -> body)) 
	        return false;
	    
	    // トリムをする（件名）
	    $title	= str_replace("\t", NO_STRING, $title);
	    $title	= str_replace("\r", NO_STRING, $title);
	    $title	= str_replace("\0", NO_STRING, $title);
	    $title	= str_replace("\x0B", NO_STRING, $title);
	    
	    // トリムをする
	    $body = str_replace("\t", NO_STRING, $body);
	    $body = str_replace("\r", NO_STRING, $body);
	    $body = str_replace("\0", NO_STRING, $body);
	    $body = str_replace("\x0B", NO_STRING, $body);
	    
	    // パラメータを設定する
	    foreach($params as $value) {
	        $title	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $title);
	        $body	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $body);
	        $cnt++;
	    }
	    
	    // ドメインの変更
	    $title = str_replace('__ELEMENT_SITE_NAME__', SITE_NAME, $title);
	    $body = str_replace('__ELEMENT_DOMAIN__', SITE_DOMAIN, $body);
	    $body = str_replace('__ELEMENT_BASE_URL__', SITE_PROTOCOL.'://'.SITE_DOMAIN_FULL, $body);
	    $body = str_replace('__ELEMENT_SUB_DOMAIN__', SITE_SUB_DOMAIN, $body);
	    $body = str_replace('__ELEMENT_SITE_NAME__', SITE_NAME, $body);
	    $body = str_replace('__ELEMENT_SITE_CORP_SHORT_NAME__', SITE_CORP_SHORT_NAME, $body);
	    $body = str_replace('__ELEMENT_SITE_SHORT_NAME__', SITE_SHORT_NAME, $body);
	    $body = str_replace('__ELEMENT_LANGAGE__', $lang, $body);
	    
	    $templateData = [
	        "body" => isset($body) ? $body : NO_STRING,
	        "title" => isset($title) ? $title : NO_STRING
	    ];
	    
	    return $templateData;    
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: メールの送信を行う（テンプレートを読み込むラッパー）
	* @parameter	: テンプレート名、パラメータ、送信先メールアドレス、送信元メールアドレス
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendMailByTmp($tmpName
							, $params
							, $address
							, $from	= NO_STRING
							, $lang = 'ja'
							, $file = null) {
		
		if($template = $this -> getMailTemplate($tmpName, $params, $lang)){
		    //check if there is a file to be attached (file is not null)
		    if($file != null) {
		        // 全部OKだったらメール送信
		        $this -> sendMail($address, $template["title"], $template["body"], $from, $file);
		    } else {
		        $this -> sendMail($address, $template["title"], $template["body"], $from);
		    }
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信を行う（テンプレートを読み込むラッパー）
	* @parameter	: テンプレート名、パラメータ、送信先メールアドレス、送信元メールアドレス
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendMailByTmpFromAPI($tmpName
							, $params
							, $address
							, $from	= NO_STRING
							, $lang = 'ja') {

		// 変数宣言部
		$path	= MAIL_TEMPLATES . $lang .DIRECTORY_SEPARATOR .$tmpName;
		$xml	= null;
		$title	= NO_STRING;
		$body	= NO_STRING;
		$cnt	= VAL_INT_1;
		$key	= NO_STRING;

		// XMLファイルの存在確認
		if(file_exists($path)) {

			// xmlファイルロード
			if(($xml = simplexml_load_file($path))) {

				// 件名を取得する
				$key = PARAM_TITLE;
				if(NO_STRING == ($title = $xml -> $key)) {
					return ;
				}

				// 件名を取得する
				$key = PARAM_BODY;
				if(NO_STRING == ($body = $xml -> $key)) {
					return ;
				}

				// トリムをする（件名）
				$title	= str_replace("\t", NO_STRING, $title);
				$title	= str_replace("\r", NO_STRING, $title);
				$title	= str_replace("\0", NO_STRING, $title);
				$title	= str_replace("\x0B", NO_STRING, $title);

				// トリムをする
				$body = str_replace("\t", NO_STRING, $body);
				$body = str_replace("\r", NO_STRING, $body);
				$body = str_replace("\0", NO_STRING, $body);
				$body = str_replace("\x0B", NO_STRING, $body);

				// パラメータを設定する
				foreach($params as $value) {
					$title	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $title);
					$body	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $body);
					$cnt++;
				}

				// ドメインの変更
				$title = str_replace('__ELEMENT_SITE_NAME__', SITE_NAME, $title);
				$body = str_replace('__ELEMENT_DOMAIN__', SITE_DOMAIN, $body);
				$body = str_replace('__ELEMENT_BASE_URL__', SITE_PROTOCOL.'://'.SITE_DOMAIN_FULL, $body);
				$body = str_replace('__ELEMENT_SUB_DOMAIN__', SITE_SUB_DOMAIN, $body);
				$body = str_replace('__ELEMENT_SITE_NAME__', SITE_NAME, $body);
				$body = str_replace('__ELEMENT_SITE_CORP_SHORT_NAME__', SITE_CORP_SHORT_NAME, $body);
				$body = str_replace('__ELEMENT_SITE_SHORT_NAME__', SITE_SHORT_NAME, $body);
				$body = str_replace('__ELEMENT_LANGAGE__', $lang, $body);



				// 全部OKだったらメール送信
				$this -> sendMail($address, $title, $body, $from);
			}
		}

		return;
	}

/*-------------------------------------------------------------------------
	* @function_name: 手动更改出金状态发送邮件
	* @parameter	: テンプレート名、パラメータ、送信先メールアドレス、送信元メールアドレス
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendMailByTmpFromManual($tmpName
							, $params
							, $address
							, $from	= NO_STRING
							, $lang = 'ja') {

		// 変数宣言部
		$path	= MAIL_TEMPLATES_LOCAL . $lang .DIRECTORY_SEPARATOR .$tmpName;
		$xml	= null;
		$title	= NO_STRING;
		$body	= NO_STRING;
		$cnt	= VAL_INT_1;
		$key	= NO_STRING;

		// XMLファイルの存在確認
		if(file_exists($path)) {

			// xmlファイルロード
			if(($xml = simplexml_load_file($path))) {

				// 件名を取得する
				$key = PARAM_TITLE;
				if(NO_STRING == ($title = $xml -> $key)) {
					return ;
				}

				// 件名を取得する
				$key = PARAM_BODY;
				if(NO_STRING == ($body = $xml -> $key)) {
					return ;
				}

				// トリムをする（件名）
				$title	= str_replace("\t", NO_STRING, $title);
				$title	= str_replace("\r", NO_STRING, $title);
				$title	= str_replace("\0", NO_STRING, $title);
				$title	= str_replace("\x0B", NO_STRING, $title);

				// トリムをする
				$body = str_replace("\t", NO_STRING, $body);
				$body = str_replace("\r", NO_STRING, $body);
				$body = str_replace("\0", NO_STRING, $body);
				$body = str_replace("\x0B", NO_STRING, $body);

				// パラメータを設定する
				foreach($params as $value) {
					$title	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $title);
					$body	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $body);
					$cnt++;
				}

				// ドメインの変更
				$title = str_replace('__ELEMENT_SITE_NAME__', SITE_NAME, $title);
				$body = str_replace('__ELEMENT_DOMAIN__', SITE_DOMAIN, $body);
				$body = str_replace('__ELEMENT_BASE_URL__', SITE_PROTOCOL.'://'.SITE_DOMAIN_FULL, $body);
				$body = str_replace('__ELEMENT_SUB_DOMAIN__', SITE_SUB_DOMAIN, $body);
				$body = str_replace('__ELEMENT_SITE_NAME__', SITE_NAME, $body);
				$body = str_replace('__ELEMENT_SITE_CORP_SHORT_NAME__', SITE_CORP_SHORT_NAME, $body);
				$body = str_replace('__ELEMENT_SITE_SHORT_NAME__', SITE_SHORT_NAME, $body);
				$body = str_replace('__ELEMENT_LANGAGE__', $lang, $body);

				// 全部OKだったらメール送信
				$this -> sendMail($address, $title, $body, $from);
			}
		}

		return;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信を行う（テンプレートを読み込むラッパーWL対応）
	* @parameter	: 対象口座番号、テンプレート名、パラメータ、送信先メールアドレス、送信元メールアドレス
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendMailByTmpAndWL($account
								, $tmpName
								, $params
								, $address	= NO_STRING
								, $from		= NO_STRING
								, $lang 	= 'ja') {

		// 変数宣言部
		$path		= MAIL_TEMPLATES;
		$accountRow	= null;
		$wlId		= NO_STRING;
		$xml		= null;
		$title		= NO_STRING;
		$body		= NO_STRING;
		$cnt		= VAL_INT_1;
		$key		= NO_STRING;
		$domain		= NO_STRING;

		// 所属WLの取得
		$accountRow	= $this -> getRowData($this -> getAccountCommon($account));
		$wlId		= $this -> getColumnData($accountRow, COLUMN_WL_ID);

		$path .= $wlId . DELIMIT_SLASH . $tmpName;

		// メールの取得
		if($address == NO_STRING) {
			$address = $this -> getColumnData($accountRow, COLUMN_MAIL);
		}

		// XMLファイルの存在確認
		if(file_exists($path)) {

			// xmlファイルロード
			if(($xml = simplexml_load_file($path))) {

				// 件名を取得する
				$key = PARAM_TITLE;
				if(NO_STRING == ($title = $xml -> $key)) {
					return ;
				}

				// 件名を取得する
				$key = PARAM_BODY;
				if(NO_STRING == ($body = $xml -> $key)) {
					return ;
				}

				// トリムをする（件名）
				$title	= str_replace("\t", NO_STRING, $title);
				$title	= str_replace("\r", NO_STRING, $title);
				$title	= str_replace("\0", NO_STRING, $title);
				$title	= str_replace("\x0B", NO_STRING, $title);

				// トリムをする（本文）
				$body = str_replace("\t", NO_STRING, $body);
				$body = str_replace("\r", NO_STRING, $body);
				$body = str_replace("\0", NO_STRING, $body);
				$body = str_replace("\x0B", NO_STRING, $body);

				// パラメータを設定する
				foreach($params as $value) {
					$title	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $title);
					$body	= str_replace("__ELEMENT" . sprintf("%02d", $cnt) . "__" , $value, $body);
					$cnt++;
				}

				// ドメインの取得
				$domain = $this -> getDomainCommon($wlId);

				// 固定パラメータの変更
				$body = str_replace('__ELEMENT_DOMAIN__', $domain , $body);
				$body = str_replace('__ELEMENT_BASE_URL__', SITE_PROTOCOL.'://'.SITE_DOMAIN_FULL, $body);
				$body = str_replace('__ELEMENT_SUB_DOMAIN__', SITE_SUB_DOMAIN, $body);
				$body = str_replace('__ELEMENT_LANGAGE__', $lang, $body);


				// 全部OKだったらメール送信
				if($wlId == NO_COUNT) {	// IWLの場合は、そのまま送信
					$this -> sendMail($address, $title, $body, $from . $domain);

				} else { 				// WLの場合はAPIが代行

					// 送信データの生成
					$post = array('address'		=> $address
									, 'title'	=> $title
									, 'body'	=> $body
									, 'from'	=> $from . $domain
					);

					$post = http_build_query($post,'', '&');

					// ポスト送信
// 					header("Content-type: application/xml");
					$url = 'https://secure.' . $domain . '/api/SendMail.php';

// 					$ch = curl_init();
// 					curl_setopt($ch, CURLOPT_URL, $url);
// 					curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
// 					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// 					curl_setopt($ch, CURLOPT_TIMEOUT, 30);
// 					curl_setopt($ch, CURLOPT_POST, true);
// 					curl_setopt($ch, CURLOPT_POSTFIELDS, $post);

// 					// API実行
// 					$result = curl_exec($ch);
// 					curl_close($ch);

					$header = array(
							"Content-Type: application/x-www-form-urlencoded",
							"Content-Length: ".strlen($post)
					);

					$context = array(
							'http' => array(
									'method'		=> 'POST'
									,  'header'  	=> implode("\r\n", $header)
									, 	'content'	=> $post
							)
					);

					$result = file_get_contents($url, false, stream_context_create($context));
				}
			}
		}

		return;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料登録
	* @parameter	: 口座番号、通貨、金額
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registFeeCommon($account
							, $currency
							, $amount
							, $msg = NO_STRING
							, $status = NO_STRING) {


		if($amount > NO_COUNT) {
			// データを登録する
			$this -> registWithdrawCommon($account
											, $currency
											, $amount
											, VAR_WITHDRAW_TYPE_FEE
											, $msg
											, $status);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料登録
	* @parameter	: 口座番号、通貨、金額
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registExchangeCommon($account
									, $fromCurrency
									, $fromAmount
									, $toCurrency
									, $toAmount) {

		// データを登録する（引き落とし）
		$this -> registWithdrawCommon($account
										, $fromCurrency
										, $fromAmount
										, VAR_WITHDRAW_TYPE_EXCHANGE);

		// データを登録する（入金）
		$this -> registDepositCommon($account
										, $toCurrency
										, $toAmount
										, VAR_DEPOSIT_TYPE_EXCHANGE);

	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金登録
	* @parameter	: 口座番号、通貨、金額、タイプ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registWithdrawCommon($account
									, $currency
									, $amount
									, $type
									, $msg = NO_STRING
									, $status = NO_STRING) {

		// 変数宣言部
		$params = array();
		$feeInt = NO_COUNT;

		$feeInt = $this -> currencyToInt($amount, $currency);

		// パラメータの作成
		$params[] = $account;
		$params[] = $currency;
		$params[] = $feeInt;
		$params[] = $type;
		$params[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_MONTHLY_FEE);
		$params[] = $msg;
		$params[] = $status;

		// データを登録する
		$this -> accessModify('INSERT_WITHDRAW_FEE', $params);

	}


	/*-------------------------------------------------------------------------
	* @function_name: 出金登録
	* @parameter	: 口座番号、通貨、金額、タイプ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registDomantCommon($account
									, $currency
									, $amount
									, $type
									, $msg = NO_STRING
									, $status = NO_STRING) {

		// 変数宣言部
		$params = array();
		$feeInt = NO_COUNT;

		$feeInt = $this -> currencyToInt($amount, $currency);

		// パラメータの作成
		$params[] = $account;
		$params[] = $currency;
		$params[] = $feeInt;
		$params[] = $type;
		$params[] = $this -> getTransactionNumberCommon($type);
		$params[] = $msg;
		$params[] = $status;

		// データを登録する
		$this -> accessModify('INSERT_WITHDRAW_FEE', $params);

	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金登録
	* @parameter	: 口座番号、通貨、金額、タイプ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registDepositCommon($account
									, $currency
									, $amount
									, $type) {

		// 変数宣言部
		$params = array();
		$feeInt = NO_COUNT;

		$feeInt = $this -> currencyToInt($amount, $currency);

		// パラメータの作成
		$params[] = $account;
		$params[] = $currency;
		$params[] = $feeInt;
		$params[] = $type;

		// データを登録する
		$this -> accessModify('INSERT_DEPOSIT_EXCHANGE', $params);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザの名前を取得する
	* @parameter	: 口座番号
	* @return		: 姓名
	-------------------------------------------------------------------------*/
	function getNameCommon($account) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs		= null;
		$row	= null;

		// ユーザデータ取得
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		return $this -> getColumnData($row, COLUMN_LAST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログイン失敗リストの更新
	* @parameter	: ユーザ名、回数
	* @return		: なし
	-------------------------------------------------------------------------*/
	function insertFailCounter($uName, $counter) {
		$this -> accessModifyCommon('UPDATE_LOGIN_FAIL_COUNT', array($uName, $counter));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログイン失敗リストの加算
	* @parameter	: ユーザ名
	* @return		: なし
	-------------------------------------------------------------------------*/
	function incrementFailCounter($uName) {

		// 変数宣言部
		$rs			= null;
		$row		= null;
		$counter	= NO_COUNT;

		$rs = $this -> accessSelect('SELECT_LOGIN_BY_USER_NAME', array($uName));

		// データの存在確認
		if($this -> isLoopData($rs)) {

			$row		= $this -> getRowData($rs);
			$counter	= intval($this -> getColumnData($row, COLUMN_FAIL_COUNT));

			// 10回以上でロックリストへ追加する
			if($counter >= VAL_INT_9) {

				// 失敗リストに登録
				$this -> accessModify('INSERT_LOGIN_FAIL', array($uName));

				// 失敗回数の更新（初期設定）
				$this -> insertFailCounter($uName, NO_COUNT);

			} else {

				$counter++;

				// 失敗回数の更新（インクリメント）
				$this -> insertFailCounter($uName, $counter);
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログイン失敗リストのクリア
	* @parameter	: ユーザ名
	* @return		: なし
	-------------------------------------------------------------------------*/
	function clearFailCounter($uName) {

		// ログイン失敗リストの削除
		$this -> accessModify('DELETE_LOGIN_FAIL', array($uName));

		// ログイン失敗カウンタのリセット
		$this -> insertFailCounter($uName, NO_COUNT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ氏名の取得
	* @parameter	: 口座番号
	* @return		: 名 姓
	-------------------------------------------------------------------------*/
	function getUserNameCommon($account) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs		= null;
		$row	= null;

		// ユーザデータを取得する
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		$rtn	= $this -> getColumnData($row, COLUMN_LAST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ連絡用EMAILの取得
	* @parameter	: 口座番号
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function getUserEMailCommon($account) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs		= null;
		$row	= null;

		// ユーザデータを取得する
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		$rtn	= $this -> getColumnData($row, COLUMN_MAIL);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 現在時刻の取得
	* @parameter	: なし
	* @return		: 現在時刻文字列（yyyy/mm/dd hh:mm:ss）
	-------------------------------------------------------------------------*/
	function getCurrentTimeCommon() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs		= null;
		$row	= null;

		$rs		= $this -> accessSelect('SELECT_CURRENT_TIME', array());
		$row	= $this -> getRowData($rs);

		$rtn	= $this -> getColumnData($row, COLUMN_CURRENT_TIME);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座開設メールの送信
	* @parameter	: 口座番号
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendRegistMailCommon($account) {

		// 変数宣言部
		$user	= null;
		$row	= null;
		$params	= array();

		// ユーザデータの取得
		$user = $this -> getAccountCommon($account);

		$row = $this -> getRowData($user);

		$params[] 	= $account;																// 口座番号
		$params[] 	= $this -> getColumnData($row, COLUMN_LAST_NAME)
						. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME);	// 姓+名
		$params[] 	= $this -> getColumnData($row, COLUMN_UID);								// UID

		// メールの送信
		$this -> sendMailByTmp('regist_mail.xml'
								, $params
								, $this -> getColumnData($row, COLUMN_MAIL)
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座開設メールの送信
	* @parameter	: 口座番号
	* @return		: なし
	-------------------------------------------------------------------------*/
	function sendChangePasswordCommon($account, $fName = NO_STRING) {

		// 変数宣言部
		$user		= null;
		$row		= null;
		$params		= array();
		$fileName	= NO_STRING;

		// ユーザデータの取得
		$user = $this -> getAccountCommon($account);

		$row = $this -> getRowData($user);

		$params[] 	= $account;																// 口座番号
		$params[] 	= $this -> getColumnData($row, COLUMN_FIRST_NAME)
						. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);	// 姓+名

		if($fName != NO_STRING) {
			$fileName = $fName;
		} else {
			$fileName = 'change_password_complete.xml';
		}

		// メールの送信
		$this -> sendMailByTmp($fileName
								, $params
								, $this -> getColumnData($row, COLUMN_MAIL)
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金処理のバッチ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function changeDepositType() {

		// 変数宣言部
		$rs			= null;
		$user		= null;
		$userRow	= null;
		$params		= array();
		$currency	= NO_STRING;
		$amount		= NO_STRING;
		$fee		= NO_STRING;

		// 該当データの取得
		$rs = $this -> accessSelect('SELECT_DEPOSIT_PENDING', array());

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {

				// ユーザデータの取得
				$user = $this -> getAccountCommon($this -> getColumnData($row, COLUMN_USER_ACCOUNT));

				if($this -> isLoopData($user)) {

					$userRow = $this -> getRowData($user);

					// 各種データ
					$currency	= $this -> getColumnData($row, COLUMN_CURRENCY);
					$amount		= $this -> getColumnData($row, COLUMN_AMOUNT);
					$fee		= $this -> getColumnData($row, COLUMN_FEE);

					// データを登録する
					$this -> accessModifyCommon('UPDATE_DEPOSIT_TYPE', array($this -> getColumnData($row, COLUMN_D_ID), NO_COUNT));

					// メール送信用のパラメータを設定
					$params		= array();
					$params[]	= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
					$params[]	= $this -> getColumnData($userRow, COLUMN_FIRST_NAME)
									. DELIMIT_SPACE . $this -> getColumnData($userRow, COLUMN_LAST_NAME);
					$params[]	= $currency;
					$params[]	= $this -> getAmountString(($amount - $fee), $currency);
					$params[]	= $this -> getColumnData($row, COLUMN_CURRENT_TIME);
					$params[]	= $this -> getColumnData($row, COLUMN_MESSAGE);

					// メールを送信
					$this -> sendMailByTmpAndWL($this -> getColumnData($row, COLUMN_USER_ACCOUNT)
												, 'deposit_complete.xml'
												, $params
												, $this -> getColumnData($userRow, COLUMN_MAIL)
												, 'bs@');
				}
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワード変更申請データの取得
	* @parameter	: なし
	* @return		: 結果セット
	-------------------------------------------------------------------------*/
	function getApplyPassword($id) {
		return $this -> accessSelect('SELECT_APPLY_PASSWORD', array($id));
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコード一覧の取得
	* @parameter	: なし
	* @return		: エージェントコード一覧
	-------------------------------------------------------------------------*/
	function getAgentCodeListCommon($agentCode = NO_STRING) {

		// 変数宣言部
		$rtn	= array();
		$rs		= null;

		if($agentCode == NO_STRING) {
			$agentCode = VAL_INT_1;
		}

		// 国マスタデータを取得する
		$rs = $this -> accessSelect('LIST_AGENT_CODE', array($agentCode));

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_AGENT_CODE)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_AGENT_CODE)
														. '(' . $this -> getColumnData($row, COLUMN_AGENT_CODE)
														. DELIMIT_COLON . $this -> getColumnData($row, COLUMN_MAIL) . ')');
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRM IDを取得する
	* @parameter	: 登録情報配列
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function getCRMIDCommon($account) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs		= null;
		$row	= null;

		// データを取得する
		$rs		= $this -> getAccountCommon($account);
		$row	= $this -> getRowData($rs);

		$rtn = $this -> getColumnData($row, COLUMN_CRM_ID);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRMの新規登録
	* @parameter	: 登録情報配列
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function crmInsertRecords($params) {

		// 変数宣言部
		$rtn			= NO_STRING;
		$xml			= NO_STRING;
		$accountType	= NO_STRING;
		try {

			// 口座種別の取得
			$accountType = $params[VAL_INT_2];

			//XMLデータの生成（共通項目）
			$xml =	'<Accounts>'
						. '<row no="1">'
							. '<FL val="Account Name">IWL' . $params[VAL_INT_3] . '</FL>'
							. '<FL val="Account Type">' . $this -> dispUserAccountTypeCommon($accountType) . '</FL>'
							. '<FL val="Email">' . $params[VAL_INT_1] . '</FL>'
							. '<FL val="Birth Date">' . $params[VAL_INT_7] . '-' . sprintf("%02d", $params[VAL_INT_8]) . '-' . sprintf("%02d", $params[VAL_INT_9]) . '</FL>'
							. '<FL val="Billing Country">' . $this -> dispCountryCommon($params[VAL_INT_10]) . '</FL>';

			if($accountType == VAR_PERSON) {		// 個人口座の場合項目を追加
				$xml .=	 '<FL val="Last name (English)">' . $params[VAL_INT_5] . '</FL>'
						. '<FL val="First name (English)">' . $params[VAL_INT_6] . '</FL>';

			} else if($accountType == VAR_CORP) {	// 法人口座の場合項目を追加
				$xml .=	'<FL val="Last name (English)">' . $params[VAL_INT_23] . '</FL>'
						. '<FL val="First name (English)">' . $params[VAL_INT_22] . '</FL>'
						. '<FL val="Client Site">' . $params[VAL_INT_24] . '</FL>'
						. '<FL val="Site Name">' . $params[VAL_INT_25] . '</FL>'
						. '<FL val="Phone">' . $params[VAL_INT_4] . '</FL>'
						. '<FL val="Billing State">' . $params[VAL_INT_11] . '</FL>'
						. '<FL val="Billing City">' . $params[VAL_INT_12] . '</FL>'
						. '<FL val="Billing Street">' . $params[VAL_INT_14] . '</FL>'
						. '<FL val="Billing Code">' . $params[VAL_INT_13] . '</FL>'
						. '<FL val="Company Name">' . $params[VAL_INT_6] . '</FL>';
			}

			$xml .=	'</row>'
					. '</Accounts>';

			// 送信データの生成
			$post = array('xmlData'			=> $xml
							, 'authtoken'	=> '83b543e09a5dffa2cfce699b3f31dee7'
							, 'scope'		=> 'crmapi'
			);

			http_build_query($post);

			// ポスト送信
			header("Content-type: application/xml");
			$url = "https://crm.zoho.com/crm/private/xml/Accounts/insertRecords";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
			$result = curl_exec($ch);
			curl_close($ch);

			// データの取り出し
			header("Content-type: text/html;charset=UTF-8");
			$res = simplexml_load_string($result);

			foreach($res -> result -> recorddetail -> FL as $val) {
				if($val -> attributes()-> val == 'Id') {
					$rtn = $val;
				}
			}

		} catch(Exception $e) {
			return $rtn;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRMの新規登録（CSV登録用）
	* @parameter	: 登録情報配列
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function crmInsertRecordsRegistCSV($params) {

		// 変数宣言部
		$rtn			= NO_STRING;
		$xml			= NO_STRING;
		$accountType	= NO_STRING;
		try {

			// 口座種別の取得
			$accountType = $params[VAL_INT_2];

			//XMLデータの生成（共通項目）
			$xml =	'<Accounts>'
					. '<row no="1">'
					. '<FL val="Account Name">IWL' . $params[VAL_INT_3] . '</FL>'
					. '<FL val="Account Type">' . $this -> dispUserAccountTypeCommon($accountType) . '</FL>'
					. '<FL val="Email">' . $params[VAL_INT_1] . '</FL>'
					. '<FL val="Birth Date">' . $params[VAL_INT_7] . '-' . sprintf("%02d", $params[VAL_INT_8]) . '-' . sprintf("%02d", $params[VAL_INT_9]) . '</FL>'
					. '<FL val="Billing Country">' . $this -> dispCountryCommon($params[VAL_INT_10]) . '</FL>'
					. '<FL val="Last name (English)">' . $params[VAL_INT_5] . '</FL>'
					. '<FL val="First name (English)">' . $params[VAL_INT_6] . '</FL>'
					. '<FL val="Billing State">' . $params[VAL_INT_11] . '</FL>'
					. '<FL val="Billing City">' . $params[VAL_INT_12] . '</FL>'
					. '<FL val="Billing Street">' . $params[VAL_INT_14] . '</FL>'
					. '<FL val="Billing Code">' . $params[VAL_INT_13] . '</FL>'
					. '<FL val="Phone">' . $params[VAL_INT_4] . '</FL>'
					. '</row>'
					. '</Accounts>';

			// 送信データの生成
			$post = array('xmlData'			=> $xml
					, 'authtoken'	=> '83b543e09a5dffa2cfce699b3f31dee7'
					, 'scope'		=> 'crmapi'
			);

			http_build_query($post);

			// ポスト送信
			header("Content-type: application/xml");
			$url = "https://crm.zoho.com/crm/private/xml/Accounts/insertRecords";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
			$result = curl_exec($ch);
			curl_close($ch);

			// データの取り出し
			header("Content-type: text/html;charset=UTF-8");
			$res = simplexml_load_string($result);

			foreach($res -> result -> recorddetail -> FL as $val) {
				if($val -> attributes()-> val == 'Id') {
					$rtn = $val;
				}
			}

		} catch(Exception $e) {
			return $rtn;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRMの新規登録
	* @parameter	: 登録情報配列
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function crmUpdateRecords($params) {

		// 変数宣言部
		$rtn			= NO_STRING;
		$xml			= NO_STRING;
		$accountType	= NO_STRING;

		try {

			// CRM IDがなかったら終わり
			if(!isset($params[NO_COUNT])
				|| $params[NO_COUNT] ==  NO_STRING) {
				return;
			}

			// 口座種別の取得
			$accountType = $params[VAL_INT_2];

			//XMLデータの生成（共通項目）
			$xml =	' <Accounts>'
					. '<row no="1">'
					. '<FL val="Billing Country">' . $this -> dispCountryCommon($params[VAL_INT_1]) . '</FL>'
					. '<FL val="Billing State">' . $params[VAL_INT_2] . '</FL>'
					. '<FL val="Billing City">' . $params[VAL_INT_3] . '</FL>'
					. '<FL val="Billing Street">' . $params[VAL_INT_4] . '</FL>'
					. '<FL val="Billing Code">' . $params[VAL_INT_5] . '</FL>'
					. '<FL val="Phone">' . $params[VAL_INT_6] . '</FL>';

			$xml .=	'</row>'
					. '</Accounts>';

			// 送信データの生成
			$post = array('authtoken'	=> '83b543e09a5dffa2cfce699b3f31dee7'
							, 'scope'		=> 'crmapi'
							, 'id'			=> $params[NO_COUNT]
							, 'xmlData'		=> $xml
			);

			http_build_query($post);

			// ポスト送信
			header("Content-type: application/xml");
			$url = "https://crm.zoho.com/crm/private/xml/Accounts/updateRecords";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
			$result = curl_exec($ch);
			curl_close($ch);

			// データの取り出し
			header("Content-type: text/html;charset=UTF-8");

		} catch(Exception $e) {
			return $rtn;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRMの新規登録
	* @parameter	: 登録情報配列
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function fromEmailToUID($email) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs		= null;
		$row	= null;

		$rs		= $this -> accessSelect('SELECT_ACCOUNT_BY_EMAIL_OR_ACCOUNT', array($email));
		$row	= $this -> getRowData($rs);

		$rtn = $this -> getColumnData($row, COLUMN_UID);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の逆引き
	* @parameter	: 国
	* @return		: 国コード
	-------------------------------------------------------------------------*/
	function getCountryCodeFromCountryName($country) {

		// 変数宣言部
		$rtn		= NO_STRING;
		$countries	= $this -> getCountyList();

		if($this -> isLoopData($countries)){

			foreach($countries as $row) {

				if(strtoupper($this -> getColumnData($row, PARAM_DATA_VALUE)) == strtoupper($country)) {
					$rtn = $this -> getColumnData($row, PARAM_DATA_KEY);
					break;
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: 取引種別
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	function getTransactionNumberCommon($type = NO_STRING) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$kind	= NO_STRING;

		switch($type) {
			case VAR_TRANSACTION_DEPOSIT:			// 入金
				$kind = 'D';
				break;
			case VAR_TRANSACTION_WITHDRAW:			// 出金
				$kind = 'W';
				break;
			case VAR_TRANSACTION_EXCHANGE:			// 通貨両替
				$kind = 'E';
				break;
			case VAR_TRANSACTION_TRANSFER_DEPOSIT:	// 口座間送金
				$kind = 'T';
				break;
			case VAR_TRANSACTION_TRANSFER_WITHDRAW:	// 口座間送金
				$kind = 'T';
				break;
			case VAR_TRANSACTION_REQUEST_WITHDRAW:	// 引き落とし
				$kind = 'R';
				break;
			case VAR_TRANSACTION_REQUEST_DEPOSIT:	// 引き落とし
				$kind = 'R';
				break;
			case VAR_TRANSACTION_MONTHLY_FEE:		// 月額維持費
				$kind = 'M';
				break;
			case VAR_TRANSACTION_DOMANT_FEE:		// 自动休止
				$kind = 'F';
				break;
			default:
				$kind = 'Z';
				break;
		}

		$rtn = $kind . $this -> getSequenceNo(SQ_KEY_TRANSACTION);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェント取得コミッションの取得
	* @parameter	: エージェントコード、トランザクションタイプ、口座種別
	* @return		: なし
	-------------------------------------------------------------------------*/
	function getCommisionFee($agentCode
							, $type
							, $walletType) {

		// 変数宣言部
		$commision		= null;

		$commision		= $this -> accessSelect('SELECT_AGENT_COMMISION', array($agentCode
																				, $type
																				, $walletType));

		return $this -> getRowData($commision);

	}

	/*-------------------------------------------------------------------------
	 * @function_name: エージェント取得コミッションの取得
	* @parameter	: エージェントコード、トランザクションタイプ、口座種別
	* @return		: なし
	-------------------------------------------------------------------------*/
	function getCommisionExchangeFee($agentCode
									, $fromCurrency
									, $toCurrency) {

		// 変数宣言部
		$commision		= null;

		$commision		= $this -> accessSelect('SELECT_COMMISION_EXCHANGE', array($agentCode
																					, $fromCurrency
																					, $toCurrency));

		return $this -> getRowData($commision);
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコミッションの登録（為替両替用）
	* @parameter	: 取引種別、エージェントコード、口座番号、通貨、手数料
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registCommisionExchange($account
									, $fromCurrency	= USD
									, $toCurrency	= USD
									, $amount) {

		// 変数宣言部
		$accountRow		= null;
		$agent			= null;
		$agentRow		= null;
		$commision		= null;
		$commisionRow	= null;
		$params			= null;
		$walletType		= NO_STRING;
		$percent		= NO_STRING;
		$fix			= NO_STRING;

		// エージェントコードの取得
		$agentCode	= $this -> getColumnData($this -> getRowData($this -> getAccountCommon($account)), COLUMN_PARENT_AGENT_CODE);

		if($agentCode == NO_STRING) {
			return;
		}

		if($amount		== NO_STRING
			|| $amount	== NO_COUNT) {
			return;
		}

		// 手数料をint化
		$fee = $this -> currencyToInt($amount, $toCurrency);

		while(true) {

			// エージェントデータの取得
			$agent = $this -> getRowData($this -> getAccountByAgentCodeCommon($agentCode));

			// コミッション取得データ
			$commision		= $this -> getCommisionExchangeFee($agentCode
																, $fromCurrency
																, $toCurrency);

			// パーセンテージの取得
			$percent = $this -> getColumnData($commision, COLUMN_PERCENT);
			$percent = $this -> intToCurrency($percent, PERCENT);
			$percent = $percent / VAL_INT_100;

			// パーセンテージが0の場合は登録しない
			if(floor($amount * $percent) > NO_COUNT) {

				// パラメータの設定
				$params		= array();
				$params[]	= $agentCode;
				$params[]	= VAR_EXCHANGE;
				$params[]	= NO_COUNT;
				$params[]	= $toCurrency;
				$params[]	= floor($amount * $percent);
				$params[]	= NO_COUNT;

				// データを登録
				$this -> accessModifyCommon('INSERT_AGENT_COMMISION_FEE', $params);
			}

			// 親がいなければ終わり
			if($this -> getColumnData($agent, COLUMN_PARENT_AGENT_CODE) == NO_STRING) {
				break;
			} else {
				$agentCode = $this -> getColumnData($agent, COLUMN_PARENT_AGENT_CODE);
			}
		}

		return;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコミッションの登録
	* @parameter	: 取引種別、エージェントコード、口座番号、通貨、手数料
	* @return		: なし
	-------------------------------------------------------------------------*/
	function registCommision($type
							, $agentCode
							, $account
							, $currency = USD
							, $fee
							, $fromTo	= PARAM_FROM) {

		// 変数宣言部
		$accountRow		= null;
		$agent			= null;
		$agentRow		= null;
		$commision		= null;
		$commisionRow	= null;
		$params			= null;
		$walletType		= NO_STRING;
		$percent		= NO_STRING;
		$fix			= NO_STRING;

		// エージェントコードがnullの場合データを取り直す
		if($agentCode === null) {
			$accountRow = $this -> getRowData($this -> getAccountCommon($account));

			$agentCode = $this -> getColumnData($accountRow, COLUMN_PARENT_AGENT_CODE);
		}

		if($agentCode == NO_STRING) {
			return;
		}

		if($fee		== NO_STRING
			|| $fee	== NO_COUNT) {
			return;
		}

		// 手数料をint化
		$fee = $this -> currencyToInt($fee, $currency);

		// ウォレットタイプの取得
		$rs			= $this -> getAccountCommon($account);
		$row		= $this -> getRowData($rs);

		$wType = $this -> getColumnData($row, COLUMN_ACCOUNT_TYPE);

		// 取引種別によって口座タイプを取得
		if($type == VAR_TRANSFER) {					// 口座振替の場合

			if($fromTo				== PARAM_FROM
				&& $wType			== NO_COUNT) {	// 送金元が個人
				$walletType	= VAL_INT_3;
			} else if($fromTo		== PARAM_FROM
						&& $wType	== VAL_INT_1) {	// 送金元が法人
				$walletType	= VAL_INT_5;
			} else if($fromTo		== PARAM_TO
						&& $wType	== NO_COUNT) {	// 送金先が個人
				$walletType	= VAL_INT_4;
			} else if($fromTo		== PARAM_TO
						&& $wType	== VAL_INT_1) {	// 送金先が法人
				$walletType	= VAL_INT_6;
			}
		} else {									// 口座振替以外の場合
			$walletType	= $wType + VAL_INT_1;
		}

		while(true) {

			// エージェントデータの取得
			$agent			= $this -> getAccountByAgentCodeCommon($agentCode);
			$agentRow		= $this -> getRowData($agent);

			// コミッション取得データ
			$commision		= $this -> getCommisionFee($agentCode
														, $type
														, $walletType);

			// パーセンテージの取得
			$percent = $this -> getColumnData($commision, COLUMN_PERCENT);
			$percent = $this -> intToCurrency($percent, PERCENT);
			$percent = $percent / VAL_INT_100;

			// 固定値の取得
			$fix = $this -> getColumnData($commision, COLUMN_FIX);
			$fix = $this -> getExchangeCommon($fix, USD, $currency);
			$fix = $fix[PARAM_AMOUNT];

			// 0の場合は登録しない
			if($fix							> NO_COUNT
				|| floor($fee * $percent)	> NO_COUNT) {

				// パラメータの設定
				$params		= array();
				$params[]	= $agentCode;
				$params[]	= $type;
				$params[]	= $walletType;
				$params[]	= $currency;
				$params[]	= floor($fee * $percent);
				$params[]	= $fix;

				// データを登録
				$this -> accessModifyCommon('INSERT_AGENT_COMMISION_FEE', $params);
			}

			// 親がいなければ終わり
			if($this -> getColumnData($agentRow, COLUMN_PARENT_AGENT_CODE) == NO_STRING) {
				break;
			} else {
				$agentCode = $this -> getColumnData($agentRow, COLUMN_PARENT_AGENT_CODE);
			}
		}

		return;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 所持カードの取得
	* @parameter	: 口座番号
	* @return		: 所持カード情報
	-------------------------------------------------------------------------*/
	function getCardsCommon($account, $cardId = NO_STRING) {

		if($cardId == NO_STRING) {
			return $this -> accessSelect('LIST_USER_CARDS', array($account));
		} else {
			return $this -> accessSelect('LIST_USER_CARDS_BY_CARD_ID', array($account, $cardId));
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード番号の取得
	* @parameter	: カードホルダーID
	* @return		: カード番号
	-------------------------------------------------------------------------*/
	function getCardNumberCommon($cardHolderId) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$row	= null;

		// データの取得
		$row		= $this -> getRowData($this -> accessSelect('SELECT_CARD_BY_CARD_HOLDER_ID', array($cardHolderId)));
		$cardDigit	= $this -> getColumnData($row, COLUMN_CARD_NUMBER);
		$len 		= strlen($cardDigit);

		if($len > VAL_INT_4) {
			$cardDigit = substr($cardDigit, ($len - VAL_INT_4));
		}

		$rtn	= $cardDigit;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: カード情報の取得
	 * @parameter	: カードホルダーID
	 * @return		: カード情報
	 -------------------------------------------------------------------------*/
	function getCardCommon($cardHolderId) {
		return $this -> getRowData($this -> accessSelect('SELECT_USER_CARDS', array($cardHolderId)));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: VPC-refId情報の取得
	 * @parameter	: VPC-refIdホルダーID
	 * @return		: VPC-refId情報
	 -------------------------------------------------------------------------*/
	function getRefId($account) {
		return $this -> getRowData($this -> accessSelect('SELECT_VPC_REFID', array($account)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: POST値のログを登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function logPost($programCode = NO_STRING) {

		// 変数宣言部
		$params		= array();
		$post		= NO_STRING;
		$ip			= NO_STRING;
		$referer	= NO_STRING;

		// 取得データの生成
		if(isset($_SERVER['REMOTE_ADDR'])) {
			$ip = $_SERVER['REMOTE_ADDR'];
		}

		if(isset($_SERVER['HTTP_REFERER'])) {
			$referer = $_SERVER['HTTP_REFERER'];
		}

		$post		= http_build_query($_POST, '', '&');

		// 登録用パラメータ
		$params[] = $ip;
		$params[] = $programCode;
		$params[] = $referer;
		$params[] = $post;

		$this -> accessModifyCommon('INSERT_LOG_POST', $params);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨手数料データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function getExchangeFeeCommon($pId = NO_COUNT) {

		// 変数宣言部
		$rtn	= array();
		$fees	= null;
		$from	= NO_STRING;
		$to		= NO_STRING;

		$fees = $this -> accessSelect('LIST_MST_EXCHANGE_FEE', array($pId));

		// データの詰め替え
		foreach($fees as $row) {

			$from	= $this -> getColumnData($row, COLUMN_FROM_CURRENCY);
			$to		= $this -> getColumnData($row, COLUMN_TO_CURRENCY);

			// 手数料データを設定する
			$rtn[$from][$to] = array(COLUMN_WHOLE	=> $this -> getColumnData($row, COLUMN_WHOLE)
									, COLUMN_MARKUP	=> $this -> getColumnData($row, COLUMN_MARKUP));
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 各サイトドメインを取得する
	* @parameter	: WL ID
	* @return		: ドメイン
	-------------------------------------------------------------------------*/
	function getDomainCommon($wId) {

		// 変数宣言部
		$rtn = NO_STRING;

		switch($wId) {
			case NO_COUNT:
				$rtn = SITE_DOMAIN_0;
				break;
			case VAL_INT_1:
				$rtn = SITE_DOMAIN_1;
				break;
			default:
				$rtn = SITE_DOMAIN_0;
				break;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 所持カードリストの取得
	* @parameter	: 口座番号
	* @return		: 所持カード一覧
	-------------------------------------------------------------------------*/
	function getCardActiveList($account) {
		return $this -> accessSelect('LIST_CARD_APPLY_ACTIVE', array($account));
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信時の表示名
	* @parameter	: メールアドレス
	* @return		: 表示名
	-------------------------------------------------------------------------*/
	function getMailDisplayNameCommon($mail) {

		// 変数宣言部
		$row = null;

		$row = $this -> getRowData($this -> accessSelect('SELECT_MST_MAIL_NAME', array($mail)));

		return $this -> getColumnData($row, COLUMN_NAME);
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信時の表示名
	* @parameter	: メールアドレス
	* @return		: 表示名
	-------------------------------------------------------------------------*/
	function getInvalidDomainList() {

		// 変数宣言部
		$handler	= fopen(SYSTEM_PATH . 'invalid_domain.txt', 'r');
		$lists		= array();

		if($handler) {
			while (!feof($handler)) {

				$buffer = str_replace("\n", NO_STRING, fgets($handler));

				if($buffer != NO_STRING) {
					$lists[$buffer] = $buffer;
				}
			}
		}

		return $lists;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード4桁の取得
	* @parameter	: カードホルダーID
	* @return		: カード4桁
	-------------------------------------------------------------------------*/
	function getCardDigtCommon($chid) {

		// 変数宣言部
		$row = null;

		// データの取得
		$row = $this -> getRowData($this -> accessSelect('SELECT_USER_CARDS', array($chid)));

		return $this -> getColumnData($row, COLUMN_DIGIT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: パワーを配列化
	* @parameter	: パワー文字列
	* @return		: パワー配列
	-------------------------------------------------------------------------*/
	function makeArrayByPowerCommon($pow) {

		// 変数宣言部
		$rtn = array();
		$len = NO_COUNT;
		$cnt = NO_COUNT;

		$len = strlen($pow);

		if($len > NO_COUNT) {

			for($cnt = NO_COUNT; $cnt < $len; $cnt++) {
				$rtn[] = substr($pow, $cnt, VAL_INT_1);
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの回数制限
	* @parameter	: メソッド、口座種別
	* @return		: GPSの回数制限
	-------------------------------------------------------------------------*/
	function getGPSCountLimit($method, $kind = NO_COUNT) {

		// 変数宣言部
		$rtn = NO_COUNT;

		if($kind == VAL_INT_1) {	// VIPの場合

			if($method == PARAM_GPS_VISA) {								// VISAの場合
				$rtn = VAR_GPS_VISA_LIMIT_COUNT_VIP;

			} else if($method == PARAM_GPS_GIFTCARD) {					// MASTERCARDの場合
				$rtn = VAR_GPS_MASTER_LIMIT_COUNT_VIP;

			} else if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金の場合
				$rtn = VAR_GPS_BANK_LIMIT_COUNT_VIP;
			}

		} else {					// その他の場合

			if($method == PARAM_GPS_VISA) {								// VISAの場合
				$rtn = VAR_GPS_VISA_LIMIT_COUNT;

			} else if($method == PARAM_GPS_GIFTCARD) {					// MASTERCARDの場合
				$rtn = VAR_GPS_MASTER_LIMIT_COUNT;

			} else if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金の場合
				$rtn = VAR_GPS_BANK_LIMIT_COUNT;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの金額制限
	* @parameter	: メソッド、口座種別
	* @return		: GPSの金額制限
	-------------------------------------------------------------------------*/
	function getGPSAmountLimit($method, $kind = NO_COUNT) {

		// 変数宣言部
		$rtn = NO_COUNT;

		if($kind == VAL_INT_1) {	// VIPの場合

			if($method == PARAM_GPS_VISA) {								// VISAの場合
				$rtn = VAR_GPS_VISA_LIMIT_AMOUNT_VIP;

			} else if($method == PARAM_GPS_GIFTCARD) {					// MASTERCARDの場合
				$rtn = VAR_GPS_MASTER_LIMIT_AMOUNT_VIP;

			} else if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金の場合
				$rtn = VAR_GPS_BANK_LIMIT_AMOUNT_VIP;
			}

		} else {					// その他の場合

			if($method == PARAM_GPS_VISA) {								// VISAの場合
				$rtn = VAR_GPS_VISA_LIMIT_AMOUNT;

			} else if($method == PARAM_GPS_GIFTCARD) {					// MASTERCARDの場合
				$rtn = VAR_GPS_MASTER_LIMIT_AMOUNT;

			} else if($method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金の場合
				$rtn = VAR_GPS_BANK_LIMIT_AMOUNT;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSデータのPull取得
	* @parameter	: リファレンス番号
	* @return		: GPSデータ
	-------------------------------------------------------------------------*/
	function getGPSResponsePull($referenceNo) {

		// 変数宣言部
		$rtn	= null;
		$url	= GPS_PULL_URL;
		$params	= array();

		// オプションパラメータ
		$params['apiKey']		= GPS_API_KEY;
		$params['referenceNo']	= $referenceNo;

		$curl	= curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $params);
		$result = curl_exec($curl);
		curl_close($curl);

		return json_decode($result, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSデータのPull取得
	* @parameter	: リファレンス番号
	* @return		: GPSデータ
	-------------------------------------------------------------------------*/
	function updateGPSResponse($res) {

		// 変数宣言部
		$sendAmount	= NO_COUNT;
		$params		= null;


		// 銀行送金の場合は、日本円なので
		if($this -> getColumnData($res, 'paymentMethod') == 'INSTANTBANKTRANSFER') {
			$sendAmount = intval($this -> intToCurrency($this -> getColumnData($res, PARAM_AMOUNT), VAR_GPAYSAFE_CARD_CURRENCY));
		} else {
			$sendAmount = intval($this -> getColumnData($res, PARAM_AMOUNT));
		}

		// パラメータを取得する
		$params		= array();
		$params[]	= $this -> getColumnData($res, 'referenceNo');
		$params[]	= $this -> getColumnData($res, 'transactionId');
		$params[]	= $sendAmount;
		$params[]	= $this -> getColumnData($res, 'currency');
		$params[]	= $this -> getColumnData($res, 'status');
		$params[]	= $this -> getColumnData($res, 'message');
		$params[]	= $this -> getColumnData($res, 'paymentMethod');
		$params[]	= $this -> getColumnData($res, 'code');
		$params[]	= $this -> getColumnData($res, 'voucherCode');

		// データを更新する
		$this -> accessModify('UPDATE_RESPONSE_GPAYSAFE', $params, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金ステータスフラグの修正
	 * @parameter	: 口座番号、フラグ群
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function updateDepositStatusCommon($account, $flgs) {

		// 変数宣言部
		$params = array(NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT, NO_COUNT);

		// まずは、データがあるか確認する
		if(is_array($flgs)
			&& count($flgs) > NO_COUNT) {
			foreach($flgs as $key => $val) {
				$params[$key] = intval($val);
			}
		}

		// 口座番号を追加する
		array_unshift($params, $account);

		// パラメータの変更
		$this -> accessModifyCommon('UPDATE_GPS_KIND_OF_PAYMENT', $params);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金ステータスフラグの修正
	 * @parameter	: 口座番号、フラグ群
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getKycCurrentStatusCommon($list) {

		// 変数宣言部
		$rtn			= NO_COUNT;
		$status			= null;
		$counterStatus	= array();

		$status = $this -> getKYCFlgList();

		// ステータスをキー単位で追加
		if($this -> isLoopData($status)) {

			// まずは、リストを取得
			foreach($status as $data) {
				$counterStatus[$data[PARAM_DATA_KEY]] = NO_COUNT;
			}

			// データの存在確認
			if($this -> isLoopData($list)) {

				foreach($list as $row) {
					$counterStatus[$row[PARAM_STATUS]] += VAL_INT_1;
				}

				// 未認証、書類不足、審査中、認証済、否認の順で優先順位付け
				if(isset($counterStatus[NO_COUNT])
					&& $counterStatus[NO_COUNT] > NO_COUNT) {			// 未認証
					$rtn = NO_COUNT;

				} else if(isset($counterStatus[VAL_INT_4])
							&& $counterStatus[VAL_INT_4] > NO_COUNT) {	// 書類不足
					$rtn = VAL_INT_4;

				} else if(isset($counterStatus[VAL_INT_3])
							&& $counterStatus[VAL_INT_3] > NO_COUNT) {	// 審査中
					$rtn = VAL_INT_3;

				} else if(isset($counterStatus[VAL_INT_1])
							&& $counterStatus[VAL_INT_1] > NO_COUNT) {	// 認証済み
					$rtn = VAL_INT_1;

				} else if(isset($counterStatus[VAL_INT_2])
							&& $counterStatus[VAL_INT_2] > NO_COUNT) {	// 否認
					$rtn = VAL_INT_2;
				}
			}

			return $rtn;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 年齢制限を取得する
	* @parameter	: 国コード
	* @return		: 年齢制限
	-------------------------------------------------------------------------*/
	function getLimitAageCommon($country) {

		// 変数宣言部
		$rtn = NO_STRING;

		if($country != null
			&& $country != NO_STRING) {
			$rtn = $this -> getColumnData($this -> getRowData($this -> accessSelect('SELECT_LIMIT_AGE_BY_COUNTRY_CODE', array($country))), COLUMN_LIMIT_AGE);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: KYCのディレクトリを取得する
	 * @parameter	: 口座番号
	 * @return		: ディレクトリパス
	 -------------------------------------------------------------------------*/
	function getKycDirectory($account) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$root	= SYSTEM_DOCUMENT_KYC;

		// まずは、アカウントの桁数のチェック
		if(strlen($account) == VAL_INT_8) {

			// アカウントの下3桁を取得する
			$rtn = $root . substr($account, VAL_INT_5, VAL_INT_3);

			// ディレクトリの存在確認
			if(file_exists($rtn)) {
				$rtn .= DELIMIT_SLASH . $account;
			} else {
				$rtn = $root . $account;
			}

		} else {
			$rtn = $root . $account;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: KYCのディレクトリを取得する
	 * @parameter	: 口座番号
	 * @return		: ディレクトリパス
	 -------------------------------------------------------------------------*/
	function getKycDirectoryWeb($account) {

		// 変数宣言部
		$rtn	= NO_STRING;
		$root	= SYSTEM_DOCUMENT_KYC;

		// まずは、アカウントの桁数のチェック
		if(strlen($account) == VAL_INT_8) {

			// アカウントの下3桁を取得する
			$rtn = $root . substr($account, VAL_INT_5, VAL_INT_3);

			// ディレクトリの存在確認
			if(file_exists($rtn)) {
				$rtn = SYSTEM_DOCUMENTS_KYC_WEB_PATH . substr($account, VAL_INT_5, VAL_INT_3) . DELIMIT_SLASH . $account;
			} else {
				$rtn = SYSTEM_DOCUMENTS_KYC_WEB_PATH . $account;
			}

		} else {
			$rtn = SYSTEM_DOCUMENTS_KYC_WEB_PATH . $account;
		}

		return $rtn;
	}

	//curl访问
	function curl(){

		$this->gateway;
		$this->arrSysRegister;
		$str = '';
		$str = '<form action="'.$this->gateway.'" method="POST" name="CUPForm">';
		foreach($this -> arrSysRegister as $key=>$val){
			$str .= '<input type="hidden" name="'.$key.'" value="'.$val.'">';
		}
		$str .= '</form>';

		return $str;
 }
    /*-------------------------------------------------------------------------
     * @function_name: DES加密
     * @parameter    :
     * @return       :
    -------------------------------------------------------------------------*/
    public function getEncryption($key, $iv, $value)
    {
        $key = base64_decode($key);
        $iv  = base64_decode($iv);
        return openssl_encrypt($value, 'des-cbc', $key, 0, $iv);
    }
    /*-------------------------------------------------------------------------
     * @function_name: DES解密
     * @parameter    :
     * @return       :
    -------------------------------------------------------------------------*/
    public function getDecryption($key, $iv, $value)
    {
        $iv  = base64_decode($iv);
        $key = base64_decode($key);
        return openssl_decrypt($value, 'des-cbc', $key, 0, $iv);
    }

    /*-------------------------------------------------------------------------
     * @function_name: 替换数据
     * @parameter    :
     * @return       :
    -------------------------------------------------------------------------*/
    public function setApiElementParam($dataString, $elementArr)
    {

        // 変数宣言部
        $elementCnt = 1; // 項目数のカウンタ

        try {

            // データ配列じゃない時は無視
            if (is_array($elementArr)) {

                // パラメータを設定する
                foreach ($elementArr as $value) {

                    $value = str_replace("'", "\'", $value);
                    $value = str_replace("(\')", "'", $value);

                    $dataString = str_replace("__MEGELM" . sprintf("%02d", $elementCnt) . "__", $value, $dataString);
                    $elementCnt++;
                }
            }
        } catch (Exception $e) {
            die($e->getMessage());
        }

        // パラメータ変換後のSQLを返却する
        return $dataString;
    }

    /*-------------------------------------------------------------------------
     * @function_name: 二次认证code方法
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/

	public function get2FaValue($rtn){
		// if ($this -> get2faaccountemable($rtn[0])) {
		// 	return True;
		// }
		$inspect = $this -> accessSelect('SELECT_2FA_24_INSPECT', $rtn);
		if (count($inspect) != NO_COUNT) {
			//判断是否重置
			if ($this -> getColumnData($inspect[0], $rtn[1]) == '3') {
				//status重置
				$this -> accessModify('UPDATE_2FA_ZERO_STATUS',array($rtn[1],$rtn[0]),false);
			}
			return True;
		} else {
			return False;
		}
	}

    /*-------------------------------------------------------------------------
     * @function_name: 2fa限定账户
     * @parameter    :
     * @return       :
    -------------------------------------------------------------------------*/
    public function get2faaccountemable($rtn){

    	$list = array(
    		'94101762'
    		,'84644371'
    		,'14419234'
    		,'60592169'
    		,'72683657'
    		,'27142966'
    		,'79681537'
				,'17783150'
				,'68172194'
				,'27225234'
				,'88769570');
    	//	启用账户限定
    	return !in_array($rtn,$list) || false;

    	//	关闭账户限定功能
    	// return !in_array($rtn,$list) && false;
    }

    /*-------------------------------------------------------------------------
     * @function_name: purifyInput
     * "@description: prifies data. removes extra whitespaces before and after and converts html tags into entities
     * @parameter    : $data
     * @return       : purified data
    -------------------------------------------------------------------------*/
    public function purifyInput($data){
        return htmlentities(trim($data), ENT_QUOTES);
    }

	function getUserMail($useraccount){
		//$user_mail = $this ->  accessSelect('SELECT_2FA_MAIL_VIA_USERID', array($useraccount));
		$row		= $this -> getRowData($this -> accessSelect('SELECT_2FA_MAIL_VIA_USERID', $useraccount));
		$userMail = $this -> getColumnData($row, 'mail');

		return $userMail;
	}

    /*-------------------------------------------------------------------------
    * @function_name: registInactiveFeeCommon
    * @parameter	: $account, $currency, $amount, $type, $msg, $status
    * @return		: $transactionNumber
    -------------------------------------------------------------------------*/
    function registInactiveFeeCommon($account
                                    , $currency
                                    , $amount
                                    , $type
                                    , $msg = NO_STRING
                                    , $status = NO_STRING) {

        // 変数宣言部
        $params = array();
        $feeInt = NO_COUNT;

        $feeInt = $this -> currencyToInt($amount, $currency);

        // パラメータの作成
        $params[] = $account;
        $params[] = $currency;
        $params[] = $feeInt;
        $params[] = $type;
        $params[] = $transactionNumber = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DOMANT_FEE);
        $params[] = $msg;
        $params[] = $status;


        // データを登録する
        $this -> accessModifyCommon('INSERT_INACTIVE_FEE', $params);

        return $transactionNumber;
    }

	/*-------------------------------------------------------------------------
	 * @function_name: getDepositSolutionListAdminCommon
	 * @parameter	: none
	 * @return		: array containing Deposit solution Method and names
	 ------------------------------------------------------------------------*/
	public function getDepositSolutionListAdminCommon() {

		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_VSMS_METHOD
				, PARAM_DATA_VALUE			=> VAL_STR_VSMS_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_FLAT3_METHOD
				, PARAM_DATA_VALUE			=> VAL_STR_FLAT3_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_CUP_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_CUP_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_LBTC_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_LBTC_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_CLEARSETTLE_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_CLEARSETTLE_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_SEPA_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_SEPA_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_LBTJ_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_LBTJ_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_IBT_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_IBT_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_H2P_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_H2P_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_BIT_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_BIT_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_CPS_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_CPS_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_LBTF3_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_LBTF3_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_JPV_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_JPV_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_STR_ZANETAPAY_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_ZANETAPAY_NAME);
		$rtn[] = array(PARAM_DATA_KEY       => VAL_STR_CCDEPOSIT_METHOD
                        , PARAM_DATA_VALUE  => VAL_STR_CCDEPOSIT_NAME);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: getWithdrawSolutionListAdminCommon
	 * @parameter	: none
	 * @return		: array containing Withdraw solution Method and names
	 ------------------------------------------------------------------------*/
	public function getWithdrawSolutionListAdminCommon() {

		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_WITHDRAW_IBT_METHOD
				, PARAM_DATA_VALUE			=> VAL_STR_IBT_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_WITHDRAW_FLAT3_METHOD
				, PARAM_DATA_VALUE			=> VAL_STR_WITHDRAW_FLAT3_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_WITHDRAW_LBTC_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_WITHDRAW_LBTC_NAME);
		$rtn[] = array(PARAM_DATA_KEY		=> PARAM_WITHDRAW_H2P_METHOD
						, PARAM_DATA_VALUE	=> VAL_STR_WITHDRAW_H2P_NAME);


		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: getUserBypassValue
	* @parameter	: $method,$solution,$userAccount
	* @return		: bool: true if
	-------------------------------------------------------------------------*/
	public function getUserBypassValue($method,$solution,$userAccount) {
		$params = array();
		$params[] = $method;
		$params[] = $solution;
		$params[] = $userAccount;

		$res = $this -> getRowData($this -> accessSelect('SELECT_USER_BYPASS_SOLUTION', $params));

		if($res!=NULL){
			return true;
		}

		return false;
	}

	/*----------------------Mikko 0313 2019------------------------------------
	 * @function_name: getRiskLevels
	 * @parameter    : none
	 * @return		 : array containing risk levels and name
	 ------------------------------------------------------------------------*/
	public function getRiskLevels() {

		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> VAL_INT_1
				, PARAM_DATA_VALUE			=> 'High Risk');
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_INT_2
				, PARAM_DATA_VALUE			=> 'For Monitoring');
		return $rtn;
	}

	/*----------------------Mikko 0313 2019------------------------------------
	 * @function_name: dispRiskLevelCommon
	 * @parameter    : $riskLevel
	 * @return		 : High Risk, For Monitoring
	 ------------------------------------------------------------------------*/
	public function dispRiskLevelCommon($riskLevel) {
		$lvl = ($riskLevel != NO_STRING) ? $this -> getValueByList($this -> getRiskLevels(), $riskLevel) : "";
		return $lvl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: getWithdrawType
	* @parameter	: none
	* @return		: all, withdraw, fee
	------------------------------------------------------------------------*/
	public function getWithdrawType() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY		=> NO_COUNT
						, PARAM_DATA_VALUE	=> VAL_STR_WITHDRAW_SOLUTION);
		$rtn[] = array(PARAM_DATA_KEY		=> VAL_INT_1
						, PARAM_DATA_VALUE	=> VAL_STRING_PAYMENT_FEES);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispExchangeFeeSettingList
	* @parameter	: none
	* @return		: exchange fee settings
	------------------------------------------------------------------------*/
	public function dispExchangeFeeSettingList() {

		$rtn	= array();
		$rs		= null;

		$rs = $this -> accessSelect('LIST_EXCHANGE_FEE_PATTERNS', array(VAL_STR_DEFAULT_EXCHANGE_SETTING));

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {

				$rtn[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_M_F_ID)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_PATTERN_NAME));
			}
		}

		return $rtn;
	}	

	/*-------------------------------------------------------------------------
	* @function_name: getAdminName
	* @parameter	:
	* @return		: string - user account
	-------------------------------------------------------------------------*/
	public function getAdminName($userAccount) {
		$rs = $this -> accessSelect('SELECT_ADMIN_USER', array($userAccount));
		$row = $this -> getRowData($rs, 0);
		$lastName 	= $this -> getColumnData($row, COLUMN_LAST_NAME);
		$firstName 	= $this -> getColumnData($row, COLUMN_FIRST_NAME);
		$fullName 	= $firstName .' '. $lastName;

		return $fullName;
	}

	public function getFeeName($fId) {

		$rs 		= $this -> accessSelect('SELECT_FEE_BY_FID', array($fId));
		$row 		= $this -> getRowData($rs, 0);
		$feeName 	= $this -> getColumnData($row, COLUMN_FEE_TYPE_NAME);

		return $feeName;
	}

	public function getPatternName($mfId) {

		$rs 			= $this -> accessSelect('SELECT_PATTERN_BY_MFID', array($mfId));
		$row 			= $this -> getRowData($rs, 0);
		$patternName 	= $this -> getColumnData($row, COLUMN_PATTERN_NAME);
		if($mfId == NO_COUNT){
			$patternName = 'Default';
		}

		return $patternName;
	}



	public function getTierStatusList() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '0'
						, PARAM_DATA_VALUE => VAL_STR_BRONZE);
		$rtn[] = array(PARAM_DATA_KEY => '1'
						, PARAM_DATA_VALUE => VAL_STR_SILVER);
		$rtn[] = array(PARAM_DATA_KEY => '2'
						, PARAM_DATA_VALUE => VAL_STR_GOLD);
		$rtn[] = array(PARAM_DATA_KEY => '3'
						, PARAM_DATA_VALUE => VAL_STR_PLATINUM);
		return $rtn;
	}

	public function dispTierLevelCommon($tierLevel) {
		$lvl = ($tierLevel != NO_STRING) ? $this -> getValueByList($this -> getTierStatusList(), $tierLevel) : "";
		return $lvl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 使用タイプを取得
	* @parameter	: なし
	------------------------------------------------------------------------*/
	public function getTypeOfUsage() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => null
						, PARAM_DATA_VALUE => '');
		$rtn[] = array(PARAM_DATA_KEY => 'Manual'
						, PARAM_DATA_VALUE => 'Manual');
		$rtn[] = array(PARAM_DATA_KEY => 'API1 Integration'
						, PARAM_DATA_VALUE => 'API1 Integration');
		$rtn[] = array(PARAM_DATA_KEY => 'API2 Integration'
						, PARAM_DATA_VALUE => 'API2 Integration');
		$rtn[] = array(PARAM_DATA_KEY => 'Both Integration'
						, PARAM_DATA_VALUE => 'Both Integration');

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 契約ステータスを取得する
	* @parameter	: なし
	-------------------------------------------------------------------------*/
	public function getAgreementStatus() {
		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => null
						, PARAM_DATA_VALUE => '');
		$rtn[] = array(PARAM_DATA_KEY => 'T&C Signed'
						, PARAM_DATA_VALUE => 'T&C Signed');
		$rtn[] = array(PARAM_DATA_KEY => 'API Signed'
						, PARAM_DATA_VALUE => 'API Signed');
		$rtn[] = array(PARAM_DATA_KEY => 'T&C & API Signed'
						, PARAM_DATA_VALUE => 'T&C & API Signed');
		$rtn[] = array(PARAM_DATA_KEY => 'LPP Signed'
						, PARAM_DATA_VALUE => 'LPP Signed');
		$rtn[] = array(PARAM_DATA_KEY => 'T&C & IPP Signed'
						, PARAM_DATA_VALUE => 'T&C & IPP Signed');
		$rtn[] = array(PARAM_DATA_KEY => 'No Signed Agreement'
						, PARAM_DATA_VALUE => 'No Signed Agreement');

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: getAdminName
	* @parameter	:
	* @return		: string - user account
	-------------------------------------------------------------------------*/
	public function getAdminNameByUid($userId) {
		$rs = $this -> accessSelect('SELECT_ADMIN_USER_BY_UID', array($userId));
		$row = $this -> getRowData($rs, 0);
		$lastName 	= $this -> getColumnData($row, COLUMN_LAST_NAME);
		$firstName 	= $this -> getColumnData($row, COLUMN_FIRST_NAME);
		$fullName 	= $firstName .' '. $lastName;

		return $fullName;
	}

	public function checkTransferBlock($userAccount) {

		$rtn = false;

		$rs 			= $this -> accessSelect('SELECT_USER_TRANSFER_FLG', array($userAccount));
		if((count($rs)) > NO_COUNT){
			$tranferFlg 	= $this -> getColumnData($rs[NO_COUNT], COLUMN_TRANSFER_FLG);

			if($tranferFlg == NO_COUNT){
				$rtn = true;
			}
		}

		return $rtn;
	}
	public function getZeroDecimalCurrenciesCommon(){

		$rtn	= array();
		$rs		= null;

		// 国マスタデータを取得する
		$rs = $this -> accessSelect('LIST_MST_NONDECIMAL_CURRENCY', array());

		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$rtn[] = $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
			}
		}

		return $rtn;

	}

	public function checkAdIDExist($id){

		$rtn	= false;
		$rs		= null;

		// 国マスタデータを取得する
		$rs = $this -> accessSelect('SELECT_AD_DETAILS', array($id));

		if((count($rs)) == 1){
			$rtn = true;
		}

		return $rtn;

	}

	 /*-------------------------------------------------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    public function getAdImages($lang, $loc){

    	$rtn			= array();

        $rs = $this -> accessSelect('DISPLAY_IMAGES', array($loc, $lang));

        if($loc == 'login'){
	        for($i = 0; $i < count($rs); $i++){
	        	$row = $this -> getRowData($rs, $i);

	        	$rtn[] .= '{
	        				url:"/documents/ads/'.$this -> getColumnData($row, 'file_name').'",
	        				id:"'.$this -> getColumnData($row, 'ads_id').'",
	        				href:"'.($this -> getColumnData($row, 'redirect_link') == '' ? '#' : $this -> getColumnData($row, 'redirect_link')).'",
	        				target:"'.($this -> getColumnData($row, 'redirect_link') == '' ? '' : '_blank' ).'"
	        			}';
	        }

	        $rtn = implode(', ', $rtn);

    	}elseif ($loc == 'menu') {
    		$cnt = 1;
    		for($i = 0; $i < count($rs); $i++){
	        	$row = $this -> getRowData($rs, $i);

				$href = ($this -> getColumnData($row, 'redirect_link') == '' ? '#image'.$cnt : $this -> getColumnData($row, 'redirect_link').'"  target="_blank"');

				$rtn[] .= '<div class="mySlides fade" id="'.$this -> getColumnData($row, 'ads_id').'" >'.
					// '<a href="#image'.$cnt.'"><img src="/documents/ads/'.$this -> getColumnData($row, 'file_name').'" class="imgC"></a>'.
					'<a href="'.$href.'"><img src="/documents/ads/'.$this -> getColumnData($row, 'file_name').'" class="imgC"></a>'.
					'</div>'.
					'<div id="image'.$cnt.'" class="lightbox">'.
					'<a href="#_">'.
					'<img src="/documents/ads/'.$this -> getColumnData($row, 'file_name').'" />'.
					'</a>'.
					'<a href="#_" class="exit">'.
					'&times;'.
					'</a>'.
					'</div>';

	        	$cnt++;
	        }

	        $rtn = implode('', $rtn);

    	}

        echo $rtn;
    }

    // recursive XSS Array sanitizer.
	public function sanitizeArrayContent(&$arr, 
        bool $pathSanitizer = false, 
        bool $headerSanitation = false, 
        bool $sqlSanitiation = false){
        if(is_array($arr)){
            foreach($arr as $k => $v){
                if(is_string($v))
                    $this -> sanitizeString($arr[$k], false, $pathSanitizer, $headerSanitation, $sqlSanitiation);
                else if(is_array($v))
                    $this -> sanitizeArrayContent($arr[$k], $pathSanitizer, $headerSanitation, $sqlSanitiation);
            }
        }
    }

    // subject to enhancement
    public function sanitizeString(&$str, 
        bool $stringify = false, 
        bool $pathSanitizer = false, 
        bool $headerSanitation = false, 
        bool $sqlSanitation = false){
        $temp = $str;
        
        if($pathSanitizer)
            $temp = $this -> pathSanitizer($temp);
        
        if($headerSanitation)
            $temp = $this -> headerSanitation($temp);
        
        if($sqlSanitation)
            $temp = $this -> sqlSanitation($temp);
            
        if($stringify)
            return htmlentities($temp);
        
        $str = htmlentities($temp);
    }

    // pls. do add sensitive path here.
    public function pathSanitizer($str){
        $critical = [
            "api\/Logs",
            "api\/([a-zA-Z0-9\-\.]+)\.php",
            "kyc\/([a-zA-Z0-9\-\.]+)\.([a-zA-Z0-9]+)",
            "logic\/([a-zA-Z0-9\-\.]+)\.php",
            "template\/([a-zA-Z0-9\-\.]+)\.php",
            "en\/template",
            "ja\/template",
            "tc\/template",
            "sc\/template",
            "id\/template",
            "en\/([a-zA-Z0-9\-\.]+)\.php",
            "ja\/([a-zA-Z0-9\-\.]+)\.php",
            "tc\/([a-zA-Z0-9\-\.]+)\.php",
            "sc\/([a-zA-Z0-9\-\.]+)\.php",
            "id\/([a-zA-Z0-9\-\.]+)\.php",
            "js\/jquery",
            "js\/([a-zA-Z0-9\-\.]+)\.js",
            "css\/([a-zA-Z0-9\-\.]+)\.css",
            "system\/([a-zA-Z0-9\-\.]+)\.php",
            "system\/lib",
            "system\/logic",
            "system\/template",
            "system\/en",
            "system\/api",
            "system\/fonts",
            "system\/documents",
            "system\/img",
            "system\/css",
            "system\/js",
            "\/\.\.",
            "\/\/",
        ];
        
        foreach($critical as $path){
            if(preg_match("/(\/|\\\\)[^,:]*/", $str, $tokens)){
                if(count($tokens) != 0){
                    $token = str_replace("\\", "/", $tokens[0]);
                    
                    if(count($tokens) != 0 && preg_match("/{$path}/", $token, $matches)){
                        if(count($matches) != 0)                        
                            $str = str_replace($matches[0], "", $str);
                    }
                }
            }
        }
        
        return $str;
    }

    // blacklisting chars., phrases the header() might execute
    public function headerSanitation($str){
        $blacklisted = [
            '=', ':', '\\n', '\\r', ';', 
            'charset', 'location', 'content\-type', 'content\-disposition',
            'cache\-control', 'http\/([0.9]+)\.([0.9]+)', 'refresh',
            'pragma', 'set\-cookie', 'expires', 'x\-powered\-by'
        ];
        
        foreach($blacklisted as $phrase){
            if(preg_match("/{$phrase}/", strtolower($str)))
                $str = preg_replace("/{$phrase}/", "", strtolower($str));
        }
        
        return $str;
    }

    public function sqlSanitation($str){
        $escaped = [
            '\'', '"', '\\n', '\\r', '\\0', '<', '>'
        ];
        
        foreach($escaped as $phrase){
            if(preg_match("/{$phrase}/", $str)){
                if(preg_match("/(<|>)/", $phrase)){
                    $str = str_replace($phrase, NO_STRING, $str);
                }else
                    $str = preg_replace("/{$phrase}/", "\\{$phrase}", $str);
            }
        }
        
        return $str;
    }
}
?>
