$(function() {
	$("#btnSearch").click(function() {
		$('#type_search').val('admin_user_list');
		submitForm('searchForm');
	});

	$("#btnSearchAll").click(function() {
		$('#type_search').val('admin_user_search_all');
		submitForm('searchForm');
	});

	$("#btnInput").click(function() {
		$('#type').val('admin_user_input');
		submitForm();
	});

	$("#btnInputSave").click(function() {
		$('#type').val('admin_user_create');
		submitForm();
	});

	$("#btnImportInput, #btnImportCancel").click(function() {
		$('#type').val('admin_user_import_input');
		submitForm();
	});

	$("#btnImportConfirm").click(function() {
		$('#type').val('admin_user_import_confirm');
		submitForm();
	});

	$("#btnImportSave").click(function() {
		$('#type').val('admin_user_import');
		submitForm();
	});

	$("#btnEditInput").click(function() {
		$('#type').val('admin_user_edit_input');
		submitForm();
	});

	$("#btnEditSave").click(function() {
		$('#type').val('admin_user_edit_save');
		submitForm();
	});

	$("#btnDelete").click(function() {
		var r = confirm("Do you want to delete this user?");
		if(r == true) {
			$('#type').val('admin_user_delete');
		} else {
			$('#type').val('admin_user_details');
		}
		submitForm();
	});

	$("#btnExportFail").click(function() {
		$('#type').val('export_admin_fail_list');
		submitForm();
	});

	$('#btnCheckAll').click(function(){
		$('.functionName').prop('checked', true);
		$('.functionAccess').prop('checked', true);
		$(this).hide();
		$('#btnUncheckAll').show();
	});
	$('#btnUncheckAll').click(function(){
		$('.functionName').prop('checked', false);
		$('.functionAccess').prop('checked', false);
		$(this).hide();
		$('#btnCheckAll').show();
	});

	$(document).on('change', '.functionName', function(){
		if(!($(this).is(":checked"))) {
			var accessName = $(this).attr("name");
			$(".functionAccess[name='"+accessName+"']").prop("checked", false);
		}
	});

	$(document).on('change', '.functionAccess', function(){
		if($(this).is(":checked")) {
			var functionName = $(this).attr("name");
			$(".functionName[name='"+functionName+"']").prop("checked", true);
		}
	});

	$("#department_id").on("change", function(e){
		$('#btnCheckAll').show();
		$('#btnUncheckAll').hide();
		$.ajax({
            url: "../logic/admin_user/config.php",
            dataType: "text",
            type: "POST",
            data: {
                action : "getDepartmentFunctionList", 
                departmentId: $("#department_id").val(),
                language : ( $("#language").length > 0 ? $("#language").val() : undefined )
            },
            success: function (data){
				$("#functionDetails").hide();
				$("#functionDetails").replaceWith(data);
				$("#functionDetails").fadeIn("slow");
            }
        });
	});

	$('#s_last_login_from').datepicker({
		// ã‚«ãƒ¬ãƒ³ãƒ€ãƒ¼ã®è¨­å®š
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_last_login_to').datepicker({
		// ã‚«ãƒ¬ãƒ³ãƒ€ãƒ¼ã®è¨­å®š
		dateFormat	: 'yy/mm/dd'
	});

	if($('#s_last_login_from').val() == '') {
		$('#s_last_login_from:text').datepicker().datepicker('setDate', nowStr);
	}

	if($('#s_last_login_to').val() == '') {
		$('#s_last_login_to:text').datepicker().datepicker('setDate','today');
	}
});

/**
 * 検索を行う（詳細表示）
 */
function actionDetail(uAccount) {
	$('#user_account').val(uAccount);
	$('#type').val('admin_user_details');
	submitForm();
}

/**
 * 検索を行う（詳細表示）
 */
function actionEditBack() {
	$('#type').val('admin_user_edit_back');
	submitForm();
}

/**
 * 検索を行う（詳細表示）
 */
function actionInputBack() {
	$('#type').val('admin_user_list');
	submitForm();
}