<?php
require_once(SYSTEM_LOGICS . 'transaction_logs/model.php');

class LogicTransactionLogs extends TransactionLogsModelClass {
	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {
		try {
			// 初期データ処理
		    $this -> init();
			
		    if($this -> getMethod() == "From_DB"){
		        $this -> lists();
		    }
		    
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		//set variables
		$where = null;

		$where = $this -> getWhere();
		$where[VAL_INT_1] = NO_STRING;
		
		$count = $this -> getColumnData($this -> getRowData($this -> accessSelect('COUNT_LOG_POST', $where), NO_COUNT), 
		    "log_ctr");
		$this -> setCount($count);
		
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$where[VAL_INT_1] = ' LIMIT ' . $start . DELIMIT_COMMA . VAR_DEFAULT_PAGE_COUNT;
		
		$this -> setResult($this -> accessSelect('LIST_LOG_POST', $where));
	}
}
?>