<?php

class UserTransactions extends OpenAPIAbstraction {
    
    /**
     * 
     * @var ParamHolder
     */
    private $holder;
    
    private $view;
    
    public function __construct(){
        parent::__construct();
    }
    
    public function setView($view){
        $this -> view = $view;
    }
    
    public function showResults(){
        $this -> holder = $this -> getHolder();
        
        switch($this -> view){
            case "balances":
                $this ->  generateBalances();
                break;
            case "transactions":
                $this -> list();
                break;
        }
    }

    private function generateBalances(){
        $account = $this -> getRowData($this -> getAccountCommon($this -> holder -> userAccount), NO_COUNT);
        
        $balances = $this -> accessSelect('SELECT_USER_BALANCES',
            [$this -> getColumnData($account, PARAM_USER_ACCOUNT)]);
        
        // enhancements
        foreach($balances as &$balance){
            unset($balance["user_account"]);
            $balance["balance"] = $this -> intToCurrency($balance["balance"], $balance["currency"]);
            $balance["withdraw_amount"] = $this -> intToCurrency($balance["withdraw_amount"], $balance["currency"]);
            $balance["deposit_amount"]  = $this -> intToCurrency($balance["deposit_amount"], $balance["currency"]);
        }
        
        $result = [
            "user_account" => $this -> getColumnData($account, COLUMN_USER_ACCOUNT),
            "account_name" => $this -> getColumnData($account, COLUMN_FIRST_NAME)." "
                .$this -> getColumnData($account, COLUMN_LAST_NAME),
            "account_type" => $this -> getColumnData($account, COLUMN_ACCOUNT_TYPE) ? "Individual" : "Corporate",
            "account_cat" => $this -> getColumnData($account, COLUMN_TEST_ACCOUNT_FLG) == 0 ? "Live" : "Test",
            "user_balances" => $balances
        ];
        
        echo json_encode($result);
    }
    
    private function list(){                
        $params = $this -> getUserAccountData();
        
        $countTransactions = $this -> getRowData($this -> accessSelect('SELECT_USER_TRANSACTION_ADMIN_COUNT', $params));
        
        $totalPage = $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $countTransactions["overall_total"]);
        
        $currentPage = empty($this -> holder -> page) || !is_numeric($this -> holder -> page) ? 1 : $this -> holder -> page;     
        
        if($currentPage > $totalPage)
            $currentPage = $totalPage;
        
        $start  = ($currentPage - 1) * VAR_DEFAULT_PAGE_COUNT;
   
        $params[3] = "DESC LIMIT {$start}, ".VAR_DEFAULT_PAGE_COUNT;
        
        $list = $this -> accessSelect('LIST_USER_TRANSACTION', $params);
       
        $start		= 	 ($currentPage - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
        
        $result = [
            "row_count" => $countTransactions["overall_total"],
            "page_total" => $totalPage,
            "current_page" => $currentPage,
            "result" => []
        ];
                
        foreach($list as $transaction){
            $this -> statusIndication($transaction);
            
            $result["result"][] = $transaction;
        }
                
        echo json_encode($result);
    }
    
    private function getUserAccountData() {
        
        // 変数宣言部
        $rtn = array();
        
        $rtn[] = $this -> holder -> userAccount;	// ユーザアカウント
        $rtn[] = $this -> holder -> currency;
        $rtn[] = $this -> getWhere();						// 検索条件
        $rtn[] = NO_STRING;
        
        return $rtn;
    }
    
    private function getWhere() {
        // 変数宣言部
        $params	= array();
        $rtn	= NO_STRING;
        
        // 通貨指定
        if($this -> holder -> currency != NO_STRING) {
            $params[] = ' (trans.deposit_currency = (\')' 
                . $this -> holder -> currency . '(\') OR trans.withdraw_currency = (\')' 
                . $this -> holder -> currency . '(\') OR trans.transfer_currency = (\')' 
                . $this -> holder -> currency . '(\'))';
        }
        
        // 日付指定(from)
        if($this -> holder -> dateFrom != NO_STRING) {
            $params[] = ' transaction_time >= (\')' . $this -> holder -> dateFrom . '(\')';
        }
        
        // 日付指定(to)
        if($this -> holder -> dateTo != NO_STRING) {
            $params[] = ' transaction_time < DATE_ADD((\')' . $this -> holder -> dateTo . '(\'), INTERVAL 1 DAY)';
        }
        
        // データが存在した場合
        if($this -> isLoopData($params)) {
            $rtn = DELIMIT_AND . implode(DELIMIT_AND, $params);
        }
        
        return $rtn;
    }
     
    private function statusIndication(&$row){
        if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_1) {						// 入金
            $row['type']   = VAL_STR_DEPOSIT;
            $row['status'] = VAL_STR_STATUS_COMP;
            
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
            && $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金
                
            $row['type']	= VAL_STR_WITHDARAW . '（' . $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '）';
            $row['status']	= $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS));
                
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
            && $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金
                
                $row['type']				= VAL_STR_FEE;
                $row['status']				= VAL_STR_STATUS_COMP;
                $row[COLUMN_MESSAGE]	= VAL_STR_MONTHLY_FEE;
                
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
            && $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_TRANSFER) {			// 出金（カード出金）
                $row['type']	= VAL_STR_CARD_DEPOSIT;
                $row['status']	= VAL_STR_STATUS_COMP;
                
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_3) {						// 両替入金
            $row['type']		= VAL_STR_EXCHANGE;
            $row['status']	    = VAL_STR_STATUS_COMP;
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 両替出金
            
            $row['type']		 = VAL_STR_EXCHANGE;
            $row['status']	     = VAL_STR_STATUS_COMP;
            
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 口座振替（出金）
            
            $row['type'] 		 = VAL_STR_TRANSFER;
            $row['status']	     = VAL_STR_STATUS_COMP;
            
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_6) {						// 口座振替（出金）
            
            $row['type'] 		= VAL_STR_TRANSFER;
            $row['status']	    = VAL_STR_STATUS_COMP;
            
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_7) {						// 引落（出金）
            
            $row['type'] 		= VAL_STR_REQUEST;
            $row['status']	    = VAL_STR_STATUS_COMP;
            
        } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {						// 引落（入金）
            
            $row['type'] 		= VAL_STR_REQUEST;
            $row['status']	    = VAL_STR_STATUS_COMP;
        }  else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_11 && $this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_2) {
            
            $row['type']			= VAL_STR_FEE;
            $row['status']			= VAL_STR_STATUS_COMP;
            $row[COLUMN_MESSAGE]	= VAL_STR_DOMANT_FEE;
        }  else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_9
            || $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_10
            || $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_11
            || $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_12) {			// 出金（返却系）
                
                $row['type'] 		= VAL_STR_WITHDARAW . '（' . $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '）';
                $row['status']	= VAL_STR_STATUS_COMP;
                
        } else {
            $row['type'] = NO_STRING;
        }
    }
}