<?php
class WithdrawModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 出金リスト
	private $total						= array();		// 結果セット（集計）
	private $user						= null;			// ユーザデータ
	private $detail						= null;			// 詳細データ
	private $currencies					= null;			// 通貨データ
	private $wId						= NO_STRING;	// 出金ID
	private $drawCurrency				= NO_STRING;	// 通貨（引き出し通貨）
	private $userName					= NO_STRING;	// ユーザ名
	private $userAccount				= NO_STRING;	// iwallet口座番号
	private $amount						= NO_STRING;	// 金額
	private $currency					= NO_STRING;	// 通貨
	private $accountName				= NO_STRING;	// 口座名義
	private $receiptCountry				= NO_STRING;	// 受取人国
	private $receiptAddress1			= NO_STRING;	// 受取人住所1
	private $receiptAddress2			= NO_STRING;	// 受取人住所2
	private $receiptMessage				= NO_STRING;	// 受取人メッセージ
	private $receiptBankName			= NO_STRING;	// 受取銀行名
	private $receiptBranchName			= NO_STRING;	// 支店名
	private $receiptBranchCode			= NO_STRING;	// 支店コード
	private $receiptBankSwift			= NO_STRING;	// 受取銀行SWIFT
	private $receiptBankCountry			= NO_STRING;	// 受取銀行国
	private $receiptBankAddress1		= NO_STRING;	// 受取銀行住所1
	private $receiptBankAddress2		= NO_STRING;	// 受取銀行住所2
	private $accountNumber				= NO_STRING;	// 受取銀行口座番号
	private $intermediaryFlg			= NO_STRING;	// 中継銀行フラグ
	private $intermediaryBankName		= NO_STRING;	// 中継銀行名
	private $intermediaryBankSwift		= NO_STRING;	// 中継銀行SWIFT
	private $intermediaryBankCountry	= NO_STRING;	// 中継銀行国
	private $intermediaryBankAddress1	= NO_STRING;	// 中継銀行住所1
	private $intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2
	private $intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージ
	private $status						= NO_COUNT;		// 送金ステータス
	private $debitCurrency				= NO_COUNT;		// 引き落し通貨
	private $debitAmount				= NO_COUNT;		// 引き落し金額
	private $rate						= NO_COUNT;		// レート
	private $fee						= NO_COUNT;		// 手数料
	private $feeRefund					= NO_COUNT;		// 差戻し手数料
	private $orderNumber				= NO_COUNT;		// 注文番号
	private $note						= NO_COUNT;		// 備考
    private $receiptBankCode            = NO_STRING;    //bank code (flat3)
    private $flat3result                = null;         //flat 3 result (json format)

	// ------------------ 検索系 ------------------//
	private $sEmail						= NO_COUNT;		// メールアドレス（検索項目）
	private $sCompletion				= NO_COUNT;		// 完了データ（検索項目）
	private $sBank						= NO_COUNT;		// 銀行データ（検索項目）
	private $sAccount					= NO_COUNT;		// 送金先口座番号（検索項目）
	private $sStatus					= NO_COUNT;		// ステータス（検索項目）
	private $sMinAmount					= NO_COUNT;		// 送金額（最少）（検索項目）
	private $sMaxAmount					= NO_COUNT;		// 送金額（最大）（検索項目）
	private $sFrom						= NO_COUNT;		// 登録時刻（開始日）（検索項目）
	private $sTo						= NO_COUNT;		// 登録時刻（終了）（検索項目）
	private $sCurrency					= NO_COUNT;		// 通貨（検索項目）
	private $sTransactionNumber			= NO_STRING;	// 取引番号
	private $sOrderNumber				= NO_STRING;	// 銀行注文番号
	private $sUserAccount				= NO_STRING;	// 送金口座番号
	private $sWithdrawSolution			= NO_STRING;	// withdrawSolution
	private $registFlg 					= NO_STRING;	// register date search flag
	private $processFlg 				= NO_STRING; 	// process date search flag
	private $sProcessFrom 				= NO_STRING;	// process time (start) (Search items)
	private $sProcessTo 				= NO_STRING;	// process time (end) (Search items)
	private $sWithdrawType 				= NO_STRING;	// process time (end) (Search items)
	private $sWithdrawFee 				= NO_STRING;
	// ------------------ 検索系 ------------------//

	// ------------------ (anton) ----------------- //
	public $lang					= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> wId						= $this -> getDataPost(PARAM_W_ID);							     // 出金ID
		$this -> userAccount				= $this -> getDataPost(PARAM_USER_ACCOUNT);					     // iwallet口座番号
		$this -> drawCurrency				= $this -> getDataPost(PARAM_DRAW_CURRENCY);				     // 金額（引き出し通貨）
		$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);						     // 金額
		$this -> currency					= $this -> getDataPost(PARAM_CURRENCY);						     // 通貨
		$this -> accountName				= $this -> getDataPost(PARAM_ACCOUNT_NAME);					     // 口座名義
		$this -> receiptCountry				= $this -> getDataPost(PARAM_RECEIPT_COUNTRY);				     // 受取人国
		$this -> receiptAddress1			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_1);			     // 受取人住所1
		$this -> receiptAddress2			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_2);			     // 受取人住所2
		$this -> receiptMessage				= $this -> getDataPost(PARAM_RECEIPT_MESSAGE);				     // 受取人メッセージ
		$this -> receiptBankName			= $this -> getDataPost(PARAM_RECEIPT_BANK_NAME);			     // 受取銀行名
		$this -> receiptBankSwift			= $this -> getDataPost(PARAM_RECEIPT_BANK_SWIFT);			     // 受取銀行SWIFT
		$this -> receiptBankCountry			= $this -> getDataPost(PARAM_RECEIPT_BANK_COUNTRY);			     // 受取銀行国
		$this -> receiptBankAddress1		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_1);		     // 受取銀行住所1
		$this -> receiptBankAddress2		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_2);		     // 受取銀行住所2
		$this -> accountNumber				= $this -> getDataPost(PARAM_ACCOUNT_NUMBER);				     // 受取銀行口座番号
		$this -> intermediaryFlg			= $this -> getDataPost(PARAM_INTERMEDIARY_FLG);				     // 中継銀行フラグ
		$this -> intermediaryBankName		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_NAME);		     // 中継銀行名
		$this -> intermediaryBankSwift		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_SWIFT);		     // 中継銀行SWIFT
		$this -> intermediaryBankCountry	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_COUNTRY);	     // 中継銀行国
		$this -> intermediaryBankAddress1	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_1);	     // 中継銀行住所1
		$this -> intermediaryBankAddress2	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_2);	     // 中継銀行住所2
		$this -> intermediaryBankMessage	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_MESSAGE);	     // 中継銀行メッセージ
		$this -> status						= $this -> getDataPost(PARAM_STATUS);						     // 出金ステータス
		$this -> debitCurrency				= $this -> getDataPost(PARAM_DEBIT_CURRENCY);				     // 引き落し通貨
		$this -> feeRefund					= $this -> getDataPost(PARAM_FEE_REFUND);					     // 差戻し手数料
		$this -> orderNumber				= $this -> getDataPost(PARAM_ORDER_NUMBER);					     // 注文番号
		$this -> note						= $this -> getDataPost(PARAM_NOTE);							     // 備考
		$this -> flat3result			    = json_decode($this -> getDataPost(PARAM_FLAT3_RESULT), true);   // flat 3 result (json format)

		// ------------------ 検索系 ------------------//
		$this -> sEmail						= $this -> getDataPost(PARAM_S_EMAIL);						// メールアドレス（検索項目）
		$this -> sCompletion				= $this -> getDataPost(PARAM_S_COMPLETION);					// 完了データ（検索項目）
		$this -> sBank						= $this -> getDataPost(PARAM_S_BANK);						// 銀行データ（検索項目）
		$this -> sAccount					= $this -> getDataPost(PARAM_S_ACCOUNT);					// 送金先口座番号（検索項目）
		$this -> sStatus					= $this -> getDataPost(PARAM_S_STATUS);						// ステータス（検索項目）
		$this -> sTier						= $this -> getDataPost(PARAM_S_TIER);						// ステータス（検索項目）
		$this -> sMinAmount					= $this -> getDataPost(PARAM_S_MIN_AMOUNT);					// 送金額（最少）（検索項目）
		$this -> sMaxAmount					= $this -> getDataPost(PARAM_S_MAX_AMOUNT);					// 送金額（最大）（検索項目）
		$this -> sFrom						= $this -> getDataPost(PARAM_S_FROM);						// 登録時刻（開始日）（検索項目）
		$this -> sTo						= $this -> getDataPost(PARAM_S_TO);							// 登録時刻（終了）（検索項目）
		$this -> sCurrency					= $this -> getDataPost(PARAM_S_CURRENCY);					// 通貨（検索項目）
		$this -> sTransactionNumber			= $this -> getDataPost(PARAM_TRANSACTION_NUMBER);			// 取引番号
		$this -> sOrderNumber				= $this -> getDataPost(PARAM_S_ORDER_NUMBER);				// 銀行注文番号
		$this -> sUserAccount				= $this -> getDataPost(PARAM_S_USER_ACCOUNT);				// 口座番号
		$this -> sWithdrawSolution		    = $this -> getDataPost(PARAM_S_WITHDRAW_SOLUTION);		    // withdraw solution
		$this -> registFlg 		    		= $this -> getDataPost(PARAM_S_APPLY_FLG);
		$this -> processFlg		   			= $this -> getDataPost(PARAM_S_PROCESS_FLG);
		$this -> sProcessFrom			   	= $this -> getDataPost(PARAM_S_PROCESS_FROM);
		$this -> sProcessTo 				= $this -> getDataPost(PARAM_S_PROCESS_TO);
		$this -> sWithdrawType 				= $this -> getDataPost(PARAM_S_WITHDRAW_TYPE);
		$this -> sWithdrawFee 				= $this -> getDataPost(PARAM_S_FEE);
		$this -> testAccountFlg		= $this -> getDataPost(PARAM_TEST_ACCOUNT_FLG);			// WLID
		// ------------------ 検索系 ------------------//

		$this -> lang						= $this -> getLangage();

	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> wId						= $this -> getColumnData($this -> detail, COLUMN_W_ID);							// 出金ID
		$this -> userName					= $this -> getColumnData($this -> detail, COLUMN_USER_NAME);					// ユーザID
		$this -> userAccount				= $this -> getColumnData($this -> detail, COLUMN_USER_ACCOUNT);					// iwallet口座番号
		$this -> currency					= $this -> getColumnData($this -> detail, COLUMN_CURRENCY);						// 通貨
		$this -> amount						= $this -> getColumnData($this -> detail, COLUMN_AMOUNT);						// 金額
		$this -> accountName				= $this -> getColumnData($this -> detail, COLUMN_ACCOUNT_NAME);					// 口座名義
		$this -> receiptCountry				= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_COUNTRY);				// 受取人国
		$this -> receiptAddress1			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_ADDRESS_1);			// 受取人住所1
		$this -> receiptAddress2			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_ADDRESS_2);			// 受取人住所2
		$this -> receiptMessage				= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_MESSAGE);				// 受取人メッセージ
		$this -> receiptBankName			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_NAME);			// 受取銀行名
		$this -> receiptBranchName			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_BRANCH_NAME);		// 支店名
		$this -> receiptBranchCode			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_BRANCH_CODE);		// 支店コード
		$this -> receiptBankSwift			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_SWIFT);			// 受取銀行SWIFT
		$this -> receiptBankCountry			= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_COUNTRY);			// 受取銀行国
		$this -> receiptBankAddress1		= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_ADDRESS_1);		// 受取銀行住所1
		$this -> receiptBankAddress2		= $this -> getColumnData($this -> detail, COLUMN_RECEIPT_BANK_ADDRESS_2);		// 受取銀行住所2
		$this -> accountNumber				= $this -> getColumnData($this -> detail, COLUMN_ACCOUNT_NUMBER);				// 受取銀行口座番号
		$this -> intermediaryFlg			= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_FLG);				// 中継銀行フラグ
		$this -> intermediaryBankName		= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_BANK_NAME);		// 中継銀行名
		$this -> intermediaryBankSwift		= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_BANK_SWIFT);		// 中継銀行SWIFT
		$this -> intermediaryBankCountry	= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_BANK_COUNTRY);	// 中継銀行国
		$this -> intermediaryBankAddress1	= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_BANK_ADDRESS_1);	// 中継銀行住所1
		$this -> intermediaryBankAddress2	= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_BANK_ADDRESS_2);	// 中継銀行住所2
		$this -> intermediaryBankMessage	= $this -> getColumnData($this -> detail, COLUMN_INTERMEDIARY_BANK_MESSAGE);	// 中継銀行メッセージ
		$this -> status						= $this -> getColumnData($this -> detail, COLUMN_STATUS);						// 送金ステータス
		$this -> tier						= $this -> getColumnData($this -> detail, COLUMN_TIER_LEVEL);						// 送金ステータス
		$this -> debitCurrency				= $this -> getColumnData($this -> detail, COLUMN_DEBIT_CURRENCY);				// 引き落し通貨
		$this -> debitAmount				= $this -> getColumnData($this -> detail, COLUMN_DEBIT_AMOUNT);					// 引き落し金額
		$this -> rate						= $this -> getColumnData($this -> detail, COLUMN_RATE);							// レート
		$this -> fee						= $this -> getColumnData($this -> detail, COLUMN_FEE);							// 手数料
		$this -> feeRefund					= $this -> getColumnData($this -> detail, COLUMN_FEE_REFUND);					// 差戻し手数料
		$this -> orderNumber				= $this -> getColumnData($this -> detail, COLUMN_ORDER_NUMBER);					// 注文番号
		$this -> note						= $this -> getColumnData($this -> detail, COLUMN_NOTE);							// 備考
		$this -> tNumber					= $this -> getColumnData($this -> detail, COLUMN_TRANSACTION_NUMBER);
		/*if($this ->getColumnData($this -> detail, COLUMN_STATUS) == 5){
			$this -> feeRefund 				= '-'.$this -> fee;
		}else{
			$this -> feeRefund 				= $this -> getColumnData($this -> detail, COLUMN_FEE_REFUND);
		}*/

        //check if flat 3
        if($this -> getColumnData($this -> detail, COLUMN_WITHDRAW_SOLUTION) == 'Flat3'){
            //branch code and bank code
            $codeArray = unserialize($this -> receiptBranchCode);
            $branchCodeString = NO_STRING;
            foreach($codeArray as $key => $val){
                $branchCodeString .= $key . '=' . $val. ' ';
            }
            $this -> receiptBranchCode = $branchCodeString;
        }
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn			= true;
		$userAccount	= NO_STRING;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('WDPR', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('WDPD', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE) {
			//check access
			if(!$this -> checkAdminUserAccess('WDPD', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_INPUT) {				// 口座番号入力の場合

			$userAccount = $this -> searchUserAccountCommon($this -> userAccount);

			// データの確認
			if($userAccount == NO_STRING) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$this -> setType(CONTROL_ACTION);
				$rtn = false;
			} else {
				$this -> userAccount = $userAccount;
			}
		} else if($this -> getType() == TYPE_SAVE) {		// データ保存の場合

			// 銀行注文番号のチェック

			// 文字数（20文字）
			if(!$this -> checkLength($this -> orderNumber
									, NO_COUNT
									, VAL_INT_20)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_ORDER_NUMBER
																					, NO_COUNT
																					, VAL_INT_20));
				$rtn = false;
			}

			// 正規表現
			if(!$this -> checkStringAscii($this -> orderNumber)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_ORDER_NUMBER));
				$rtn = false;
			}

			//check if fee refund value is a string or lower than  0
			if((!$this -> checkStringNumber($this -> feeRefund) || $this -> feeRefund <= NO_COUNT) && ($this -> status  == VAL_INT_4)) {
				$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_REFUND, NO_COUNT));
				$rtn = false;
			}

			// 備考のチェック
			if(!$this -> checkLength($this -> note
									, NO_COUNT
									, VAL_INT_2000)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_NOTE
																					, NO_COUNT
																					, VAL_INT_2000));
				$rtn = false;
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_DETAIL);
				return true;
			}

		} else if($this -> getType() == TYPE_CONFIRM) {		// 出金登録の場合

			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 口座名義のチェック
			if(!$this -> checkNull($this -> accountName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ACCOUNT_NAME));
				$rtn = false;
			}

			// 受取人国のチェック
			if(!$this -> checkNull($this -> receiptCountry)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_COUNTRY));
				$rtn = false;
			}

			// 受取人住所1のチェック
			if(!$this -> checkNull($this -> receiptAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_ADDRESS_1));
				$rtn = false;
			}

			// 受取銀行名のチェック
			if(!$this -> checkNull($this -> receiptBankName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				$rtn = false;
			}

			// 受取銀行SWIFTのチェック
			if(!$this -> checkNull($this -> receiptBankSwift)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_SWIFT_CODE));
				$rtn = false;
			}

			// 受取銀行国のチェック
			if(!$this -> checkNull($this -> receiptBankCountry)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_COUNTRY));
				$rtn = false;
			}

			// 受取銀行住所1のチェック
			if(!$this -> checkNull($this -> receiptBankAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_ADDRESS_1));
				$rtn = false;
			}

			// 受取銀行口座番号のチェック
			if(!$this -> checkNull($this -> accountNumber)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_ACCOUNT_NUMBER));
				$rtn = false;
			}

			// 中継銀行のフラグが立っている場合
			if($this -> intermediaryFlg != NO_STRING) {

				// 中継銀行名のチェック
				if(!$this -> checkNull($this -> intermediaryBankName)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_NAME));
					$rtn = false;
				}

				// 中継銀行SWIFTのチェック
				if(!$this -> checkNull($this -> intermediaryBankSwift)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_SWIFT_CODE));
					$rtn = false;
				}

				// 中継銀行国のチェック
				if(!$this -> checkNull($this -> intermediaryBankCountry)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_COUNTRY));
					$rtn = false;
				}

				// 中継銀行住所1のチェック
				if(!$this -> checkNull($this -> intermediaryBankAddress1)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_ADDRESS_1));
					$rtn = false;
				}

				// 			$this -> intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2のチェック
				// 			$this -> intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージのチェック
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			// 金額の正規表現チェック
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 受取銀行SWIFTの正規表現チェック
			if(!$this -> checkStringAscii($this -> receiptBankSwift)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_BANK_SWIFT_CODE));
				$rtn = false;
			}

			// 受取銀行SWIFTの文字数チェック
			if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_8)) {
				if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_11)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH', array($this -> receiptBankSwift));
					$rtn = false;
				}
			}

			// 受取人住所1の正規表現チェック
			if(!$this -> checkStringAddress($this -> receiptAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_ADDRESS_1));
				$rtn = false;
			}

			// 受取銀行住所1の正規表現チェック
			if(!$this -> checkStringAddress($this -> receiptBankAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_BANK_ADDRESS_1));
				$rtn = false;
			}

			// 中継銀行のフラグが立っている場合
			if($this -> intermediaryFlg != NO_STRING) {

				// 受取銀行SWIFTの正規表現チェック
				if(!$this -> checkStringAscii($this -> intermediaryBankSwift)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_INTERMEDIARY_BANK_SWIFT_CODE));
					$rtn = false;
				}

				// 受取銀行SWIFTの文字数チェック
				if(!$this -> checkStringLength($this -> intermediaryBankSwift, VAL_INT_8)) {
					if(!$this -> checkStringLength($this -> intermediaryBankSwift, VAL_INT_11)) {
						$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH', array($this -> intermediaryBankSwift));
						$rtn = false;
					}
				}

				// 受取銀行住所1の正規表現チェック
				if(!$this -> checkStringAddress($this -> intermediaryBankAddress1)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_INTERMEDIARY_BANK_ADDRESS_1));
					$rtn = false;
				}
			}

// 			$this -> receiptAddress2			= NO_STRING;	// 受取人住所2のチェック
// 			$this -> receiptMessage				= NO_STRING;	// 受取人メッセージのチェック
// 			$this -> receiptBankAddress2		= NO_STRING;	// 受取銀行住所2のチェック

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件を取得する
	* @parameter	: なし
	* @return		: 検索条件
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtn = NO_STRING;

		// 送金先口座番号（検索項目）
		if($this -> sTransactionNumber != NO_STRING) {
			$rtn .= ' AND withdraw.transaction_number = (\')' . $this -> sTransactionNumber . '(\')';
		}

		// メールアドレス（検索項目）
		if($this -> sEmail != NO_STRING) {
			$rtn .= ' AND (users.user_name = (\')' . $this -> sEmail . '(\')'
							. ' OR users.mail = (\')' . $this -> sEmail . '(\')' . ')';
		}

		// 銀行データ（検索項目）
		if($this -> sBank != NO_STRING) {
			$rtn .= ' AND (withdraw.receipt_bank_name = (\')' . $this -> sBank . '(\')'
							. ' OR withdraw.receipt_bank_swift = (\')' . $this -> sBank . '(\')'
							. ' OR withdraw.intermediary_bank_name = (\')' . $this -> sBank . '(\')'
							. ' OR withdraw.intermediary_bank_swift = (\')' . $this -> sBank . '(\')'
							. ')';
		}

		// 送金先口座番号（検索項目）
		if($this -> sAccount != NO_STRING) {
			$rtn .= ' AND withdraw.account_number = (\')' . $this -> sAccount . '(\')';
		}

		// 銀行注文番号
		if($this -> sOrderNumber != NO_STRING) {
			$rtn .= ' AND withdraw.order_number = (\')' . $this -> sOrderNumber . '(\')';
		}

		// ステータス（検索項目）
		if($this -> sStatus != NO_STRING) {
			$rtn .= ' AND withdraw.status = (\')' . $this -> sStatus . '(\')';
		}
		if($this -> sTier != NO_STRING) {
			$rtn .= ' AND users.tier_tag = (\')' . $this -> sTier . '(\')';
		}

		// 通貨
		if($this -> sCurrency != NO_STRING) {
			$rtn .= ' AND withdraw.currency = (\')' . $this -> sCurrency . '(\')';
		}

		// 口座番号
		if($this -> sUserAccount != NO_STRING) {
			$rtn .= ' AND withdraw.user_account = (\')' . $this -> sUserAccount . '(\')';
		}

		// 送金額（最少）（検索項目）
		if($this -> sMinAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn .= ' AND withdraw.amount >= (\')' . $this -> sMinAmount . '(\')';
			} else {								// 通貨指定
				$rtn .= ' AND withdraw.amount >= (\')' . $this -> currencyToInt($this -> sMinAmount, $this -> sCurrency) . '(\')';
			}
		}

		// 送金額（最大）（検索項目）
		if($this -> sMaxAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn .= ' AND withdraw.amount <= (\')' . $this -> sMaxAmount . '(\')';
			} else {								// 通貨指定
				$rtn .= ' AND withdraw.amount <= (\')' . $this -> currencyToInt($this -> sMaxAmount, $this -> sCurrency) . '(\')';
			}
		}

		if($this -> sWithdrawFee != NO_STRING && $this -> sWithdrawFee == 'All' ){
			// $withdrawFee = $this -> getWithdrawFeeList();
			// foreach($withdrawFee as $fee => $feeValue){
			// 	$xy[] = 'LEFT(withdraw.transaction_number, 1) = (\')' . $feeValue . '(\')';
			// }
			// $rtn .= 'AND (' . implode(DELIMIT_OR, $xy) . ')';
			$rtn .= ' AND (LEFT(withdraw.transaction_number, 1) = (\')F(\')
					  OR LEFT(withdraw.transaction_number, 1) = (\')M(\'))';
		}

		if($this -> sWithdrawFee != NO_STRING && $this -> sWithdrawFee != 'All' && $this -> sWithdrawFee != 'Select') {
			$rtn .= ' AND LEFT(withdraw.transaction_number, 1) = (\')'. $this -> sWithdrawFee .'(\')';
		}

		if($this -> registFlg != NO_STRING){
			// 登録時刻（開始日）（検索項目）
			if($this -> sFrom != NO_STRING) {
				$rtn .= ' AND withdraw.create_time >= (\')' . $this -> sFrom . '(\')';
			}

			// 登録時刻（終了）（検索項目）
			if($this -> sTo != NO_STRING) {
				$rtn .= ' AND withdraw.create_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
			}
		}

		if($this -> processFlg != NO_STRING){
			// 登録時刻（開始日）（検索項目）
			if($this -> sProcessFrom != NO_STRING) {
				$rtn .= ' AND withdraw.process_time >= (\')' . $this -> sProcessFrom . '(\')';
			}

			// 登録時刻（終了）（検索項目）
			if($this -> sProcessTo != NO_STRING) {
				$rtn .= ' AND withdraw.process_time < DATE_ADD((\')' . $this -> sProcessTo . '(\'), INTERVAL 1 DAY)';
			}
		}

        if($this -> sWithdrawSolution != NO_STRING && $this -> sWithdrawSolution != 'All' &&  $this -> sWithdrawSolution != 'Select') {
			$rtn .= ' AND withdraw.withdraw_solution = (\')' . $this -> sWithdrawSolution . '(\')';
		}
		if($this -> sWithdrawSolution != NO_STRING && $this -> sWithdrawSolution == 'All' ){
			$rtn .= 'AND LEFT(withdraw.transaction_number, 1) = (\')W(\')';
		}

		if($this -> testAccountFlg != NO_STRING) {
			$rtn .= 'AND users.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}

		return $rtn;
	}


	public function getWhere_new() {

		// 変数宣言部
		$rtn = NO_STRING;

		// 送金先口座番号（検索項目）
		if($this -> sTransactionNumber != NO_STRING) {
			$rtn .= ' AND withdraw.transaction_number = (\')' . $this -> sTransactionNumber . '(\')';
		}

		// メールアドレス（検索項目）
		if($this -> sEmail != NO_STRING) {
			$rtn .= ' AND (users.user_name = (\')' . $this -> sEmail . '(\')'
							. ' OR users.mail = (\')' . $this -> sEmail . '(\')' . ')';
		}

		// 銀行データ（検索項目）
		if($this -> sBank != NO_STRING) {
			$rtn .= ' AND (withdraw.receipt_bank_name = (\')' . $this -> sBank . '(\')'
							. ' OR withdraw.receipt_bank_swift = (\')' . $this -> sBank . '(\')'
							. ' OR withdraw.intermediary_bank_name = (\')' . $this -> sBank . '(\')'
							. ' OR withdraw.intermediary_bank_swift = (\')' . $this -> sBank . '(\')'
							. ')';
		}

		// 送金先口座番号（検索項目）
		if($this -> sAccount != NO_STRING) {
			$rtn .= ' AND withdraw.account_number = (\')' . $this -> sAccount . '(\')';
		}

		// 銀行注文番号
		if($this -> sOrderNumber != NO_STRING) {
			$rtn .= ' AND withdraw.order_number = (\')' . $this -> sOrderNumber . '(\')';
		}

		// ステータス（検索項目）
		if($this -> sStatus != NO_STRING) {
			$rtn .= ' AND withdraw.status = (\')' . $this -> sStatus . '(\')';
		}
		if($this -> sTier != NO_STRING) {
			$rtn .= ' AND withdraw.tier_tag = (\')' . $this -> sTier . '(\')';
		}

		// 通貨
		if($this -> sCurrency != NO_STRING) {
			$rtn .= ' AND withdraw.currency = (\')' . $this -> sCurrency . '(\')';
		}

		// 口座番号
		if($this -> sUserAccount != NO_STRING) {
			$rtn .= ' AND withdraw.user_account = (\')' . $this -> sUserAccount . '(\')';
		}

		// 送金額（最少）（検索項目）
		if($this -> sMinAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn .= ' AND withdraw.amount >= (\')' . $this -> sMinAmount . '(\')';
			} else {								// 通貨指定
				$rtn .= ' AND withdraw.amount >= (\')' . $this -> currencyToInt($this -> sMinAmount, $this -> sCurrency) . '(\')';
			}
		}

		// 送金額（最大）（検索項目）
		if($this -> sMaxAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn .= ' AND withdraw.amount <= (\')' . $this -> sMaxAmount . '(\')';
			} else {								// 通貨指定
				$rtn .= ' AND withdraw.amount <= (\')' . $this -> currencyToInt($this -> sMaxAmount, $this -> sCurrency) . '(\')';
			}
		}

		if($this -> sWithdrawFee != NO_STRING && $this -> sWithdrawFee == 'All' ){
			// $withdrawFee = $this -> getWithdrawFeeList();
			// foreach($withdrawFee as $fee => $feeValue){
			// 	$xy[] = 'LEFT(withdraw.transaction_number, 1) = (\')' . $feeValue . '(\')';
			// }
			// $rtn .= 'AND (' . implode(DELIMIT_OR, $xy) . ')';
			$rtn .= ' AND (LEFT(withdraw.transaction_number, 1) = (\')F(\')
					  OR LEFT(withdraw.transaction_number, 1) = (\')M(\'))';
		}

		if($this -> sWithdrawFee != NO_STRING && $this -> sWithdrawFee != 'All' && $this -> sWithdrawFee != 'Select') {
			$rtn .= ' AND LEFT(withdraw.transaction_number, 1) = (\')'. $this -> sWithdrawFee .'(\')';
		}

		if($this -> registFlg != NO_STRING){
			// 登録時刻（開始日）（検索項目）
			if($this -> sFrom != NO_STRING) {
				$rtn .= ' AND withdraw.create_time >= (\')' . $this -> sFrom . '(\')';
			}

			// 登録時刻（終了）（検索項目）
			if($this -> sTo != NO_STRING) {
				$rtn .= ' AND withdraw.create_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
			}
		} else{
			$dateTo = strtotime("-1 year", time());
			$dateTo = date("Y/m/d", $dateTo);
			$dateFrom = date("Y/m/d");

			$rtn .= ' AND withdraw.create_time >= (\')' . $dateTo . '(\')';
			$rtn .= ' AND withdraw.create_time < DATE_ADD((\')' . $dateFrom . '(\'), INTERVAL 1 DAY)';
		}

		if($this -> processFlg != NO_STRING){
			// 登録時刻（開始日）（検索項目）
			if($this -> sProcessFrom != NO_STRING) {
				$rtn .= ' AND withdraw.process_time >= (\')' . $this -> sProcessFrom . '(\')';
			}

			// 登録時刻（終了）（検索項目）
			if($this -> sProcessTo != NO_STRING) {
				$rtn .= ' AND withdraw.process_time < DATE_ADD((\')' . $this -> sProcessTo . '(\'), INTERVAL 1 DAY)';
			}
		}

        if($this -> sWithdrawSolution != NO_STRING && $this -> sWithdrawSolution != 'All' &&  $this -> sWithdrawSolution != 'Select') {
			$rtn .= ' AND withdraw.withdraw_solution = (\')' . $this -> sWithdrawSolution . '(\')';
		}
		if($this -> sWithdrawSolution != NO_STRING && $this -> sWithdrawSolution == 'All' ){
			$rtn .= 'AND LEFT(withdraw.transaction_number, 1) = (\')W(\')';
		}

		if($this -> testAccountFlg != NO_STRING) {
			$rtn .= 'AND users.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$intermediary	= NO_STRING;
		$currency		= NO_STRING;
		$amount			= NO_STRING;
		$status			= NO_STRING;
		$statusClass	= NO_STRING;
		$fee			= NO_STRING;
		$feeRefund		= NO_STRING;
		$debitCurrency	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {



			// データの数だけループを回す
			$start		= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

				$row = $this -> getRowData($this -> rs, $cnt);

				if($this -> getColumnData($row, COLUMN_INTERMEDIARY_FLG) == VAL_INT_1) {
					$intermediary = VAL_STR_WITHDRAW_APPLIED;
				} else {
					$intermediary = VAL_STR_WITHDRAW_NOTAPPLIED;
				}

				// データを取得する
				$currency		= $this -> getColumnData($row, COLUMN_CURRENCY);
				$amount			= $this -> getColumnData($row, COLUMN_AMOUNT);
				$fee			= $this -> getColumnData($row, COLUMN_FEE);
				$feeRefund		= $this -> getColumnData($row, COLUMN_FEE_REFUND);
				$debitCurrency	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
				/*if($this ->getColumnData($row, COLUMN_STATUS) == 5){
					$feeRefund = $debitCurrency . DELIMIT_SPACE . '-' .$this -> getAmountString($fee, $debitCurrency);
				}else{
					$feeRefund = $debitCurrency . DELIMIT_SPACE . $this -> getAmountString($feeRefund, $debitCurrency);

				}*/


				// ステータス
				$status = $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS));
				if($this -> getColumnData($row, COLUMN_STATUS) == NO_COUNT
					|| $this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_1
					|| $this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_3) {		// 申請中、総気受付、不備確認中
					$statusClass = 'yellow';

				} else if($this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_2) {	// 送金済み
					$statusClass = 'blue';
				} else {																// 組戻し、取消、キャンセル
					$statusClass = 'red';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td><a href="javascript:void(0);" onclick="actionDetail(\'' . $this -> getColumnData($row, COLUMN_W_ID) . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</a></td>'
							// . '<td class=""><a href="javascript:userDetail(\'' . $row[COLUMN_USER_ACCOUNT] . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '</a></td>'
							. '<td class=""><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'</a></td>'
							. '<td>'. $this -> dispTierLevelCommon($this -> getColumnData($row, COLUMN_TIER_LEVEL)). '</td>'
							. '<td>' . $currency . '</td>'
							. '<td class="r">' . number_format($this -> intToCurrency($amount, $currency), $this -> getDigitCount($currency)) . '</td>'
// 							. '<td>' . $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER) . '</td>'
							. '<td class="l">' . $this -> getColumnData($row, COLUMN_RECEIPT_BANK_NAME) . '</td>'
							. '<td>' . $intermediary . '</td>'
							. '<td class="r">' . $debitCurrency . DELIMIT_SPACE . $this -> getAmountString($fee, $debitCurrency) . '</td>'
							. '<td class="r">' . $feeRefund = $debitCurrency . DELIMIT_SPACE . $this -> getAmountString($feeRefund, $debitCurrency) . '</td>'
							. '<td class="l">' . $this -> getColumnData($row, COLUMN_ORDER_NUMBER) . '</td>'
							. '<td class="l">' . $this -> getColumnData($row, COLUMN_PROCESS_USER_NAME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_PROCESS_TIME_STRING) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_RATE) . '</td>'
							. '<td><span class="' . $statusClass . '">' . $status . '</span></td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="14">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金IDの取得
	* @parameter	: なし
	* @return		: 出金ID
	-------------------------------------------------------------------------*/
	public function getWId() {
		return $this -> wId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金IDの表示
	* @parameter	: なし
	* @return		: 出金ID
	-------------------------------------------------------------------------*/
	public function echoWId() {
		echo $this -> wId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> getAmountString($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き出し通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getDrawCurrency() {
		return $this -> drawCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き出し通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function dispDrawCurrency() {
		echo $this -> dispCurrencyCommon($this -> drawCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き出し通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoDrawCurrency() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="draw_currency" name="draw_currency">' . $this -> dispCurrencyOptionList($this -> drawCurrency, false) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function dispCurrency() {
		echo $this -> dispCurrencyCommon($this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoCurrency() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="currency" name="currency">' . $this -> dispCurrencyOptionList($this -> currency, false) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座名義の取得
	* @parameter	: なし
	* @return		: 口座名義
	-------------------------------------------------------------------------*/
	public function echoAccountName() {
		echo $this -> accountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function getReceiptCountry() {
		return $this -> receiptCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function dispReceiptCountry() {
		echo $this -> dispCountryCommon($this -> receiptCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function echoReceiptCountry() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="receipt_country" name="receipt_country">' . $this -> dispCountryOptionList($this -> receiptCountry) . '</select>';

		echo $this -> dispCountryCommon($this -> receiptCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人住所1の取得
	* @parameter	: なし
	* @return		: 受取人住所1
	-------------------------------------------------------------------------*/
	public function echoReceiptAddress1() {
		echo $this -> receiptAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人住所2の取得
	* @parameter	: なし
	* @return		: 受取人住所2
	-------------------------------------------------------------------------*/
	public function echoReceiptAddress2() {
		echo $this -> receiptAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人メッセージの取得
	* @parameter	: なし
	* @return		: 受取人メッセージ
	-------------------------------------------------------------------------*/
	public function echoReceiptMessage() {
		echo $this -> receiptMessage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行名の取得
	* @parameter	: なし
	* @return		: 受取銀行名
	-------------------------------------------------------------------------*/
	public function echoReceiptBankName() {
		echo $this -> receiptBankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行支店コードの取得
	* @parameter	: なし
	* @return		: 受取銀行支店コード
	-------------------------------------------------------------------------*/
	public function echoReceiptBranchCode() {
		echo $this -> receiptBranchCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行支店名の取得
	* @parameter	: なし
	* @return		: 受取銀行名
	-------------------------------------------------------------------------*/
	public function echoReceiptBranchName() {
		echo $this -> receiptBranchName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行SWIFTの取得
	* @parameter	: なし
	* @return		: 受取銀行SWIFT
	-------------------------------------------------------------------------*/
	public function echoReceiptBankSwift() {
		echo $this -> receiptBankSwift;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行国の取得
	* @parameter	: なし
	* @return		: 受取銀行国
	-------------------------------------------------------------------------*/
	public function getReceiptBankCountry() {
		return $this -> receiptBankCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行の取得
	* @parameter	: なし
	* @return		: 受取銀行
	-------------------------------------------------------------------------*/
	public function dispReceiptBankCountry() {
		echo $this -> dispCountryCommon($this -> receiptBankCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行国の取得
	* @parameter	: なし
	* @return		: 受取銀行国
	-------------------------------------------------------------------------*/
	public function echoReceiptBankCountry() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="receipt_bank_country" name="receipt_bank_country">' . $this -> dispCountryOptionList($this -> receiptBankCountry) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行住所1の取得
	* @parameter	: なし
	* @return		: 受取銀行住所1
	-------------------------------------------------------------------------*/
	public function echoReceiptBankAddress1() {
		echo $this -> receiptBankAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行住所2の取得
	* @parameter	: なし
	* @return		: 受取銀行住所2
	-------------------------------------------------------------------------*/
	public function echoReceiptBankAddress2() {
		echo $this -> receiptBankAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行口座番号の取得
	* @parameter	: なし
	* @return		: 受取銀行口座番号
	-------------------------------------------------------------------------*/
	public function echoAccountNumber() {
		echo $this -> accountNumber;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function getIntermediaryFlg() {
		return $this -> intermediaryFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function echoIntermediaryFlg() {
		echo $this -> makeCheckOne(PARAM_INTERMEDIARY_FLG
									, PARAM_INTERMEDIARY_FLG
									, VAL_INT_1
									, '中継銀行を利用する'
									, $this -> intermediaryFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function dispIntermediaryFlg() {



		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> intermediaryFlg == VAL_INT_1) {
			$rtn = VAL_STR_WITHDRAW_APPLIEDIND;
		} else {
			$rtn = VAL_STR_WITHDRAW_NOTAPPLIEDIND;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行名の取得
	* @parameter	: なし
	* @return		: 中継銀行名
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankName() {
		echo $this -> intermediaryBankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行SWIFTの取得
	* @parameter	: なし
	* @return		: 中継銀行SWIFT
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankSwift() {
		echo $this -> intermediaryBankSwift;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function getIntermediaryBankCountry() {
		return $this -> intermediaryBankCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行の取得
	* @parameter	: なし
	* @return		: 中継銀行
	-------------------------------------------------------------------------*/
	public function dispIntermediaryBankCountry() {

		// 変数宣言部
		$status = NO_STRING;

		$status = $this -> dispCountryCommon($this -> intermediaryBankCountry);

		if($status == '無効') {
			$status = NO_STRING;
		}
		echo $status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankCountry() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="intermediary_bank_country" name="intermediary_bank_country">' . $this -> dispCountryOptionList($this -> intermediaryBankCountry) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行住所1の取得
	* @parameter	: なし
	* @return		: 中継銀行住所1
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankAddress1() {
		echo $this -> intermediaryBankAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行住所2の取得
	* @parameter	: なし
	* @return		: 中継銀行住所2
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankAddress2() {
		echo $this -> intermediaryBankAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行メッセージの取得
	* @parameter	: なし
	* @return		: 中継銀行メッセージ
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankMessage() {
		echo $this -> intermediaryBankMessage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の取得
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function getUserName() {
		return $this -> userName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の取得
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function echoUserName() {

		// 変数宣言部
		$rtn = NO_STRING;

		if(count($this -> user)) {
			$rtn = $this -> user[COLUMN_USER_NAME];
		}

		// echo $rtn;
		echo '<a href="account_edit?detail_account=' . $this -> userAccount . '" target="_blank">'. $this -> userName . '</a>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータスの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoStatus() {
		echo '<select id="status" name="status">' . $this -> dispListOption($this -> getWithdrawStatusList(), $this -> status) . '</select>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータス（検索用）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoSStatus() {
		echo $this -> dispListOption($this -> getWithdrawStatusList(), $this -> sStatus);
	}

	public function echoSTier() {
		echo $this -> dispListOption($this -> getTierStatusList(), $this -> sTier);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 組戻し手数料の取得
	* @parameter	: なし
	* @return		: 組戻し手数料
	-------------------------------------------------------------------------*/
	public function echoFeeRefund() {
		echo $this -> intToCurrency(intval($this -> feeRefund), $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: なし
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}





	/*-------------------------------------------------------------------------
	* @function_name: 注文番号の取得
	* @parameter	: なし
	* @return		: 注文番号
	-------------------------------------------------------------------------*/
	public function echoOrderNumber() {
		echo $this -> orderNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 備考の取得
	* @parameter	: なし
	* @return		: 備考
	-------------------------------------------------------------------------*/
	public function echoNote() {
		echo $this -> note;
	}










	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;				// ユーザ口座番号(1)
		$rtn[] = $this -> drawCurrency;				// 金額（引き出し口座）(2)
		$rtn[] = intval($this -> amount);			// 金額(3)
		$rtn[] = $this -> currency;					// 通貨(4)
		$rtn[] = $this -> accountName;				// 口座名義(5)
		$rtn[] = $this -> receiptCountry;			// 受取人国(6)
		$rtn[] = $this -> receiptAddress1;			// 受取人住所1(7)
		$rtn[] = $this -> receiptAddress2;			// 受取人住所2(8)
		$rtn[] = $this -> receiptMessage;			// 受取人メッセージ(9)
		$rtn[] = $this -> receiptBankName;			// 受取銀行名(10)
		$rtn[] = $this -> receiptBankSwift;			// 受取銀行SWIFT(11)
		$rtn[] = $this -> receiptBankCountry;		// 受取銀行国(12)
		$rtn[] = $this -> receiptBankAddress1;		// 受取銀行住所1(13)
		$rtn[] = $this -> receiptBankAddress2;		// 受取銀行住所2(14)
		$rtn[] = $this -> accountNumber;			// 受取銀行口座番号(15)
		$rtn[] = intval($this -> intermediaryFlg);	// 中継銀行フラグ(16)
		$rtn[] = $this -> intermediaryBankName;		// 中継銀行名(17)
		$rtn[] = $this -> intermediaryBankSwift;	// 中継銀行SWIFT(18)
		$rtn[] = $this -> intermediaryBankCountry;	// 中継銀行国(19)
		$rtn[] = $this -> intermediaryBankAddress1;	// 中継銀行住所1(20)
		$rtn[] = $this -> intermediaryBankAddress2;	// 中継銀行住所2(21)
		$rtn[] = $this -> intermediaryBankMessage;	// 中継銀行メッセージ(22)

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータス更新用のデータを取得
	* @parameter	: なし
	* @return		: ステータス更新用データ
	-------------------------------------------------------------------------*/
	public function getUpdateStatus() {

		// 変数宣言部
		$rtn		= array();
		$fee		= null;
		$amount		= NO_COUNT;
		$currency	= NO_COUNT;
		$feeRefund	= NO_COUNT;

		// 差戻しの場合
// 		if($this -> status == VAL_INT_4) {

// 			$amount		= $this -> getColumnData($this -> detail, COLUMN_DEBIT_AMOUNT);
// 			$currency	= $this -> getColumnData($this -> detail, COLUMN_DEBIT_CURRENCY);

// 			// 手数料の取得
// 			$fee = $this -> getFeeCommon(VAR_WITHDRAW_REFUND
// 										, $this -> intToCurrency($amount, $currency)
// 										, $currency
// 										, $this -> getColumnData($this -> detail, COLUMN_USER_ACCOUNT));

// 			$feeRefund = $this -> currencyToInt($fee[$currency . VAL_INT_1], $currency);
// 		}

		$rtn[] = $this -> wId;															// 出金ID
		$rtn[] = $this -> status;														// ステータス
		$rtn[] = $this -> getAdminUserData(PARAM_USER_ACCOUNT);							// 担当者口座番号
		$rtn[] = $this -> currencyToInt($this -> feeRefund, $this -> debitCurrency);	// 出金失敗時の手数料

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 備考更新用のデータを取得
	* @parameter	: なし
	* @return		: 備考更新用データ
	-------------------------------------------------------------------------*/
	public function getUpdateOrderNumAndNote() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> wId;			// 出金ID
		$rtn[] = $this -> orderNumber;	// ステータス
		$rtn[] = $this -> note;			// 担当者口座番号

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	public function setTotal($rs) {
		$this -> total = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function getResult() {
		return $this -> rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: iwallet口座番号の設定
	* @parameter	: iwallet口座番号
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUserAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: iwallet口座番号の取得
	* @parameter	: なし
	* @return		: iwallet口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落し通貨の取得
	* @parameter	: なし
	* @return		: 引き落し通貨
	-------------------------------------------------------------------------*/
	public function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落し金額の取得
	* @parameter	: なし
	* @return		: 引き落し金額
	-------------------------------------------------------------------------*/
	public function dispDebitAmount() {
		echo $this -> getAmountString($this -> debitAmount, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: レートの取得
	* @parameter	: なし
	* @return		: レート
	-------------------------------------------------------------------------*/
	public function echoRate() {
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料
	-------------------------------------------------------------------------*/
	public function dispFee() {
		echo $this -> getAmountString($this -> fee, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 差戻し手数料の取得
	* @parameter	: なし
	* @return		: 差戻し手数料
	-------------------------------------------------------------------------*/
	public function dispFeeRefund() {
		echo $this -> getAmountString($this -> feeRefund, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレス（検索項目）の取得
	* @parameter	: なし
	* @return		: メールアドレス（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSEmail() {
		echo $this -> sEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号（検索項目）の取得
	* @parameter	: なし
	* @return		: 口座番号（検索項目）
	 -------------------------------------------------------------------------*/
	public function echoSUserAccount() {
		echo $this -> sUserAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 完了データ（検索項目）の取得
	* @parameter	: なし
	* @return		: 完了データ（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSCompletion() {
		echo $this -> sCompletion;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行データ（検索項目）の取得
	* @parameter	: なし
	* @return		: 銀行データ（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSBank() {
		echo $this -> sBank;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先口座番号（検索項目）の取得
	* @parameter	: なし
	* @return		: 送金先口座番号（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSAccount() {
		echo $this -> sAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行送金番号（検索項目）の取得
	* @parameter	: なし
	* @return		: 銀行送金番号（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSOrderNumber() {
		echo $this -> sOrderNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータス（検索項目）の取得
	* @parameter	: なし
	* @return		: ステータス（検索項目）
	-------------------------------------------------------------------------*/
	public function dispSStatus() {
		echo '<select name="s_status">' . $this -> dispWithdrawStatusOptionList($this -> sStatus) . '</select>';
	}

	public function dispSTier() {
		echo '<select name="s_status">' . $this -> dispTierOptionList($this -> sTier) . '</select>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金額（最少）（検索項目）の取得
	* @parameter	: なし
	* @return		: 送金額（最少）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSMinAmount() {
		echo $this -> sMinAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金額（最大）（検索項目）の取得
	* @parameter	: なし
	* @return		: 送金額（最大）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSMaxAmount() {
		echo $this -> sMaxAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録時刻（開始日）（検索項目）の取得
	* @parameter	: なし
	* @return		: 登録時刻（開始日）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録時刻（終了）（検索項目）の取得
	* @parameter	: なし
	* @return		: 登録時刻（終了）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoCurrencyList() {

		// 変数宣言部
		$lists	= array();

		if($this -> isLoopData($this -> currencies)) {

			foreach($this -> currencies as $row) {
				$lists[] = array(PARAM_DATA_KEY			=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME)
									, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME));
			}
		}

		echo $this -> dispListOption($lists, $this -> sCurrency);
	}

	public function echoTotalList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$lists		= array();
		$counter	= NO_STRING;
		$data		= NO_STRING;
		$cName		= NO_STRING;
		$amount		= NO_STRING;

		// データを入れ替える
		if($this -> isLoopData($this -> total)) {
			foreach($this -> total as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		foreach($this -> currencies as $row) {

			if(isset($lists[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)])) {

				$cName	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$amount	= $this -> getColumnData($lists[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)], COLUMN_AMOUNT);

				$counter	= number_format($this -> getColumnData($lists[$cName], COLUMN_USER_ACCOUNT));
				$data		= number_format($this -> intToCurrency($amount, $cName), $this -> getDigitCount($cName));
			} else {
				$counter	= NO_COUNT;
				$data		= number_format(NO_COUNT, $this -> getColumnData($row, COLUMN_DIGIT));

			}

			$rtn .=	'<tr>'
					. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY_NAME) . '</td>'
					. '<td>' . $counter . '</td>'
					. '<td class="r">' . $data . '</td>'
					. '</tr>';
		}

		echo $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 詳細データの設定
	* @parameter	: 詳細データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setDetail($rs) {
		$this -> detail = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨データの設定
	* @parameter	: 通貨データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING
										, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: エクスポートデータの作成
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function makeExportData() {

		// 変数宣言部
		$data				= NO_STRING;
		$arr				= null;
		$intermediaryFlg	= NO_STRING;



		// まずはタイトル
		$data = '申請時間,アカウント名,メールアドレス,ティアレベル,口座カテゴリー,取引番号,送金通貨,送金額,出金通貨,出金額,為替レート,口座名義,受取人国,住所,メッセージ,受取銀行名,受取銀行支店コード,受取銀行支店名,SWIFTコード,受取銀行国,受取銀行住所,口座番号,中継銀行の利用,中継銀行名,SWIFTコード,中継銀行国,中継銀行住所,中継銀行メッセージ,送金手数料,差戻し手数料,出金ステータス,銀行伝票番号,処理時間,処理担当,備考' . "\n";

		if($this -> lang == "en"){
			$data = 'Application Time,Account name,Email Address,Tier Level,Account Category,Transaction Number,Remitter Currency,Remittance Amount,Withdrawal Currency,Withdrawal Amount,Exchange Rate,Account Name,Country of Receiver,Address,Message,Beneficiary Bank Name,Branch Code of Beneficiary Bank,Branch Name of Beneficiary Bank,SWIFT Code,Country of Beneficiary Bank,Address of Beneficiary Bank,Account Number,Use of Correspondent Bank,Correspondent Bank,SWIFT Code,Country of Correspondent,Address of Correspondent Bank,Message of Correspondent Bank,Withdrawal Processing Fee,Remittance Returned Processing Fee,Withdrawal Status,Bank Slip Number,Processing Date,Person-In-Charge,Note' . "\n";
		}

		// データの存在確認
		if($this -> isLoopData($this -> rs)) {

			foreach($this -> rs as $row) {

				// 配列の初期化
				$arr = array();

				// 中継銀行フラグ
				if($this -> getColumnData($row, COLUMN_INTERMEDIARY_FLG) == NO_COUNT) {
					$intermediaryFlg = 'N';
				} else {
					$intermediaryFlg = 'Y';
				}

                $branchCodeString = $this -> getColumnData($row, COLUMN_RECEIPT_BANK_BRANCH_CODE);
                //check if flat 3
                if($this -> getColumnData($row, COLUMN_WITHDRAW_SOLUTION) == 'Flat3'){
                    //branch code and bank code
                    $codeArray = unserialize($this -> getColumnData($row, COLUMN_RECEIPT_BANK_BRANCH_CODE));
                    $branchCodeString = NO_STRING;
                    foreach($codeArray as $key => $val){
                        $branchCodeString .= $key . '=' . $val. ' ';
                    }
                }

				// データの設定
				$arr[] = $this -> getColumnData($row, COLUMN_CREATE_TIME);																					// 申請時間
				$arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);																					// アカウント名
				$arr[] = $this -> getColumnData($row, COLUMN_MAIL);																							// メールアドレス
				$arr[] = $this -> dispTierLevelCommon($this -> getColumnData($row, COLUMN_TIER_LEVEL));																					// メールアドレス
				$arr[] = $this -> getValueByList($this -> getTestAccountList(), $this -> getColumnData($row, COLUMN_TEST_ACCOUNT_FLG));
				$arr[] = $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);																			// 取引番号
				$arr[] = $this -> getColumnData($row, COLUMN_CURRENCY);																						// 送金通貨
				$arr[] = $this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));				// 送金額
				$arr[] = $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);																				// 出金通貨
				$arr[] = $this -> intToCurrency($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY));	// 出金額
				$arr[] = $this -> getColumnData($row, COLUMN_RATE);																							// 為替レート
				$arr[] = $this -> getColumnData($row, COLUMN_ACCOUNT_NAME);																					// 口座名義
				$arr[] = $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_RECEIPT_COUNTRY));													// 受取人国
				$arr[] = $this -> getColumnData($row, COLUMN_RECEIPT_ADDRESS_1);																			// 住所
				$arr[] = $this -> getColumnData($row, COLUMN_RECEIPT_MESSAGE);																				// メッセージ
				$arr[] = $this -> getColumnData($row, COLUMN_RECEIPT_BANK_NAME);																			// 受取銀行名
				$arr[] = $branchCodeString;																		                                            // 受取銀行支店コード
				$arr[] = $this -> getColumnData($row, COLUMN_RECEIPT_BANK_BRANCH_NAME);																		// 受取銀行支店名
				$arr[] = $this -> getColumnData($row, COLUMN_RECEIPT_BANK_SWIFT);																			// SWIFTコード
				$arr[] = $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_RECEIPT_BANK_COUNTRY));												// 受取銀行国
				$arr[] = $this -> getColumnData($row, COLUMN_RECEIPT_BANK_ADDRESS_1);																		// 受取銀行住所
				$arr[] = $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER);																				// 口座番号
				$arr[] = $intermediaryFlg;																													// 中継銀行の利用
				$arr[] = $this -> getColumnData($row, COLUMN_INTERMEDIARY_BANK_NAME);																		// 中継銀行名
				$arr[] = $this -> getColumnData($row, COLUMN_INTERMEDIARY_BANK_SWIFT);																		// SWIFTコード
				$arr[] = $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_INTERMEDIARY_BANK_COUNTRY));										// 中継銀行国
				$arr[] = $this -> getColumnData($row, COLUMN_INTERMEDIARY_BANK_ADDRESS_1);																	// 中継銀行住所
				$arr[] = $this -> getColumnData($row, COLUMN_INTERMEDIARY_BANK_MESSAGE);																	// 中継銀行メッセージ
				$arr[] = $this -> intToCurrency($this -> getColumnData($row, COLUMN_FEE), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY));				// 送金手数料
				$arr[] = $this -> intToCurrency($this -> getColumnData($row, COLUMN_FEE_REFUND), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY));		// 差戻し手数料
				$arr[] = $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS));													// 出金ステータス
				$arr[] = $this -> getColumnData($row, COLUMN_ORDER_NUMBER);																					// 送金注文番号
				$arr[] = $this -> getColumnData($row, COLUMN_PROCESS_TIME);																					// 処理時間
				$arr[] = $this -> getColumnData($row, COLUMN_PROCESS_USER_NAME);																			// 処理担当
				$arr[] = preg_replace("/\s+/", " ", $this -> getColumnData($row, COLUMN_NOTE));															// 備考

				$data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
			}
		}

		// 共通項目へデータをセット
		$this -> setExportDataCommon($data);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 是否发送邮件
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function takeMail(){

		//发送邮件
		if( $this -> receiptBankName == TYPE_LOCAL_BACK_IDENTIFICATION ){

			$rs = $this -> accessSelect('SELECT_WITHDRAW_LOCAL_MAIL_MANUAL', array($this -> wId));
			foreach ($rs as $key => $value) {
				$data_new = time();
				$date = date("Y-m-d h:i:s",$data_new);
			    $mail        = $value[PARAM_MAIL];
			    $mailparam[] = $value[PARAM_USER_ACCOUNT];
			    $mailparam[] = $value[PARAM_ACCOUNT_NAME];
			    $mailparam[] = $date;
			    $lang        = $value['lang'];

			    //修改成成功出金
			    if ($this -> status  == VAL_INT_2) {
			        $mailparam[] = $value[PARAM_DRAW_CURRENCY];
			        $mailparam[] = $this -> getAmountString($this -> amount, $this -> currency);
			        $mailxml     = 'withdraw_local_bank_success.xml';

			    //修改成出金失败
			    }  else if ( $this -> status == VAL_INT_5 ) {
			        $mailxml = 'withdraw_local_bank_failed.xml';
			    }
			}

			$this -> sendMailByTmpFromManual($mailxml
			    , $mailparam
			    , $mail
			    , VAR_CS_MAIL_ADDRESS
			    , $lang);
		}
	}

    /*-------------------------------------------------------------------------
	* @function_name: getWithdrawSolutionList
	* @parameter	:
	* @return		: array() - list of withdraw solutions
	*
	* 2019/04/16
	* anton
	-------------------------------------------------------------------------*/
    function getWithdrawSolutionList(){
        $rtn = array('Select','All', 'International', 'SDPay', 'Flat3', 'H2P');
        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: getSelectedWithdrawfee
	* @parameter	:
	* @return		: string - selected withdraw fee
	-------------------------------------------------------------------------*/
    function getSelectedWithdrawFee(){
        return $this -> sWithdrawFee;
    }

    /*-------------------------------------------------------------------------
	* @function_name: getWithdrawFeeList
	* @parameter	:
	* @return		: array() - list of withdraw fee
	-------------------------------------------------------------------------*/
    function getWithdrawFeeList(){
        $rtn = array('Select'=>'Select', 'All'=>'All', VAL_STR_DORMANCY=>'F', VAL_STR_MONTH_MAINTENANCE=>'M');
        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: getSelectedWithdrawSolution
	* @parameter	:
	* @return		: string - selected withdraw solution
	-------------------------------------------------------------------------*/
    function getSelectedWithdrawSolution(){
        return $this -> sWithdrawSolution;
    }

    /*-------------------------------------------------------------------------
	* @function_name: getFlat3Result
	* @parameter	:
	* @return		: array - flat 3 result
	-------------------------------------------------------------------------*/
    function getFlat3Result(){
        return $this -> flat3result;
    }

	function echoTestAccountFlg() {
		echo $this -> dispListOption($this -> getTestAccountList(), $this -> testAccountFlg);
	}

    /*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoFlat3Preview() {

		// 変数宣言部
		$rtn			      = NO_STRING;
        $bankCode             = NO_STRING;
        $branchName           = NO_STRING;
        $branchCode           = NO_STRING;
        $depositType          = "普通口座";
        $applicationDate      = NO_STRING;
        $branchCodeArray      = null;

		if($this -> isLoopData($this -> flat3result)) {

			foreach($this -> flat3result as $key => $details){
                    $branchCodeArray = unserialize($details[COLUMN_RECEIPT_BANK_BRANCH_CODE]);
                    $branchCode      = $branchCodeArray['Branch Code'];
                    $bankCode        = $branchCodeArray['Bank Code'];
                    $applicationDate = date('Y/m/d', strtotime($details[COLUMN_CREATE_TIME]));


				$rtn	.= '<tr>'
							. '<td class=""><a href="javascript:userDetail(\'' . $details[COLUMN_USER_ACCOUNT] . '\', \'_blank\');">' . $details[COLUMN_USER_ACCOUNT] . '</a></td>'
							. '<td>' . $details[COLUMN_RECEIPT_BANK_NAME] . '</td>'
							. '<td>' . $bankCode . '</td>'
							. '<td>' . $details[COLUMN_RECEIPT_BANK_BRANCH_NAME] . '</td>'
							. '<td>' . $branchCode . '</td>'
 							. '<td>' . $depositType . '</td>'
							. '<td>' . $details[COLUMN_ACCOUNT_NUMBER] . '</td>'
							. '<td>' . $details[COLUMN_ACCOUNT_NAME] . '</td>'
							. '<td>' . $details[COLUMN_CURRENCY] . DELIMIT_SPACE . $details[COLUMN_AMOUNT] . '</td>'
							. '<td>' . $applicationDate . '</td>'
							. '</tr>';
            }

		} else {
			$rtn = '<tr><td colspan="14">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispRegistFlg
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispRegistFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_S_APPLY_FLG
											, PARAM_S_APPLY_FLG
											, VAL_INT_1
											, NO_STRING, $this -> registFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispProcessFlg
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispProcessFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_S_PROCESS_FLG
											, PARAM_S_PROCESS_FLG
											, VAL_INT_1
											, NO_STRING, $this -> processFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoSProcessFrom
	* @parameter	: none
	* @return		: process date
	-------------------------------------------------------------------------*/
	public function echoSProcessFrom() {
		echo $this -> sProcessFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoSProcessFrom
	* @parameter	: none
	* @return		: process date
	-------------------------------------------------------------------------*/
	public function echoSProcessTo() {
		echo $this -> sProcessTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function dispWithdrawRadio() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$list	= $this -> getWithdrawType();

		foreach($list as $val) {
			$rtn .= '<br>' . $this -> makeRadioOne(PARAM_S_WITHDRAW_TYPE . $this -> getColumnData($val, PARAM_DATA_KEY)
														, PARAM_S_WITHDRAW_TYPE
														, $this -> getColumnData($val, PARAM_DATA_KEY)
														, $this -> sWithdrawType)
					. $this -> getColumnData($val, PARAM_DATA_VALUE) . '</br>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoTransactionNumber
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoTransactionNumber() {
		echo $this -> tNumber;
	}


	/*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getActivity(){

		$id 			= $this -> wId;
		$details 		= array();
		$type 			= $this -> getType();
		$newStatus 		= $this -> status;
		$newOrderNumber = $this -> orderNumber;
		$newNote 		= $this -> note;
   		$row 		 	= $this -> accessSelect('SELECT_WITHDRAW_ID', array($id));
   		$tNumber 		= $this -> getColumnData($row[0], COLUMN_TRANSACTION_NUMBER);
   		$oldStatus 		= $this -> getColumnData($row[0], COLUMN_STATUS);
   		$oldOrderNumber = $this -> getColumnData($row[0], COLUMN_ORDER_NUMBER);
   		$oldNote 		= $this -> getColumnData($row[0], COLUMN_NOTE);


   		if($type == TYPE_SAVE){
   			if($oldStatus != $newStatus){
   				$details[] = ' status from ['.$this -> dispWithdrawStatusCommon($oldStatus).'] to ['.$this -> dispWithdrawStatusCommon($newStatus).']';
   			}

   			if($oldOrderNumber != $newOrderNumber){
   				$details[] = ' order number from ['.$oldOrderNumber.'] to ['.$newOrderNumber.']';
   			}

   			if($oldNote != $newNote){
   				$details[] = ' note from ['.$oldNote.'] to ['.$newNote.']';
   			}

   			if($details != NULL){
   				$message = 'Edited '. $tNumber . implode(', ', $details);
   			}else{
   				$message = 'Saved without any changes';
   			}
   		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 16;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}

}
?>