<?php

use Aws\Ses\SesClient;
use Aws\Exception\AwsException;
use Aws\Exception\CredentialsException;

class AWSMangoMailer {
    
    private $sender_email = 'cs@iwl.world';
    private $sesClient;
    private $altName = NO_STRING;
    
    public function __construct(){
        $this -> sesClient = new SesClient([
            'version' => '2010-12-01',
            'region'  => 'eu-west-1',
            'credentials' => [
                'key' => 'AKIAXB5DZ67EBHJXJLVL',
                'secret' => '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'
            ]
        ]);
    } 
    
    /**
     * 
     * sets new sender email.
     * 
     * @param String $sender_email
     */
    public function setSenderEmail(String $sender_email){
        $this -> sender_email;    
        return $this;
    }
    
    public function setAltName(String $altName){
        $this -> altName = $altName;
        return $this;
    }

    /**
     * 
     * when the message is successfully sent. this method will return a message id.
     * 
     * @param array $recipientEmails
     * @param String $subject
     * @param String $htmlBody
     * @param String $plainTextBody
     * @param string $charSet
     * @param bool $errorTrace
     * @return \Aws\Result|boolean
     */
    public function sendEmail(Array $recipientEmails, 
        String $subject, 
        String $plainTextBody, 
        $charSet = "UTF-8", 
        bool $errorTrace = false){
        
        try {
            $senderLabelFormat = "iWallet Customer Support <{$this -> sender_email}>";
            
            if(!empty($this -> altName))
                $senderLabelFormat = "{$this -> altName} <{$this -> sender_email}>";
            
            $result = $this -> sesClient ->sendEmail([
                'Destination' => [
                    'ToAddresses' => $recipientEmails,
                ],
                'ReplyToAddresses' => [$this -> sender_email],
                'Source' => $senderLabelFormat,
                'Message' => [
                    'Body' => [
                        'Text' => [
                            'Charset' => $charSet,
                            'Data' => $plainTextBody,
                        ],
                    ],
                    'Subject' => [
                        'Charset' => $charSet,
                        'Data' => $subject,
                    ],
                ],
            ]);
            
            return $result['MessageId'];
        } catch (AwsException $e) {
            if($errorTrace){
                // output error message if fails
                echo $e->getMessage();
                echo("The email was not sent. Error message: {$e->getAwsErrorMessage()}\n");
                echo "\n";
            }
        } catch(CredentialsException $e) {
            if($errorTrace){
                // output error message if fails
                echo $e->getMessage();
                echo "\n";
            }
        }
        
        return false;
    }
}