﻿<?php
class SupportModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $user			= null;			// ユーザ情報
	private $userAccount	= NO_STRING;	// 口座番号
	private $accountType	= NO_STRING;	// 口座種別
	private $email			= NO_STRING;	// メールアドレス
	private $reEmail		= NO_STRING;	// メールアドレス（再入力）
	private $name			= NO_STRING;	// 名前
	private $manager		= NO_STRING;	// 担当者名
	private $title			= NO_STRING;	// 件名
	private $body			= NO_STRING;	// 本分

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> accountType	= $this -> getDataPost(PARAM_ACCOUNT_TYPE);	// 口座種別
		$this -> email			= $this -> getDataPost(PARAM_EMAIL);		// メールアドレス
		$this -> reEmail		= $this -> getDataPost(PARAM_RE_EMAIL);		// メールアドレス（再入力）

		if($this -> accountType == NO_STRING
			|| $this -> accountType == NO_COUNT) {
			$this -> name		= $this -> getDataPost(PARAM_NAME_PER);		// 名前（個人）
		} else {
			$this -> name		= $this -> getDataPost(PARAM_NAME_CORP);	// 名前（法人）
		}

		$this -> manager		= $this -> getDataPost(PARAM_MANAGER_NAME);	// 担当者名
		$this -> title			= $this -> getDataPost(PARAM_TITLE);		// 件名
		$this -> body			= $this -> getDataPost(PARAM_BODY);			// 本分
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// 確認の場合
		if($this -> getType() == TYPE_CONFIRM) {

			// 必須項目
			// メールアドレス
			if(!$this -> checkNull($this -> email)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL));
				$rtn = false;
			}

			// メールアドレス（再入力）
			if(!$this -> checkNull($this -> reEmail)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL_RE_ENTER));
				$rtn = false;
			}

			// 名前
			if(!$this -> checkNull($this -> name)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_NAME_CORP));
				$rtn = false;
			}

			// 法人の場合のみ
			if($this -> accountType == VAR_CORP) {

				// 担当者名
				if(!$this -> checkNull($this -> manager)) {
					$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RESPONSIBLE_PARTY_NAME));
					$rtn = false;
				}
			}

			// 件名
			if(!$this -> checkNull($this -> title)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TITLE));
				$rtn = false;
			}

			// 本文
			if(!$this -> checkNull($this -> body)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_BODY));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			////////////// メールアドレス //////////////

			// 正規表現
			if(!$this -> checkStringMailAddress($this -> email)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_MANAGER_EMAIL));
				$rtn = false;
			}

			// 複合チェック
			if($this -> email != $this -> reEmail) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_SAME_DATA', array(VAL_STR_EMAIL, VAL_STR_EMAIL_RE_ENTER));
				$rtn = false;
			}

			////////////// メールアドレス //////////////

			////////////// 名前 //////////////

			if(!$this -> checkLength($this -> name
									, VAL_INT_1
									, VAL_INT_64)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_NAME_CORP
																					, VAL_INT_1
																					, VAL_INT_64));
				$rtn = false;
			}

			////////////// 名前 //////////////

			////////////// ご担当者名 //////////////

			// 法人の場合のみ
			if($this -> accountType == VAR_CORP) {

				if(!$this -> checkLength($this -> manager
										, VAL_INT_1
										, VAL_INT_64)) {
					$this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_RESPONSIBLE_PARTY_NAME
																						, VAL_INT_1
																						, VAL_INT_64));
					$rtn = false;
				}
			}

			////////////// ご担当者名 //////////////

			////////////// 件名 //////////////

			if(!$this -> checkLength($this -> title
										, VAL_INT_1
										, VAL_INT_128)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_INQUIRY . VAL_STR_TITLE
																					, VAL_INT_1
																					, VAL_INT_128));
				$rtn = false;
			}

			////////////// 件名 //////////////

			////////////// 本文 //////////////

			if(!$this -> checkLength($this -> body
									, VAL_INT_1
									, VAL_INT_500)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_INQUIRY . VAL_STR_BODY
																					, VAL_INT_1
																					, VAL_INT_500));
				$rtn = false;
			}

			////////////// 本文 //////////////

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// 送金元口座番号
		$rtn[] = $this -> fromCurrency;													// 送金元通貨
		$rtn[] = $this -> toAccount;													// 送金先口座番号
		$rtn[] = $this -> toCurrency;													// 送金先通貨
		$rtn[] = $this -> currencyToInt($this -> total, $this -> toCurrency);			// 金額
		$rtn[] = $this -> transferType;													// 送金方法
		$rtn[] = $this -> message;														// メッセージ
		$rtn[] = $this -> fromCurrency;													// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> fromCurrency);	// 送金金額
		$rtn[] = $this -> rate;															// レート

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	 -------------------------------------------------------------------------*/
	function echoAccountType() {
		echo $this -> accountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispAccountType() {

		// 変数宣言部
		$rtn = NO_STRING;
		$list = $this -> getAccountTypeList();

		// デフォルト値
		if($this -> accountType == NO_STRING) {
			$this -> accountType = NO_COUNT;
		}

		if($this -> isLoopData($list)) {
			foreach($list as $row) {
				$rtn .= '<li><a><label>'
						. $this -> makeRadioOne(PARAM_ACCOUNT_TYPE . $row[PARAM_DATA_KEY]
												, PARAM_ACCOUNT_TYPE
												, $row[PARAM_DATA_KEY]
												, $this -> accountType)
						. DELIMIT_SPACE . $row[PARAM_DATA_VALUE]
						. '</label></a></li>&emsp;';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function echoEmail() {
		echo $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function getEmail() {
		return $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレス（再入力）の取得
	* @parameter	: なし
	* @return		: メールアドレス（再入力）
	-------------------------------------------------------------------------*/
	function echoReEmail() {
		echo $this -> reEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名前の取得
	* @parameter	: なし
	* @return		: 名前
	-------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 担当者名の取得
	* @parameter	: なし
	* @return		: 担当者名
	-------------------------------------------------------------------------*/
	function echoManager() {
		echo $this -> manager;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 件名の取得
	* @parameter	: なし
	* @return		: 件名
	-------------------------------------------------------------------------*/
	function echoTitle() {
		echo $this -> title;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本文の取得
	* @parameter	: なし
	* @return		: 本文
	-------------------------------------------------------------------------*/
	function echoBody() {
		echo $this -> body;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本文の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispBody() {
		echo nl2br($this -> body);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispAccountTypeString() {
		if(strpos($_SERVER['REQUEST_URI'], 'id') !== false){
			echo VAL_STR_CUSTOMER ." ". $this -> getValueByList($this -> getAccountTypeList(), $this -> accountType);
		}else{
			echo $this -> getValueByList($this -> getAccountTypeList(), $this -> accountType)." ". VAL_STR_CUSTOMER;
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispConfirm() {

		// 変数宣言部
		$rtn = NO_STRING;

		// 口座種別による振り分け
		if($this -> accountType == VAR_PERSON) {
			$rtn =	'<div class="form-group row info-section">'
					. '<label class="col-sm-3 info-label" for="inquiry-content">' . VAL_STR_FULL_NAME . ' </label>'
					. '<div class="col-sm-9 input-box">'
					. $this -> name
					. '</div>'
					. '</div>';

		} else {
			$rtn =	'<div class="form-group row info-section">'
					. '<label class="col-sm-3 info-label" for="inquiry-content">' . VAL_STR_COPR_NAME . ' </label>'
					. '<div class="col-sm-9 input-box">'
					. $this -> name
					. '</div>'
					. '</div>'
					. '<div class="form-group row info-section">'
					. '<label class="col-sm-3 info-label" for="inquiry-content">' . VAL_STR_RESPONSIBLE_PARTY_NAME . ' </label>'
					. '<div class="col-sm-9 input-box">'
					. $this -> manager
					. '</div>'
					. '</div>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispInput() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> userAccount != NO_STRING) {	// ログイン済み

			$rtn =	'<div class="form-group row info-section">'
					. '<label class="col-sm-3 info-label" for="email">' . VAL_STR_EMAIL . ' <span id="required" class="required">*</span></label>'
					. '<div class="col-sm-9 input-box">' . $this -> email
					. '</div>'
					. '</div>'
					. '<input type="hidden" name="re_email" value="' . $this -> email . '" />'
					. '<input type="hidden" name="email" value="' . $this -> email . '" />';

		} else {								// 未ログイン

			$rtn =	'<div class="form-group row info-section">'
					. '<label class="col-sm-3 info-label" for="email">' . VAL_STR_EMAIL . ' <span id="required" class="required">*</span></label>'
					. '<div class="col-sm-9 input-box">'
					. '<input type="email" name="email" value="' . $this -> email . '" class="form-control w50p">'
					. '</div>'
					. '</div>'
					. '<div class="form-group row info-section">'
					. '<label class="col-sm-3 info-label" for="email">' . VAL_STR_MAILADDRESS_RE_ENTER . ' <span id="required" class="required">*</span></label>'
					. '<div class="col-sm-9 input-box">'
					. '<input type="email" name="re_email" value="' . $this -> reEmail . '" class="form-control w50p">'
					. '</div>'
					. '</div>';

		}

		echo $rtn;
	}



	/*-------------------------------------------------------------------------
	* @function_name: メール送信用パラメータ（管理者用）の取得
	* @parameter	: ユーザ情報
	* @return		: メール送信用パラメータ
	-------------------------------------------------------------------------*/
	function getSendParamsForAdmin($rs) {

		// 変数宣言部
		$rtn	= array();
		$row	= null;

		// 口座情報があるか否か
		if($this -> isLoopData($rs)) {	// データが存在する

			$row = $this -> getRowData($rs);
			$rtn[]	= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);

		} else {						// データが存在しない
			$rtn[]	= $this -> email;
		}

		$rtn[]	= $this -> title;
		$rtn[]	= $this -> getValueByList($this -> getAccountTypeList(), $this -> accountType);
		$rtn[]	= $this -> name;
		$rtn[]	= $this -> manager;
		$rtn[]	= $this -> body;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信用パラメータ（ユーザ用）の取得
	* @parameter	: ユーザ情報
	* @return		: メール送信用パラメータ
	-------------------------------------------------------------------------*/
	function getSendParamsForUser($rs) {

		// 変数宣言部
		$rtn	= array();
		$row	= null;

		// 口座情報があるか否か
		if($this -> isLoopData($rs)) {	// データが存在する

			$row = $this -> getRowData($rs);
			$rtn[]	= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
			$rtn[]	= $this -> getColumnData($row, COLUMN_FIRST_NAME)
						. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);

		} else {						// データが存在しない
			$rtn[]	= $this -> email;
			$rtn[]	= $this -> name;
		}

		$rtn[]	= $this -> title;
		$rtn[]	= $this -> body;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ情報を設定する
	* @parameter	: ユーザ情報
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setUserData($row) {
		$this -> user = $row;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function restore() {

		if($this -> isLoopData($this -> user)) {	// データが存在する

			$this -> userAccount	= $this -> getColumnData($this -> user, COLUMN_USER_ACCOUNT);
			$this -> accountType	= $this -> getColumnData($this -> user, COLUMN_ACCOUNT_TYPE);
			$this -> email			= $this -> getColumnData($this -> user, COLUMN_MAIL);
			$this -> reEmail		= $this -> getColumnData($this -> user, COLUMN_MAIL);

			if($this -> accountType == VAR_PERSON) {	// 個人口座の場合
				$this -> name		= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME)
										. DELIMIT_SPACE . $this -> getColumnData($this -> user, COLUMN_LAST_NAME);

			} else {									// 法人口座の場合
				$this -> name		= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME);
			}

		} else {									// データが存在しない
		}
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: Zendeskのローカルコード
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getZendeskLocaleCode() {
	    switch($this -> getLangage()){
	        case "ja":
	            return 67;
	        case "tc":
	            return 9;
	        case "sc":
	            return 10;
	        case "id":
	            return 77;
	        case "en":
	        default:
	            return 1;
	    }
	}
}
?>
