<?php
class SendModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $account		= NO_STRING;	// 送金先アカウント
	private $amount			= NO_STRING;	// 送金額
	private $sendMessage	= NO_STRING;	// 送金メッセージ

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> account		= $this -> getDataPost(PARAM_ACCOUNT);	// 送金先アカウント
		$this -> amount			= $this -> getDataPost(PARAM_AMOUNT);	// 送金額
		$this -> sendMessage	= $this -> getDataPost(PARAM_MESSAGE);	// 送金メッセージ
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		if($this -> getType() == TYPE_INPUT) {

			// 口座の存在確認
			if(!$this -> existAccount($this -> account)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$this -> setType(CONTROL_ACTION);
				$rtn = false;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先アカウントの取得
	* @parameter	: なし
	* @return		: 送金先アカウント
	-------------------------------------------------------------------------*/
	public function echoAccount() {
		echo $this -> account;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金金額の取得
	* @parameter	: なし
	* @return		: 送金金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金メッセージの取得
	* @parameter	: なし
	* @return		: 送金メッセージ
	-------------------------------------------------------------------------*/
	public function echoSendMessage() {
		echo $this -> sendMessage;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 登録用データ配列
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// 送金元口座番号
		$rtn[] = $this -> account;							// 送金先口座番号
		$rtn[] = $this -> amount;							// 送金金額
		$rtn[] = $this -> sendMessage;						// 送金メッセージ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}
}
?>