<?php
require_once(SITE_LOGICS . 'api/model.php');

class LogicApi extends ApiModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr	= NO_STRING;	// 表示用HTML文字列
	private $msg		= NO_STRING;	// 表示用HTMLメッセージ
	private $result		= true;			// 実行結果

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		// 変数宣言部

		try {

			// 初期データ処理
			if(!$this -> init()) {
				return false;
			}

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() == CONTROL_SETTING_CHANGE_MAIL) {		// メール変更画面
			$this -> changeMail();
		} else if($this -> getMethod() == CONTROL_VER_REGIST) {		// 新規口座開設認証
			$this -> verification();
		} else if($this -> getMethod() == CONTROL_RE_SEND) {		// 新規口座開設認証メール再送信
			$this -> verReSend();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの変更
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function changeMail() {

		// 変数宣言部
		$id			= NO_STRING;
		$rs			= null;
		$row		= null;
		$params		= array();
		$account	= null;
		$data		= null;
		$sendParams	= array();

		// 申請データの取得
		$rs			= $this -> accessSelect('SELECT_CHANGE_MAIL', array($this -> getDataGet(PARAM_ID)));
		$row		= $this -> getRowData($rs);

		// パラメータの作成
		if($this -> getColumnData($row, COLUMN_CHICKET) == NO_STRING) {
			$this -> msg = $this -> getMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_DATA));
			return;
		}

		if(intval($this -> getColumnData($row, COLUMN_DIFF_TIME) >= NO_COUNT)) {
			$this -> msg = $this -> getMessage(ERROR, 'E_ERROR_EXPIRATION_DATE', array());
			return;
		}

		// チェックOKの場合はアカウントデータを取得する
		$account	= $this -> getAccountCommon($this -> getColumnData($row, COLUMN_USER_ACCOUNT));
		$data 		= $this -> getRowData($account);

		// パラメータの設定
		$params[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
		$params[] = $this -> getColumnData($row, COLUMN_MAIL);

		// データの変更
		$this -> accessModify('UPDATE_USER_EMAIL', $params);		// ユーザテーブル更新

		// ログイン情報の更新
		$params		= array();
		$params[]	= $this -> getColumnData($data, COLUMN_UID);
		$params[]	= $this -> getColumnData($row, COLUMN_MAIL);

 		$this -> accessModify('UPDATE_LOGIN_USER_NAME', $params);	// ログインテーブル更新


		// メール送信用のパラメータ作成
		$sendParams[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);	// 口座番号
		$sendParams[] = $this -> getCurrentTimeCommon();					// 現在時刻
		$sendParams[] = $this -> getColumnData($data, COLUMN_MAIL);			// 旧メール
		$sendParams[] = $this -> getColumnData($row, COLUMN_MAIL);			// 新メール

		// 完了メールの送信
		$this -> sendMailByTmp('change_mail_complete_for_admin.xml'
								, $sendParams
								, VAR_NOTICE_MAIL_ADDRESS
								, VAR_NOTICE_MAIL_ADDRESS);

		$this -> msg = $this -> getMessage(INFO, 'I_COMPLETE_CHANGE_EMAIL', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 新規口座開設認証
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function verification() {

		// 変数宣言部
		$flg	= true;
		$uId	= NO_STRING;
		$rs		= null;
		$row	= null;

		// データの取得
		$rs = $this -> accessSelect('SELECT_USER_OF_VERIFCATION', array($this -> id));

		// データの存在確認
		if(count($rs) != VAL_INT_1) {
			$this -> msg	=	'<p class="red">' . $this -> getMessage(ERROR, 'E_DIDNT_OPEN_ACCOUNT', array()) . '</p>';
			$this -> result = false;
		}

		if($this -> result) {
			$row = $this -> getRowData($rs);

			// ステータスの確認
			if($this -> getColumnData($row, COLUMN_STATUS) > VAL_INT_1) {
				$this -> msg	=	'<p class="red">' . $this -> getMessage(ERROR, 'E_DID_OPEN_ACCOUNT', array()) . '</p>';
				$this -> result = false;
			}
		}

		if($this -> result) {

			// 有効期限の確認（10日間）
			if($this -> getColumnData($row, COLUMN_DIFF_TIME) >= VAL_INT_240) {
				$this -> msg =	'<p class="red">' . $this -> getMessage(ERROR, 'E_ERROR_EXPIRATION_DATE', array()) . '<br/>'
								. $this -> getMessage(ERROR, 'E_PLEASE_CONTACT_US', array()) . '</p>';
				$this -> result = false;
			}
		}

		if($this -> result) {

			// 最後までOK
			$this -> accessModify('UPDATE_USER_STATUS', array($this -> getColumnData($row, COLUMN_USER_ACCOUNT), VAL_INT_2), false);

			// 登録完了メールの送信
			$this -> sendChangePasswordCommon($this -> getColumnData($row, COLUMN_USER_ACCOUNT), 'regist_password_complete.xml');

			$this -> msg =	NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
 	* @function_name: 新規口座開設認証メール再送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function verReSend() {

		// 変数宣言部
		$rs		= null;
		$row	= null;

		// データを取得する
		$rs = $this -> accessSelect('SELECT_USER_BY_ACCOUNT_OR_EMAIL', array($this -> id));

		// データの時間更新
		$this -> accessModify('UPDATE_VERI_DATE', array($this -> id));

		$row = $this -> getRowData($rs);

		// 開設メール送信（共通）
		$this -> sendRegistMailCommon($this -> getColumnData($row, COLUMN_USER_ACCOUNT));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果メッセージの取得
	* @parameter	: なし
	* @return		: 結果メッセージ
	-------------------------------------------------------------------------*/
	function echoResultMsg() {
		echo $this -> msg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 実行結果の取得
	* @parameter	: なし
	* @return		: 実行結果
	-------------------------------------------------------------------------*/
	function getResult() {
		return $this -> result;
	}

}
?>