<?php
require_once('config.php');
require_once('CheckWithdrawBase.php');

class APIUploadKYCDocument extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $img1Flg					= NO_COUNT;	// 画像1フラグ
	private $img2Flg					= NO_COUNT;	// 画像2フラグ
	private $img3Flg					= NO_COUNT;	// 画像3フラグ
	private $img4Flg					= NO_COUNT;	// 画像4フラグ
	private $img5Flg					= NO_COUNT;	// 画像5フラグ
	private $img6Flg					= NO_COUNT;	// 画像6フラグ
	private $img7Flg					= NO_COUNT;	// 画像7フラグ
	private $img8Flg					= NO_COUNT;	// 画像8フラグ
	private $img9Flg					= NO_COUNT;	// 画像9フラグ
	private $img10Flg					= NO_COUNT;	// 画像10フラグ
	private $img11Flg					= NO_COUNT;	// 画像11フラグ

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$param		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE, false, true);
			$this -> account					= $this -> getDataPost(PARAM_USER_ACCOUNT, true, true);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'K' . $this -> account);
			}

			// チェックク
			$this -> validate();

			$this -> upload();























			echo json_encode(array('result'			=> 'OK'
								, 'messages'		=> 'I_COMPLETE_PROCESS'
								, 'debit_currency'	=> $this -> debitCurrency
								, 'debit_amount'	=> $base -> getDebitAmount()
								, 'rate'			=> $base -> getRateEx()
								, 'fee'				=> $base -> getFeeEx(), $this -> debitCurrency));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// ユーザデータの取得
		$account = $this -> getRowData($this -> getAccountCommon($this -> account));

		// 州・都道府県
		// 市区町村
		// 住所
		// 郵便番号
		// 電話番号が空欄の場合はデータの転送
		if($this -> getColumnData($account, PARAM_STATE)	== NO_STRING
		|| $this -> getColumnData($account, PARAM_CITY)		== NO_STRING
		|| $this -> getColumnData($account, PARAM_ADDRESS)	== NO_STRING
		|| $this -> getColumnData($account, PARAM_ZIP_CODE)	== NO_STRING
		|| $this -> getColumnData($account, PARAM_TEL)		== NO_STRING) {
			throw new Exception('W_NOT_ADDRESS');
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ファイルのアップロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function upload() {

		// 変数宣言部
		$path		= NO_STRING;
		$saveName	= NO_STRING;
		$oldName	= NO_STRING;
		$uploads	= array();
		$cnt		= NO_COUNT;
		$id			= NO_COUNT;

		$path = SYSTEM_DOCUMENT_KYC . $this -> account;

		// 該当ディレクトリの確認
		if(!file_exists($path)) {
			mkdir($path, 0777);
		} else {
			chmod($path, 0777);
		}

		// 画像11個の登録とアップロードファイルのセーブ
		for($cnt = VAL_INT_1; $cnt <= VAL_INT_11; $cnt++) {

			// 画像の存在確認
			if($this -> isUpload(PARAM_IMG . $cnt)) {

				// 保存ファイル名
				$info		= new SplFileInfo($_FILES[PARAM_IMG . $cnt][PARAM_NAME]);
				$saveName	= $this -> createUId() . DELIMIT_DOT . $info -> getExtension();

				// 画像の移動
				if(move_uploaded_file($_FILES[PARAM_IMG . $cnt][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

					// アップロードファイル名
					$oldName	= basename($_FILES[PARAM_IMG . $cnt][PARAM_NAME]);
					$imgFlg		= $this -> getImgFlg($cnt);

					// ファイルパーミッションの変更
					chmod($path . DELIMIT_SLASH . $saveName, 0777);

					// データの登録
					$this -> accessModify('INSERT_KYC', array($this -> account
																, $oldName
																, $saveName
																, $imgFlg
																, NO_COUNT
																, NO_COUNT)
																, false);

					// 書類種類の取得
					if($cnt <= VAL_INT_3) {
						$id = NO_COUNT;
					} else if($cnt <= VAL_INT_6) {
						$id = VAL_INT_1;
					} else {
						$id = $cnt - VAL_INT_5;
					}

					if($this -> getColumnData($uploads, $id) == NO_STRING) {
						$uploads[$id] = array($oldName);
					} else {
						$uploads[$id][] = $oldName;
					}
				}
			}
		}

		// アップロードが完了したら一旦認証フラグを落とす
		if($flg) {
			$this -> accessModify('UPDATE_KYC_FLG', array($this -> account, NO_COUNT), false);
		}

		// アップロードファイルが存在したらメールを送信する
		if($this -> isLoopData($uploads)) {

			// 送信用パラメータの作成
			$imgs		= array();
			$params		= array();
			$params[]	= $this -> account;
			$params[]	= $this -> getCurrentTimeCommon();
			$dest		= NO_STRING;

			// アップロードファイルのリスト化
			foreach($uploads as $key => $val) {

				$str	= $this -> dispIdentityTypeCommon($key);
				$imgs	= array();

				foreach($val as $val) {
					$imgs[] = $val;
				}

				$dest .= "\n" . $str . DELIMIT_COLON . DELIMIT_SPACE
							. implode(DELIMIT_COMMA . DELIMIT_SPACE, $imgs);
			}

			$params[]	= $dest;

			// メールの送信（管理者側）
			$this -> sendMailByTmp('kyc_upload_for_admin.xml'
									, $params
									, VAR_NOTICE_MAIL_ADDRESS
									, VAR_NOTICE_MAIL_ADDRESS);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ファイルフラグ
	* @parameter	: なし
	* @return		: アップロードフラグ
	-------------------------------------------------------------------------*/
	function getImgFlg($index) {

		// 変数宣言部
		$rtn = NO_COUNT;

		if($index == VAL_INT_1) {	// 画像ファイル1フラグ
			$rtn = $this -> img1Flg;

		} else if($index == VAL_INT_2) {	// 画像ファイル2フラグ
			$rtn = $this -> img2Flg;

		} else if($index == VAL_INT_3) {	// 画像ファイル3フラグ
			$rtn = $this -> img3Flg;

		} else if($index == VAL_INT_4) {	// 画像ファイル4フラグ
			$rtn = $this -> img4Flg;

		} else if($index == VAL_INT_5) {	// 画像ファイル5フラグ
			$rtn = $this -> img5Flg;

		} else if($index == VAL_INT_6) {	// 画像ファイル6フラグ
			$rtn = $this -> img6Flg;

		} else if($index == VAL_INT_7) {	// 画像ファイル7フラグ
			$rtn = $this -> img7Flg;

		} else if($index == VAL_INT_8) {	// 画像ファイル8フラグ
			$rtn = $this -> img8Flg;

		} else if($index == VAL_INT_9) {	// 画像ファイル9フラグ
			$rtn = $this -> img9Flg;

		} else if($index == VAL_INT_10) {	// 画像ファイル10フラグ
			$rtn = $this -> img10Flg;

		} else if($index == VAL_INT_11) {	// 画像ファイル11フラグ
			$rtn = $this -> img11Flg;
		}

		return $rtn;
	}
}

$api = new APIMakeWithdraw();
$api -> action();
?>