<?php
require_once('config.php');

class APICheckWithdrawBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $accountName				= NO_STRING;	// 口座名義
	private $receiptCountry				= NO_STRING;	// 受取人国
	private $receiptAddress1			= NO_STRING;	// 受取人住所1
	private $receiptAddress2			= NO_STRING;	// 受取人住所2
	private $tel						= NO_STRING;	// 電話番号
	private $receiptMessage				= NO_STRING;	// 受取人メッセージ
	private $receiptBankName			= NO_STRING;	// 受取銀行名
	private $receiptBankSwift			= NO_STRING;	// 受取銀行SWIFT
	private $receiptBankCountry			= NO_STRING;	// 受取銀行国
	private $receiptBranchCode			= NO_STRING;	// 受取銀行支店コード
	private $receiptBranchName			= NO_STRING;	// 受取銀行支店名
	private $receiptBankAddress1		= NO_STRING;	// 受取銀行住所1
	private $receiptBankAddress2		= NO_STRING;	// 受取銀行住所2
	private $accountNumber				= NO_STRING;	// 受取銀行口座番号
	private $intermediaryFlg			= NO_STRING;	// 中継銀行フラグ
	private $intermediaryBankName		= NO_STRING;	// 中継銀行名
	private $intermediaryBankSwift		= NO_STRING;	// 中継銀行SWIFT
	private $intermediaryBankCountry	= NO_STRING;	// 中継銀行国
	private $intermediaryBankAddress1	= NO_STRING;	// 中継銀行住所1
	private $intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2
	private $intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージ
	private $fromCurrency				= NO_STRING;	// From通貨
	private $debitCurrency				= NO_STRING;	// 引落通貨
	private $debitAmount				= NO_STRING;	// 引落金額

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account					= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> currency					= $this -> getDataPost(PARAM_CURRENCY);								// 通貨
			$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);								// 金額
			$this -> accountName				= $this -> getDataPost(PARAM_ACCOUNT_NAME);							// 口座名義
			$this -> receiptCountry				= $this -> getDataPost(PARAM_RECEIPT_COUNTRY);						// 受取人国
			$this -> receiptAddress1			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_1);					// 受取人住所1
			$this -> receiptAddress2			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_2);					// 受取人住所2
			$this -> tel						= $this -> getDataPost(PARAM_TEL);									// 電話番号
			$this -> receiptMessage				= $this -> getDataPost(PARAM_RECEIPT_MESSAGE);						// 受取人メッセージ
			$this -> receiptBankName			= $this -> getDataPost(PARAM_RECEIPT_BANK_NAME);					// 受取銀行名
			$this -> receiptBankSwift			= $this -> getDataPost(PARAM_RECEIPT_BANK_SWIFT);					// 受取銀行SWIFT
			$this -> receiptBankCountry			= $this -> getDataPost(PARAM_RECEIPT_COUNTRY);						// 受取銀行国
			$this -> receiptBranchCode			= $this -> getDataPost(PARAM_RECEIPT_BRANCH_CODE);					// 受取銀行支店コード
			$this -> receiptBranchName			= $this -> getDataPost(PARAM_RECEIPT_BRANCH_NAME);					// 受取銀行支店名
			$this -> receiptBankAddress1		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_1);				// 受取銀行住所1
			$this -> receiptBankAddress2		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_2);				// 受取銀行住所2
			$this -> accountNumber				= $this -> getDataPost(PARAM_ACCOUNT_NUMBER);						// 受取銀行口座番号
			$this -> intermediaryFlg			= $this -> getDataPost(PARAM_INTERMEDIARY_FLG);						// 中継銀行フラグ
			$this -> intermediaryBankName		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_NAME);				// 中継銀行名
			$this -> intermediaryBankSwift		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_SWIFT);				// 中継銀行SWIFT
			$this -> intermediaryBankCountry	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_COUNTRY);			// 中継銀行国
			$this -> intermediaryBankAddress1	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_1);			// 中継銀行住所1
			$this -> intermediaryBankAddress2	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_2);			// 中継銀行住所2
			$this -> intermediaryBankMessage	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_MESSAGE);			// 中継銀行メッセージ
			$this -> fromCurrency				= strtoupper($this -> getDataPost(PARAM_DEBIT_CURRENCY));			// From通貨
			$this -> debitCurrency				= strtoupper($this -> getDataPost(PARAM_DEBIT_CURRENCY));			// 引落通貨
			$this -> debitAmount				= $this -> getDataPost(PARAM_DEBIT_AMOUNT);							// 引落金額

			// エラーチェック
			$this -> validate();

			return true;

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs			= array();
		$fromCurrency	= NO_STRING;
		$toCurrency		= NO_STRING;
		$divFlg			= NO_STRING;
		$check			= NO_STRING;
		$digit			= NO_STRING;

		try {

			// 口座ステータスチェック
			if(!$this -> checkAccountStatus($this -> account, VAR_TRANSACTION_WITHDRAW)) {
				throw new Exception('E_INVALID_ACCOUNT_STATUS');
			}

			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 口座名義のチェック
			if(!$this -> checkNull($this -> accountName)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 受取人国のチェック
			if(!$this -> checkNull($this -> receiptCountry)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 受取人住所1のチェック
			if(!$this -> checkNull($this -> receiptAddress1)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 受取銀行名のチェック
			if(!$this -> checkNull($this -> receiptBankName)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			if($this -> receiptBankCountry == VAR_JP) {

				// 支店コードのチェック
				if(!$this -> checkNull($this -> receiptBranchCode)) {
					throw new Exception('E_REQUIRED_VALUE');
				}

				// 支店名のチェック
				if(!$this -> checkNull($this -> receiptBranchName)) {
					throw new Exception('E_REQUIRED_VALUE');
				}
			}

			// 受取銀行SWIFTのチェック
			if(!$this -> checkNull($this -> receiptBankSwift)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 受取銀行国のチェック
			if(!$this -> checkNull($this -> receiptBankCountry)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 受取銀行住所1のチェック
			if(!$this -> checkNull($this -> receiptBankAddress1)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 受取銀行口座番号のチェック
			if(!$this -> checkNull($this -> accountNumber)) {
				throw new Exception('E_REQUIRED_VALUE');
			} else if(!$this -> checkLength($this -> accountNumber, VAL_INT_1, VAL_INT_50)) {
				throw new Exception('E_ERROR_STRING_LENGTH_ANY');
			}

			// 必須項目
			// debit口座のチェック
			if(!$this -> checkNull($this -> fromCurrency)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 中継銀行のフラグが立っている場合
			if($this -> intermediaryFlg != NO_STRING) {

				// 中継銀行名のチェック
				if(!$this -> checkNull($this -> intermediaryBankName)) {
					throw new Exception('E_REQUIRED_VALUE');
				}

				// 中継銀行SWIFTのチェック
				if(!$this -> checkNull($this -> intermediaryBankSwift)) {
					throw new Exception('E_REQUIRED_VALUE');
				}

				// 中継銀行国のチェック
				if(!$this -> checkNull($this -> intermediaryBankCountry)) {
					throw new Exception('E_REQUIRED_VALUE');
				}

				// 中継銀行住所1のチェック
				if(!$this -> checkNull($this -> intermediaryBankAddress1)) {
					throw new Exception('E_REQUIRED_VALUE');
				}
			}

			// 金額の正規表現チェック
			if(!$this -> checkStringNumber($this -> amount)) {
				throw new Exception('E_ERROR_REGULAR_NUMBER');
			}

			// 口座名義の正規表現チェック
			if(!$this -> checkStringAscii($this -> accountNumber)) {
				throw new Exception('E_ERROR_REGULAR_ASCII');
			}

			// 口座名義の正規表現チェック
			if(!$this -> checkStringAsciiAndSpace($this -> accountName)) {
				throw new Exception('E_ERROR_REGULAR_ASCII');
			}

			if($this -> receiptBankCountry == VAR_JP) {

				// 支店コードの正規表現チェック
				if(!$this -> checkStringNumberOnly($this -> receiptBranchCode)) {
					throw new Exception('E_ERROR_VALUE_PREG');
				}
			}

			// 受取銀行名の文字数チェック
			if(!$this -> checkLength($this -> receiptBankName
									, VAL_INT_1
									, VAL_INT_100)) {
				throw new Exception('E_ERROR_STRING_LENGTH_ANY');
			}

			// 受取銀行SWIFTの正規表現チェック
			if(!$this -> checkStringAscii($this -> receiptBankSwift)) {
				throw new Exception('E_ERROR_REGULAR_ASCII');
			}

			// 受取銀行SWIFTの文字数チェック
			if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_8)) {
				if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_11)) {
					throw new Exception('E_ERROR_STRING_LENGTH');
				}
			}

			// 受取人住所1の正規表現チェック
			if(!$this -> checkStringWithdraw($this -> receiptAddress1)) {
				throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
			}

			// 受取銀行住所1の正規表現チェック
			if(!$this -> checkStringWithdraw($this -> receiptBankAddress1)) {
				throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
			}

			// 銀行名の正規表現チェック
			if(!$this -> checkStringWithdraw($this -> receiptBankName)) {
				throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
			}

			// メッセージが入力されていたら、チェック開始
			if($this -> receiptMessage != NO_STRING) {
				if(!$this -> checkStringWithdraw($this -> receiptMessage)) {
					throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
				}
			}

			// 中継銀行のフラグが立っている場合
			if($this -> intermediaryFlg != NO_STRING) {

				// 銀行名の正規表現チェック
				if(!$this -> checkStringWithdraw($this -> intermediaryBankName)) {
					throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
				}

				// 受取銀行SWIFTの正規表現チェック
				if(!$this -> checkStringAscii($this -> intermediaryBankSwift)) {
					throw new Exception('E_ERROR_REGULAR_ASCII');
				}

				// 受取銀行SWIFTの文字数チェック
				if(!$this -> checkStringLength($this -> intermediaryBankSwift, VAL_INT_8)) {
					if(!$this -> checkStringLength($this -> intermediaryBankSwift, VAL_INT_11)) {
						throw new Exception('E_ERROR_STRING_LENGTH');
					}
				}

				// 中継銀行名の文字数チェック
				if(!$this -> checkLength($this -> intermediaryBankName
										, VAL_INT_1
										, VAL_INT_100)) {
					throw new Exception('E_ERROR_STRING_LENGTH_ANY');
				}

				// 受取銀行住所1の正規表現チェック
				if(!$this -> checkStringWithdraw($this -> intermediaryBankAddress1)) {
					throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
				}

				// 中継銀行メッセージが入力されていたら、チェック開始
				if($this -> intermediaryBankMessage != NO_STRING) {
					if(!$this -> checkStringWithdraw($this -> intermediaryBankMessage)) {
						throw new Exception('E_ERROR_REGULAR_ASCII_WITHDRAW');
					}
				}
			}

			// 制限口座のチェック(1回あたりの送金時)
			if(!$this -> checkWithdrawLimitOneTimes($this -> account
													, $this -> currency
													, floatval($this -> amount))) {
				throw new Exception('E_LIMIT_WITHDRAW_ONE_TIME');
			}

			// 残高のチェック
			$balance			= $this -> getBalanceCommon($this -> account, $this -> fromCurrency);
			$fee				= $this -> getFeeCommon(VAR_WITHDRAW_SUCCESS
														, $this -> amount
														, $this -> currency
														, $this -> getUserData(PARAM_USER_ACCOUNT));

			$feeExchange		= $this -> getExchangeCommon($fee[$this -> currency . VAL_INT_1]
															, $this -> currency
															, $this -> fromCurrency);

			// バランスと（送金額 + 手数料）のチェック
			if($this -> fromCurrency == USD) {
				$this -> setFeeEx($fee[USD . VAL_INT_1]);
			} else {
				$this -> setFeeEx($feeExchange[PARAM_AMOUNT]);
			}

			$this -> setAgent1Ex($fee[PARAM_AGENT_CODE . VAL_INT_1]);

			$exchange	= $this -> getExchangeCommon($this -> amount
													, $this -> currency
													, $this -> fromCurrency
													, false
													, true);

			$total = ($exchange[PARAM_AMOUNT] + $this -> getFeeEx());
			$this -> setRateEx($exchange[PARAM_RATE]);

			if(NO_COUNT >= $this -> amount) {
				throw new Exception('E_ERROR_VALUE_AMOUNT');
			} else if($balance < $total) {
				throw new Exception('E_INSUFFICIENT_FUNDS');
			}

			// 最低額のチェック
			if(!$this -> checkMinimum($this -> currency, $this -> amount)) {
				throw new Exception('E_ERROR_AMOUNT');
			}

			if($this -> currency != $this -> fromCurrency) {
				if(!$this -> checkMinimum($this -> fromCurrency, $exchange[PARAM_AMOUNT])) {
					throw new Exception('E_ERROR_AMOUNT');
				}
			}

			// 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> account, $this -> currency, $this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$this -> setType(TYPE_BACK);
				return;
			}

			// 引落口座の設定
			$this -> debitCurrency	= $this -> fromCurrency;
			$this -> debitAmount	= $exchange[PARAM_AMOUNT];

			if(NO_COUNT >= $this -> amount) {
				throw new Exception('E_ERROR_VALUE_AMOUNT');
			} else if($balance < $total) {
				throw new Exception('E_INSUFFICIENT_FUNDS');
			}

			// 最低額のチェック
			if(!$this -> checkMinimum($this -> currency, $this -> amount)) {
				throw new Exception('E_ERROR_AMOUNT');
			}

			if($this -> currency != $this -> fromCurrency) {
				if(!$this -> checkMinimum($this -> fromCurrency, $exchange[PARAM_AMOUNT])) {
					throw new Exception('E_ERROR_AMOUNT');
				}
			}

			if(count($msgs) > NO_COUNT) {
				throw new Exception(implode(DELIMIT_COMMA, $msgs));
			}
		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金通貨の取得
	* @parameter	: なし
	* @return		: 送金通貨
	-------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金金額の取得
	* @parameter	: なし
	* @return		: 送金金額
	-------------------------------------------------------------------------*/
	public function getAmount() {
		return $this -> amount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 引き落とし通貨の取得
	* @parameter	: なし
	* @return		: 引き落とし通貨
	-------------------------------------------------------------------------*/
	public function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし金額の取得
	* @parameter	: なし
	* @return		: 引き落とし金額
	-------------------------------------------------------------------------*/
	public function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	public function getRate() {
		return $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function getOriginalAmount() {
		return $this -> originalAmount;
	}

}
?>