<?php
require_once(SYSTEM_LOGICS . 'withdraw/model.php');

class LogicWithdraw extends WithdrawModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType() == TYPE_COMPLETE) {				// 出金データの登録
					$this -> regist();
					$this -> lists();

				} else if($this -> getType() == TYPE_INPUT) {			// 出金データの入力
					$this -> select();

				} else if($this -> getType() == TYPE_CONFIRM) {			// 出金データの確認
					$this -> select();

				} else if($this -> getType() == TYPE_DETAIL) {			// 出金データの詳細
					$this -> selectDetail();
					$this -> restore();

				} else if($this -> getType() == TYPE_SAVE) {			// 出金ステータスの更新
					$this -> insertActivity();
					$this -> selectDetail();
					$this -> save();
					$this -> selectDetail();
					$this -> restore();
					$this -> takeMail();

				} else if($this -> getType() == TYPE_EXPORT) {			// エクスポート
					$this -> lists();
					$this -> makeFile();

				} else if($this -> getType() == TYPE_EXPORT_COMMON) {	// エクスポート
					$this -> lists();
					$this -> makeExportData();

				} else if($this -> getType() == TYPE_EXPORT_FLAT3) {	// flat3 export
					$this -> makeFlat3ExportData();

				} else if($this -> getType() == TYPE_SEARCH) {			// 検索
					$this -> lists();

				} else if($this -> getType() == TYPE_DELETE) {
				    $this -> insertActivity();
				    $this -> deleteTransaction();
				    $this -> lists();
				} else {												// その他
					$this -> lists();
				}

				$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		//remove _REVISED if want to use the old query - mark
		$this -> setResult($this -> accessSelect('LIST_WITHDRAW_REVISED', array($this -> getWhere(), "withdraw.create_time DESC")));
		$this -> setTotal($this -> accessSelect('LIST_WITHDRAW_TOTAL', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
		$this -> setUser($this -> accessSelect('SELECT_ACCOUNT', array($this -> setUserAccount())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function selectDetail() {
		$this -> setDetail($this -> accessSelect('SELECT_WITHDRAW', array($this -> getWId())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金の登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_WITHDRAW', $this -> getRegistData());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータスの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function save() {

		$this -> accessModify('UPDATE_WITHDRAW_STATUS', $this -> getUpdateStatus(), false);				// ステータス

		$this -> accessModify('UPDATE_WITHDRAW_ORDER_NOTE', $this -> getUpdateOrderNumAndNote(), false);	// 注文番号と備考

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引削除
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function deleteTransaction() {	    
	    $this -> accessModify('COPY_WITHDRAW_TRANSACTION', $this -> getDetailData());
	    $this -> accessModify('DELETE_WITHDRAW_TRANSACTION', $this -> getDetailData());
	    
	    $this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: エクスポート用のファイルを作成する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function makeFile() {

		// 変数宣言部
		$path			= NO_STRING;	// ファイルパス
		$fp 			= null;			// ファイルポインタ
		$rs 			= null;			// 結果セット
		$rowValues		= null;			// 表示データ
		$intermediary	= NO_STRING;	// 中継銀行

		// ファイルパス
		$path = SYSTEM_DOCUMENT_WITHDRAW . date('Ymd') . '.csv';

		// ファイルポインタの取得
		$fp = fopen($path, 'w+');

		// 結果セットの取得
		$rs = $this -> getResult();

		// タイトル行
		fputs($fp, '申請時間,アカウント名,金額,銀行口座,銀行名,SWIFT,中継銀行,ステータス' . "\n");

		// データの数だけループを回す
		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {

				if($row[COLUMN_INTERMEDIARY_FLG] == VAL_INT_1) {
					$intermediary = '利用する';
				} else {
					$intermediary = '利用しない';
				}

				// データストア
				$rowValues = array();
				$rowValues[] = $row[COLUMN_CREATE_TIME];
				$rowValues[] = $row[COLUMN_USER_NAME];
				$rowValues[] = $row[COLUMN_AMOUNT];
				$rowValues[] = $row[COLUMN_ACCOUNT_NUMBER];
				$rowValues[] = $row[COLUMN_RECEIPT_BANK_NAME];
				$rowValues[] = $row[COLUMN_RECEIPT_BANK_SWIFT];
				$rowValues[] = $intermediary;
				$rowValues[] = $this -> dispWithdrawStatusCommon($row[COLUMN_STATUS]);

				// ファイルの書き込み
				fputs($fp, implode(DELIMIT_COMMA, $rowValues) . "\n");
			}
		}

		fclose($fp);
	}

    /*-------------------------------------------------------------------------
	* @function_name: makeFlat3File
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function makeFlat3ExportData() {
		//get flat3 result
		$rs = $this -> getFlat3Result();

		/**
		 *
		 * 2019/04/15
		 * anton
		 *
		 */

        //headers
		$data = ($this -> lang == "en" ?
			"IWL Membership Number,Beneficiary Bank,Beneficiary Bank Code,Branch Name of Beneficiary Bank,Branch Code of Beneficary Bank,Deposit Account Type,Bank Account Number,Account Nume,Amount,Date Received,Transaction Number\n" :
				'IWL会員番号,受取銀行名,受取銀行コード,受取銀行支店名,受取銀行支店コード,預金種別,銀行口座番号,口座名義,金額,受付日,取引番号' . "\n");

		// データの数だけループを回す
		if($this -> isLoopData($rs)) {
            $bankCode             = NO_STRING;
            $branchName           = NO_STRING;
            $branchCode           = NO_STRING;
            $depositType          = "普通口座";
            $applicationDate      = NO_STRING;
            $branchCodeArray      = null;

			foreach($rs as $key => $details) {
                $branchCodeArray = unserialize($details[COLUMN_RECEIPT_BANK_BRANCH_CODE]);
                $branchCode      = $branchCodeArray['Branch Code'];
                $bankCode        = $branchCodeArray['Bank Code'];
                $applicationDate = date('Y/m/d', strtotime($details[COLUMN_CREATE_TIME]));

				// データストア
				$rowValues = array();
				$rowValues[] = $details[COLUMN_USER_ACCOUNT];
				$rowValues[] = $details[COLUMN_RECEIPT_BANK_NAME];
				$rowValues[] = $bankCode;
				$rowValues[] = $details[COLUMN_RECEIPT_BANK_BRANCH_NAME];
				$rowValues[] = $branchCode;
				$rowValues[] = $depositType;
				$rowValues[] = $details[COLUMN_ACCOUNT_NUMBER];
				$rowValues[] = $details[COLUMN_ACCOUNT_NAME];
				$rowValues[] = $details[COLUMN_CURRENCY] . DELIMIT_SPACE . $details[COLUMN_AMOUNT];
				$rowValues[] = $applicationDate;
                $rowValues[] = $details[COLUMN_TRANSACTION_NUMBER];

				//data
                $data .= '"'. implode('"' . DELIMIT_COMMA . '"', $rowValues) . '"' . "\n";
			}
		}

        $this -> setExportDataCommon($data);
	}

	/*-------------------------------------------------------------------------
    * @function_name: insertActivity
    * @parameter	:
    * @return		:
    -------------------------------------------------------------------------*/

    function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);

		$this -> setType(TYPE_DETAIL);
	}
}
?>