<?php
require_once('../logic/deposit/model.php');

class LogicDeposit extends DepositModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		// 変数宣言部

		try {

			// 初期データ処理
			if(!$this -> init()) {
				throw new Exception(NO_STRING);
			}

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() == CONTROL_ACTION) {			// 完了画面へ遷移

			// タイプの変更
			$this -> setType(TYPE_COMPLETE);

		} else if($this -> getType() == TYPE_SEND) {			// メールの送信
			$this -> send();

		} else if($this -> getType() == TYPE_COMPLETE) {		// 完了タイプの場合

			if($this -> getMethod() != NO_STRING) {				// 通常入金以外
				$this -> setType(TYPE_CONFIRM);
			}

		} else if($this -> getType() == TYPE_SUCCESS) {			// GPS完了タイプの場合
			$this -> sendSuccess();

		} else if($this -> getType()		== TYPE_PENDING
					|| $this -> getType()	== TYPE_FAIL) {		// GPS保留タイプの場合
			$this -> sendPending();
		} else if($this -> getType() == VAL_STR_FLAT3_MAILSEND){
			$this -> flat3send();
		} else if($this -> getType() == VAL_STR_LBTF3_MAILSEND){
			$this -> lbtf3send();
		} else if($this -> getType() == VAL_STR_JPV_MAILSEND){
			$this -> jpvsend();
		} elseif($this -> getType() == TYPE_LBTJ_COMPLETE) {
			//define variables
			$language = $this -> getLangage();
			$file  = $this -> getFile();

			//get send data
			$params = $this -> getLBTJEmailParams();
			//send email with attachment (to zendesk)
			$this -> sendMailByTmp('send_lbtj_mail_for_admin.xml'
									, $params
									, VAR_CS_MAIL_ADDRESS
									, $params[1]
									, $language
									, $file);
			//send confirmation email to user
			$this -> sendMailByTmp('send_lbtj_mail_for_user.xml'
									, $params
									, $params[1]
									, VAR_CS_MAIL_ADDRESS
									, $language);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function flat3send() {
		// 変数宣言部
		$account	= null;
		$row		= null;
		$params		= array();

		// ユーザデータの取得
		$rowFloat3  = $_SESSION['BankInfo'];
		$account	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row		= $this -> getRowData($account);

		// パラメータの作成
		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);
		$params[] = $this -> getUserData(PARAM_NAME);
		$params[] = $this -> getColumnData($rowFloat3,'bankName');
		$params[] = $this -> getColumnData($rowFloat3,'shitenName');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaType');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaNum');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaMeigi');
		$params[] = $this -> getColumnData($rowFloat3,'Credit');
		$params[] = $this -> getColumnData($rowFloat3,'Purchase');
		$params[] = VAL_STR_FLAT3_FEE;
		
		if($this -> getColumnData($row, COLUMN_MAIL) != NO_STRING) {
			$this -> sendMailByTmp('deposit_float3_info.xml'
									, $params
									, $this -> getColumnData($row, COLUMN_MAIL)
									, VAR_CS_MAIL_ADDRESS);
		}
	}

	private function lbtf3send() {
		// 変数宣言部
		$account	= null;
		$row		= null;
		$params		= array();

		// ユーザデータの取得
		$rowFloat3  = $_SESSION['BankInfo'];
		$account	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row		= $this -> getRowData($account);

		// パラメータの作成
		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);
		$params[] = $this -> getUserData(PARAM_NAME);
		$params[] = $this -> getColumnData($rowFloat3,'bankName');
		$params[] = $this -> getColumnData($rowFloat3,'shitenName');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaType');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaNm');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaMeigi');
		$params[] = $this -> getColumnData($rowFloat3,'Credit');
		$params[] = $this -> getColumnData($rowFloat3,'Purchase');
		$params[] = $this -> getColumnData($rowFloat3,'nameId');
		$params[] = VAL_STR_LBTF3_FEE;
		if($this -> getColumnData($row, COLUMN_MAIL) != NO_STRING) {
			$this -> sendMailByTmp('deposit_lbtf3_info.xml'
									, $params
									, $this -> getColumnData($row, COLUMN_MAIL)
									, VAR_CS_MAIL_ADDRESS);
		}
	}

	private function jpvsend() {
		// 変数宣言部
		$account	= null;
		$row		= null;
		$params		= array();

		// ユーザデータの取得
		$rowFloat3  = $_SESSION['BankInfo'];
		$account	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row		= $this -> getRowData($account);

		// パラメータの作成
		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);
		$params[] = $this -> getUserData(PARAM_NAME);
		$params[] = $this -> getColumnData($rowFloat3,'bankName');
		$params[] = $this -> getColumnData($rowFloat3,'shitenName');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaType');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaNm');
		$params[] = $this -> getColumnData($rowFloat3,'kouzaMeigi');
		$params[] = $this -> getColumnData($rowFloat3,'Credit');
		$params[] = $this -> getColumnData($rowFloat3,'Purchase');
		$params[] = $this -> getColumnData($rowFloat3,'nameId');
		$params[] = VAL_STR_JPV_FEE;
		if($this -> getColumnData($row, COLUMN_MAIL) != NO_STRING) {
			$this -> sendMailByTmp('deposit_jpv_info.xml'
									, $params
									, $this -> getColumnData($row, COLUMN_MAIL)
									, VAR_CS_MAIL_ADDRESS);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function send() {

		// 変数宣言部
		$account	= null;
		$row		= null;
		$params		= array();

		// ユーザデータの取得
		$account	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row		= $this -> getRowData($account);

		// パラメータの作成
		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);
		$params[] = $this -> getUserData(PARAM_NAME);

		if($this -> getColumnData($row, COLUMN_MAIL) != NO_STRING) {
			$this -> sendMailByTmp('deposit_info.xml'
									, $params
									, $this -> getColumnData($row, COLUMN_MAIL)
									, VAR_CS_MAIL_ADDRESS);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メールの送信（GPS入金成功メール）
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	private function sendSuccess() {

		// 変数宣言部
		$payData		= null;
		$account		= null;
		$userAccount	= NO_STRING;
		$method			= NO_STRING;
		$paymentAmount	= NO_STRING;
		$depositAmount	= NO_STRING;
		$params			= array();

		// 決済データの取得
		$payData = $this -> getRowData($this -> accessSelect('SELECT_RESPONSE_GPS_BY_R_ID', array($this -> getRefarenceNo())));

		// 口座番号の取得
		$userAccount = $this -> getColumnData($payData, COLUMN_USER_ACCOUNT);

		// 決済種別の取得
		if($this -> getColumnData($payData, COLUMN_METHOD) == 'GIFTCARD') {
			$method = 'MASTERCARD';
		} else {
			$method = $this -> getColumnData($payData, COLUMN_PAYMENT_METHOD);
		}

		// 口座データ
		$account = $this -> getRowData($this -> getAccountCommon($userAccount));

		// 決済金額の生成
		$paymentAmount = $this -> getAmountString($this -> getColumnData($payData, COLUMN_PAYMENT), $this -> getColumnData($payData, COLUMN_CURRENCY));

		// 入金金額の生成
		$depositAmount = $this -> getAmountString($this -> getColumnData($payData, COLUMN_AMOUNT), VAR_GPAYSAFE_CARD_CURRENCY);

		// メールデータの設定
		$params[] = $userAccount;											// 口座番号
		$params[] = $this -> getNameCommon($userAccount);					// 氏名
		$params[] = $method;												// 購入種別
		$params[] = $this -> getColumnData($payData, COLUMN_CURRENCY);		// 決済通貨
		$params[] = $paymentAmount;											// 決済金額
		$params[] = $this -> getColumnData($payData, COLUMN_UPDATE_TIME);	// 決済日時
		$params[] = VAR_GPAYSAFE_CARD_CURRENCY;								// 入金通貨
		$params[] = $depositAmount;											// 入金金額
		$params[] = $this -> getRefarenceNo();								// 取引番号

		// メールの送信
		$this -> sendMailByTmp('gpay_success_user.xml'
								, $params
								, $this -> getUserEMailCommon($userAccount)
								, VAR_CARD_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メールの送信（GPS入金保留メール）
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	private function sendPending() {

		// 変数宣言部
		$payData		= null;
		$account		= null;
		$userAccount	= NO_STRING;
		$params			= array();

		// 決済データの取得
		$payData = $this -> getRowData($this -> accessSelect('SELECT_RESPONSE_GPS_BY_R_ID', array($this -> getRefarenceNo())));

		// 口座番号の取得
		$userAccount = $this -> getColumnData($payData, COLUMN_USER_ACCOUNT);

		// 口座データ
		$account = $this -> getRowData($this -> getAccountCommon($userAccount));

		// メールデータの設定
		$params[] = $userAccount;											// 口座番号
		$params[] = $this -> getNameCommon($userAccount);					// 氏名

		// メールの送信
		$this -> sendMailByTmp('gpay_decline_user.xml'
				, $params
				, $this -> getUserEMailCommon($userAccount)
				, VAR_CARD_MAIL_ADDRESS);

	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>