<?php
require_once('config.php');
require_once('GetPlatinumCardAuthToken.php');

class APIGetPlemiumCardBalance extends System {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $details	= NO_STRING;

	/*-------------------------------------------------------------------------
	 * @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		ob_start();
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$cardId			= NO_COUNT;
		$proxy			= NO_COUNT;

		try {

			// トークンの取得
			$objAuth	= new APIGetPlemiumCardAuthToken();
			$token		= $objAuth -> getToken();

			// パラメータの取得
			$cardId			= $this -> getPosParameter(PARAM_CARD_HOLDER_ID);
			$row			= $this -> getCardCommon($cardId);
			$proxy			= $this -> getColumnData($row, COLUMN_PROXY);

			// パラメータの取得
			$cardId			= $this -> getPosParameter(PARAM_CARD_HOLDER_ID);
			$row			= $this -> getCardCommon($cardId);
			$proxy			= $this -> getColumnData($row, COLUMN_PROXY);
			$startDate		= $this -> getPosParameter('from');
			$endDate		= $this -> getPosParameter('to');

// 			$balanceUrl = PLATINUM_CARD_ROOT_URL . 'users/1218675/cards/246654418652051/transactions';
// 			$balanceUrl = PLATINUM_CARD_ROOT_URL . 'users/1360318/cards/246654430404424/transactions';
// 			$balanceUrl = PLATINUM_CARD_ROOT_URL . 'users/1548625/cards/246654409219548/transactions';
// 			$balanceUrl = PLATINUM_CARD_ROOT_URL . 'users/1540285/cards/246654475603377/transactions';

			$balanceUrl = PLATINUM_CARD_ROOT_URL . 'users/' . $cardId . '/cards/' . $proxy . '/transactions';

			$curl = curl_init($balanceUrl); // 初期化！

			// 送信データ
			$params = array(
						"txnType"				=> array("All")
						, "businessPartnerId"	=> "1508229"
						, "startDate"			=> "2015-08-30T00:00:00.000+05:00"
						, "endDate"				=> "2017-05-31T00:00:00.000+05:00"
						, 'txnType'				=> array("All")
						, "businessPartnerId"	=> "1508229"
						, "startDate"			=> $startDate
						, "endDate"				=> $endDate
						, "channelType"			=> "1"
						, "offset"				=> "0"
						, "txnCount"			=> "100"
						// , "refId"				=> "1234"
						// , "localeTime"			=> "2013-08-30T00:00:00.000+05:00"
					);

			$options = array(
				CURLOPT_URL					=> $balanceUrl
				, CURLOPT_HTTPHEADER		=> array('Developerid:' . PLATINUM_CARD_DEVELOPER_ID
														, 'Developerpassword:' . PLATINUM_CARD_DEVELOPER_PASSWORD
														, 'X-Method-Override:login'
														, 'AuthenticationToken:' . $token
														, 'Content-Type:application/json'
				)
				, CURLOPT_POSTFIELDS		=> json_encode($params)
				, CURLOPT_POST				=> true
				, CURLINFO_HEADER_OUT		=> true
				, CURLOPT_RETURNTRANSFER	=> true

			);

			curl_setopt_array($curl, $options);

			// リクエスト実行
			$result			= curl_exec($curl);
			$json_result	= json_decode($result, true);
// print_r($json_result);
			// 通貨があった場合
			$this -> details = $this -> getColumnData($json_result, 'transactionDetails');

			curl_close($curl);

		} catch (Exception $e) {
			ob_end_clean();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {
		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 利用明細の取得
	 * @parameter	: 利用明細
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getDetailsJson() {

		// 変数宣言部
		$rtn = array(PARAM_RESULT	=> $this -> details);
		return  json_encode($rtn);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高の取得
	 * @parameter	: カード残高
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getDetails() {
		return  $this -> details;
	}
}

$api = new APIGetPlemiumCardBalance();
$api -> action();
echo $api -> getDetailsJson();
?>
