<?php
require_once(SYSTEM_LOGICS . 'developer/model.php');

class LogicDeveloper extends DeveloperModelClass {
    
	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	public function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（�?�クラス共通）
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	public function logic() {
		try {
		    if($this -> init()){ 
		        switch($this -> getType()){
		            case TYPE_NEW_DEV_CREDENTIAL_COMPLETE:{
		                $this -> insertActivity();
		                $this -> insertDevCredential();
		                $this -> lists();
		                break;
		            }

		            case TYPE_DEV_CREDENTIAL_UPDATE:{
		                $this -> insertActivity();
		                $this -> updateDevCredential();
		                $this -> lists();
		                break;
		            }
		            
		            case TYPE_DEV_CREDENTIAL_PASSCODE_UPDATE:{
		                $this -> insertActivity();
		                $this -> updateDevCredPasscode();
		                $this -> lists();
		                break;
		            }
		            
		            case TYPE_DEV_CREDENTIAL_DELETE:{
		                $this -> insertActivity();
		                $this -> deleteDevCredential();
		                $this -> lists();
		                break;
		            }
		            
		            default:
		                $this -> lists();
		                break;
		        }
		    }else
			    $this -> lists();
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リスト
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	public function lists() {	
	    $whereClause = $this -> getWhere();
	    
	    $rowCount = $this -> getColumnData($this -> getRowData($this -> accessSelect("COUNT_DEV_CREDENTIALS", 
	        [$whereClause])), "creds_ctr");
	    
	    $this -> setTotal($rowCount);	  	    
        $start = ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
	    
        $whereClause .= " LIMIT {$start}, ".VAR_DEFAULT_PAGE_COUNT;
       
        $this -> setResult($this -> accessSelect("LIST_DEV_CREDENTIALS", [$whereClause]));
	}
	
	public function insertDevCredential(){ 
	    $this -> accessModify("INSERT_DEV_CREDENTIAL", $this -> getDevCredentialsData());
	    $this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}
	
	public function updateDevCredential(){
	    $this -> accessModify("UPDATE_DEV_CREDENTIAL_DETAILS", $this -> getUpdatedDevData());
	    $this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}
	
	public function updateDevCredPasscode(){
	    $this -> accessModify("UPDATE_DEV_CREDENTIAL_PASSCODE", $this -> getUpdatedDevCredPasscode());
	    $this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}
	
	public function deleteDevCredential(){
	    $this -> accessModify("DELETE_DEV_CREDENTIAL", [$this -> getFieldValue("devKey")]);
	    $this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
	}
	
	public function insertActivity(){
	    $this -> accessModify('INSERT_ACTIVITY', $this -> getActivity());
	}
}

