<?php
class LoginModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $userName	= NO_STRING;	// ユーザ名
	private $userPass	= NO_STRING;	// ユーザパスワード

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

			return true;
		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> userName	= $this -> getDataPost(PARAM_USER_ID);	// ユーザ名
		$this -> userPass	= $this -> getDataPost(PARAM_PASSWORD);	// パスワード
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn	= true;
		$rs		= null;

		// アクションの確認
		if($this -> getAction() == NO_STRING) {
			throw new Exception();
		}

		// ユーザ名のチェックを行う
		$rtn = $this -> vailedateUserName($this -> userName);

		// パスワードのチェックを行う
		$rtn = $this -> vailedatePassword($this -> userPass);

		// この時点でエラーの場合はスロー
		if(!$rtn) {
			throw new Exception(NO_STRING);
		}

		// 複合チェックを行う

		// ユーザの存在確認
		$rs = $this -> checkAdminUser($this -> userName, $this -> userPass);

		// セッションを詰め込む
		if(count($rs) == VAL_INT_1) {
			$this -> putSessionAdminUserData($rs);
		} else {
			$this -> popUpSessionMessage(ERROR, 'E_CAN_NOT_LOGIN', array());
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名のチェックを行う
	* @parameter	: なし
	* @return		: true:成功、false:失敗
	-------------------------------------------------------------------------*/
	private function vailedateUserName($name) {

		// 変数宣言部
		$rtn = true;

		// ユーザ名のチェック
		if(!$this -> checkNull($name)) {
			$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_NAME));
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名のチェックを行う
	* @parameter	: なし
	* @return		: true:成功、false:失敗
	-------------------------------------------------------------------------*/
	private function vailedatePassword($password) {

		// 変数宣言部
		$rtn = true;

		// ユーザパスワードのチェック
		if(!$this -> checkNull($password)) {
			$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PASSWORD));
			$rtn = false;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名を取得する
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function getUserName() {
		echo $this -> userName;
	}
}
?>