<?php
require_once SITE_LOGICS . 'withdraw/config.php';
class WithdrawModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $user						= null;			// ユーザデータ
	private $userAccount				= null;			// iwallet口座番号
	private $history					= null;			// 送金履歴
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $accountName				= NO_STRING;	// 口座名義
	private $receiptCountry				= NO_STRING;	// 受取人国
	private $receiptAddress1			= NO_STRING;	// 受取人住所1
	private $receiptAddress2			= NO_STRING;	// 受取人住所2
	private $tel						= NO_STRING;	// 電話番号
	private $receiptMessage				= NO_STRING;	// 受取人メッセージ
	private $receiptBankName			= NO_STRING;	// 受取銀行名
	private $receiptBankSwift			= NO_STRING;	// 受取銀行SWIFT
	private $receiptBankCountry			= NO_STRING;	// 受取銀行国
	private $receiptBranchCode			= NO_STRING;	// 受取銀行支店コード
	private $receiptBranchName			= NO_STRING;	// 受取銀行支店名
	private $receiptBankAddress1		= NO_STRING;	// 受取銀行住所1
	private $receiptBankAddress2		= NO_STRING;	// 受取銀行住所2
	private $accountNumber				= NO_STRING;	// 受取銀行口座番号
	private $intermediaryFlg			= NO_STRING;	// 中継銀行フラグ
	private $intermediaryBankName		= NO_STRING;	// 中継銀行名
	private $intermediaryBankSwift		= NO_STRING;	// 中継銀行SWIFT
	private $intermediaryBankCountry	= NO_STRING;	// 中継銀行国
	private $intermediaryBankAddress1	= NO_STRING;	// 中継銀行住所1
	private $intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2
	private $intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージ
	private $fromCurrency				= NO_STRING;	// From通貨
	private $debitCurrency				= NO_STRING;	// 引落通貨
	private $debitAmount				= NO_STRING;	// 引落金額
	private $drawFee                    = NO_COUNT;     // 引落金額
	private $drawFeeCurrency            = NO_STRING;    // 引落通貨
  	private $fee                        = NO_STRING;    // 引落金額
    private $addressTextArray           = null;         //contains array('beneficiary address', 'bank address') based on language
    private $moneyoutSolution           = NO_STRING;    //moneyout solution selected
    private $accountType                = null;         //account data for set parameters
    private $receiptBankCode            = NO_STRING;    //bank code (flat3)
    private $province                   = null;         //province (SDPay)
    private $city                       = null;         //city (SDPay)
    private $withdrawTool               = null;         //withdrawal tool class (SDPay)

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();
						
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {


		$this -> currency					= htmlspecialchars($this -> getDataPost(PARAM_CURRENCY));						// 通貨
		$this -> amount						= ($this -> amount != NO_STRING) ? htmlspecialchars(abs($this -> getDataPost(PARAM_AMOUNT))) : htmlspecialchars($this -> getDataPost(PARAM_AMOUNT));				            // 金額
		$this -> tel						= htmlspecialchars($this -> getDataPost(PARAM_TEL));							// 電話番号
		$this -> accountName				= htmlspecialchars($this -> getDataPost(PARAM_ACCOUNT_NAME));					// 口座名義
		$this -> receiptCountry				= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_COUNTRY));				// 受取人国
		$this -> receiptAddress1			= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_ADDRESS_1));				// 受取人住所1
		$this -> receiptAddress2			= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_ADDRESS_2));				// 受取人住所2
		$this -> receiptMessage				= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_MESSAGE));				// 受取人メッセージ
		$this -> receiptBankCountry			= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BANK_COUNTRY));			// 受取銀行国
		$this -> receiptBankName			= htmlspecialchars((($this -> getDataPost(PARAM_RECEIPT_BANK_NAME))!== PARAM_OTHERS) ? $this -> getDataPost(PARAM_RECEIPT_BANK_NAME): $this -> getDataPost(PARAM_OTHER_RECEIPT_BANK_NAME));
		$this -> receiptBankSwift			= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BANK_SWIFT));				// 受取銀行SWIFT
		$this -> receiptBankCountry			= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BANK_COUNTRY));			// 受取銀行国
		$this -> receiptBranchCode			= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BRANCH_CODE));			// 受取銀行支店コード
		$this -> receiptBranchName			= htmlspecialchars((($this -> getDataPost(PARAM_RECEIPT_BRANCH_NAME))!== PARAM_OTHERS) ? $this -> getDataPost(PARAM_RECEIPT_BRANCH_NAME): $this -> getDataPost(PARAM_OTHER_RECEIPT_BRANCH_NAME));
		$this -> receiptBankAddress1		= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_1));			// 受取銀行住所1
		$this -> receiptBankAddress2		= htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_2));			// 受取銀行住所2
		$this -> accountNumber				= htmlspecialchars($this -> getDataPost(PARAM_ACCOUNT_NUMBER));					// 受取銀行口座番号
		$this -> intermediaryFlg			= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_FLG));				// 中継銀行フラグ
		$this -> intermediaryBankName		= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_BANK_NAME));			// 中継銀行名
		$this -> intermediaryBankSwift		= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_BANK_SWIFT));		// 中継銀行SWIFT
		$this -> intermediaryBankCountry	= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_BANK_COUNTRY));		// 中継銀行国
		$this -> intermediaryBankAddress1	= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_1));	// 中継銀行住所1
		$this -> intermediaryBankAddress2	= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_2));	// 中継銀行住所2
		$this -> intermediaryBankMessage	= htmlspecialchars($this -> getDataPost(PARAM_INTERMEDIARY_BANK_MESSAGE));		// 中継銀行メッセージ
		$this -> fromCurrency				= htmlspecialchars($this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY));			// From通貨

		$this -> debitCurrency				= htmlspecialchars($this -> getDataPost(PARAM_DEBIT_CURRENCY));					// 引落口座通貨
		$this -> debitAmount				= htmlspecialchars($this -> getDataPost(PARAM_DEBIT_AMOUNT));					// 引落口座金額
		$this -> setFeeEx(htmlspecialchars(abs($this -> getDataPost(PARAM_FEE))));												// 手数料
		$this -> setRateEx(htmlspecialchars(abs($this -> getDataPost(PARAM_RATE))));												// レート
		$this -> setAgent1Ex(htmlspecialchars($this -> getDataPost(PARAM_AGENT_CODE)));										// エージェントコード

        $this -> addressTextArray           = getAddressText($this -> getLangage());                                       //array('beneficiary address', 'bank address')
        $this -> moneyoutSolution           = htmlspecialchars($this -> getDataPost(PARAM_MONEYOUT_SOLUTION));             // moneyout solution
        $this -> receiptBankCode            = htmlspecialchars($this -> getDataPost(PARAM_RECEIPT_BANK_CODE));             // bank code(flat3)

        $this -> province                   = explode(',', htmlspecialchars($this -> getDataPost(PARAM_PROVINCE)));        // province(SDPay)
        $this -> city                       = explode(',', htmlspecialchars($this -> getDataPost(PARAM_CITY)));             // city(SDPay)

        //get account data
        $this -> account     = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));

        //if moneyout solution is not null save it to session
        if($this -> moneyoutSolution != NO_STRING && in_array($this -> moneyoutSolution, VAL_ARR_MONEYOUT_SOLUTIONS)){
            $_SESSION['moneyoutSolution'] = $this -> moneyoutSolution;
        }

        //if $_SESSION['moneyoutSolution'] == 'Flat3' edit reciept message
        if(isset($_SESSION['moneyoutSolution']) && $_SESSION['moneyoutSolution'] == 'Flat3'){
            $this -> receiptMessage = 'Transfer Agency Service (Japan)';

            $this -> receiptBranchCode = serialize(array(
                                                            'Branch Code' => $this -> receiptBranchCode,
                                                            'Bank Code'   => $this -> receiptBankCode
                                                        ));
        }

	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {

		// 変数宣言部
		$addrList = array();

		// 住所の結合用
		if($this -> getColumnData($this -> user, COLUMN_ADDRESS) != NO_STRING) {
			$addrList[] = $this -> getColumnData($this -> user, COLUMN_ADDRESS);
		}
		if($this -> getColumnData($this -> user, COLUMN_CITY) != NO_STRING) {
			$addrList[] = $this -> getColumnData($this -> user, COLUMN_CITY);
		}
		if($this -> getColumnData($this -> user, COLUMN_STATE) != NO_STRING) {
			$addrList[] = $this -> getColumnData($this -> user, COLUMN_STATE);
		}
		if($this -> getColumnData($this -> user, COLUMN_ZIP_CODE) != NO_STRING) {
			$addrList[] = $this -> getColumnData($this -> user, COLUMN_ZIP_CODE);
		}

		$this -> accountName			= $this -> getColumnData($this -> user, COLUMN_ACCOUNT_NAME);							// 口座名義
		$this -> receiptCountry			= $this -> getColumnData($this -> user, COLUMN_COUNTRY);								// 受取人国
		$this -> receiptAddress1		= implode(DELIMIT_COMMA_AND_SPACE, $addrList);											// 受取人住所1
		$this -> tel					= $this -> getColumnData($this -> user, COLUMN_TEL);									// 受取人電話番号
		$this -> receiptBankCountry		= $this -> getColumnData($this -> user, COLUMN_BANK_COUNTRY);							// 受取銀行国
		$this -> receiptBankName		= $this -> getColumnData($this -> user, COLUMN_BANK_NAME);								// 受取銀行名
		$this -> receiptBankSwift		= $this -> getColumnData($this -> user, COLUMN_RECEIPT_BANK_SWIFT);						// 受取銀行SWIFT CODE
		$this -> receiptBankAddress1	= $this -> getColumnData($this -> user, COLUMN_RECEIPT_ADDRESS_1);						// 受取銀行住所1
		$this -> receiptBranchName		= $this -> getColumnData($this -> user, COLUMN_BRANCH_NAME);							// 受取銀行支店名
		$this -> accountNumber			= $this -> getColumnData($this -> user, COLUMN_ACCOUNT_NUMBER);							// 受取銀行口座番号
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		$rtn = true;

        //set type confirm, type complete and type back based on money out solution
        $typeArray = setWithdrawalType();

        if(!isset($_SESSION['moneyoutSolution'])) {
			$this -> setType();
            return;
        }
        
		// if type is not input
		if($this -> getType() != TYPE_INPUT
			&& $this -> getType() != TYPE_LOCAL_INPUT
			&& $this -> getType() != TYPE_WITHDRAW_H2P_INPUT
			&& $this -> getType() != TYPE_WITHDRAW_H2P_CONFIRM
			&& $this -> getType() != TYPE_WITHDRAW_H2P_BACK
			&& $this -> getType() != TYPE_WITHDRAW_H2P_COMPLETE) {
			//switch case for checking if the type is for the current moneysolution
			switch($_SESSION['moneyoutSolution']) {
				case 'Flat3':
					if(stripos($this -> getType(), 'flat3')  === false) {
						$this -> setType();
						return;
					}
					break;
				case 'International':
					if(!in_array($this -> getType(), $typeArray)) {
						$this -> setType();
						return;
					}
					break;
				case 'SDPay':
					if(stripos($this -> getType(), 'local') === false) {
						$this -> setType();
						return;
					}
					break;
				default:
					$this -> setType();
					return;
			}
		}

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 口座ステータスチェック
		if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_WITHDRAW)) {
			throw new Exception(VAL_INT_99);
		}

        //if getType is empty
        if($this -> getType() == null || $this -> getType() == "") {
            unset($_SESSION['moneyoutSolution']);
            return;
        }


		if($this -> getType() == $typeArray["Complete"]) {		// 完了タイプの場合

			//set valuse based on moneyoutSolution
			if(isset($_SESSION['moneyoutSolution']) && $_SESSION['moneyoutSolution'] == "Flat3") {
				$type = TYPE_FLAT3_INPUT;
				$function = 'withdrawal_flat3';
			} else {
				$type = TYPE_INPUT;
				$function = 'withdrawal_international';
			}

			//check if 2fa is enabled
			if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), $function)){
				//cehck if 2fa validated
				if(!$this -> checkIs2FAValidated()) {
					$this -> setType($type);

					return false;
				}
			}

			// 残高チェック
			// 制限口座のチェック(1回あたりの送金時)
			if(!$this -> checkWithdrawLimitOneTimes($this -> getUserData(PARAM_USER_ACCOUNT)
					, $this -> currency
					, floatval($this -> amount))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_ONE_TIME', array());
				$rtn = false;
			}

            // タイプを戻す
			if(!$rtn) {
				$this -> setType($typeArray["Confirm"]);
				return;
			}

            //input validation
            $rtn = $this -> validateInputs();

            // タイプを戻す
			if(!$rtn) {
				$this -> setType($typeArray["Back"]);
				return;
			}

			// 残高のチェック
			$balance			= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> fromCurrency);
			$fee				= $this -> getFeeCommon(VAR_WITHDRAW_SUCCESS
														, $this -> amount
														, $this -> currency
														, $this -> getUserData(PARAM_USER_ACCOUNT));

			if($this -> debitCurrency == $this -> currency) {	// 送金通貨と引き落とし通貨が一緒

				$feeExchange[PARAM_AMOUNT] = $fee[$this -> currency . VAL_INT_1];

			} else {
				$feeExchange		= $this -> getExchangeCommon($fee[USD . VAL_INT_1]
																, USD
																, $this -> fromCurrency
																, false
																, true
																, NO_STRING
													            , $this -> getUserData(PARAM_USER_ACCOUNT));
			}

			// バランスと（送金額 + 手数料）のチェック
			if($this -> fromCurrency == USD) {
				$this -> setFeeEx($fee[USD . VAL_INT_1]);
			} else {
				$this -> setFeeEx($feeExchange[PARAM_AMOUNT]);
			}

			$this -> setAgent1Ex($fee[PARAM_AGENT_CODE . VAL_INT_1]);

			$exchange	= $this -> getExchangeCommon($this -> amount
													, $this -> currency
													, $this -> fromCurrency
													, false
													, true
													, NO_STRING
													, $this -> getUserData(PARAM_USER_ACCOUNT)); //FOR FLAT3 & INTERNATIONAL

			$total		= ($exchange[PARAM_AMOUNT] + $this -> getFeeEx());
			$this -> setRateEx($exchange[PARAM_RATE]);

			if(NO_COUNT >= $this -> amount) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_AMOUNT', array(VAL_STR_AMOUNT, $this -> fromCurrency, $this -> formatCurrency($this -> amount, $this -> fromCurrency)));
				$rtn = false;
			} else if($balance < $total) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> fromCurrency, $this -> formatCurrency($total, $this -> fromCurrency)));
				$rtn = false;
			}

			// 最低額のチェック
			if(!$this -> checkMinimum($this -> currency, $this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
				$rtn = false;
			}

			if($this -> currency != $this -> fromCurrency) {
				if(!$this -> checkMinimum($this -> fromCurrency, $exchange[PARAM_AMOUNT])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
					$rtn = false;
				}
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType($typeArray["Confirm"]);
			} else {

				// 制限口座のチェック
				if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> currency, $this -> amount)) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC2', array());
					$this -> setType($typeArray["Back"]);
					return;
				}

				// 引落口座の設定
				$this -> debitCurrency	= $this -> fromCurrency;
				$this -> debitAmount	= $exchange[PARAM_AMOUNT];

                //check if flat 3
                if($_SESSION['moneyoutSolution'] == 'Flat3'){
                    $flat3Fee = round($this -> debitAmount * VAL_FLOAT_FLAT3_WITHDRAW_FEE, 2);

                    if($this -> getFeeEx() < $flat3Fee){
                        $this -> setFeeEx($flat3Fee);
                    }
                }
			}


		} else if($this -> getType() == $typeArray["Confirm"]) {	// 確認タイプの場合
			// 制限口座のチェック(出金確認時)
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> currency
											, $this -> currencyToInt(floatval($this -> amount), $this -> currency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC', array());
				$this -> setType($typeArray["Back"]);
				return;
			}

            //input validation
            $rtn = $this -> validateInputs();

			// タイプを戻す
			if(!$rtn) {
				$this -> setType($typeArray["Back"]);
				return;
			}

			// 制限口座のチェック(1回あたりの送金時)
			if(!$this -> checkWithdrawLimitOneTimes($this -> getUserData(PARAM_USER_ACCOUNT)
													, $this -> currency
													, floatval($this -> amount))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_ONE_TIME', array());
				$rtn = false;
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType($typeArray["Back"]);
				return;
			}

			// 残高のチェック
			$balance			= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> fromCurrency);

			$fee				= $this -> getFeeCommon(VAR_WITHDRAW_SUCCESS
														, $this -> amount
														, $this -> currency
														, $this -> getUserData(PARAM_USER_ACCOUNT));

			if($this -> fromCurrency == $this -> currency) {	// 送金通貨と引き落とし通貨が一緒

				$feeExchange[PARAM_AMOUNT] = $fee[$this -> currency . VAL_INT_1];
			} else {

				$feeExchange		= $this -> getExchangeCommon($fee[USD . VAL_INT_1]
																, USD
																, $this -> fromCurrency
																, false
																, true
																, NO_STRING
																, $this -> getUserData(PARAM_USER_ACCOUNT));
			}

			// バランスと（送金額 + 手数料）のチェック
			if($this -> fromCurrency == USD) {
				$this -> setFeeEx($fee[USD . VAL_INT_1]);
			} else {
				$this -> setFeeEx($feeExchange[PARAM_AMOUNT]);
			}

			$this -> setAgent1Ex($fee[PARAM_AGENT_CODE . VAL_INT_1]);

			$exchange	= $this -> getExchangeCommon($this -> amount
													, $this -> currency
													, $this -> fromCurrency
													, false
													, true
													, NO_STRING
													, $this -> getUserData(PARAM_USER_ACCOUNT));//FOR FLAT3 & INTERNATIONAL

			$total		= ($exchange[PARAM_AMOUNT] + $this -> getFeeEx());
			$this -> setRateEx($exchange[PARAM_RATE]);

			if(NO_COUNT >= $this -> amount) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_AMOUNT', array(VAL_STR_AMOUNT, $this -> fromCurrency, $this -> formatCurrency($this -> amount, $this -> fromCurrency)));
				$rtn = false;
			} else if($balance < $total) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> fromCurrency, $this -> formatCurrency($total, $this -> fromCurrency)));
				$rtn = false;
			}

			if($this -> amount >= 500000){
			    $this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
			    $rtn = false;
			}
			
			// 最低額のチェック
			if(!$this -> checkMinimum($this -> currency, $this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
				$rtn = false;
			}

			if($this -> currency != $this -> fromCurrency) {
				if(!$this -> checkMinimum($this -> fromCurrency, $exchange[PARAM_AMOUNT])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
					$rtn = false;
				}
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType($typeArray["Back"]);
			} else {

				// 制限口座のチェック
				if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> currency, $this -> amount)) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC2', array());
					$this -> setType($typeArray["Back"]);
					return;
				}

				// 引落口座の設定
				$this -> debitCurrency	= $this -> fromCurrency;
// 				$this -> debitAmount	= $total;
				$this -> debitAmount	= $exchange[PARAM_AMOUNT];

                //check if flat 3
                if($_SESSION['moneyoutSolution'] == 'Flat3'){
//                     $flat3Fee = round($this -> debitAmount * VAL_FLOAT_FLAT3_WITHDRAW_FEE, 2);

//                     if($this -> getFeeEx() < $flat3Fee){
//                         $this -> setFeeEx($flat3Fee);
//                     }
                    
                    $this -> arrangeMinimumFee();
                }
			}

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

            //Local Bank Transfer (China) Withdrawal Application
        } else if ($this->getType() == TYPE_LOCAL_INPUT) {
            //check if user doesn't have bypass solution access
            if(!$this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_LBTC_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
                //check if user has unli status
    			if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
    					$this -> setWithdrawSolution('lbtc');
    					$this->setType(TYPE_WITHDRAW_NOTICE_KYC);
    					return;
    			}
            }

            if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'withdrawal_sdpay_status','withdrawal_sdpay_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24WITHDRAWAL_SDPAY_LOCK', array());
				$this->setType(TYPE_LOCAL_BACK_LOCKED);
			}else if (!$this->checkWithdrawLimit($this->getUserData(PARAM_USER_ACCOUNT))) {
                $this->popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC', array());
                $this->setType(NO_STRING);
                $rtn = false;
            }

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

        } else if ($this->getType() == TYPE_LOCAL_CONFIRM) {
			// 必须选择出金币种
            if (!$this->checkNull($this->fromCurrency)) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
                $rtn = false;
            }

            //限制出金金额
            if (!$this->checkNull($this->amount)) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
                $rtn = false;

			// 金額の正規表現チェック
			} else if(!$this -> checkStringNumberOnly($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;

			//限制出金金额
			} else if ( ($this -> checkUsuallyStatus($this -> getUserData(PARAM_USER_ACCOUNT))) && ($this->amount < VAL_INT_500 || $this->amount > VAL_INT_6000 || (preg_match("/^\d*$/",$this -> amount) == false))){
	            $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_AMOUNT_KYC_MIXMAX', array());
	            $rtn = false;

	        } else if ($this->amount < VAL_INT_500 || $this->amount > VAL_INT_50000 || (preg_match("/^\d*$/",$this -> amount) == false)) {
	            $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_AMOUNT_MIXMAX', array());
	            $rtn = false;
	        }

            // Account Number is a mandatory field!
            if (!$this->checkNull($this->accountNumber)) {

                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT));
                $rtn = false;

            } else  if (!$this->checkStringNumber($this->accountNumber)) {
                $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_ACCOUNT_MNUMBER', array());
                $rtn = false;
            }


            // Account Name is a mandatory field!
            if ($this->accountName == NO_STRING) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT_NAME));
                $rtn = false;
             //必须输入中文
            } else if (!$this->checkStringAsciiCN($this->accountName)) {
                $this->popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_CHINA', array(VAL_STR_LOCAL_NAME));
                $rtn = false;
            }

           	// 必须选择银行
			if(!$this -> checkNull($this->receiptBankName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				$rtn = false;
			} else if($this->receiptBankName == 'Select'){
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				$this->receiptBankName = '';
				$rtn = false;
			}

			// check if province and city is null
            if (!$this->checkNull($this->province[0])) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PROVINCE));
                $rtn = false;
            }

			if (!$this->checkNull($this->city[0])) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CITY));
                $rtn = false;
            }

            if (!$rtn) {
                $this->setType(TYPE_LOCAL_BACK);
                return;
            }

			// 制限口座のチェック
      		if (!$this->checkWithdrawLimit($this->getUserData(PARAM_USER_ACCOUNT), CNY, $this->amount)) {
                    $this->popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC2', array());
                    $this->setType(TYPE_LOCAL_BACK);
                    return;
            }

                // 残高のチェック
            $balance = $this->getBalanceCommon($this->getUserData(PARAM_USER_ACCOUNT), $this->fromCurrency);

            $exchange = $this->getExchangeCommon($this->amount
            										, CNY
            										, $this->fromCurrency
            										, false
            										, true
            										, NO_STRING
            										, $this -> getUserData(PARAM_USER_ACCOUNT));

           	$this->fee = round($exchange[PARAM_AMOUNT] * VAL_INT_1_5,2);

            $total = ($exchange[PARAM_AMOUNT] + $this->fee);
                // echo VAL_INT_1_5
            $this->setRateEx($exchange[PARAM_RATE]);
                // 引落口座の設定
            $this->debitCurrency = $this->fromCurrency;
            $this->debitAmount   = $exchange[PARAM_AMOUNT];

                //判断是否有足够的存款
            if ($balance < $total && $this->checkNull($this->fromCurrency)) {
                    $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_FUNDS', array($this->fromCurrency, $this->formatCurrency($total, $this->fromCurrency)));
                    $rtn = false;
            }

            if (!$rtn) {
                $this->setType(TYPE_LOCAL_BACK);
                return;
            }

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

            //提交信息验证
        } else if ($this->getType() == TYPE_LOCAL_COPLETE) {

			//check if 2fa is enabled
			if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), 'withdrawal_sdpay')){
				//cehck if 2fa validated
				if(!$this -> checkIs2FAValidated()) {
					$this -> setType(TYPE_LOCAL_INPUT);
					return false;
				}
			}

           // 必须选择出金币种
            if (!$this->checkNull($this->fromCurrency)) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
                $rtn = false;
            }

            //限制出金金额
            if (!$this->checkNull($this->amount)) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
                $rtn = false;

			// 金額の正規表現チェック
			} else if(!$this -> checkStringNumberOnly($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;

			//限制出金金额
			} else if ( ($this -> checkUsuallyStatus($this -> getUserData(PARAM_USER_ACCOUNT))) && ($this->amount < VAL_INT_500 || $this->amount > VAL_INT_6000 || (preg_match("/^\d*$/",$this -> amount) == false))){
	            $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_AMOUNT_KYC_MIXMAX', array());
	            $rtn = false;

	        } else if ($this->amount < VAL_INT_500 || $this->amount > VAL_INT_50000 || (preg_match("/^\d*$/",$this -> amount) == false)) {
	            $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_AMOUNT_MIXMAX', array());
	            $rtn = false;
	        }

            // Account Number is a mandatory field!
            if (!$this->checkNull($this->accountNumber)) {

                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT));
                $rtn = false;

            } else  if (!$this->checkStringNumber($this->accountNumber)) {
                $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_ACCOUNT_MNUMBER', array());
                $rtn = false;
            }


            // Account Name is a mandatory field!
            if ($this->accountName == NO_STRING) {
                $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT_NAME));
                $rtn = false;
             //必须输入中文
            } else if (!$this->checkStringAsciiCN($this->accountName)) {
                $this->popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_CHINA', array(VAL_STR_LOCAL_NAME));
                $rtn = false;
            }

           	// 必须选择银行
			if(!$this -> checkNull($this->receiptBankName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				$rtn = false;
			} else if($this->receiptBankName == 'Select'){
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				$this->receiptBankName = '';
				$rtn = false;
			}

            if (!$rtn) {
                $this->setType(TYPE_LOCAL_BACK);
                return;
            }


			// 制限口座のチェック
      		if (!$this->checkWithdrawLimit($this->getUserData(PARAM_USER_ACCOUNT), CNY, $this->amount)) {
                    $this->popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC2', array());
                    $this->setType(TYPE_LOCAL_BACK);
                    return;
            }

                // 残高のチェック
            $balance = $this->getBalanceCommon($this->getUserData(PARAM_USER_ACCOUNT), $this->fromCurrency);

            $exchange = $this->getExchangeCommon($this->amount
            										, CNY
            										, $this->fromCurrency
            										, false
            										, true
            										, NO_STRING
            										, $this -> getUserData(PARAM_USER_ACCOUNT));

           	$this->fee = round($exchange[PARAM_AMOUNT] * VAL_INT_1_5,2);

            $total = ($exchange[PARAM_AMOUNT] + $this->fee);
                // echo VAL_INT_1_5
            $this->setRateEx($exchange[PARAM_RATE]);
                // 引落口座の設定
            $this->debitCurrency = $this->fromCurrency;
            $this->debitAmount   = $exchange[PARAM_AMOUNT];

                //判断是否有足够的存款
            if ($balance < $total && $this->checkNull($this->fromCurrency)) {
                    $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_FUNDS', array($this->fromCurrency, $this->formatCurrency($total, $this->fromCurrency)));
                    $rtn = false;
            }

            if (!$rtn) {
                $this->setType(TYPE_LOCAL_BACK);
                return;
            }
            //提交信息验证
        } else if( $this->getType() == TYPE_INPUT ){
            //check if method is Flat3
            if($_SESSION['moneyoutSolution'] == 'Flat3'){
                
                if(count($this -> getPendingWithdrawalTransactions())){
                    $this -> popUpSessionMessage(ERROR, 'E_ERROR_PENDING_FLAT3_WITHDRAWAL', array());
                    $this -> setType();
                    return;
                }
                
                //check if user doesn't have bypass solution access
                if(!$this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_FLAT3_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
                    //check if user has unli status
    				if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
    					$this -> setWithdrawSolution('flat3');
    					$this->setType(TYPE_WITHDRAW_NOTICE_KYC);
    					return;
    				}
					//check if user is high risk - Mikko 2019 0312
					if($this -> getColumnData($this -> account, COLUMN_RISK_LEVEL) == VAL_INT_1){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
							$this->setType();
							return;
						}
                    //check if user lives in Japan
                    if($this -> dispCountryCommon($this -> getColumnData($this -> account,'country')) != 'Japan'){
                        $this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_NOT_IN_JAPAN', array());
                        $this->setType();
                    } else{
                        $this->setType(TYPE_FLAT3_INPUT);
                    }

                    //check if user is Corporate
                    if(intval($this -> getColumnData($this -> account,'account_type')) == 1){
                        $this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAWAL_CORPORATE_ONLY', array());
                        $this->setType();
                        return;
                    }
                }else{
					$this->setType(TYPE_FLAT3_INPUT);
				}

				//check if user is not locked by 2fa
                if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'withdrawal_flat3_status','withdrawal_flat3_update_time'))) {
    				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24WITHDRAWAL_FLAT3_LOCK', array());
    				$this->setType(TYPE_FLAT3_LOCKED);
    			}

                return;
            }

            //check if user doesn't have bypass solution access
            if(!$this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_IBT_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
    			//check if user has unli status
    			if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
    				$this -> setWithdrawSolution();
    				$this->setType(TYPE_WITHDRAW_NOTICE_KYC);
    				return;
    			}
				//check if user is high risk - Mikko 2019 0312
				if($this -> getColumnData($this -> account, COLUMN_RISK_LEVEL) == VAL_INT_1){
						$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
						$this->setType();
						return;
					}
            }

			if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'withdrawal_international_status','withdrawal_international_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24WITHDRAWAL_LOCK', array());
				$this->setType(TYPE_LOCKED);
			}


			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

        }else if ($this -> getType() == TYPE_WITHDRAW_H2P_INPUT){
				//check if user doesn't have bypass solution access
				if(!$this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){
					//check if user has unli status
				   if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					   $this -> setWithdrawSolution('H2P');
					   $this->setType(TYPE_WITHDRAW_NOTICE_KYC);
					   return;
				   }

					//check if user is Corporate
					if(intval($this -> getColumnData($this -> account,'account_type')) == 1){
						$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAWAL_CORPORATE_ONLY', array());
						$this->setType();
						return;
					}

					//check if user is high risk - Mikko 2019 0312
					if($this -> getColumnData($this -> account, COLUMN_RISK_LEVEL) == VAL_INT_1){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
							$this->setType();
							return;
					}

					//check if user lives in  Vietnam, Thailand, Malaysia and Indonesia
					$countries = array('Vietnam','Thailand','Malaysia','Indonesia');
					if(!(in_array($this -> dispCountryCommon($this -> getColumnData($this -> account,'country')), $countries))){

						$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_COUNTRY_H2P', array());
						$this->setType();
						return;
					}
				}



				//check if user is not locked by 2fa
				if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'withdrawal_h2p_status','withdrawal_h2p_update_time'))) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24WITHDRAWAL_H2P_LOCK', array());
					$this->setType(TYPE_WITHDRAW_H2P_LOCKED);
					return;
				}else if (!$this->checkWithdrawLimit($this->getUserData(PARAM_USER_ACCOUNT))) {
					$this->popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC', array());
					$this->setType(NO_STRING);
					$rtn = false;
				}

				return;
		 } else if ($this->getType() == TYPE_WITHDRAW_H2P_CONFIRM || $this->getType() == TYPE_WITHDRAW_H2P_COMPLETE) {
			 		//

				  if (!$this->checkNull($this -> fromCurrency)) {
					  $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
					  $rtn = false;
				  }

				  //
				  if (!$this->checkNull($this -> amount)) {
					  $this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
					  $rtn = false;

				 //
				 } else if(!$this -> checkStringNumberOnly($this -> amount)) {
					 $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
					 $rtn = false;
				 }

					 // Account Number is a mandatory field!
				if (!$this->checkNull($this -> accountNumber)) {

					$this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT));
					$rtn = false;

				} else  if (!$this->checkStringNumber($this -> accountNumber)) {
					$this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_ACCOUNT_MNUMBER', array());
					$rtn = false;
				}


				// Account Name is a mandatory field!
				if ($this->accountName == NO_STRING) {
					$this->popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT_NAME));
					$rtn = false;
			   }
				   //
			   if(!$this -> checkNull($this -> receiptBankName)) {
				   $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				   $rtn = false;
			   } else if($this->receiptBankName == 'Select'){
				   $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				   $this->receiptBankName = '';
				   $rtn = false;
			   }

				if (!$rtn) {
					$this->setType(TYPE_WITHDRAW_H2P_BACK);
					return;
				}

				//check if user lives in  Vietnam, Thailand, Malaysia and Indonesia
				$countries = array('Vietnam','Thailand','Malaysia','Indonesia');
				//$userCountry = $this -> dispCountryCommon($this -> getColumnData($this -> account,'country'));
				$userCountry = $this -> receiptBankCountry;

				if((in_array($userCountry, $countries))){
					if($userCountry == 'Vietnam'){
						$this -> receiptCountry = 'VN';
						$this -> currency = 'VND';
						if(($this -> amount < 300000) || ($this -> amount >300000000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("VND 300,000", "VND 300,000,000"));
							$rtn = false;
						}
					} else if($userCountry == 'Thailand'){
						$this -> receiptCountry = 'TH';
						$this -> currency  = 'THB';
						if(($this -> amount < 500) || ($this -> amount >500000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("THB 500", "THB 500,000"));
							$rtn = false;
						}
					} else if($userCountry == 'Malaysia'){
						$this -> receiptCountry = 'MY';
						$this -> currency  = 'MYR';
						if(($this -> amount < 50) || ($this -> amount >50000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("MYR 50", "MYR 50,000"));
							$rtn = false;
						}
					} else if($userCountry == 'Indonesia'){
						$this -> receiptCountry = 'ID';
						$this -> currency  = 'IDR';
						if(($this -> amount < 300000) || ($this -> amount >200000000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_AMOUNT_VALUE', array("IDR 300,000", "IDR 200,000,000"));
							$rtn = false;
						}
					}

				} else{
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_COUNTRY_H2P', array());
					$this->setType();
				}

				if (!$rtn) {
					$this->setType(TYPE_WITHDRAW_H2P_BACK);
					return;
				}

				if (!$this->checkWithdrawLimit($this->getUserData(PARAM_USER_ACCOUNT), $this -> currency , $this-> amount)) {
						 $this->popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW_KYC2', array());
						 $this->setType(TYPE_WITHDRAW_H2P_BACK);
						 return;
				 }

				 $balance = $this->getBalanceCommon($this->getUserData(PARAM_USER_ACCOUNT), $this->fromCurrency);

				$exchange = $this->getExchangeCommon($this -> amount
													, $this -> currency
													, $this -> fromCurrency
													, false
													, true
													, NO_STRING
													, $this -> getUserData(PARAM_USER_ACCOUNT)); //FOR H2P

				$computedFee = round($exchange[PARAM_AMOUNT] * 0.02,2);

				$minimumFee = $this -> getMinimumFee($this -> receiptBankCountry); // get min fee based on Country

				$exchangeMinimumFee = $this->getExchangeCommon($minimumFee
					                                           , $this -> currency
					                                           , $this -> fromCurrency
					                                           , false
					                                           , true
					                                           , NO_STRING
															   , $this -> getUserData(PARAM_USER_ACCOUNT));

				$computedMinimumFee =  round($exchangeMinimumFee[PARAM_AMOUNT],2);

				if(($computedMinimumFee > $computedFee)){
					$this->fee = $computedMinimumFee;
				} else {
					$this->fee = $computedFee;
				}

				//$this->fee = round($exchange[PARAM_ORIGINAL_AMOUNT] * 0.02,2);

				$total = ($exchange[PARAM_AMOUNT] + $this->fee);

				$this->setRateEx($exchange[PARAM_RATE]);
				$this -> setFeeEx($this -> fee);
					//
				$this->debitCurrency = $this->fromCurrency;
				$this->debitAmount   = $exchange[PARAM_AMOUNT];

					//
				if ($balance < $total && $this->checkNull($this->fromCurrency)) {
						$this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_FUNDS', array($this->fromCurrency, $this->formatCurrency($total, $this->fromCurrency)));
						$rtn = false;
				}

				if (!$rtn) {
					$this->setType(TYPE_WITHDRAW_H2P_BACK);
					return;
				}

			   //create session variable for 2favalidated
			   $_SESSION['2fa_validated'] = 'not validated';

         }

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: バランスの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispBalances() {

		// 変数宣言部
		$rtn 	= NO_STRING;
		$lists	= array();

		// データを入れ替える
		if($this -> isLoopData($this -> balances)) {

			foreach($this -> balances as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> currencies)) {
			foreach($this -> currencies as $row) {

				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$data		= $this -> getColumnData($lists, $currency);
				$amount		= NO_COUNT;

				// データを生成
				if($data == NO_STRING) {	// データが無い
					$amount = $this -> getAmountString($amount, $currency);
				} else {
					$amount = $this -> getAmountString($this -> getColumnData($data, COLUMN_BALANCE), $currency);
				}

				$rtn .= '<label class="w33p">' . $this -> makeRadioOne(PARAM_TRANSFER_FROM_CURRENCY . $currency
																		, PARAM_TRANSFER_FROM_CURRENCY
																		, $currency
																		, $this -> fromCurrency)
						 . $currency . ' - ' . $amount . '</label>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 過去の送金履歴リストの取得
	* @parameter	: なし
	* @return		: 過去の送金履歴リスト
	-------------------------------------------------------------------------*/
	public function dispWithdarawHistory() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$lists	= array();

		// データが存在した場合
		if($this -> isLoopData($this -> history)) {

			foreach($this -> history as $row) {
				$lists[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_W_ID)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_ACCOUNT_NAME) . ' - ' . $this -> getColumnData($row, COLUMN_RECEIPT_BANK_NAME) . ' - ' . $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER));
			}

			$rtn = $this -> dispListOption($lists, NO_STRING);
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
     * @function_name: CN銀行
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function disWithdarawLocalBank()
    {
        $rtn = NO_STRING;
        $this->accountNumber = NO_STRING;
        $this->accountName = NO_STRING;

        //set country
        if(count($this -> user) > 0){
            $this -> receiptCountry = $this -> getColumnData($this -> user, COLUMN_COUNTRY);
        }

        //check if user doesn't have bypass sulotion access
        if(!$this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_LBTC_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)))){

			//check if user is high risk - Mikko 2019 0312
			if($this -> getColumnData($this -> account, COLUMN_RISK_LEVEL) == VAL_INT_1){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
				$this->setType();
				return;
			}

			//Determine if you are a Chinese account
            if ($this->getReceiptCountry() != TYPE_LOCAL_BANK_COUNTRY) {
                $this->popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_COUNTRY', array());
                $this->setType(NO_STRING);
                $rtn = false;
            }
        }

    }

   	 /*-------------------------------------------------------------------------
	 * @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function dispCurrency() {
		echo $this -> dispCurrencyOptionList($this -> currency, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料
	 * @parameter	: なし
	 * @return		: 
	 -------------------------------------------------------------------------*/
	public function echoDrawFee(){
	    echo $this -> drawFee;
	}
    	
	/*-------------------------------------------------------------------------
	 * @function_name: 手数料
	 * @parameter	: なし
	 * @return		:
	 -------------------------------------------------------------------------*/
	public function echoDrawFeeCurrency(){
	    echo $this -> drawFeeCurrency;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function dispAmount() {
		echo number_format(floatval($this -> amount), $this -> getDigitCount($this -> currency));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座名義の取得
	* @parameter	: なし
	* @return		: 口座名義
	-------------------------------------------------------------------------*/
	public function echoAccountName() {
		echo $this -> accountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function getReceiptCountry() {
		return $this -> receiptCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function echoReceiptCountry() {
		echo $this -> dispCountryOptionList($this -> receiptCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function dispReceiptCountry() {
		echo $this -> dispCountryCommon($this -> receiptCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人住所1の取得
	* @parameter	: なし
	* @return		: 受取人住所1
	-------------------------------------------------------------------------*/
	public function echoReceiptAddress1() {
		echo $this -> receiptAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人住所2の取得
	* @parameter	: なし
	* @return		: 受取人住所2
	-------------------------------------------------------------------------*/
	public function echoReceiptAddress2() {
		echo $this -> receiptAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人メッセージの取得
	* @parameter	: なし
	* @return		: 受取人メッセージ
	-------------------------------------------------------------------------*/
	public function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人メッセージの取得
	* @parameter	: なし
	* @return		: 受取人メッセージ
	-------------------------------------------------------------------------*/
	public function echoReceiptMessage() {
        echo $this->receiptMessage;
    }

	/*-------------------------------------------------------------------------
	* @function_name: 受取人メッセージの取得
	* @parameter	: なし
	* @return		: 受取人メッセージ
	-------------------------------------------------------------------------*/
	public function echoLocalMessage() {
		$uri        = $_SERVER["REQUEST_URI"];
        $langStrArr = explode(DELIMIT_SLASH, $uri);
        $langStr    = $langStrArr[VAL_INT_1];

        //判断是否有message
        if(!$this->checkNull($this->receiptMessage)){
           echo $this->receiptMessage = getLanguageMessage($langStr);
        } else {
            echo $this->receiptMessage;
        }
    }

	/*-------------------------------------------------------------------------
	 * @function_name: 受取銀行名の取得
	* @parameter	: なし
	* @return		: 受取銀行名
	-------------------------------------------------------------------------*/
	public function echoReceiptBankName() {
		echo $this -> receiptBankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行SWIFTの取得
	* @parameter	: なし
	* @return		: 受取銀行SWIFT
	-------------------------------------------------------------------------*/
	public function echoReceiptBankSwift() {
		echo $this -> receiptBankSwift;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行支店コードの取得
	* @parameter	: なし
	* @return		: 受取銀行支店コード
	-------------------------------------------------------------------------*/
	public function echoReceiptBranchCode() {
        $branchCode = $this -> receiptBranchCode;

        //get branch code only
        if($_SESSION['moneyoutSolution'] == 'Flat3') {
            $codeArray = unserialize($this -> receiptBranchCode);
            foreach($codeArray as $key => $val){
                if($key == 'Branch Code'){
                    $branchCode = $val;
                    break;
                }
            }
        }


		echo $branchCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行支店の取得
	* @parameter	: なし
	* @return		: 受取銀行支店
	-------------------------------------------------------------------------*/
	public function echoReceiptBranchName() {
		echo $this -> receiptBranchName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行国の取得
	* @parameter	: なし
	* @return		: 受取銀行国
	-------------------------------------------------------------------------*/
	public function getReceiptBankCountry() {
		return $this -> receiptBankCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行国の取得
	* @parameter	: なし
	* @return		: 受取銀行国
	-------------------------------------------------------------------------*/
	public function echoReceiptBankCountry() {
		echo $this -> dispCountryOptionList($this -> receiptBankCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人銀行国の取得
	* @parameter	: なし
	* @return		: 受取人銀行国
	-------------------------------------------------------------------------*/
	public function dispReceiptBankCountry() {
		echo $this -> dispCountryCommon($this -> receiptBankCountry);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取銀行住所1の取得
	* @parameter	: なし
	* @return		: 受取銀行住所1
	-------------------------------------------------------------------------*/
	public function echoReceiptBankAddress1() {
		echo $this -> receiptBankAddress1;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取銀行住所2の取得
	* @parameter	: なし
	* @return		: 受取銀行住所2
	-------------------------------------------------------------------------*/
	public function echoReceiptBankAddress2() {
		echo $this -> receiptBankAddress2;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取銀行口座番号の取得
	* @parameter	: なし
	* @return		: 受取銀行口座番号
	-------------------------------------------------------------------------*/
	public function echoAccountNumber() {
		echo $this -> accountNumber;
	}


	/*-------------------------------------------------------------------------
	 * @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function getIntermediaryFlg() {
		return $this -> intermediaryFlg;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function echoIntermediaryFlg() {
		echo $this -> makeCheckOne(PARAM_INTERMEDIARY_FLG
									, PARAM_INTERMEDIARY_FLG
									, VAL_INT_1
									, VAL_STR_INTERMEDIARY_BANK_USED
									, $this -> intermediaryFlg);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function dispIntermediaryFlg() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> intermediaryFlg == VAL_INT_1) {
			$rtn = VAL_STR_INTERMEDIARY_BANK_USED;
		} else {
			$rtn = VAL_STR_INTERMEDIARY_BANK_NOT_USED;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行名の取得
	* @parameter	: なし
	* @return		: 中継銀行名
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankName() {
		if($this -> intermediaryFlg == VAL_INT_1) {
			echo $this -> intermediaryBankName;
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行SWIFTの取得
	* @parameter	: なし
	* @return		: 中継銀行SWIFT
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankSwift() {
		if($this -> intermediaryFlg == VAL_INT_1) {
			echo $this -> intermediaryBankSwift;
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankCountry() {
		if($this -> intermediaryFlg == VAL_INT_1) {
			echo $this -> intermediaryBankCountry;
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankCountryString() {
		if($this -> intermediaryFlg == VAL_INT_1) {
			echo $this -> dispCountryCommon($this -> intermediaryBankCountry);
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function dispIntermediaryBankCountry() {
		echo $this -> dispCountryOptionList($this -> intermediaryBankCountry, false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行住所1の取得
	* @parameter	: なし
	* @return		: 中継銀行住所1
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankAddress1() {
		if($this -> intermediaryFlg == VAL_INT_1) {
			echo $this -> intermediaryBankAddress1;
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行住所2の取得
	* @parameter	: なし
	* @return		: 中継銀行住所2
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankAddress2() {
		echo NO_STRING;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行メッセージの取得
	* @parameter	: なし
	* @return		: 中継銀行メッセージ
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankMessage() {
		if($this -> intermediaryFlg == VAL_INT_1) {
			echo $this -> intermediaryBankMessage;
		} else {
			echo NO_STRING;
		}
	}


	public function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 最小手数料の指定
	 * @parameter	: 
	 * @return		: 
	 -------------------------------------------------------------------------*/
	private function arrangeMinimumFee(){
	    $minimumFee = VAL_INT_35;
	    $this -> drawFeeCurrency = JPY;
	    
	    $transactionFee = $this -> convertedFee($this -> debitCurrency, USD, $this -> getFeeEx());
	    
	    if($transactionFee["published_amount"] < $minimumFee){
	        // antonius gaming 2023
	        $standardJPYFee = $this -> convertedFee(USD, JPY, $minimumFee);
	        $transactionFee = $this -> convertedFee(USD, $this -> debitCurrency, $minimumFee);
	        
	        $this -> setFeeEx($transactionFee["published_amount"]);
	    }else{
	        $standardJPYFee = $this -> convertedFee(USD, JPY, $transactionFee["published_amount"]);
	    }
	    
	    $this -> drawFee = $standardJPYFee["published_amount"];
	    
	    $loggedInUserAcc = $this -> getUserData(PARAM_USER_ACCOUNT);
	    $adminException  = $this -> getSettingConfiguration("administrative_exception");
	    
	    foreach($adminException as $data){
	        if(isset($data -> user_account) && $data -> user_account === $loggedInUserAcc){
	            if(isset($data -> ignore_f3withdrawal_fee) && $data -> ignore_f3withdrawal_fee){
	               $this -> setFeeEx(NO_COUNT);
	               $this -> drawFee = NO_COUNT;
	            }
	            break;
	        }
	    }
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 手数料の両替
	 * @parameter	: from, to, amount
	 * @return		: 引落口座通貨
	 -------------------------------------------------------------------------*/
	private function convertedFee($from, $to, $amount){
	    $exchange = $this -> getExchangeCommon($amount,
	        $from,
	        $to,
	        false,
	        true,
	        NO_STRING,
	        $this -> getUserData(PARAM_USER_ACCOUNT));
	    
	    $rtn = [
	        "parameter" => $amount,
	        "conversion_currency" => $to,
	        "original_amount" => $exchange[PARAM_ORIGINAL_AMOUNT],
	        "published_amount" => $exchange[PARAM_AMOUNT]
	    ];
	    
	    return $rtn;
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: 引落口座通貨の取得
	* @parameter	: なし
	* @return		: 引落口座通貨
	-------------------------------------------------------------------------*/
	public function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落口座金額の取得
	* @parameter	: なし
	* @return		: 引落口座金額
	-------------------------------------------------------------------------*/
	public function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落口座金額の取得
	* @parameter	: なし
	* @return		: 引落口座金額
	-------------------------------------------------------------------------*/
	public function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落口座金額の取得
	* @parameter	: なし
	* @return		: 表示用HTM用文字列
	-------------------------------------------------------------------------*/
	public function dispDebitAmount() {
		echo $this -> formatCurrency($this -> debitAmount, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料
	-------------------------------------------------------------------------*/
	public function dispFee() {
		echo $this -> formatCurrency($this -> getFeeEx(), $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落口座の取得
	* @parameter	: なし
	* @return		: 引落口座
	-------------------------------------------------------------------------*/
	public function echoFromCurrency() {
		echo $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示・非表示の取得
	* @parameter	: なし
	* @return		: CSSクラス
	-------------------------------------------------------------------------*/
	public function echoCssDisplay() {
		if($this -> receiptBankCountry == VAR_JP) {
			echo NO_STRING;
		} else {
			echo 'style="display:none;"';
		}
	}

    /*-------------------------------------------------------------------------
	* @function_name: echoMoneyOutSolution
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoMoneyOutSolution() {
		echo $_SESSION['moneyoutSolution'];
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoProvince
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoProvince() {
		echo $this -> province[1];
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoProvinceCode
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoProvinceValue() {
		echo implode(',', $this -> province);
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoCity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoCity() {
		echo $this -> city[1];
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoCityCode
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function echoCityValue() {
		echo implode(',', $this -> city);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のバランスデータの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setBalances($rs) {
		$this -> balances = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のの設定
	* @parameter	: 結果ット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金履歴のの設定
	* @parameter	: 結果ット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setHistory($rs) {
		$this -> history = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 登録用データ配列
	-------------------------------------------------------------------------*/
    public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		// 変数宣言部
		$rtn = array();
		
		$this -> arrangeMinimumFee();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								                                        // 口座番号(1)
		$rtn[] = $this -> currency;														                                        // 通貨(2)
		$rtn[] = $this -> currencyToInt($this -> amount, $this -> currency);			                                        // 金額(3)
		$rtn[] = $this -> currency;														                                        // 通貨(4)
		$rtn[] = $this -> accountName;													                                        // 口座名義(5)
		$rtn[] = $this -> receiptCountry;												                                        // 受取人国(6)
		$rtn[] = $this -> receiptAddress1;												                                        // 受取人住所1(7)
		$rtn[] = $this -> receiptAddress2;												                                        // 受取人住所2(8)
		$rtn[] = $this -> receiptMessage;		                                                                                // 受取人メッセージ(9)
		$rtn[] = $this -> receiptBankName;												                                        // 受取銀行名(10)
		$rtn[] = $this -> receiptBranchName;											                                        // 受取銀行支店名(11)
		$rtn[] = $this -> receiptBankSwift;												                                        // 受取銀行SWIFT(12)
		$rtn[] = $this -> receiptBankCountry;											                                        // 受取銀行国(13)
		$rtn[] = $this -> receiptBankAddress1;											                                        // 受取銀行住所1(14)
		$rtn[] = $this -> receiptBankAddress2;											                                        // 受取銀行住所2(15)
		$rtn[] = $this -> accountNumber;												                                        // 受取銀行口座番号(16)
		$rtn[] = intval($this -> intermediaryFlg);										                                        // 中継銀行フラグ(17)
		$rtn[] = $this -> intermediaryBankName;											                                        // 中継銀行名(18)
		$rtn[] = $this -> intermediaryBankSwift;										                                        // 中継銀行SWIFT(19)
		$rtn[] = $this -> intermediaryBankCountry;										                                        // 中継銀行国(20)
		$rtn[] = $this -> intermediaryBankAddress1;										                                        // 中継銀行住所1(21)
		$rtn[] = $this -> intermediaryBankAddress2;										                                        // 中継銀行住所2(22)
		$rtn[] = $this -> intermediaryBankMessage;										                                        // 中継銀行メッセージ(23)
		$rtn[] = $this -> tel;															                                        // 電話番号(24)
		$rtn[] = $this -> debitCurrency;												                                        // 引落口座通貨(25)
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);	                                        // 引落口座金額(26)
		$rtn[] = $this -> getRateEx();													                                        // レート(27)
		$rtn[] = $this -> currencyToInt($this -> getFeeEx(), $this -> debitCurrency);	                                        // 手数料(28)
		$rtn[] = $this -> drawFeeCurrency;                                                                                      // 通貨(29)
		$rtn[] = $this -> drawFee;                                                                                              // 手数料(30)
		$rtn[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_WITHDRAW);			                                        // 取引番号(31)
		$rtn[] = $this -> receiptBranchCode;											                                        // 受取銀行支店コード(32)
		$rtn[] = $_SESSION['moneyoutSolution'];											                                        // withdraw solution (33)
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得
	* @parameter	: なし
	* @return		: メール送信用データ
	-------------------------------------------------------------------------*/
	public function getSendData() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($data);

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);		// ユーザ名
		$rtn[] = $this -> getCurrentTimeCommon();										// 現在時刻
		$rtn[] = $this -> currency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> amount, $this -> currency);			// 金額
		$rtn[] = $this -> getColumnData($row, COLUMN_MAIL);								// メールアドレス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

    public function getLanguage()
    {

        // 変数宣言部
        $rtn  = array();
        $lang = NO_COUNT;

        // 言語判定
        if (isset($_SERVER["REQUEST_URI"])) {
            $uri        = $_SERVER["REQUEST_URI"];
            $langStrArr = explode(DELIMIT_SLASH, $uri);
            $langStr    = $langStrArr[VAL_INT_1];

            if ($langStr == "ja") {
                $lang = VAL_INT_1;
            } else if ($langStr == "en") {
                $lang = VAL_INT_1;
            } else if ($langStr == "sc") {
                $lang = NO_COUNT;
            } else if ($langStr == "tc") {
                $lang = NO_COUNT;
            }
        }

        return $lang;
    }
    public function getLang()
    {

        // 変数宣言部
        $rtn  = array();
        $lang = NO_COUNT;

        // 言語判定
        if (isset($_SERVER["REQUEST_URI"])) {
            $uri        = $this -> sqlSanitation($_SERVER["REQUEST_URI"]);
            $langStrArr = explode(DELIMIT_SLASH, $uri);
            $lang    = $langStrArr[VAL_INT_1];
        }

        return $lang;
    }
    /*-------------------------------------------------------------------------
     * @function_name: AllBank
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function disabledAllBank()
    {
        $rtn  = NO_STRING;
        $bank = getLocalBankAllowList();
        $lang = $this->getLanguage();
        foreach ($bank as $key => $value) {
            if ($this->receiptBankName == $value[2]) {

                $rtn .= '<option value=' . $value[2] . ' selected=\'selected\' >' . $value[$lang] . '</option>';
            } else {
                $rtn .= '<option value=' . $value[2] . '>' . $value[$lang] . '</option>';
            }
        }
        echo $rtn;
    }

	/*-------------------------------------------------------------------------
     * @function_name: echoProvinceList
     * @parameter    :
     * @return       :
    --------------------------------------------------------------------------*/
	public function echoProvinceList() {
		$rtn  = NO_STRING;
		$provinceData = getProvinceCityData();

		foreach($provinceData['province'] as $value) {
			$optionValue = $value['code'].','.$value['name'];
			if($this -> province != null && implode(',', $this -> province) == $optionValue) {
				$rtn .= '<option value="'.$optionValue.'" selected="selected">'.$value['name'].'</option>';
			} else {
				$rtn .= '<option value="'.$optionValue.'">'.$value['name'].'</option>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
     * @function_name: echoCityList
     * @parameter    :
     * @return       :
    --------------------------------------------------------------------------*/
	public function echoCityList() {
		$rtn  = NO_STRING;
		$provinceData = getProvinceCityData();

		if($this -> province != null) {
			foreach($provinceData['province'] as $value) {
				$provinceValue = $value['code'].','.$value['name'];
				if(implode(',', $this -> province) == $provinceValue) {
					$city = $value['city'];
					foreach ($city as $cityData) {
						$optionValue = $cityData['code'].','.$cityData['name'];
						if(implode(',', $this -> city) == $optionValue) {
							$rtn .= '<option value="'.$optionValue.'" selected="selected">'.$cityData['name'].'</option>';
						} else {
							$rtn .= '<option value="'.$optionValue.'>'.$cityData['name'].'</option>';
						}
					}
				}
			}
		}

		echo $rtn;
	}

    /*-------------------------------------------------------------------------
     * @function_name: BankName
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function disBankName()
    {
        $lang = $this->getLanguage();
        $bank = getLocalBankAllowList();
        echo $bank[$this->receiptBankName][$lang];
    }
    /*-------------------------------------------------------------------------
     * @function_name: BankID
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function disBankID()
    {
        $bank = getLocalBankAllowList();
        echo $bank[$this->receiptBankName][2];
    }
    /*-------------------------------------------------------------------------
     * @function_name: Rate
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function disFee()
    {
        echo $this->fee;
    }    /*-------------------------------------------------------------------------
     * @function_name: LocalRate
     * @parameter    :
     * @return       :
    --------------------------------------------------------------------------*/
    public function disLocalFee()
    {
        echo $this -> formatCurrency($this->fee, $this -> debitCurrency);
    }
    /*-------------------------------------------------------------------------
     * @function_name: 登録用のデータ取得関数
     * @parameter    : なし
     * @return        : 登録用データ配列
    -------------------------------------------------------------------------*/
    public function getLocalRegistData()
    {
        $bank = getLocalBankAllowList();
        // 変数宣言部
        $rtn = array();


        $rtn[] = $this->getUserData(PARAM_USER_ACCOUNT); // 口座番号(1)
        $rtn[] = CNY; // 通貨(2)
        $rtn[] = $this->currencyToInt($this->amount, CNY); // 金額(3)
        $rtn[] = CNY; // 通貨(4)
        $rtn[] = $this->accountName; // 口座名義(5)
        $rtn[] = 'CN'; // 受取人国(6)
        $rtn[] = $this->receiptAddress1; // 受取人住所1(7)
        $rtn[] = $this->receiptAddress2; // 受取人住所2(8)
        $rtn[] = $this->receiptMessage; // 受取人メッセージ(9)
        $rtn[] = TYPE_LOCAL_BACK_IDENTIFICATION; // 受取銀行名(10)
        $rtn[] = $this->receiptBranchName; // 受取銀行支店名(11)
        $rtn[] = $this->receiptBankSwift; // 受取銀行SWIFT(12)
        $rtn[] = 'CN'; // 受取銀行国(13)
        $rtn[] = $this->receiptBankAddress1; // 受取銀行住所1(14)
        $rtn[] = $this->receiptBankAddress2; // 受取銀行住所2(15)
        $rtn[] = $this->accountNumber; // 受取銀行口座番号(16)
        $rtn[] = intval($this->intermediaryFlg); // 中継銀行フラグ(17)
        $rtn[] = $this->intermediaryBankName; // 中継銀行名(18)
        $rtn[] = $this->intermediaryBankSwift; // 中継銀行SWIFT(19)
        $rtn[] = $this->intermediaryBankCountry; // 中継銀行国(20)
        $rtn[] = $this->intermediaryBankAddress1; // 中継銀行住所1(21)
        $rtn[] = $this->intermediaryBankAddress2; // 中継銀行住所2(22)
        $rtn[] = $this->intermediaryBankMessage; // 中継銀行メッセージ(23)
        $rtn[] = $this->tel; // 電話番号(24)
        $rtn[] = $this->debitCurrency; // 引落口座通貨(25)
        $rtn[] = $this->currencyToInt($this->debitAmount, $this->debitCurrency); // 引落口座金額(26)
        $rtn[] = $this->getRateEx(); // レート(27)
        $rtn[] = $this->currencyToInt($this->fee, $this->debitCurrency); // 手数料(28)
        $rtn[] = $this->getTransactionNumberCommon(VAR_TRANSACTION_WITHDRAW); // 取引番号(29)
        $rtn[] = $this->receiptBranchCode; // 受取銀行支店コード(30)
        $rtn[] = $_SESSION['moneyoutSolution']; // 受取銀行支店コード(30)
        $rtn[] = NO_COUNT; // 受取銀行支店コード(30)
        $rtn[] = $this->getLang(); // 语言
        return $rtn;
    }
    /*-------------------------------------------------------------------------
     * @function_name: get API
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function getSdPayApiData($data)
    {
        $bank = getLocalBankAllowList();

        // $unique        = $this->createUId();
        // $keyEncryption = NO_STRING;
        // $rtn           = array();
        // $rtn[]         = NO_COUNT;
        // $rtn[]         = $data[VAL_INT_15];
        // $rtn[]         = $data[VAL_INT_4];
        // $rtn[]         = $bank[$this->receiptBankName][VAL_INT_2];
        // $rtn[]         = NO_STRING;
        // $rtn[]         = $this->intToCurrency($data[VAL_INT_2], $data[VAL_INT_1]);
        // $rtn[]         = $data[VAL_INT_28];
        // $dataApi       = getApiXml();
        // $dataApi       = $this->setApiElementParam($dataApi, $rtn);
        // $keyEncryption = $this->getEncryption(VAL_SDPAY_KEY1, VAL_SDPAY_KEY2, $dataApi);

		$amount = $this -> formatCurrency($this -> amount, $this -> currency);
		$amount = str_replace(',', '', $amount);

		$arr_param = array (
			'intoAccount' => $this -> accountNumber,
			'intoName' => $this -> accountName,
			'intoBank' => $bank[$this->receiptBankName][NO_COUNT],
			'intoBankBranch' => $this -> receiptBranchName,
			'intoBankCode' => $bank[$this->receiptBankName][VAL_INT_2],
			'intoProvince' => $this -> province[0],
			'intoCity' => $this -> city[0],
			'intoAmount' => $amount,
			'serialNumber' => $data[VAL_INT_28],
			'merchantCode' => SD_MERCHANT_CODE,
			'remark' => $this -> receiptMessage,
			'asyncURL' => SD_WITHDRAW_ASYNC_URL.'?t_num='.$data[VAL_INT_28],
			'requestTime' => date("YmdHis"),
			'signature' => $this -> withdrawTool -> create_send_privatesign(SD_MERCHANT_CODE.$this -> accountNumber.$amount, SD_MERCHANT_PRIVATE_KEY)
		);

		$dir = '../api/Logs/SDPayWithdraw/request';
        if(!is_dir($dir))
        {
            mkdir($dir);
            chmod($dir,0777);
        }
        //发送数据存入log
        error_log(date("\r\n[Y-m-d H:i:s]") . "SDPay request data\r\n" . json_encode($arr_param, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . "\r\n", 3, '../api/Logs/SDPayWithdraw/request/Log_' . date("Y-m-d") . '.log');

        return $arr_param;
    }
    /*-------------------------------------------------------------------------
     * @function_name: first return
     * @parameter    : なし
     * @return       : 送金
    --------------------------------------------------------------------------*/
    public function getReturnSDpay($data, $params)
    {
        if ($data > 0) {
            $params[2] = VAL_WITHDRAW_SUCCESS_RETURN . $data;
            $this->setType(TYPE_LOCAL_BACK_SUCCESS);
        } else {
            $params[2] = VAL_WITHDRAW_FAILED_RETURN . $data;
            $this->setType(TYPE_LOCAL_BACK_FAILED);
        }
        $params[1] = $data;
        $params[3] = VAL_INT_0;
        return $params;
    }

    public function getSDpay($rtn){
		//require api file
		include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'sdAPIWithdraw.php';

		$this -> withdrawTool = new sdAPIWithdraw();

		$dir = '../api/Logs/SDPayWithdraw';
        if(!is_dir($dir))
        {
            mkdir($dir);
            chmod($dir,0777);
        }

		$dir2 = '../api/Logs/SDPayWithdraw/response';
        if(!is_dir($dir2))
        {
            mkdir($dir2);
            chmod($dir2,0777);
        }

        //取得加密代码
        $merchantid            = VAL_SDPAY_USER;
		$data1                 = $this -> withdrawTool -> create_send_publicsign(json_encode($this->getSdPayApiData($rtn)), SD_PUBLIC_KEY);
        $des['securityCode']   = $data1;
		$data2                 = base64_encode(json_encode($des));
		$sendData['content']   = $data2;
        $params     = array();
        $params[0]  = $rtn[VAL_INT_28];


        //发送数据存入log
        error_log(date("\r\n[Y-m-d H:i:s]") . "SDPay Encrypted request\r\n" . $data2 . "\r\n", 3, '../api/Logs/SDPayWithdraw/Log_' . date("Y-m-d") . '.log');
        //对接api

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, SD_WITHDRAW_API_URL);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $sendData);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$responseData = curl_exec($ch);
		if(curl_errno($ch)) {
			$error = curl_error($ch);

			$params[1] = 5;
			$params[2] = 'failed request. curl error: ' . $error;
			$params[3] = $params[0];
			$this -> accessModifyCommon('UPDATE_WITHDRAW_LOCAL_STATUS', $params);
			$this -> accessModifyCommon('UPDATE_WITHDRAW_LOCAL_STATUS_RETURN', array($params[0]));

			return $error;
		}
		curl_close($ch);
		$responseArray = json_decode($responseData, true);

		//log response
		error_log(date("\r\n[Y-m-d H:i:s]") . "SDPay Response\r\n" . $responseData . "\r\n", 3, '../api/Logs/SDPayWithdraw/response/Log_' . date("Y-m-d") . '.log');

		$type = $this -> withdrawTool -> processWithdrawal($responseArray, $params);

		if($type != null) {
			$this -> setType($type);
		}

		return;
    }
    
    public function getPendingWithdrawalTransactions(){
        $userAccount = (is_null($this -> user) 
            ? $this -> getUserData(PARAM_USER_ACCOUNT)
            : $this -> getColumnData($this -> user, PARAM_USER_ACCOUNT));
        
        return $this -> accessSelect("LIST_FLAT3_PENDING_WITHDRAWALS", [$userAccount]);
    }
    
    public function getOutStatus()
    {
        $rtn    = array();
        $method = getOouMoney();
        $lang = $this -> getLangage();
        foreach ($method as $key => $value) {
			$solution = ($value[1] == 'Flat3') ? PARAM_WITHDRAW_FLAT3_METHOD : (($value[1] == 'SDPay') ? PARAM_WITHDRAW_LBTC_METHOD : (($value[1] == 'H2P') ? PARAM_WITHDRAW_H2P_METHOD : PARAM_WITHDRAW_IBT_METHOD));
			$access = $this -> getUserBypassValue(PARAM_WITHDRAW,$solution,$this -> getColumnData($this -> user, 'user_account'));
            if ($value[0] == 0 && ((strpos($value[3],$lang) !== false) && !($this -> checkAccountType($this -> getColumnData($this -> user, 'mail')))) || $value[1] == 'International' || $access != false) {
                if(($lang == 'ja' && $value[1] != 'SDPay' && $value[1] != 'H2P')||(($lang == 'sc' || $lang == 'tc')&& $value[1] != 'Flat3' && $value[1] != 'H2P')||(($lang == 'en') && $value[1] != "H2P")||(($lang == 'id')&& ($value[1] != 'SDPay' && $value[1] != 'Flat3'))){
                    $rtn[] = $value[2].getOutLanguage($lang.'_'.$value[1]);
				}
            }
        }
        return $rtn;
    }

    /*-------------------------------------------------------------------------
     * @function_name: echoReceiptBankCode
     * @parameter    :
     * @return       :
    --------------------------------------------------------------------------*/
    public function echoReceiptBankCode(){
        echo $this -> receiptBankCode;

    }
	public function setWithdrawSolution($withdrawSolution = 'ibt'){
			$this -> withdrawSolution = $withdrawSolution;
	}
	public function getWithdrawSolution(){
		//set header according to solution
		if($this -> withdrawSolution == 'flat3'){
			$rtn = VAL_STR_WITHDRAW_FLAT3;
		}else if($this -> withdrawSolution == 'lbtc'){
			$rtn = VAL_STR_WITHDRAW_LBTC;
		}else if($this -> withdrawSolution == 'H2P'){
			$rtn = VAL_STR_WITHDRAW_H2P;
		}else{
			$rtn = VAL_STR_WITHDRAW;
		}
        return $rtn;
    }
    /*-------------------------------------------------------------------------
     * @function_name: validateInputs
     * @parameter    :
     * @return       : bool - true if all are valid else false
    --------------------------------------------------------------------------*/
    public function validateInputs(){
        $rtn = true;

        // 金額のチェック
        if(!$this -> checkNull($this -> amount)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
            $rtn = false;
        } elseif(!$this -> checkStringNumber($this -> amount)) {
            $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
            $rtn = false;
        } elseif(!$this->CheckWithdrawMinimum($this -> currency, $this -> amount)) { //check withdrawal minimum
            $exchange = $this -> getExchangeCommon(VAL_INT_MINIMUM_WITHDRAW_AMOUNT, 'USD', $this -> currency,
            			false, false, NO_STRING, $this -> getUserData(PARAM_USER_ACCOUNT)); // anton
            $this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_MINIMUM', array($this -> currency, $exchange[PARAM_ORIGINAL_AMOUNT]));
            $rtn = false;
        }

        // check currency if in list of allowed currenicies
        if(!$this -> checkWithdrawCurrency($this -> currency, $_SESSION['moneyoutSolution'])){
            $this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_CURRENCY_NOT_ALLOWED', array());
            $rtn = false;
        }

        // 口座名義のチェック
        if(!$this -> checkNull($this -> accountName)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ACCOUNT_NAME));
            $rtn = false;
        } elseif($_SESSION['moneyoutSolution'] == 'Flat3'){ //check if flat3
            //check if Katakana only
            if(!$this -> checkKatakanaStringOnly($this -> accountName)){
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_NAME_KATAKANA_ONLY', array(VAL_STR_ACCOUNT_NAME));
                $rtn = false;
            }
        } else{
            // 口座名義の正規表現チェック
            if(!$this -> checkStringAsciiAndSpace($this -> accountName)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_ACCOUNT_NAME));
                $rtn = false;
            }
        }

        // 受取人国のチェック
        if(!$this -> checkNull($this -> receiptCountry)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_COUNTRY));
            $rtn = false;
        }

        //check if moneyout solution is not Flat3
        if($_SESSION['moneyoutSolution'] != 'Flat3'){
            // 受取人住所1のチェック
            if(!$this -> checkNull($this -> receiptAddress1)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_ADDRESS));
                $rtn = false;
            } elseif(!$this -> checkMaxStringLength($this -> receiptAddress1)) { //check length if greater than 256
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_ADDRESS_CHARACTER_LENGTH_EXCEEDED', array($this -> addressTextArray[0]));
                $rtn = false;
            } elseif(!$this -> checkStringWithdraw($this -> receiptAddress1)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_WITHDRAW', array(VAL_STR_RECEIPT_ADDRESS_1));
                $rtn = false;
            }

            // 受取銀行SWIFTのチェック
            if(!$this -> checkNull($this -> receiptBankSwift)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_SWIFT_CODE));
                $rtn = false;
            } elseif(!$this -> checkStringAscii($this -> receiptBankSwift)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_BANK_SWIFT_CODE));
                $rtn = false;
            } elseif(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_8)) {
                if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_11)) {
                    $this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH', array($this -> receiptBankSwift));
                    $rtn = false;
                }
            }

            // 受取銀行住所1のチェック
            if(!$this -> checkNull($this -> receiptBankAddress1)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_ADDRESS));
                $rtn = false;
            } elseif(!$this -> checkMaxStringLength($this -> receiptBankAddress1)) { //check length if greater than 256
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_ADDRESS_CHARACTER_LENGTH_EXCEEDED', array($this -> addressTextArray[1]));
                $rtn = false;
            } elseif(!$this -> checkStringWithdraw($this -> receiptBankAddress1)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_WITHDRAW', array(VAL_STR_RECEIPT_BANK_ADDRESS_1));
                $rtn = false;
            }
        } else{ //if moneyout solution is flat 3
            //check if bank code is null
            if(!$this -> checkNull($this -> receiptBankCode)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_CODE));
                $rtn = false;
            } elseif(!$this -> checkStringNumberOnly($this -> receiptBankCode)) { //check if number only
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_RECEIPT_BANK_CODE));
                $rtn = false;
            }

			if(mb_strlen($this -> accountNumber, CHAR_SET_UTF_8) > VAL_INT_7) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_RECEIPT_BANK_ACCOUNT_NUMBER, VAL_INT_1, VAL_INT_7));
				$rtn = false;
			} elseif(mb_strlen($this -> accountNumber, CHAR_SET_UTF_8) < VAL_INT_7) {
				$this -> accountNumber = str_pad($this -> accountNumber,VAL_INT_7,"0",STR_PAD_LEFT);
			}
        }

        // 受取銀行名のチェック
        if(!$this -> checkNull($this -> receiptBankName)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
            $rtn = false;
        } elseif(!$this -> checkLength($this -> receiptBankName
                                , VAL_INT_1
                                , VAL_INT_100)) {
            $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_RECEIPT_BANK_NAME
                                                                                , VAL_INT_1
                                                                                , VAL_INT_100));
            $rtn = false;
        }
		 elseif(!$this -> checkStringWithdraw($this -> receiptBankName)) {
			 if($_SESSION['moneyoutSolution'] != 'Flat3'){
				 $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_WITHDRAW', array(VAL_STR_RECEIPT_BANK_NAME));
				 $rtn = false;
			 }
        }

        if($this -> receiptBankCountry == VAR_JP) {
            $branchCode = $this -> receiptBranchCode;

            //check if flat 3
            if($_SESSION['moneyoutSolution'] == 'Flat3') {
                $codeArray = unserialize($this -> receiptBranchCode);
                foreach($codeArray as $key => $val){
                    if($key == 'Branch Code'){
                        $branchCode = $val;
                        break;
                    }
                }
            }

            // 支店コードのチェック
            if(!$this -> checkNull($branchCode)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BRANCH_CODE));
                $rtn = false;
            } elseif(!$this -> checkStringNumberOnly($branchCode)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_RECEIPT_BRANCH_CODE));
                $rtn = false;
            }

            // 支店名のチェック
            if(!$this -> checkNull($this -> receiptBranchName)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BRANCH_NAME));
                $rtn = false;
            }
        }

        // 受取銀行国のチェック
        if(!$this -> checkNull($this -> receiptBankCountry)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_COUNTRY));
            $rtn = false;
        }


        // 受取銀行口座番号のチェック
        if(!$this -> checkNull($this -> accountNumber)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_ACCOUNT_NUMBER));
            $rtn = false;
        } else if(!$this -> checkLength($this -> accountNumber, VAL_INT_1, VAL_INT_50)) {
			if($_SESSION['moneyoutSolution'] != 'Flat3'){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_RECEIPT_BANK_ACCOUNT_NUMBER, VAL_INT_1, VAL_INT_50));
				$rtn = false;
			}
        } elseif(!$this -> checkStringAscii($this -> accountNumber)) {
            $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_BANK_ACCOUNT_NUMBER));
            $rtn = false;
        }

        // 必須項目
        // debit口座のチェック
        if(!$this -> checkNull($this -> fromCurrency)) {
            $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
            $rtn = false;
        }

        // 中継銀行のフラグが立っている場合
        if($this -> intermediaryFlg != NO_STRING) {

            // 中継銀行名のチェック
            if(!$this -> checkNull($this -> intermediaryBankName)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_NAME));
                $rtn = false;
            } elseif(!$this -> checkStringWithdraw($this -> intermediaryBankName)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_WITHDRAW', array(VAL_STR_INTERMEDIARY_BANK_NAME));
                $rtn = false;
            }

            // 中継銀行SWIFTのチェック
            if(!$this -> checkNull($this -> intermediaryBankSwift)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_SWIFT_CODE));
                $rtn = false;
            } elseif(!$this -> checkStringAscii($this -> intermediaryBankSwift)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_INTERMEDIARY_BANK_SWIFT_CODE));
                $rtn = false;
            }

            // 中継銀行国のチェック
            if(!$this -> checkNull($this -> intermediaryBankCountry)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_COUNTRY));
                $rtn = false;
            }

            // 中継銀行住所1のチェック
            if(!$this -> checkNull($this -> intermediaryBankAddress1)) {
                $this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_ADDRESS_1));
                $rtn = false;
            } elseif(!$this -> checkStringWithdraw($this -> intermediaryBankAddress1)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_WITHDRAW', array(VAL_STR_INTERMEDIARY_BANK_ADDRESS_1));
                $rtn = false;
            }

            // 中継銀行メッセージが入力されていたら、チェック開始
            if($this -> intermediaryBankMessage != NO_STRING) {
                if(!$this -> checkStringWithdraw($this -> intermediaryBankMessage)) {
                    $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_WITHDRAW', array(VAL_STR_INTERMEDIARY_BANK_MESSAGE));
                    $rtn = false;
                }
            }
        }

        return $rtn;
    }

	public function echoFlat3BankList(){

		$rtn    = '';
		$list = getFlat3BankList();
		$selected = '';
		foreach ($list as $key => $value) {
			if(isset($this -> receiptBankName)){
				if($this -> receiptBankName == $value){
					$selected = 'selected';
				}else{
					$selected = '';
				}
			}
			$rtn .= '<option value="'.$value.'" code="'.$key.'" '.$selected.'>'.$value.'</option>';
		}

		echo $rtn;
	}

	public function dispH2PCurrency() {
		$country = $this -> dispCountryCommon($this -> getColumnData($this -> account,'country'));
		$bypassValue = $this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)));

		if($bypassValue){
			$rtn    = '';

			$currencyList = array('IDR', 'MYR', 'THB', 'VND');
			$selected = '';

			if($this -> currency!= NO_STRING){
				foreach ($currencyList as $value) {
					if($this -> currency == $value){
						$selected = 'selected';
					}else{
						$selected = '';
					}
					$currencyCountry = ($value=='IDR'? 'Indonesia':($value=='MYR'? 'Malaysia' : ( $value=='THB'? 'Thailand' : ( $value=='VND'? 'Vietnam' : (NO_STRING)))));
					$rtn .= '<option value='.$value.' country='.$currencyCountry.' '.$selected.'>'.$value.'</option>';
				}

			}else{
				if($this -> getLangage()=='id'){
					$rtn .= '<option name="select" id="select" value="select" class="px100" disabled selected="selected">Pilih</option>';
				}else{
					$rtn .= '<option name="select" id="select" value="select" class="px100" disabled selected="selected">Select</option>';
				}


				foreach ($currencyList as $value) {
					$currencyCountry = ($value=='IDR'? 'Indonesia':($value=='MYR'? 'Malaysia' : ( $value=='THB'? 'Thailand' : ( $value=='VND'? 'Vietnam' : (NO_STRING)))));
					$rtn .= '<option value='.$value.' country='.$currencyCountry.' '.$selected.'>'.$value.'</option>';
				}
			}


			echo "<select name='currency' id='currency' class='px80'>".$rtn."</select>";
		}else{
			if($country == 'Indonesia'){
				echo "<input type='text' id='currency' name='currency' value='IDR' class='px70' readonly>";
			}else if($country == 'Malaysia'){
				echo "<input type='text' id='currency' name='currency' value='MYR' class='px70' readonly>";
			}else if($country == 'Thailand'){
				echo "<input type='text' id='currency' name='currency' value='THB' class='px70' readonly>";
			}else if($country == 'Vietnam'){
				echo "<input type='text' id='currency' name='currency' value='VND' class='px70' readonly>";
			}
		}
	}

	public function echoH2PMaxValue() {
		$country = $this -> dispCountryCommon($this -> getColumnData($this -> account,'country'));
		$bypassValue = $this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)));

		if($bypassValue){
			$rtn    = '';

			if($this -> currency!= NO_STRING){
					$currencyCountry = ($this -> currency =='IDR'? 'Indonesia':($this -> currency=='MYR'? 'Malaysia' : ( $this -> currency =='THB'? 'Thailand' : ( $this -> currency=='VND'? 'Vietnam' : (NO_STRING)))));
					if($currencyCountry == 'Indonesia'){
						echo "9";
					}else if($currencyCountry == 'Malaysia'){
						echo "5";
					}else if($currencyCountry == 'Thailand'){
						echo "6";
					}else if($currencyCountry == 'Vietnam'){
						echo "9";
					}
			}

		}else{
			if($country == 'Indonesia'){
				echo "9";
			}else if($country == 'Malaysia'){
				echo "5";
			}else if($country == 'Thailand'){
				echo "6";
			}else if($country == 'Vietnam'){
				echo "9";
			}
		}
	}

	public function echoH2PCountry() {
		$country = $this -> dispCountryCommon($this -> getColumnData($this -> account,'country'));
		$bypassValue = $this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)));

		if($bypassValue){
			$currencyCountry=' ';
			$currencyList = array('IDR', 'MYR', 'THB', 'VND');

			foreach ($currencyList as $value) {
				if(isset($this -> currency)){
					if($this -> currency == $value){
						$currencyCountry = ($value=='IDR'? 'Indonesia':($value=='MYR'? 'Malaysia' : ( $value=='THB'? 'Thailand' : ( $value=='VND'? 'Vietnam' : (NO_STRING)))));
					}
				}
			}
			echo "<input type='text' id='receipt_bank_country' name='receipt_bank_country' value='".$currencyCountry."' class='px100' readonly>";
		}elseif(in_array($country, array('Indonesia', 'Malaysia', 'Thailand', 'Vietnam'))) {
			echo "<input type='text' id='receipt_bank_country' name='receipt_bank_country' value=".$country." class='px100' readonly>";
		}
	}

	public function dispH2PBankList() {
		$rtn  = NO_STRING;
		$country = $this -> dispCountryCommon($this -> getColumnData($this -> account,'country'));
		$bypassValue = $this -> getUserBypassValue(PARAM_WITHDRAW,PARAM_WITHDRAW_H2P_METHOD,($this -> getUserData(PARAM_USER_ACCOUNT)));
		$countryArray = array('ID','MY','TH','VN');

		if(isset($this -> currency) && $this -> currency!=NULL){
			$value = $this -> currency;
			$country = ($value=='IDR'? 'ID':($value=='MYR'? 'MY' : ( $value=='THB'? 'TH' : ( $value=='VND'? 'VN' : (NO_STRING)))));
		}elseif($country === 'Indonesia' && !$bypassValue){
			$country = 'ID';
		}elseif($country === 'Malaysia' && !$bypassValue){
			$country = 'MY';
		}elseif($country === 'Thailand' && !$bypassValue){
			$country = 'TH';
		}elseif($country === 'Vietnam' && !$bypassValue){
			$country = 'VN';
		}

		if(in_array($country,$countryArray)){
			$bank = getH2PBankAllowList($country);
			foreach ($bank as $key => $value) {
				$bankCode = trim(preg_replace('/\s+/', ' ', $value[1]));
				if ($this->receiptBankName == $value[1]) {
					$rtn .= '<option value=' . $bankCode . ' selected=\'selected\' >' . $value[0] . '</option>';
				} else {
					$rtn .= '<option value=' . $bankCode . '>' . $value[0] . '</option>';
				}
			}
			echo $rtn;
		}else{
			echo "";
		}

	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取銀行名の取得
	* @parameter	: なし
	* @return		: 受取銀行名
	-------------------------------------------------------------------------*/
	public function echoH2PReceiptBankName() {
		$country = $this -> receiptCountry;
		if($country == 'Indonesia'){
			$country = 'ID';
		}else if($country == 'Malaysia'){
			$country = 'MY';
		}else if($country == 'Thailand'){
			$country = 'TH';
		}else if($country == 'Vietnam'){
			$country = 'VN';
		}
		$bank = getH2PBankAllowList($country);
		//$bankName = $this -> receiptBankName;
		$bankName = trim(preg_replace('/\s+/', ' ', $this -> receiptBankName));
		if($bankName!=NO_STRING){
			if($bank[$bankName][0]!=NO_STRING || $bank[$bankName][0] != NULL){
				echo $bank[$bankName][0];
			}else{
				echo "";
			}
		}else{
			echo "";
		}

	}

	public function getMinimumFee($country){
		$rtn = NULL;

		if($country == 'Indonesia'){
			$rtn = 10000;
		}else if($country == 'Malaysia'){
			$rtn = 2;
		}else if($country == 'Thailand'){
			$rtn = 20;
		}else if($country == 'Vietnam'){
			$rtn = 10000;
		}

		return $rtn;
	}

	public function geth2pRegistData()
	{
		$bank = getH2PBankAllowList($this -> receiptCountry);

		$bankName =  $bank[$this->receiptBankName][0];
		$this -> transactionId  = $this -> getTransactionNumberCommon(VAR_TRANSACTION_WITHDRAW);

		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								                                        // account number(1)
		$rtn[] = $this -> currency;														                                        // currency(2)
		$rtn[] = $this -> currencyToInt($this -> amount, $this -> currency);			                                    // Amount of money(3)
		$rtn[] = $this -> currency;														                                        // currency(4)
		$rtn[] = $this -> accountName;													                                        // Account holder(5)
		$rtn[] = $this -> receiptCountry;												                                        // Recipient country(6)
		$rtn[] = $this -> receiptAddress1;												                                        // Recipient address 1(7)
		$rtn[] = $this -> receiptAddress2;												                                        // Recipient address 1(8)
		$rtn[] = 'Local Bank Transfer (Southeast Asia)';								                                        // Recipient message(9)
		$rtn[] = 'Local Bank Transfer (Southeast Asia)';								                                        // Receiving bank name(10)
		$rtn[] = $this -> receiptBranchName;											                                        // Receiving bank branch name(11)
		$rtn[] = $this -> receiptBankSwift;												                                        // Receiving bank SWIFT(12)
		$rtn[] = $this -> receiptCountry;												                                        // Receiving bank country(13)
		$rtn[] = $this -> receiptBankAddress1;											                                        // Receiving bank address 1(14)
		$rtn[] = $this -> receiptBankAddress2;											                                        // Receiving bank address 2(15)
		$rtn[] = $this -> accountNumber;												                                        // Receiving bank account number(16)
		$rtn[] = intval($this -> intermediaryFlg);										                                        // Relay bank flag(17)
		$rtn[] = $this -> intermediaryBankName;											                                        // Relay bank name(18)
		$rtn[] = $this -> intermediaryBankSwift;										                                        // Relay bank SWIFT(19)
		$rtn[] = $this -> intermediaryBankCountry;										                                        // Relay bank country(20)
		$rtn[] = $this -> intermediaryBankAddress1;										                                        // Relay bank address 1(21)
		$rtn[] = $this -> intermediaryBankAddress2;										                                        // Relay bank address 2(22)
		$rtn[] = $this -> intermediaryBankMessage;										                                        // Relay bank message(23)
		$rtn[] = $this -> tel;															                                        // phone number(24)
		$rtn[] = $this -> debitCurrency;												                                        // Debit account currency(25)
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);	                                        // Withdrawal account amount(26)
		$rtn[] = $this -> getRateEx();													                                        // rate(27)
		$rtn[] = $this -> currencyToInt($this -> getFeeEx(), $this -> debitCurrency);	                                        // Fee(28)
		$rtn[] = $this -> transactionId;														                                    // Transaction Number(29)
		$rtn[] = $this -> receiptBranchCode;											                                        // Receiving bank branch code(30)
		$rtn[] = 'H2P';																	                                        // withdraw solution (31)

		return $rtn;
	}


	public function sendH2PRequest(){
    	$language = $this -> getLangage();
    
    	//prep log path
    	$apiPath 		= dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
    	$errorUrl 	    = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'sending_request'.DIRECTORY_SEPARATOR.'error';
    	$requestUrl 	    = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'sending_request'.DIRECTORY_SEPARATOR.'request';
    
    	//require api file
    	include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'help2PayAPI.php';
    
    	//instantiate api class
    	$help2PayAPI = new help2PayAPI();
    
    	//start request
    	$data = array(
    		'TransactionID' => $this -> transactionId,
    		'CurrencyCode' => $this -> currency,
    		'MemberCode' =>  $this -> getUserData(PARAM_USER_ACCOUNT),
    		'Amount' => number_format((float)$this -> amount, 2, '.', ''),
    		'TransactionDateTime' => date('YmdHis'),
    		'TransactionDateTime2' => date('Y-m-d h:i:sA'),
    		'BankCode' => $this -> receiptBankName,
    		'toBankAccountName' => $this -> accountName,
    		'toBankAccountNumber' => $this -> accountNumber,
    	);
        $raw = NO_STRING;
    	//generate key
    	$key         = $help2PayAPI -> generateKey($data, $raw);
        
    	//save key to db
    	$param = array();
    	$param[] = $this -> transactionId;
    	$param[] = $key;
    	$param[] = $language;
    	$param[] = $this -> receiptBankName;
        
    	$this -> accessModify('UPDATE_WITHDRAW_H2P_KEY', $param);
        
    	//send request
    	$requestData    = $help2PayAPI -> generateRequestData($data, $key); //generate request data
    	$requestDataLog = implode(" ", $requestData); //generate request data log
    	$res            = $help2PayAPI -> submitPayoutRequest($requestData); //create channel
    
    	//check if create request is successful
    	if($res != NULL) {
    		$xml = new SimpleXMLElement($res);
    		$statusCode   = $xml->statusCode;
    		$message      = $xml->message;
    		$date		  = date('Y-m-d H:i:s'); //created date
    
        	if($statusCode == 000) {
        		if(!file_exists($requestUrl)) {
        			mkdir($requestUrl, 0777, true);
        		}
        
        		error_log("[{$date}]\r\nREQUEST:\r\n\r\n{$requestDataLog}\r\n\r\n\r\n\r\n", 
        		          VAL_INT_3, 
        		          $requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
        		
        		chmod($requestUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log', 511);
        
        		return true;
        	}elseif($statusCode == 001){
        		if(!file_exists($errorUrl)) {
        		    mkdir($errorUrl, 0777, true);
        		}
        
        		error_log("\n\n".print_r($requestData, true)."\n\n".print_r($res, true)."\n\n{$raw}\n\n{$key}", 
        		          VAL_INT_3, 
        		          $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
        		
        		error_log("[{$date}]\r\nERROR:{$this -> transactionId}\r\n\r\nMessage:\r\n{$message}\r\n\r\n\r\n\r\n", 
        		          VAL_INT_3, 
        		          $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
        		
        		chmod($errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log', 511);
        
        		return false;
        	}else{
        		//logerror of invalid statuscode
        		if(!file_exists($errorUrl)) {
        		    mkdir($errorUrl, 0777, true);
        		}
        
        		error_log("[{$date}]\r\nInvalid Status Code ERROR{$this -> transactionId}\r\n", 
        		          VAL_INT_3, 
        		          $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
        		
        		chmod($errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
        
        		return false;
        	}
    	} else { //create request failed
    	    $this -> popUpSessionMessage(ERROR, 'E_ERROR_H2P_API_NULL', array());
    	 	$this -> setType(TYPE_WITHDRAW_H2P_INPUT);
    		return;
    	}
	}
}
