<?php
$page_title = "カード情報入力";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
	<!-- メインエリア -->
	<div id="main" class="container">
		<ol class="breadcrumb">
			<li><a href="<?php echo $home_url; ?>">Home</a></li>
			<li class="active"><?php echo $page_title; ?></li>
		</ol>
		<div class="progress">
			<div class="progress-bar progress-bar-striped active w80p" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"><span class="visible-xs">STEP1</span><span class="hidden-xs">カード情報入力</span></div>
		</div>
		<h2><?php echo $page_title; ?></h2>
		<form id="acForm" action="" method="post" class="pleft40">
			<?php $this -> dispMessagesCommon(); ?>
			<table class="table ml00 col bdr default odd w50p fontM mb25 mt25 ma90sp">
				<colgroup>
					<col class="w35p">
					<col class="w65p">
				</colgroup>
				<tbody>
					<tr>
						<th>生年月日</th>
						<td>
							<select name="year" class="select">
								<?php $this -> dispYear(); ?>
							</select>
							<span class="spcr-br">年</span>
							<select name="month" class="select">
								<?php $this -> dispMonth(); ?>
							</select>
							<span class="spcr-br">月</span>
							<select name="day" class="select">
								<?php $this -> dispDay(); ?>
							</select>
							<span>日</span>
						</td>
					</tr>
					<tr>
						<th>カード番号</th>
						<td><input type="text" id="card_number" name="card_number" value="<?php $this -> echoCardNumber(); ?>" /></td>
					</tr>
				</tbody>
			</table>
			<p class="red font12 mb20">
				注意事項<br/>
				※PINコードは、誰にも知られないようお客様の責任において大事に保管して下さい。<br/>
				※PINコードご入力の際、３回失敗するとロックされますのでご注意ください。
			</p>
			<p class="mb40 mt40 w50pButton"><input type="button" id="btnConfirm" value="注意事項を読んで、PINコードを確認する" class="btn bg-grad px350"></p>
			<input type="hidden" id="type" name="type" value="" />
		</form>
	</div>
	<script src="../js/card_pin.js"></script>
    <!-- /メインエリア -->
<?php
	include_once('template/base_site_foot.php');
	echo $endscripts;
?>
</body>
</html>