<?php
require_once(SYSTEM_LOGICS . 'mst_exchange_fee/model.php');

class LogicMstExchangeFee extends MstExchangeFeeModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// 各種処理
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 各種処理を行う
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {		
		if($this -> getType() == TYPE_COMPLETE) {
			$this -> insertActivity();
			$this -> remove();	// データの削除
			$this -> regist();	// データの登録
			$this -> select();
			$this -> restore();
		}else if($this -> getType() == TYPE_DETAIL) {
			 $this -> select();
			 $this -> restore();
		}else if($this -> getType() == TYPE_DELETE) {
		     $this -> insertActivity(); 
			 $this -> remove();
			 $this -> select();
			 $this -> restore();
			 $this -> listPatterns();
		}else if($this -> getType() == TYPE_SEARCH) {
			$this -> listPatterns();
		}else{
			// パターン名の取得
			$this -> listPatterns();
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: パターンリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	/**
	 * mikko X anton
	 * 
	 */
	private function listPatterns() {
		$this -> setPatterns($this -> accessSelect('LIST_EXCHANGE_FEE', 
				array(
					$this -> getWhere(), 	
					VAL_STR_DEFAULT_EXCHANGE_SETTING
				)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの削除
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function remove() {
		$this -> accessModify('DELETE_MST_EXCHANGE_FEE', array($this -> getPId()), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {
		$this -> accessModify('INSERT_MST_EXCHANGE_FEE', $this -> getRegistData(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	/**
	 * mikko X anton
	 *
	 */
	function select() {
		$this -> setDetail($this -> accessSelect('LIST_EXCHANGE_FEE_PATTERNS_NAME', 
				array($this -> getPId(), 
						VAL_STR_DEFAULT_EXCHANGE_SETTING)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: udpate exchange fee
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	private function update() {
		$this -> accessModify('INSERT_MST_EXCHANGE_FEE', $this -> getRegistData(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: insertActivity
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	private function insertActivity() {
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}


}
?>