<?php
require_once(SITE_LOGICS . 'exchange/model.php');

class LogicExchange extends ExchangeModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() == TYPE_COMPLETE) {
			$this -> regist();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {

		// 変数宣言部
		$original	= NO_COUNT;
		$from		= NO_STRING;
		$to			= NO_STRING;
		$profit		= NO_COUNT;


		$transaction_number = $this -> getTransactionNumberCommon(VAR_TRANSACTION_EXCHANGE);

		$this -> accessModify('INSERT_EXCHANGE', array($this -> getUserData(PARAM_USER_ACCOUNT)
														, $this -> getFromCurrency()
														, $this -> currencyToInt($this -> getFromAmount(), $this -> getFromCurrency())
														, $this -> getToCurrency()
														, $this -> currencyToInt($this -> getToAmount(), $this -> getToCurrency())
														, $this -> getRate()
														, $transaction_number));

		$params = $this -> getSendInfoParams($transaction_number);
		$this -> sendMailByTmp('exchange_complete.xml'
								, $params
								, $params[4]
								, VAR_CS_MAIL_ADDRESS);

		// コミッションの設定
		if($this -> getCAmountType() == NO_COUNT) {
			$original	= $this -> getOriginalAmount() - $this -> getToAmount();
			$profit		= $this -> currencyToInt($this -> getOriginalAmount(), $this -> getToCurrency());
			$from		= $this -> getFromCurrency();
			$to			= $this -> getToCurrency();

		} else {
			$original 	= $this -> getFromAmount() - $this -> getOriginalAmount();
			$profit		= $this -> currencyToInt($this -> getFromAmount(), $this -> getFromCurrency());
			$from		= $this -> getToCurrency();
			$to			= $this -> getFromCurrency();
		}

		$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
										, $from
										, $to
										, $profit);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>