$(function() {
	var _authSettlementRequest = function(form){
		let transp = {};
		
		form.find("input").each(function(e){
			let type = $(this).attr("type").trim().toLowerCase()
			if(type != "submit")
				transp[$(this).attr("name")] = $(this).val()
		})
		
		$("#acForm input").each(function(e){
			transp[$(this).attr("name")] = $(this).val()
		})
		
		transp["debit_currency"] 	= $("#debit_currency").val()
		transp["message"]	 		= $("#message_field").val()
		
		$.ajaxSetup({
			beforeSend : function(){
				$(".loading-cont").addClass("active")
			},
			complete : function(){
				$(".loading-cont").removeClass("active")
			}
		})
		
		$.post("settlement?type=settle_express_check", transp, function(data){
			if(isJSON(data) || typeof data == "object"){				
				let encoded = typeof data != "object" ? JSON.parse(data) : data;
				
				let returns = encoded.returns;
				let invalid = encoded.invalid;
				let invkeys = Object.keys(invalid)
				
				if(invkeys.length){
					validation : {
						if(invkeys.includes("OE04") && invkeys.length == 1)
							break validation;
					
						$("#errorTraces").empty()
						$(".error-cont").addClass("active");
						
						for(var ids in invalid){
							let errRow = '<p class="red mt10"><span class="fa fa-times-circle fa-lg mt"></span>'+invalid[ids]+'</p>';
							$("#errorTraces").append(errRow)
						}	
					}
				}
				
				if(Object.keys(returns).length){
					$(".overlay-cont").addClass("active");
  					$(".overlay-cont").hide().fadeIn(700);
					
					let transactionDetails = returns.transaction_details;
					
					$("#spRequesterAcc").html(transactionDetails.from_account)
					$("#spRequesterName").html(transactionDetails.from_full_name)
					$("#spRate").html(transactionDetails.rate)
					$("#spDebitAmount").html(transactionDetails.debit_currency+' '
						+transactionDetails.debit_amount)
					$("#spAmount").html(transactionDetails.currency+' '
						+transactionDetails.amount)
					$("#spDebitCurBalance").html(transactionDetails.debit_currency+' '
						+transactionDetails.balance)
					$("#spMessage").html(transactionDetails.message)
					
					if(transactionDetails.uniqueSubmission.length != 0){
						$(".settleInsufficient").hide()
						$(".settleQuestion").show()			
						$(".conf-settle-pop").show()
						
						$(".conf-settle-pop").click(function(e){
							e.preventDefault()
							$(this).hide()
							$(".loading-cont").addClass("active")
					
							$("#uniqueSubmission").val(transactionDetails.uniqueSubmission)
							$("#debit_currency_ac").val(transactionDetails.debit_currency)
							$("#from_account").val(transactionDetails.from_account)
							$("#message").val(transactionDetails.message)
							$("#rate").val(transactionDetails.rate)
							$("#type").val("settle_express_submit")
							submitForm()
						})
					}else{
						$(".settleInsufficient").show()
						$(".settleQuestion").hide()
						$(".conf-settle-pop").hide()
					}
							
				}
			}else
				alert("Internal Error Occurred.")
		})
	}
	
	$("#authConfirm").submit(function(e){
		e.preventDefault()
		 _authSettlementRequest($(this))
	})
	
	$('.close-pop').click(function(e) {
		$(".conf-settle-pop").unbind()
		$(".overlay-cont").removeClass("active")
		$(".overlay-cont").fadeOut(1000)

	})
	
	$('.error-close').click(function(e) {
		$(".error-cont").removeClass("active")
	})
})





