<?php
/******************************************************************************
* @program_name:   共通：コンフィグ情報
* @classExp:なし
******************************************************************************/

//******************************************************************************//
// システム共通項目
//******************************************************************************//
// ルートが違うのでその対応
$root = explode('/', $_SERVER['DOCUMENT_ROOT']);
$uri	= explode('/', $_SERVER['REQUEST_URI']);
$isAdmin = strpos( $_SERVER['DOCUMENT_ROOT'], "system");

if($root[count($root) - 1]		== 'system'
		|| $root[count($root) - 1]	== 'api'
		|| $root[count($root) - 1]	== 'admin') {
			array_pop($root);
			define('PROJECT_ROOT', implode('/', $root));									// プロジェクトルート
} else {
	define('PROJECT_ROOT', $_SERVER['DOCUMENT_ROOT']);								// プロジェクトルート
}

//-----------------------------------------------------------------------//
// 初期ファイルパス群
//-----------------------------------------------------------------------//
define('SYSTEM_PATH', PROJECT_ROOT . '/system/');									// システムデイィレクトリパス
define('SYSTEM_TEMPLATE_PATH', SYSTEM_PATH . 'template/');							// システムテンプレートパス
define('SYSTEM_TEMPLATE_CORE_PATH', SYSTEM_TEMPLATE_PATH . 'core/');				// システム共通テンプレートパス
define('LIBRARIES', SYSTEM_PATH . 'lib/');											// システムライブラリルート
define('LIBRARIES_CORE', LIBRARIES . 'core/');										// コア設定群ディレクトリルート
define('SYSTEM_LOGICS', SYSTEM_PATH . 'logic/');									// ロジックディレクトリ
define('CONFIGRATION_FILE_NAME', 'marsys_conf.ini');								// 設定ファイルのファイル名
define('CREDENTIALS_FILE_NAME', 'marsys_data_conf.ini');							// 設定ファイルのファイル名
define('CONFIGRATION_FILE_PATH', LIBRARIES . CONFIGRATION_FILE_NAME);				// 設定ファイルのファイルパス
define('CREDENTIALS_FILE_PATH', LIBRARIES . CREDENTIALS_FILE_NAME);				    // 設定ファイルのファイルパス

define('SYSTEM_DOCUMENT', SYSTEM_TEMPLATE_PATH . 'documents/');						// ドキュメント群のルート

define('SYSTEM_DOCUMENT_DOPOSIT', SYSTEM_PATH . 'documents/deposit/');				// 入金アップロードファイル
define('SYSTEM_DOCUMENT_DOPOSIT_ERROR', SYSTEM_PATH . 'documents/deposit/error/');	// 入金アップロードエラーファイル
define('SYSTEM_DOCUMENT_TRANSFER', SYSTEM_PATH . 'documents/transfer/');			// 口座振替アップロードファイル
define('SYSTEM_DOCUMENT_TRANSFER_ERROR', SYSTEM_PATH . 'documents/transfer/error/');// 口座振替アップロードエラーファイル
define('SYSTEM_DOCUMENT_PROFILE', SYSTEM_PATH . 'documents/profile/');				// プロフィールアップロードファイル
define('SYSTEM_DOCUMENT_WITHDRAW', SYSTEM_PATH . 'documents/withdraw/');			// 出金データエクスポートデータ
define('SYSTEM_DOCUMENT_ACCOUNT', SYSTEM_PATH . 'documents/account/');				// 口座開設のアップロードファイル

define('SYSTEM_DOCUMENT_KYC', SYSTEM_PATH . 'documents/kyc/');						// KYC書類アップロードファイル
define('SYSTEM_DOCUMENT_ADS', PROJECT_ROOT . '/documents/ads/');						// KYC書類アップロードファイル

define('WEB_DIR_ROOT', '/');														// ウェブルートパス
define('SYSTEM_WEB_PATH', WEB_DIR_ROOT . '');										// ウェブシステムパス
define('SYSTEM_DOCUMENTS_WEB_PATH', SYSTEM_WEB_PATH . 'documents/');				// ウェブ書類群パス
define('SYSTEM_DOCUMENTS_KYC_WEB_PATH', SYSTEM_DOCUMENTS_WEB_PATH . 'kyc/');		// ウェブ書類群KYCパス
define('SYSTEM_WEB_TEMPLATE_PATH', SYSTEM_WEB_PATH . 'template/');					// ウェブシステムテンプレートパス
define('IMAGES_WEB_PATH', WEB_DIR_ROOT . 'images/');								// ウェブ画像パス

define('MEMBER_ROOT', PROJECT_ROOT . '/member/');									// サイトメンバルート
define('MEMBER_TEMPLATE', MEMBER_ROOT . 'template/');								// サイトメンバテンプレート
define('MEMBER_TEMPLATE_CORE', MEMBER_TEMPLATE . 'core/');							// サイトメンバテンプレート（コア）
define('MEMBER_LOGICS', MEMBER_ROOT . '/logic/');									// サイトメンバロジック

define('SITE_ROOT', PROJECT_ROOT . '/');											// サイトルート
define('SITE_TEMPLATE', SITE_ROOT . 'template/');									// サイトテンプレート
define('SITE_TEMPLATE_CORE', SITE_TEMPLATE . 'core/');								// サイトテンプレート（コア）
define('SITE_LOGICS', SITE_ROOT . 'logic/');										// サイトロジックファイル群のパス
define('SITE_IMAGES', SITE_ROOT . 'images/');										// サイトロ画像群のパス

define('SITE_MULTI_TEMPLATE', 'template');											// サイトテンプレート
define('MAIL_TEMPLATES_LOCAL',SYSTEM_PATH . 'documents/mail_template/');            // localbank
// 多言語対応
if(count($uri) >= 2 && $isAdmin==FALSE) {

	// リテラルファイルが存在した場合そのファイルを利用する
	$mailPath = SYSTEM_PATH . 'documents/mail_template/' . $uri[count($uri) - 2] . '/';


	if(file_exists($mailPath)) {	// 多言語
		define('MAIL_TEMPLATES', $mailPath);										// メールテンプレート（多言語）

	} else {								// その他（デフォルト日本語）
		define('MAIL_TEMPLATES', SYSTEM_PATH . 'documents/mail_template/');			// メールテンプレート
	}

} else {
	define('MAIL_TEMPLATES', SYSTEM_PATH . 'documents/mail_template/');				// メールテンプレート
}


//-----------------------------------------------------------------------//
// コアファイル群インクルード
//-----------------------------------------------------------------------//
require_once(LIBRARIES_CORE . 'core.php');

//-----------------------------------------------------------------------//
// 設定ファイルセクション群
//-----------------------------------------------------------------------//
define('SECTION_DB', 'SECTION_DB');													// DBセクション
define('SECTION_DIR_PATH', 'SECTION_DIR_PATH');										// ファイル、ディレクトリパスセクション
define('SECTION_DIR_PATH_SYSTEM', SECTION_DIR_PATH . '_SYSTEM');					// システムファイルテンプレートパスセクション
define('SECTION_DIR_PATH_SITE', SECTION_DIR_PATH . '_SITE');						// サイトファイルテンプレートパスセクション

//-----------------------------------------------------------------------//
// DBセクション内キー
//-----------------------------------------------------------------------//
define('HOST_NAME', 'HOST_NAME');													// ホスト名
define('USER_NAME', 'USER_NAME');													// ユーザ名
define('LOGIN_PASS', 'LOGIN_PASS');													// パスワード
define('TARGET_DB_NAME', 'TARGET_DB_NAME');											// DB名

//-----------------------------------------------------------------------//
// その他情報内キー
//-----------------------------------------------------------------------//
define('EDIT_DATA_MAX_LINE_NUMBER', 'EDIT_DATA_MAX_LINE_NUMBER');					// 動画データ編集（リスト）1ページ最大表示件数
define('SITE_URL', 'SITE_URL');														// サイトURL

//-----------------------------------------------------------------------//
// メッセージレベル
//-----------------------------------------------------------------------//
define('ERROR', 'ERROR');		// エラー
define('WARNING', 'WARNING');	// 警告
define('INFO', 'INFO');			// 情報

error_reporting(0);

if(defined('API_ACCESS')){
    $sessionCookieParams = session_get_cookie_params();
    
    if(!$sessionCookieParams['lifetime'])
        session_set_cookie_params(3600, '/; samesite=None', $_SERVER['HTTP_HOST'], true, false);
}

// セッションスタート
session_name('iwallet');
session_start();
?>