<?php
// include_once $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'config.php';
// include_once $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'api'.DIRECTORY_SEPARATOR.'help2PayAPI.php';

// include_once('config.php');
include_once('../config.php');
include_once('help2PayAPI.php');

//instantiate ModelClassEx
$system = new System();
$param     = array();

//instantiate api class
$help2PayAPI = new help2PayAPI();

//error_log paths
// $apiPath 		= dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
$apiPath 		= '../api';
$successUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'callback'.DIRECTORY_SEPARATOR.'success';
$errorUrl 	    = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'callback'.DIRECTORY_SEPARATOR.'error';
$accessLogUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P_Withdrawal'.DIRECTORY_SEPARATOR.'callback'.DIRECTORY_SEPARATOR.'access';

//check if directory exists if not, create directory

if(!file_exists($successUrl)) {
    mkdir($successUrl, 0777, true);
}

if(!file_exists($errorUrl)) {
    mkdir($errorUrl, 0777, true);
}

if(!file_exists($accessLogUrl)) {
    mkdir($accessLogUrl, 0777, true);
}

//log the access details
error_log(date("[Y-m-d H:i:s]")."\r\n".'Accessed' ."\r\n\r\n", 3, $accessLogUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
chmod($accessLogUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

//check post parameters
if(!empty($_POST)){
	//get the POST body
	$response = implode("&", $_POST);

	//get transaction from database
	$res = $system -> getRowData($system -> accessSelect('SELECT_WITHDRAW_H2P_TEMP', array($_POST['TransactionID'])));

	if(count($res) > 0){
		//get necessary details from result
		$transaction_id 			= $system -> getColumnData($res, 'transaction_number'); //transaction number
		$member_code				= $system -> getColumnData($res, 'user_account'); //user account
		$amount						= $system -> getColumnData($res, 'amount'); //amount
		$currency					= $system -> getColumnData($res, 'currency'); //currency
		$language					= $system -> getColumnData($res, 'language'); //language
		$bankCode					= $system -> getColumnData($res, 'receipt_bank_name'); //language

		$veriKey = $help2PayAPI -> verifyCallbackKey($_POST['Key'], $transaction_id, $member_code, $amount, $currency, $_POST['Status']);
		$veriKeyUpper = strtoupper($veriKey);

		if($_POST['Key'] == $veriKey || $_POST['Key'] == $veriKeyUpper) {
			$param[] = $_POST['TransactionID'];
			$param[] = $response.'Bank_code:'.$bankCode;

			//check if state is completed
			if($_POST['Status'] == '000') {

				if($member_code == $_POST['MemberCode']){
					//update withdraw
					$param[] = VAL_INT_2;
					$system->accessModifyCommon('UPDATE_WITHDRAW_H2P_STATUS', $param);
					$system->accessModifyCommon('UPDATE_WITHDRAW_H2P_TEMP_STATUS', $param);

					//create email parameters
					$date = date('Y-m-d H:i:s');
					$newdate = strtotime ( '-1 hour' , strtotime ( $date ) ) ;
					$newdate = date( 'Y-m-d H:i:s' , $newdate );

					$params   = array();
		            $params[] = $member_code;
		            $params[] = $system -> getUserNameCommon($member_code);
		            $params[] = $currency;
		            $params[] = number_format($amount,2,'.','');
		            //$params[] = date_format(date_create($_POST['TransactionDatetime']), 'Y-m-d H:i:s');
		            $params[] = $newdate;

		            //send email
		            $system -> sendMailByTmp($language.DIRECTORY_SEPARATOR.'withdraw_h2p_success.xml'
		                    , $params
		                    , $system -> getUserEMailCommon($member_code)
		                    , VAR_CS_MAIL_ADDRESS);

					//log details
					error_log(date("[Y-m-d H:i:s]")."\r\n".'success status:' ."\r\n\r\n".$response."\r\n\r\n", 3, $successUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
					chmod($successUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
				}else{
					//error, member code not valid
					error_log(date("[Y-m-d H:i:s]")."\r\n".'Error member code invalid:' ."\r\n\r\n".$response."\r\n\r\n".$member_code."\r\n\r\n", 3, $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
					chmod($errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
				}

			}else if($_POST['Status'] == '001'){
				//send email
				if($member_code == $_POST['MemberCode']){
					//update withdraw
					$param[] = VAL_INT_5;
					$system->accessModifyCommon('UPDATE_WITHDRAW_H2P_STATUS', $param);
					$system->accessModifyCommon('UPDATE_WITHDRAW_H2P_TEMP_STATUS', $param);

					//create email parameters
		            $params   = array();
		            $params[] = $member_code;
		            $params[] =  $system -> getUserNameCommon($member_code);

		            //send email
		            $system -> sendMailByTmp($language.DIRECTORY_SEPARATOR.'withdraw_h2p_fail.xml'
		                    , $params
		                    , $system -> getUserEMailCommon($member_code)
		                    , VAR_CS_MAIL_ADDRESS);

					//log details
					error_log(date("[Y-m-d H:i:s]")."\r\n".'fail status:' ."\r\n\r\n".$response."\r\n\r\n", 3, $successUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
					chmod($successUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
				}else{
					//error, member code not valid
					error_log(date("[Y-m-d H:i:s]")."\r\n".'Error member code invalid:' ."\r\n\r\n".$response."\r\n\r\n".$member_code."\r\n\r\n", 3, $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
					chmod($errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
				}
			}else{
				//error, status not valid
				error_log(date("[Y-m-d H:i:s]")."\r\n".'Error status code invalid:' ."\r\n\r\n".$response."\r\n\r\n".$_POST['Status']."\r\n\r\n", 3, $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
				chmod($errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
			}
		}else{
			//error, status not valid
			error_log(date("[Y-m-d H:i:s]")."\r\n".'Key invalid:' ."\r\n\r\n".$response."\r\n\r\n", 3, $errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
			chmod($errorUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
		}
	}


}
