<?php
class AgentModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// エージェントリスト
	private $agent				= null;			// エージェント
	private $chirdren			= null;			// 子供リスト
	private $commision			= null;			// 手数料一覧
	private $cardCommissions	= null;			// カード手数料一覧
	private $currencies			= null;			// 通貨一覧
	private $patterns			= null;			// 為替手数料パターン一覧
	private $dId				= NO_STRING;	// エージェントID
	private $wlId				= NO_STRING;	// WLID
	private $parent				= NO_STRING;	// 親エージェント
	private $email				= NO_STRING;	// メールアドレス
	private $lastName			= NO_STRING;	// 姓
	private $firstName			= NO_STRING;	// 名
	private $birth				= NO_STRING;	// 生年月日
	private $birthYear			= NO_STRING;	// 生年月日（年）
	private $birthMonth			= NO_STRING;	// 生年月日（月）
	private $birthDay			= NO_STRING;	// 生年月日（日）
	private $country			= NO_STRING;	// 国
	private $state				= NO_STRING;	// 都道府県
	private $city				= NO_STRING;	// 市区町村
	private $address1			= NO_STRING;	// 住所1
	private $address2			= NO_STRING;	// 住所2
	private $zipCode			= NO_STRING;	// 郵便番号
	private $tel				= NO_STRING;	// 電話番号
	private $agentCode			= NO_STRING;	// 親エージェントコード
	private $corporationName	= NO_STRING;	// 会社名
	private $bankName			= NO_STRING;	// 銀行名
	private $commisionId		= NO_STRING;	// 手数料ID
	private $exchangeFeeId		= NO_STRING;	// 為替手数料ID
	private $parentName			= NO_STRING;	// 親エイリアス
	private $userAccount		= NO_STRING;	// 口座番号
	private $year				= NO_STRING;	// 報酬取得年
	private $month				= NO_STRING;	// 報酬取得月
	private $total				= NO_STRING;	// カード報酬合計

	// ------------------ 検索系 ------------------//
	private $sEmail			= NO_STRING;		// メールアドレス
	private $sName			= NO_STRING;		// 名前
	private $sAgentCode		= NO_STRING;		// エージェントコード
	private $sFrom			= NO_STRING;		// 開始日
	private $sTo			= NO_STRING;		// 終了日
	
	// ------------------ (anton) ----------------- //
	public $lang					= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> dId				= $this -> getDataPost(PARAM_D_ID);						// 詳細ID
		$this -> parent				= $this -> getDataPost(PARAM_PARENT);					// メールアドレス
		$this -> email				= $this -> getDataPost(PARAM_EMAIL);					// 親エージェント
		$this -> lastName			= $this -> getDataPost(PARAM_LAST_NAME);				// 姓
		$this -> firstName			= $this -> getDataPost(PARAM_FIRST_NAME);				// 名
		$this -> birthYear			= $this -> getDataPost(PARAM_BIRTH_YEAR);				// 生年月日（年）
		$this -> birthMonth			= $this -> getDataPost(PARAM_BIRTH_MONTH);				// 生年月日（月）
		$this -> birthDay			= $this -> getDataPost(PARAM_BIRTH_DAY);				// 生年月日（日）
		$this -> country			= $this -> getDataPost(PARAM_COUNTRY);					// 国
		$this -> state				= $this -> getDataPost(PARAM_STATE);					// 都道府県
		$this -> city				= $this -> getDataPost(PARAM_CITY);						// 市区町村
		$this -> address1			= $this -> getDataPost(PARAM_ADDRESS_1);				// 住所1
		$this -> address2			= $this -> getDataPost(PARAM_ADDRESS_2);				// 住所2
		$this -> zipCode			= $this -> getDataPost(PARAM_ZIP_CODE);					// 郵便番号
		$this -> tel				= $this -> getDataPost(PARAM_TEL);						// 電話番号
		$this -> corporationName	= $this -> getDataPost(PARAM_CORPORATION_NAME);			// 会社名
		$this -> bankName			= $this -> getDataPost(PARAM_BANK_NAME);				// 銀行名
		$this -> agentCode			= $this -> getDataPost(PARAM_AGENT_CODE);				// エージェントコード
		$this -> commisionId		= $this -> getDataPost(PARAM_COMMISION_ID);				// 手数料ID
		$this -> exchangeFeeId		= $this -> getDataPost(PARAM_EXCHANGE_FEE_ID);			// 手数料ID
		$this -> parentName			= $this -> getDataPost(PARAM_PARENT_CORPORATION_NAME);	// 親エイリアス
		$this -> userAccount		= $this -> getDataPost(PARAM_USER_ACCOUNT);				// 口座番号

		if($this -> getPosParameter(PARAM_DATE) == NO_STRING) {		// 日付未指定（最新日付）

			// 現在の日時を取得
			$date = getdate();

			$this -> year		= $date[PARAM_YEAR];	// 検索年
			$this -> month		= $date[PARAM_MON];		// 検索月

		} else {													// 日付指定

			// 日付の分割
			$date = explode(DELIMIT_HYPHEN, $this -> getPosParameter(PARAM_DATE));

			$this -> year		= $this -> getColumnData($date, NO_COUNT);		// 検索年
			$this -> month		= $this -> getColumnData($date, VAL_INT_1);		// 検索月
		}


		// ------------------ 検索系 ------------------//
		$this -> sEmail		= $this -> getDataPost(PARAM_S_EMAIL);					// メールアドレス
		$this -> sName		= $this -> getDataPost(PARAM_S_NAME);					// 名前
		$this -> sAgentCode	= $this -> getDataPost(PARAM_S_AGENT_CODE);				// エージェントコード
		$this -> sFrom		= $this -> getDataPost(PARAM_S_FROM);					// 開始日
		$this -> sTo		= $this -> getDataPost(PARAM_S_TO);						// 終了日
		
		$this -> lang = $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定（エージェントデータ）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restoreAgent() {
		$this -> wlId				= $this -> getColumnData($this -> agent, COLUMN_WL_ID);						// メールアドレス
		$this -> email				= $this -> getColumnData($this -> agent, COLUMN_MAIL);						// メールアドレス
		$this -> lastName			= $this -> getColumnData($this -> agent, COLUMN_LAST_NAME);					// 姓
		$this -> firstName			= $this -> getColumnData($this -> agent, COLUMN_FIRST_NAME);				// 名
		$this -> birth				= $this -> getColumnData($this -> agent, COLUMN_BIRTH);						// 生年月日
		$this -> country			= $this -> getColumnData($this -> agent, COLUMN_COUNTRY);					// 国
		$this -> state				= $this -> getColumnData($this -> agent, COLUMN_STATE);						// 都道府県
		$this -> city				= $this -> getColumnData($this -> agent, COLUMN_CITY);						// 市区町村
		$this -> address1			= $this -> getColumnData($this -> agent, COLUMN_ADDRESS);					// 住所1
		$this -> address2			= $this -> getColumnData($this -> agent, COLUMN_ADDRESS_2);					// 住所2
		$this -> zipCode			= $this -> getColumnData($this -> agent, COLUMN_ZIP_CODE);					// 郵便番号
		$this -> tel				= $this -> getColumnData($this -> agent, COLUMN_TEL);						// 電話番号
		$this -> agentCode			= $this -> getColumnData($this -> agent, COLUMN_AGENT_CODE);				// エージェントコード
		$this -> corporationName	= $this -> getColumnData($this -> agent, PARAM_CORPORATION_NAME);			// 会社名
		$this -> bankName			= $this -> getColumnData($this -> agent, PARAM_BANK_NAME);					// 銀行名
		$this -> parent				= $this -> getColumnData($this -> agent, COLUMN_PARENT_AGENT_CODE);			// 親エージェントコード
		$this -> commisionId		= $this -> getColumnData($this -> agent, COLUMN_COMMISION_ID);				// 手数料ID
		$this -> exchangeFeeId		= $this -> getColumnData($this -> agent, COLUMN_EXCHANGE_COMMISION_ID);		// 手数料ID
		$this -> parentName			= $this -> getColumnData($this -> agent, COLUMN_PARENT_CORPORATION_NAME);	// 親エイリアス
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定（口座情報）
	* @parameter	: なし
	* @return		: なし
	------------------------------------------------------------------------*/
	public function restoreAccount() {
		$this -> email				= $this -> getColumnData($this -> rs, COLUMN_MAIL);						// メールアドレス
		$this -> lastName			= $this -> getColumnData($this -> rs, COLUMN_LAST_NAME);				// 姓
		$this -> firstName			= $this -> getColumnData($this -> rs, COLUMN_FIRST_NAME);				// 名
		$this -> birth				= $this -> getColumnData($this -> rs, COLUMN_BIRTH_STRING);				// 生年月日
		$this -> country			= $this -> getColumnData($this -> rs, COLUMN_COUNTRY);					// 国
		$this -> state				= $this -> getColumnData($this -> rs, COLUMN_STATE);					// 都道府県
		$this -> city				= $this -> getColumnData($this -> rs, COLUMN_CITY);						// 市区町村
		$this -> address1			= $this -> getColumnData($this -> rs, COLUMN_ADDRESS);					// 住所1
		$this -> address2			= $this -> getColumnData($this -> rs, COLUMN_ADDRESS_2);				// 住所2
		$this -> zipCode			= $this -> getColumnData($this -> rs, COLUMN_ZIP_CODE);					// 郵便番号
		$this -> tel				= $this -> getColumnData($this -> rs, COLUMN_TEL);						// 電話番号
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定（コミッションデータ）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restoreCommision() {

		// 変数宣言部
		$cnt = NO_COUNT;

		if($this -> isLoopData($this -> commision)) {

			for($cnt = NO_COUNT; $cnt < count($this -> commision); $cnt++) {

				// データ
				$row = $this -> commision[$cnt];

				// 手数料種別を取得する
				$mFId = $this -> getColumnData($row, COLUMN_M_F_ID);
				$type = $this -> getColumnData($row, COLUMN_WALLET_TYPE);

				// データをストアする
				$row[COLUMN_WHOLE_PERCENT]		= $row[COLUMN_CHILDREN_PERCENT];
				$row[COLUMN_WHOLE_FIX] 			= $row[COLUMN_CHILDREN_FIX];
				$row[COLUMN_PERCENT]			= $this -> currencyToInt(floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_percent')), PERCENT);
				$row[COLUMN_FIX]				= $this -> currencyToInt(floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_fix')), USD);
				$row[COLUMN_CHILDREN_PERCENT]	= $this -> currencyToInt(floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_percent')), PERCENT);
				$row[COLUMN_CHILDREN_FIX]		= $this -> currencyToInt(floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_fix')), USD);

				// データをリストアする
				$this -> commision[$cnt] = $row;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		//check access
		if(!$this -> checkAdminUserAccess('AGNT', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == CONTROL_ACTION) {
			//check access
			if(!$this -> checkAdminUserAccess('AGNT', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('AGTL', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE) {
			//check access
			if(!$this -> checkAdminUserAccess('AGTL', array('', '1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_COMMISSION) {
			//check access
			if(!$this -> checkAdminUserAccess('ARDT', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_UPDATE) {
			//check access
			if(!$this -> checkAdminUserAccess('ARDT', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_INPUT) {			// 口座番号入力

			// 口座番号の入力チェック
			if(!$this -> checkNull($this -> userAccount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT));
				$rtn = false;
			}

			// 口座番号の存在チェック
			if(!$this -> checkExistAccount($this -> userAccount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

		} else if($this -> getType() == TYPE_CONFIRM) {	// 新規登録の場合

			// 親エージェントのコードチェック
			if($this -> parent != NO_STRING) {
				if(!$this -> checkParentAgentCode($this -> parent)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_AGENT', array());
					$rtn = false;
				}
			}

			// エラーを検出した場合タイプを変更する
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
			}

		} else if($this -> getType() == TYPE_SAVE) {

			// 必須項目のチェック

			if(!$rtn) {
				return $rtn;

			}

			// コミッションデータの取得（デフォルトデータ）
			$comm = $this -> getCommisionDataCommon($this -> parent);

			if($this -> isLoopData($comm)) {

				// すべての手数料を調査する
				foreach($comm as $row) {

					$mFId = $this -> getColumnData($row, COLUMN_M_F_ID);
					$type = $this -> getColumnData($row, COLUMN_WALLET_TYPE);

					if($this -> parent == NO_STRING) {	// 親がいなければ、デフォルト値
						$wholePercent	= $this -> intToCurrency(VAL_INT_10000, PERCENT);	// パーセンテージ卸値
						$wholeFix		= $this -> intToCurrency(VAL_INT_10000, USD);		// 固定値卸値

					} else {							// 親がいればデータを取得

						$wholePercent	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_CHILDREN_PERCENT), PERCENT);	// パーセンテージ卸値
						$wholeFix		= $this -> intToCurrency($this -> getColumnData($row, COLUMN_CHILDREN_FIX), USD);			// 固定値卸値
					}

					$percentVal	= floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_percent')) + floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_percent'));
					$fixVal		= floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_fix')) + floatval($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_fix'));

					if($percentVal > $wholePercent
						|| $fixVal > $wholeFix) {

						$typeName	= $this -> getColumnData($row, COLUMN_FEE_NAME) . '（' . $this -> getColumnData($row, COLUMN_COMMISION_TYPE) . '）';
						$rtn		= false;
						$this -> popUpSessionMessage(ERROR, 'E_ERROR_MAX_PARCENT_TOTAL', array($typeName));
					}
				}
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sEmail != NO_STRING) {		// メールアドレス
			$rtnParams[] = ' agents.mail = (\')' . $this -> sEmail . '(\') ';
		}

		if($this -> sName != NO_STRING) {		// 名前
			$rtnParams[] = ' (agents.last_name = (\')' . $this -> sName . '(\') OR agents.first_name = (\')' . $this -> sName . '(\')) ';
		}

		if($this -> sAgentCode != NO_STRING) {	// エージェントコード
			$rtnParams[] = ' agents.agent_code = (\')' . $this -> sAgentCode . '(\') ';
		}

		if($this -> sFrom != NO_STRING) {		// 開始日
			$rtnParams[] = ' agents.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
		}

		if($this -> sTo != NO_STRING) {			// 終了日
			$rtnParams[] = ' agents.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$aType	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {			
			/**
			 *
			 * 2019/04/11
			 *　anton
			 *
			 */
			
			
			// データの数だけループを回す
			foreach($this -> rs as $row) {

				$wlname = ($this -> lang == "en" ? "IWL Headquarters" : $this -> getColumnData($row, COLUMN_WL_NAME));
				
				$rtn	.= '<tr>'
						. '<td class="l">' . $wlname . '</td>'
						. '<td class="l"><a href="javascript:userDetail(\'' .  $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\');">' . $this -> getColumnData($row, COLUMN_LAST_NAME) . ' ' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</a></td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_SITE_NAME) . '</td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_MAIL) . '</td>'
						. '<td class="l"><a href="javascript:goAgentCommission(\'' . $this -> getColumnData($row, COLUMN_AGENT_CODE) . '\');">' . $this -> getColumnData($row, COLUMN_AGENT_CODE) . '</a></td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE) . '</td>'
						. '<td class="l">https://secure.' . $this -> getDomainCommon($this -> getColumnData($row, COLUMN_WL_ID)) . '/ja/register.php?reference=' . $this -> getColumnData($row, COLUMN_AGENT_CODE) . '</td>'
						. '<td class="r">' . $this -> getColumnData($row, COLUMN_AGENT_COUNTER) . '</td>'
						. '<td class="r">' . $this -> getColumnData($row, COLUMN_USER_COUNTER) . '</td>'
						. '<td class="blocka"><a href="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="9">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoAgentCommissionHeader() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$currencies	= null;

		$currencies			= $this -> getCurrencyList();
		$this -> currencies	= array();

		// データの存在確認
		if($this -> isLoopData($currencies)) {
			foreach($currencies as $currency) {
				$rtn .= '<th class="w10p">' . $currency[PARAM_DATA_VALUE] . '</th>';

				// データストック用
				$this -> currencies[$currency[PARAM_DATA_VALUE]] = array();
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoAgentCommissionList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$lists			= array();
		$fees			= null;
		$commissionData	= NO_STRING;
		$title			= NO_STRING;
		$row			= null;
		$totalRow		= array();

		// まずはデータを入れなおす
		foreach($this -> rs as $row) {

			// キーデータ
			$fee		= $row[COLUMN_M_F_ID];
			$walletType	= $row[COLUMN_WALLET_TYPE];
			$currency	= $row[COLUMN_CURRENCY];

			$lists[$fee][$walletType][$currency] = $row;
		}

		if($this -> isLoopData($lists)) {

			foreach($lists as $fee) {

				foreach($fee as $walletType => $currency) {

					$commissionData = NO_STRING;

					foreach($this -> currencies as $key => $val) {

						$row = $this -> getColumnData($currency, $key);

						if($row != NO_STRING) {
							$title = $this -> getColumnData($row, COLUMN_FEE_NAME) . '(' . $this -> getColumnData($row, COLUMN_COMMISION_TYPE) . ')';
						}

						$data = intval($this -> getColumnData($row, COLUMN_FIX) + $this -> getColumnData($row, COLUMN_PERCENT));

						if(isset($totalRow[$key])) {
							$totalRow[$key] += $data;
						} else {
							$totalRow[$key] = $data;
						}


						// データの取り出し
						$commissionData	.=  '<td class="r">' . $this -> getAmountString($data, $key) . '</td>';
					}

					$rtn	.= '<tr>'
							. '<td>' . $title . '</td>'
							. $commissionData
							. '</tr>';
				}
			}

			// 合計行の取得
			$rtn .= '<tr class="sum">'
					. '<th>合計</th>';

			foreach($this -> currencies as $key => $val) {
				$rtn .= '<td class="r">' . $this -> getAmountString($totalRow[$key], $key) . '</td>';
			}

			$rtn .= '</tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoChildrenList() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> isLoopData($this -> chirdren)) {

			$rtn = '<ul class="disc mt10">';

			// データの数だけループを回す
			foreach($this -> chirdren as $row) {
				$rtn .= '<li>' . $this -> getColumnData($row, COLUMN_USER_NAME) . '</li>';
			}

			$rtn .= '</ul>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoCommisionList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$paramName		= NO_STRING;
		$parentPercent	= NO_STRING;
		$parentFix		= NO_STRING;

		if($this -> isLoopData($this -> commision)) {

			// データの数だけループを回す
			foreach($this -> commision as $row) {

				$rtn	.= '<tr>'
						. '<td class="w40p">' . $this -> getColumnData($row, COLUMN_FEE_NAME) . '（' . $this -> getColumnData($row, COLUMN_COMMISION_TYPE) . '）</td>';

						$paramName	= $this -> getColumnData($row, COLUMN_M_F_ID) . DELIMIT_UNDER_BAR . $this -> getColumnData($row, COLUMN_WALLET_TYPE);

						// 親がいなければGOD!
						if($this -> parent == NO_STRING) {
							$parentPercent	= $this -> getAmountString(VAL_INT_10000, PERCENT);
							$parentFix		= $this -> getAmountString(VAL_INT_10000, USD);

						} else {
							$parentPercent	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WHOLE_PERCENT), PERCENT);
							$parentFix		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WHOLE_FIX), USD);
						}

						$rtn	.=  '<td class="w10p">' . $parentPercent . ' %</td>'
								. '<td class="w10p">&#036; ' . $parentFix . ' </td>'
								. '<td class="w10p"><input type="text" id="' . $paramName . '_percent" name="' . $paramName . '_percent" value="' . $this -> getAmountString($this -> getColumnData($row, COLUMN_PERCENT), PERCENT) . '" class="w70p ralign" /> %</td>'
								. '<td class="w10p">&#036; <input type="text" id="' . $paramName . '_fix" name="' . $paramName . '_fix" value="' . $this -> getAmountString($this -> getColumnData($row, COLUMN_FIX), USD) . '" class="w70p ralign" /></td>'
								. '<td class="w10p"><input type="text" id="' . $paramName . '_children_percent" name="' . $paramName . '_children_percent" value="' . $this -> getAmountString($this -> getColumnData($row, COLUMN_CHILDREN_PERCENT), PERCENT) . '" class="w70p ralign" /> %</td>'
								. '<td class="w10p">&#036; <input type="text" id="' . $paramName . '_children_fix" name="' . $paramName . '_children_fix" value="' . $this -> getAmountString($this -> getColumnData($row, COLUMN_CHILDREN_FIX), USD) . '" class="w70p ralign" /></td>';

				$rtn	.=  '</tr>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 詳細IDの取得
	* @parameter	: なし
	* @return		: 詳細ID
	-------------------------------------------------------------------------*/
	public function getDId() {
		return $this -> dId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッション取得用IDの取得
	* @parameter	: なし
	* @return		: コミッション取得用ID
	-------------------------------------------------------------------------*/
	public function getCommisionID() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> parent == NO_STRING) {
			$rtn = $this -> agentCode;
		} else {
			$rtn = $this -> parent;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function getAgentCode() {
		return $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function echoAgentCode() {
		echo $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードデータ適用年
	* @parameter	: なし
	* @return		: カードデータ適用年
	-------------------------------------------------------------------------*/
	public function getYear() {
		return $this -> year;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード報酬合計
	* @parameter	: なし
	* @return		: カード報酬合計
	-------------------------------------------------------------------------*/
	public function dispTotal() {
		echo $this -> formatCurrency($this -> total, USD) ;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードデータ適用月
	* @parameter	: なし
	* @return		: カードデータ適用月
	-------------------------------------------------------------------------*/
	public function getMonth() {
		return $this -> month;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoEmail() {
		echo $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 所属WLの取得
	* @parameter	: なし
	* @return		: 所属WL
	-------------------------------------------------------------------------*/
	public function echoWLName() {
		/**
		 *
		 * 2019/04/11
		 * anton
		 *
		 */
		
		echo ($this -> lang == "en" ? "IWL Headquarters" : $this -> dispWhiteLabelNameCommon($this -> wlId));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日の取得
	* @parameter	: なし
	* @return		: 生年月日
	-------------------------------------------------------------------------*/
	public function getBirth() {
		return $this -> birth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日の取得
	* @parameter	: なし
	* @return		: 生年月日
	-------------------------------------------------------------------------*/
	public function echoBirth() {
		echo $this -> birth;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 生年月日（年）の取得
	* @parameter	: なし
	* @return		: 生年月日（年）
	-------------------------------------------------------------------------*/
	public function getBirthYear() {
		return $this -> birthYear;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 生年月日（月）の取得
	* @parameter	: なし
	* @return		: 生年月日（月）
	-------------------------------------------------------------------------*/
	public function getBirthMonth() {
		return $this -> birthMonth;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 生年月日（日）の取得
	* @parameter	: なし
	* @return		: 生年月日（日）
	-------------------------------------------------------------------------*/
	public function getBirthDay() {
		return $this -> birthDay;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoCountry() {
		echo $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の表示
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function dispCountry() {
		echo $this -> dispCountryOptionList($this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の表示
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoCountryName() {
		echo $this -> dispCountryCommon($this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の取得
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	public function echoState() {
		echo $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の取得
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	public function echoCity() {
		echo $this -> city;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 住所1の取得
	* @parameter	: なし
	* @return		: 住所1
	-------------------------------------------------------------------------*/
	public function echoAddress1() {
		echo $this -> address1;
	}

	/*-------------------------------------------------------------------------
	  @function_name: 住所2の取得
	* @parameter	: なし
	* @return		: 住所2
	-------------------------------------------------------------------------*/
	public function echoAddress2() {
		echo $this -> address2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function echoZipCode() {
		echo $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function getEmail() {
		return $this -> email;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function getLastName() {
		return $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function getFirstName() {
		return $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function getCountry() {
		return $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の取得
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	public function getState() {
		return $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の取得
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	public function getCity() {
		return $this -> city;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 住所1の取得
	* @parameter	: なし
	* @return		: 住所1
	-------------------------------------------------------------------------*/
	public function getAddress1() {
		return $this -> address1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 住所2の取得
	* @parameter	: なし
	* @return		: 住所2
	-------------------------------------------------------------------------*/
	public function getAddress2() {
		return $this -> address2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function getZipCode() {
		return $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function getTel() {
		return $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function getPassword() {
		return NO_STRING;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	public function getAccountType() {
		return NO_COUNT;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 親エージェントの取得
	* @parameter	: なし
	* @return		: 親エージェント
	-------------------------------------------------------------------------*/
	public function getParent() {
		return $this -> parent;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 親エージェントの取得
	* @parameter	: なし
	* @return		: 親エージェント
	-------------------------------------------------------------------------*/
	public function echoParent() {
		echo $this -> parent;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 会社名の取得
	* @parameter	: なし
	* @return		: 会社名
	-------------------------------------------------------------------------*/
	public function echoCorporationName() {
		echo $this -> corporationName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行名の取得
	* @parameter	: なし
	* @return		: 銀行名
	-------------------------------------------------------------------------*/
	public function echoBankName() {
		echo $this -> bankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoSEmail() {
		echo $this -> sEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名前の取得
	* @parameter	: なし
	* @return		: 名前
	-------------------------------------------------------------------------*/
	public function echoSName() {
		echo $this -> sName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function echoSAgentCode() {
		echo $this -> sAgentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開始日の取得
	* @parameter	: なし
	* @return		: 開始日
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 終了日の取得
	* @parameter	: なし
	* @return		: 終了日
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 親エイリアスの取得
	* @parameter	: なし
	* @return		: 親エイリアス
	-------------------------------------------------------------------------*/
	public function echoParentName() {
		echo $this -> parentName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索月の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispSearchDate() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$cnt			= NO_COUNT;
		$currentDate	= NO_STRING;
		$lists			= array();

		// 月数のループ（とりあえず1年）
		for($cnt = NO_COUNT; $cnt < VAL_INT_12; $cnt++) {

			$date = date('Y-m', strtotime('-' . $cnt  . ' month'));

			$lists[] = array(PARAM_DATA_KEY		=> date('Y-m', strtotime('-' . $cnt  . ' month'))
							, PARAM_DATA_VALUE	=> date('Y-m', strtotime('-' . $cnt  . ' month')));
		}

		echo $this -> dispListOption($lists, $this -> getPosParameter(PARAM_DATE));
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェント追加ボックス
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoAddAgent() {
			
		// anton
		if($this -> parent == NO_STRING) {
			echo '<input type="text" id="add_code" value="" class="w50p"> <input type="button" id="btnAddAent" value="'.VAL_STR_ADMIN_ADD.'" class="btn bg-grad px50 hi20 fontXX">';
		} else {
			echo VAL_STR_ADMIN_EAGENT;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = intval($this -> amount);			// 金額
		$rtn[] = $this -> accountName;				// 口座名義
		$rtn[] = $this -> receiptCountry;			// 受取人国
		$rtn[] = $this -> receiptAddress1;			// 受取人住所1
		$rtn[] = $this -> receiptAddress2;			// 受取人住所2
		$rtn[] = $this -> receiptMessage;			// 受取人メッセージ
		$rtn[] = $this -> receiptBankName;			// 受取銀行名
		$rtn[] = $this -> receiptBankSwift;			// 受取銀行SWIFT
		$rtn[] = $this -> receiptBankCountry;		// 受取銀行国
		$rtn[] = $this -> receiptBankAddress1;		// 受取銀行住所1
		$rtn[] = $this -> receiptBankAddress2;		// 受取銀行住所2
		$rtn[] = $this -> accountNumber;			// 受取銀行口座番号
		$rtn[] = intval($this -> intermediaryFlg);	// 中継銀行フラグ
		$rtn[] = $this -> intermediaryBankName;		// 中継銀行名
		$rtn[] = $this -> intermediaryBankSwift;	// 中継銀行SWIFT
		$rtn[] = $this -> intermediaryBankCountry;	// 中継銀行国
		$rtn[] = $this -> intermediaryBankAddress1;	// 中継銀行住所1
		$rtn[] = $this -> intermediaryBankAddress2;	// 中継銀行住所2
		$rtn[] = $this -> intermediaryBankMessage;	// 中継銀行メッセージ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェント一覧の設定
	* @parameter	: エージェント一覧
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントの設定
	* @parameter	: エージェント
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setAgent($rs) {
		$this -> agent = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントの設定
	* @parameter	: エージェント
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setAccount($rs) {
		$this -> rs = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 子エージェントの設定
	* @parameter	: 子エージェントリスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setChirdren($rs) {
		$this -> chirdren = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料一覧の取得
	* @parameter	: なし
	* @return		: 手数料一覧
	-------------------------------------------------------------------------*/
	public function getCommision() {
		return $this -> commision;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 為替手数料IDの取得
	* @parameter	: なし
	* @return		: 為替手数料ID
	-------------------------------------------------------------------------*/
	public function getExchangeFeeId() {
		return $this -> exchangeFeeId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード手数料の取得
	* @parameter	: キー
	* @return		: カード手数料
	-------------------------------------------------------------------------*/
	public function echoCardCommission($key = VAL_INT_1) {
		echo $this -> intToCurrency(intval($this -> getColumnData($this -> getRowData($this -> cardCommissions, $key), COLUMN_AMOUNT)), USD);
	}


	/*-------------------------------------------------------------------------
	* @function_name: 手数料一覧の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispFeeList() {
		echo $this -> dispListOption($this -> getFeeListCommon(), $this -> commisionId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 為替手数料一覧の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispExchangeFeeList() {

		// 変数宣言部
		$list = array();

		if($this -> isLoopData($this -> patterns)) {

			foreach($this -> patterns as $row) {

				$list[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_M_F_ID)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_PATTERN_NAME));
			}
		}

		echo $this -> dispListOption($list, $this -> exchangeFeeId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 為替手数料一覧データの取得
	* @parameter	: なし
	* @return		: 為替手数料一覧データ
	-------------------------------------------------------------------------*/
	public function echoExchangeFeeList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$currencies	= null;
		$from		= NO_STRING;
		$to			= NO_STRING;
		$whole		= NO_COUNT;
		$markup		= NO_COUNT;
		$fees		= array();
		$pId		= NO_COUNT;

		if($this -> exchangeFeeId !== NO_STRING) {
			$pId = $this -> exchangeFeeId;
		}

		// 為替手数料データの取得
		$fees = $this -> getExchangeFeeCommon($pId);

		// 通貨データを取得
		$currencies = $this -> getCurrencyList();

		if($this -> isLoopData($currencies)) {	// データが存在する場合

			// 各通貨のレートを設定する
			foreach($currencies as $name => $val) {

				// From通貨
				$from = $this -> getColumnData($val, PARAM_DATA_KEY);

				foreach($currencies as $nameSub => $valSub){

					// From通貨
					$to = $this -> getColumnData($valSub, PARAM_DATA_KEY);

					// 手数料データが存在するか否か
					if(isset($fees[$from][$to])) {
						$whole	= $this -> intToCurrency($fees[$from][$to][COLUMN_WHOLE], PERCENT);
						$markup	= $this -> intToCurrency($fees[$from][$to][COLUMN_MARKUP], PERCENT);
					} else {
						$whole	= $this -> intToCurrency(NO_COUNT, PERCENT);
						$markup	= $this -> intToCurrency(NO_COUNT, PERCENT);
					}

					// 同一通貨以外の場合リスト表示
					if($from != $to) {
						$rtn .= '<tr>'
								. '<td>' . $from . '</td>'
								. '<td>' . $to . '</td>'
								. '<td><span id="whole_' . $from . DELIMIT_UNDER_BAR . $to . '">' . $whole . '</span>&nbsp;%</td>'
								. '<td><input type="text" class="w80p ralign" id="share_' . $from . DELIMIT_UNDER_BAR . $to . '" name="share_' . $from . DELIMIT_UNDER_BAR . $to . '" value="' . $whole . '" />&nbsp;%</td>'
								. '<td><input type="text" class="w80p ralign" id="bottom_' . $from . DELIMIT_UNDER_BAR . $to . '" name="bottom_' . $from . DELIMIT_UNDER_BAR . $to . '" value="' . $whole . '" />&nbsp;%</td>'
								. '</tr>';
					}
				}
			}

		} else {								// データが存在しない場合
			$rtn = '<tr><td colspan="3">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料一覧の設定
	* @parameter	: 手数料一覧
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCommision($rs) {
		$this -> commision = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード手数料一覧の設定
	* @parameter	: カード手数料
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCardCommissions($rs) {

		$this -> cardCommissions	= array();
		$this -> total				= NO_COUNT;

		// データの存在確認
		if($this -> isLoopData($rs)) {

			foreach($rs as $row) {
				$this -> cardCommissions[$this -> getColumnData($row, COLUMN_TYPE)] = $row;

				$this -> total += $this -> getColumnData($row, COLUMN_AMOUNT);
			}

			$this -> total = $this -> intToCurrency($this -> total, USD);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パターンリストデータの設定
	* @parameter	: パターンリストデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setPatterns($rs) {
		$this -> patterns = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータの取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	public function getUpdateDatas() {

		// 変数宣言部
		$rtn = array();

		// データの設定
		$rtn[] = $this -> dId;
		$rtn[] = $this -> corporationName;
		$rtn[] = $this -> commisionId;
		$rtn[] = $this -> exchangeFeeId;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータの取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	public function getRegistAgentCommisionDatas($mFId, $type) {

		// 変数宣言部
		$rtn = array();

		// データの設定
		$rtn[] = $this -> agentCode;
		$rtn[] = $mFId;
		$rtn[] = $type;
		$rtn[] = $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_percent'), PERCENT);
		$rtn[] = $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_fix'), USD);
		$rtn[] = $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_percent'), PERCENT);
		$rtn[] = $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_fix'), USD);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータの取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	public function getRegistExchangeCommisionDatas($from, $to) {

		// 変数宣言部
		$rtn = array();


		$rtn[] = $this -> agentCode;
		$rtn[] = $this -> exchangeFeeId;
		$rtn[] = $from;
		$rtn[] = $to;
		$rtn[] = $this -> currencyToInt(floatval($this -> getPosParameter('share_' . $from . DELIMIT_UNDER_BAR . $to)), PERCENT);
		$rtn[] = $this -> currencyToInt(floatval($this -> getPosParameter('bottom_' . $from . DELIMIT_UNDER_BAR . $to)), PERCENT);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータの取得
	* @parameter	: なし
	* @return		: 更新用データ
	-------------------------------------------------------------------------*/
	public function getRegistCardCommissionDatas() {

		// 変数宣言部
		$rtn	= array();
		$cnt	= VAL_INT_1;

		for($cnt = VAL_INT_1; $cnt <= VAL_INT_100; $cnt++) {

 			if(isset($_POST['card_commission_' . $cnt])) {
 				$rtn[] = '((\')' . $this -> agentCode . '(\'), (\')' . $this -> currencyToInt(floatval($this -> getPosParameter('card_commission_' . $cnt)), USD) . '(\'), (\')' . $cnt . '(\'), (\')' . $this -> year . '-' . $this -> month . '-01 00:00:00(\'))';
			} else {
				break;
			}
		}

		return array(implode(DELIMIT_COMMA, $rtn));
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションデータ取得用パラメータ取得
	* @parameter	: なし
	* @return		: コミッションデータ取得用パラメータ
	-------------------------------------------------------------------------*/
	public function getSelectData() {

		// 変数宣言部
		$params	= array();
		$date	= null;

		// 現在の日時を取得
		$date = getdate();

		$params[] = $this -> agentCode;
		$params[] = $date[PARAM_YEAR];
		$params[] = $date[PARAM_MON];

		return $params;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
				, count($this -> rs)
				, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function getActivity() {

		$type 					= $this -> getType();
		$message 				= NO_STRING; 
		$details 				= array(); 
		$dId				    = $this -> dId;
		$newCorpName			= $this -> corporationName;
		$newCommId				= $this -> commisionId;
		$newExchangeFeeId		= $this -> exchangeFeeId;

		if($type == TYPE_COMPLETE){

			$row 					= $this -> getAccountCommon($this -> getUserAccount());
			$firstName 				= $this -> getColumnData($row[0], COLUMN_FIRST_NAME);
			$lastName 				= $this -> getColumnData($row[0], COLUMN_LAST_NAME);
			
			$message = 'Created agent code for user '.$this -> getUserAccount().' '.$firstName. ' '.$lastName;
		
		}elseif($type == TYPE_SAVE){

			$row 					= $this -> accessSelect('SELECT_AGENT', array($this -> getDId()));
			$firstName 				= $this -> getColumnData($row[0], COLUMN_FIRST_NAME);
			$lastName 				= $this -> getColumnData($row[0], COLUMN_LAST_NAME);
		  	$origCorpName 			= $this -> getColumnData($row[0], COLUMN_CORPORATION_NAME);
		  	$origCommId 			= $this -> getColumnData($row[0], COLUMN_COMMISION_ID);
		  	$origExchangeFeeId 		= $this -> getColumnData($row[0], COLUMN_EXCHANGE_COMMISION_ID);

		  	if($origCorpName != $newCorpName){
		  		$details[] .= 'Alias from ['.($origCorpName).'] to ['.($newCorpName).']';
		  	}

		  	if($origCommId != $newCommId){
		  		$details[] .= 'General Fee Setting from ['.$this -> getFeeName($origCommId).'] to ['.$this -> getFeeName($newCommId).']';
		  	}

		  	if($origExchangeFeeId != $newExchangeFeeId){
		  		$details[] .= 'Exchange Fee Setting from ['.$this -> getPatternName($origExchangeFeeId).'] to ['.$this -> getPatternName($newExchangeFeeId).']';
		  	}

		  	$qkey = ($this -> lang == "en" ? 'LIST_AGENT_COMMISION_EN' : 'LIST_AGENT_COMMISION');
		  	$rs   = $this -> accessSelect($qkey, array($this -> getAgentCode(), $this -> getParent()));

		  	foreach ($rs as $value) {

		  		$feeName[] 				= $this -> getColumnData($value, COLUMN_FEE_NAME);
		  		$commissionType[] 		= $this -> getColumnData($value, COLUMN_COMMISION_TYPE);
		  		$origPercent[] 			= $this -> getColumnData($value, COLUMN_PERCENT);
		  		$origFix[] 				= $this -> getColumnData($value, COLUMN_FIX);
		  		$origChildPercent[] 	= $this -> getColumnData($value, COLUMN_CHILDREN_PERCENT);
		  		$origChildFix[] 		= $this -> getColumnData($value, COLUMN_CHILDREN_FIX);
		  		
		  	}
		  	
		  	$defaultCommision = $this -> getDefaultCommisionData();

		  	if($this -> isLoopData($defaultCommision)) {

				foreach($defaultCommision as $value2) {

					$mFId 					= $this -> getColumnData($value2, COLUMN_M_F_ID);
					$type 					= $this -> getColumnData($value2, COLUMN_WALLET_TYPE);

					$newPercent[] 			= $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_percent'), PERCENT);
					$newFix[]				= $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_fix'), USD);
					$newChildPercent[] 		= $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_percent'), PERCENT);
					$newChildFix[] 			= $this -> currencyToInt($this -> getDataPost($mFId . DELIMIT_UNDER_BAR . $type . '_children_fix'), USD);
					
					
				}

				for($cnt = 0; $cnt < (count($rs)); $cnt++){
			
					if($this -> getAmountString($origPercent[$cnt], PERCENT) != $this -> getAmountString($newPercent[$cnt], PERCENT)){
						$details[] .= $feeName[$cnt] .' ('.$commissionType[$cnt].') Acquisition Percent from ['.$this -> getAmountString($origPercent[$cnt], PERCENT).'] to ['.$this -> getAmountString($newPercent[$cnt], PERCENT).']';
					}

					if($this -> getAmountString($origFix[$cnt], USD) != $this -> getAmountString($newFix[$cnt], USD)){
						$details[] .= $feeName[$cnt] .' ('.$commissionType[$cnt].') Acquisition Fix from ['.$this -> getAmountString($origFix[$cnt], USD).'] to ['.$this -> getAmountString($newFix[$cnt], USD).']';
					}

					if($this -> getAmountString($origChildPercent[$cnt], PERCENT) != $this -> getAmountString($newChildPercent[$cnt], PERCENT)){
						$details[] .= $feeName[$cnt] .' ('.$commissionType[$cnt].') Downward Wholesale Percent from ['.$this -> getAmountString($origChildPercent[$cnt], PERCENT).'] to ['.$this -> getAmountString($newChildPercent[$cnt], PERCENT).']';
					}

					if($this -> getAmountString($origChildFix[$cnt], USD) != $this -> getAmountString($newChildFix[$cnt], USD)){
						$details[] .= $feeName[$cnt] .' ('.$commissionType[$cnt].') Downward Wholesale Fix from ['.$this -> getAmountString($origChildFix[$cnt], USD).'] to ['.$this -> getAmountString($newChildFix[$cnt], USD).']';
					}

				}
				 
			}

			$exchangeFee = $this -> getExchangeFeeCommon($newExchangeFeeId);
			$rs2	     = $this -> accessSelect('LIST_COMMISION_EXCHANGE', array($this -> agentCode));

			if($this -> isLoopData($rs2)) {
				foreach($rs2 as $row) {
					$list[$this -> getColumnData($row, COLUMN_FROM_CURRENCY) . $this -> getColumnData($row, COLUMN_TO_CURRENCY)] = $row;
				}
			}

			if($this -> isLoopData($exchangeFee)) {

				foreach($exchangeFee as $key => $val) {

					$from = $key;

					foreach($val as $keySub => $valSub){
						$to = $keySub;

						$row = $this -> getColumnData($list, $from . $to);

						if($from != $to){
							
							$newAcquisition[] 		= $this -> getAmountString($this -> currencyToInt(floatval($this -> getPosParameter('share_' . $from . DELIMIT_UNDER_BAR . $to)), PERCENT), PERCENT);
							$newDownward[] 			= $this -> getAmountString($this -> currencyToInt(floatval($this -> getPosParameter('bottom_' . $from . DELIMIT_UNDER_BAR . $to)), PERCENT),PERCENT);
							$origAcquisition[] 		= $this -> getAmountString($this -> getColumnData($row, COLUMN_PERCENT),PERCENT);
							$origDownward[] 		= $this -> getAmountString($this -> getColumnData($row, COLUMN_CHILDREN_PERCENT),PERCENT);

							$currencyFrom[] 		= $from;
							$currencyTo[]			= $to;

						}
										
					}
				}
				if((count($origAcquisition)) == (count($rs2))){
					for($cnt = 0; $cnt < (count($rs2)); $cnt++){
					
							if($origAcquisition[$cnt] != $newAcquisition[$cnt]){
								$details[] .= $currencyFrom[$cnt] .'->'. $currencyTo[$cnt] .' Acquisition Value from ['.$origAcquisition[$cnt].'] to ['.$newAcquisition[$cnt].']';
							}
						
							if($origDownward[$cnt] != $newDownward[$cnt]){
								$details[] .= $currencyFrom[$cnt] .'->'. $currencyTo[$cnt] .' Downward Wholesale Price from ['.$origDownward[$cnt].'] to ['.$newDownward[$cnt].']';
							}

					}
				}
			}

		  	if($details != NULL){
		  		$message = 'Edited '.$dId.' '.$lastName .' '.$firstName.'\'s '. implode(', <br/>', $details);
		  	}else{
		  		$message = 'Saved without any changes';
		  	}
		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 20;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}
}
?>