<?php
class AccountDuplicateModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs 			= null;
	private $Mail			= NO_STRING;
	private $accountNumber	= NO_STRING;	// 口座番号
	private $lastName		= NO_STRING;	// 姓
	private $firstName		= NO_STRING;	// 名
	private $status			= NO_STRING;	// 状態
	private $birth			= NO_STRING;
	private $accountType 	= NO_STRING;
	private $country		= NO_STRING;	// 国
	private $address		= NO_STRING;	// 番地1
	private $loginFrom		= NO_STRING;	// 開始日（最終ログイン日）
	private $loginTo		= NO_STRING;	// 終了日（最終ログイン日）
	private $closeFrom		= NO_STRING;	// 開始日（口座閉鎖日）
	private $closeTo		= NO_STRING;	// 終了日（口座閉鎖日）
	private $loginFlg		= NO_STRING;	// ログイン日検索フラグ
	private $closeFlg		= NO_STRING;	// 閉鎖日検索フラグ
	private $arrValidate	= array();

	//search parameters
	private $sMail			= NO_STRING;
	private $sAccountNumber	= NO_STRING;
	private $sName 			= NO_STRING;
	
	/**
	 *
	 * anton
	 *
	 */
	private $lang			= NO_STRING;
	private $sort           = NO_STRING;

	/**
	 * DN053
	 */
	private $doaoFrom       = NO_STRING;
	private $doaoTo         = NO_STRING;
	private $dobFrom        = NO_STRING;
	private $dobTo          = NO_STRING;
	private $direction      = NO_STRING;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
	    $this -> sort                       =   (!empty($this -> getDataPost(PARAM_SORT)) ? $this -> getDataPost(PARAM_SORT) : $this -> getDataGet(PARAM_SORT));
	    
		$this -> sMail						= 	$this -> getDataPost(PARAM_EMAIL);
		$this -> sAccountNumber				=	$this -> getDataPost(PARAM_USER_ACCOUNT);
		$this -> sName 						= 	$this -> getDataPost(PARAM_NAME);
		$this -> doaoFrom                   =   (!empty($this -> getDataPost(PARAM_DOAO_FROM)) ? $this -> getDataPost(PARAM_DOAO_FROM) : $this -> getDataGet(PARAM_DOAO_FROM));
		$this -> doaoTo                     =   (!empty($this -> getDataPost(PARAM_DOAO_TO)) ? $this -> getDataPost(PARAM_DOAO_TO) : $this -> getDataGet(PARAM_DOAO_TO));
		$this -> dobFrom                    =   (!empty($this -> getDataPost(PARAM_DOB_FROM)) ? $this -> getDataPost(PARAM_DOB_FROM) : $this -> getDataGet(PARAM_DOB_FROM));
		$this -> dobTo                      =   (!empty($this -> getDataPost(PARAM_DOB_TO)) ? $this -> getDataPost(PARAM_DOB_TO) : $this -> getDataGet(PARAM_DOB_TO));
		$this -> direction                  =   $this -> getDataGet(PARAM_DIRECTION);
		$this -> lang						=   $this -> getLangage();
		$this -> country                    =   $this -> getDataPost(PARAM_COUNTRY);
		
		$dpvar = ["doaoFrom", "doaoTo", "dobFrom", "dobTo"];
		
		foreach($dpvar as $var){
		    if($this -> $var == "(empty)")
		        $this -> $var = NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}
		
		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		 if(!$this -> checkAdminUserAccess('PDAL', array(''))){
		 	$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
		 	header('Location: /'.$redirect.'menu');
		 	exit();
		 }

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
				, count($this -> rs)
				, NO_STRING
				, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ一覧の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$row		= null;

	
		if($this -> isLoopData($this -> rs)) {

		    usort($this -> rs, function($a, $b){
		        $sorter = strcasecmp($a[COLUMN_LAST_NAME], $b[COLUMN_LAST_NAME]);
		        
		        switch($this -> direction){
		            case "up":
		                $dirOne = $a;
		                $dirTwo = $b;
		                break;
		            case "down":
		                $dirOne = $b;
		                $dirTwo = $a;
		                break;
		            default:
		                $dirOne = $a;
		                $dirTwo = $b;
		                break;
		        }
		       
		       switch($this -> sort){
		            case "threshold":
		                $sorter = $dirOne[COLUMN_USER_THRESHOLD] - $dirTwo[COLUMN_USER_THRESHOLD];
		                break;
		            case "doao":
		                $sorter = strtotime($dirOne[COLUMN_CREATE_TIME]) - strtotime($dirTwo[COLUMN_CREATE_TIME]);
		                break;
		        }
		        
		        return $sorter;
		    });
		    
			$listCount	= count($this -> rs);
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			
			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
			    $row = $this -> getRowData($this -> rs, $cnt);
			    
			    /* $dupsource = json_decode($this -> getColumnData($row, COLUMN_DUPLICATE_SOURCE));
			    if(count($dupsource) == 0)
			        continue; */
				
				$rtn .= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_MAIL) . '</td>'
						. '<td> <a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'</a></td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_LAST_NAME) . '&nbsp;' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
						//. '<td>' . $this -> dispKYCStatusCommon($this -> getColumnData($row, COLUMN_KYC_STATUS)) . '</td>'
						. '<td>' . date("Y-m-d", strtotime($this -> getColumnData($row, COLUMN_BIRTH))) . '</td>'
						// . '<td>' . $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '</td>'
						. '<td>' . $this -> dispCountryCommon($this -> getColumnData($row , COLUMN_COUNTRY)) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_ADDRESS) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						// . '<td>' . $this -> getColumnData($row, COLUMN_CLOSE_TIME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_USER_THRESHOLD) . '</td>'
						. '<td class="blocka"><a href="account_duplicate_com?user_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '"><span class="fa fa-info-circle fa-lg"></span></a></td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="16">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}
	
	public function echoToggleSortDirection(){
	    switch($this -> direction){
	        case "up":
	            echo "down";
	            break;
	        case "down":
	            echo "up";
	            break;
	        default:
	            echo "down";
	            break;
	    }
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 国の表示
	 * @parameter	: なし
	 * @return		: 国
	 -------------------------------------------------------------------------*/
	public function echoCountry() {
	    echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}
	
    /*-------------------------------------------------------------------------
	* @function_name: 口座状態の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispStatuses() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$sStatus	= array();
		$checked	= array();

		// 口座状態リストの取得
		$sStatus = $this -> getStatusList();

		// チェックリストの作成（デフォルト全取得）
		if(!is_array($this -> sStatus)) {

			if($this -> getType() == NO_STRING) {
				if($this -> isLoopData($sStatus)) {

					foreach($sStatus as $row) {
						$checked[$this -> getColumnData($row, PARAM_DATA_KEY)] = $this -> getColumnData($row, PARAM_DATA_KEY);
					}
				}
			}
		} else {

			foreach($this -> sStatus as $row) {
				$checked[$row] = $row;
			}
		}

		if($this -> isLoopData($sStatus)) {

			foreach($sStatus as $row) {
				$rtn .= '<label>' . $this -> makeCheckOne(PARAM_STATUSES . $row[PARAM_DATA_KEY], PARAM_STATUSES . '[]', $row[PARAM_DATA_KEY], $row[PARAM_DATA_VALUE] , $this -> getColumnData($checked, $row[PARAM_DATA_KEY])) . '</label>&emsp;';
			}
		}

		echo $rtn;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: 結果セット
	* @return		: 検索条件配列
	-------------------------------------------------------------------------*/
	function getWhere() {

		// 変数宣言部
		$where		= NO_STRING;
		$rtn		= array();

		//search via useraccount
		if($this -> sAccountNumber != NO_STRING) {
			$where .= ' AND user_account = (\')' . $this -> sAccountNumber . '(\')';
		}

		//search via name
		if($this -> sName != NO_STRING) {
			$where .= ' AND (first_name LIKE (\')%' . $this -> sName . '%(\') OR last_name LIKE (\')%' . $this -> sName . '%(\'))';
		}

		// メールアドレス
		if($this -> sMail != NO_STRING) {
			$where .= ' AND mail LIKE (\')%' . $this -> sMail . '%(\')';
		}
		
		if($this -> country != NO_STRING) {
		    $where .= ' AND country = (\')'. $this -> country . '(\')';
		}

		if($this -> doaoFrom != NO_STRING && $this -> doaoTo != NO_STRING) {
		    $where .= ' AND (cast(create_time as DATE) >= (\')'.$this -> doaoFrom.'(\') AND cast(create_time as DATE) <= (\')'.$this -> doaoTo.'(\'))';
		}
		
		if($this -> dobFrom != NO_STRING && $this -> dobTo != NO_STRING) {
		    $where .= ' AND (cast(birth as DATE) >= (\')'.$this -> dobFrom.'(\') AND cast(birth as DATE) <= (\')'.$this -> dobTo.'(\'))';
		}
		
		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		// $end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

		//chck if search is not search all
		// if($this -> getType() == TYPE_ADMIN_USER_SEARCH_ALL) {
		// 	$where = NO_STRING;
		// }

		$rtn[] = $where;
		$rtn[] = $page;

		return $rtn;
	}

	

	/*-------------------------------------------------------------------------
	* @function_name: 開設日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispOpenFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_DATE_TAGGED
											, PARAM_DATE_TAGGED
											, VAL_INT_1
											, NO_STRING, $this -> sDateTagged)
				. '</label>';
	}
	
	function echoKYCFlg() {
		$arrTmp = array();
		foreach($this -> arrValidate as $key=>$val){
			$arrTmp[$key][PARAM_DATA_KEY] = $key;
			$arrTmp[$key][PARAM_DATA_VALUE] = $val;
		}
		echo $this -> dispListOption($arrTmp, $this -> kycFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoTagFrom() {
		echo $this -> sTagFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoTagTo() {
		echo $this -> sTagTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> sName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の表示
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoAccountNumber() {
		echo $this -> sAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoMail() {
		echo $this -> sMail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: makeExportData()
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function makeExportData(){

		
		
		$data = ($this -> lang == "en" ?  "Email Address,Account Number,Name,KYC Status,Date of Birth,Account Type, Coutry, Address, Date of Account Opening, Date of Account Closing, Threshold\n" 
				: 'メールアドレス,口座番号,名前,KYC,生年月日,口座種別,国名,都道府県,開設日,口座閉鎖日,しきい値' . "\n"); 

		if($this -> isLoopData($this -> rs)){

			foreach($this -> rs as $row){

				$arr = array();

				$arr[] = $this -> getColumnData($row, COLUMN_MAIL);	
				$arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);	
				$arr[] = $this -> getColumnData($row, COLUMN_LAST_NAME) .' '.  $this -> getColumnData($row, COLUMN_FIRST_NAME);				
				$arr[] = $this -> getColumnData($row, COLUMN_VALIDATE_STATUS);					
				$arr[] = $this -> getColumnData($row, COLUMN_BIRTH);					
				$arr[] = $this -> getColumnData($row, COLUMN_ACCOUNT_TYPE);							
				$arr[] = $this -> getColumnData($row, COLUMN_COUNTRY);		
				$arr[] = $this -> getColumnData($row, COLUMN_ADDRESS);			
				$arr[] = $this -> getColumnData($row, COLUMN_CREATE_TIME_STRING);			
				$arr[] = $this -> getColumnData($row, COLUMN_CLOSE_TIME);			
				$arr[] = $this -> getColumnData($row, COLUMN_USER_THRESHOLD);					

                $data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";

			}

		}

		$this -> setExportDataCommon($data);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: echoDOAOFrom
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
	function echoDOAOFrom(){
	    echo $this -> doaoFrom;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: echoDOAOTo
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
	function echoDOAOTo(){
	    echo $this -> doaoTo;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: echoDOBFrom
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
	function echoDOBFrom(){
	    echo $this -> dobFrom;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: echoDOBTo
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
	function echoDOBTo(){
	    echo $this -> dobTo;
	}
}
?>