<?php
class NewsModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// 結果セット
	private $nId				= NO_COUNT;		// newsID
	private $title				= NO_STRING;	// タイトル
	private $body				= NO_STRING;	// 本文
	private $exposeTime			= NO_STRING;	// 公開日
	private $langage			= NO_COUNT;		// 言語
	private $status				= NO_COUNT;		// ステータス
	private $siteFlg			= NO_COUNT;		// サイトフラグ
	
	/**
	 *
	 * anton
	 *
	 */
	private $lang				= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> nId		= $this -> getDataPost(PARAM_N_ID);				// newsId
		$this -> title		= $this -> getDataPost(PARAM_NEWS_TITLE);		// タイトル
		$this -> body		= $this -> getDataPost(PARAM_NEWS_BODY);		// 本文
		$this -> exposeTime	= $this -> getDataPost(PARAM_NEWS_EXPOSE_TIME);	// 公開日
		$this -> langage	= $this -> getDataPost(PARAM_LANGAGE);			// 言語
		$this -> siteFlg	= $this -> getDataPost(PARAM_SITE_FLG);			// サイトフラグ
		$this -> status		= $this -> getDataPost(PARAM_STATUS);			// ステータス
		
		$this -> lang		= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('NOTC', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_REGITS) {
			//check access
			if(!$this -> checkAdminUserAccess('NOTC', array('', '1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('NDTL', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_CONFIRM || $this -> getType() == TYPE_UPDATE || $this -> getType() == TYPE_COMPLETE) {
			//check access
			if(!$this -> checkAdminUserAccess('NDTL', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('NDTL', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		// 登録時・更新時
		if($this -> getType() == TYPE_COMPLETE || $this -> getType() == TYPE_UPDATE) {

			// 公開日入力チェック
			if(!$this -> checkNull($this -> exposeTime)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_NEWS_EXPOSETIME));
				$rtn = false;
			}

			// タイトル入力チェック
			if(!$this -> checkNull($this -> title)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_NEWS_TITLE));
				$rtn = false;
			}

			// 本文入力チェック
			if(!$this -> checkNull($this -> body)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_NEWS_BODY));
				$rtn = false;
			}

			// リストに変更
			if(!$rtn) {
				$this -> setType(TYPE_REGITS);
				return $rtn;
			}

		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);

			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

				$row = $this -> getRowData($this -> rs, $cnt);

				// 言語
				if($this -> getColumnData($row, COLUMN_LANGAGE) == NO_COUNT) {
					$lang = 'ja';
				} else if($this -> getColumnData($row, COLUMN_LANGAGE) == VAL_INT_1) {
					$lang = 'en';
				} else if($this -> getColumnData($row, COLUMN_LANGAGE) == VAL_INT_2) {
					$lang = 'sc';
				} else if($this -> getColumnData($row, COLUMN_LANGAGE) == VAL_INT_3) {
					$lang = 'tc';
				} else if($this -> getColumnData($row, COLUMN_LANGAGE) == VAL_INT_4) {
					$lang = 'id';
				}

				// サイト
				if($this -> getColumnData($row, COLUMN_SITE_FLG) == NO_COUNT) {
					$site = 'i';
				} else if($this -> getColumnData($row, COLUMN_SITE_FLG) == VAL_INT_1) {
					$site = 'D';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_EXPOSE_TIME) . '</td>'
							. '<td>' . $lang . '</td>'
							. '<td>' . $site . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_NEWS_TITLE) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_NEWS_BODY) . '</td>'
							. '<td class="blocka"><a href="javascript:actionDetail(' . $this -> getColumnData($row, COLUMN_N_ID) . ');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/**
	 *
	 * anton --- 04/23/2019
	 * @param string $type
	 */
	public function echoTranslationData($action, $type = "regist"){
		if(strlen(trim($this -> nId)) > 0 && $type == "regist")
			$type = "detail";
		else if(strlen(trim($this -> nId)) == 0 && $type == "confirm")
			$type = "regist";
		
		echo  "<!-- Language Transition Data (Anton) 04/23/2016 -->
		<input class=\"lang-trans-data\" type=\"hidden\" id=\"lang_data_action\" value=\"{$action}\"/>
		<input class=\"lang-trans-data\" type=\"hidden\" id=\"lang_data_type\" value=\"{$type}\"/>
		<input class=\"lang-trans-data\" type=\"hidden\" id=\"lang_data_form\" value=\"#acForm\"/>
		<!-- /Language Transition Data -->" ;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	
	public function setDetail() {

		$row = $this -> rs[NO_COUNT];

		$this -> exposeTime = $this -> getColumnData($row, COLUMN_EXPOSE_TIME);
		$this -> title 		= $this -> getColumnData($row, COLUMN_NEWS_TITLE);
		$this -> body		= $this -> getColumnData($row, COLUMN_NEWS_BODY);
		$this -> langage	= $this -> getColumnData($row, COLUMN_LANGAGE);
		$this -> siteFlg	= $this -> getColumnData($row, COLUMN_SITE_FLG);
	}
	


	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> exposeTime;		// 公開日
		$rtn[] = $this -> title;			// タイトル
		$rtn[] = $this -> body;				// 本文
		$rtn[] = $this -> langage;			// 言語
		$rtn[] = $this -> siteFlg;			// サイトフラグ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 更新用のデータを取得
	 * @parameter	: なし
	 * @return		: 更新用データ
	 -------------------------------------------------------------------------*/
	public function getUpdateData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> nId;
		$rtn[] = $this -> exposeTime;		// 公開日
		$rtn[] = $this -> title;			// タイトル
		$rtn[] = $this -> body;				// 本文
		$rtn[] = $this -> langage;			// 言語
		$rtn[] = $this -> siteFlg;			// サイトフラグ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: newsIDの取得
	* @parameter	: なし
	* @return		: newsID
	-------------------------------------------------------------------------*/
	public function getNId() {
		return $this -> nId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ステータスの取得
	 * @parameter	: なし
	 * @return		: ステータス
	 -------------------------------------------------------------------------*/
	public function getStatus() {
		return $this -> status;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: newsIDの取得
	 * @parameter	: なし
	 * @return		: newsID
	 -------------------------------------------------------------------------*/
	public function echoNId() {
		echo $this -> nId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 公開日の取得
	 * @parameter	: なし
	 * @return		: 公開日
	 -------------------------------------------------------------------------*/
	public function echoExposeTime() {
		if($this -> getType() == TYPE_DETAIL) {
			echo $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_EXPOSE_TIME);
		} else {
			echo $this -> exposeTime;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: タイトルの取得
	 * @parameter	: なし
	 * @return		: タイトル
	 -------------------------------------------------------------------------*/
	public function echoTitle() {
		if($this -> getType() == TYPE_DETAIL) {
			echo $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_NEWS_TITLE);
		} else {
			echo $this -> title;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 本文の取得
	 * @parameter	: なし
	 * @return		: 本文
	 -------------------------------------------------------------------------*/
	public function echoBody() {
		if($this -> getType() == TYPE_DETAIL && $this -> status == NO_COUNT) {
			echo $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_NEWS_BODY);
		} else {
			echo $this -> body;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 言語の取得
	 * @parameter	: なし
	 * @return		: 言語
	 -------------------------------------------------------------------------*/
	public function echoLangageValue($value) {

		if($this -> getType() == TYPE_DETAIL && $this -> status == NO_COUNT) {
			if($this -> getColumnData($this -> rs[NO_COUNT], COLUMN_LANGAGE) == $value) {
				echo 'checked';
			}
		} else {
			if($value == VAL_INT_1) {
				echo 'checked';
			}
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: サイトの取得
	 * @parameter	: なし
	 * @return		: サイト
	 -------------------------------------------------------------------------*/
	public function echoSiteFlgValue($value) {
		if($this -> getType() == TYPE_DETAIL && $this -> status == NO_COUNT) {
			if($this -> getColumnData($this -> rs[NO_COUNT], COLUMN_SITE_FLG) == $value) {
				echo 'checked';
			}
		} else {
			if($this -> siteFlg == $value) {
				echo 'checked';
			}
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 登録ボタンの取得
	 * @parameter	: なし
	 * @return		: 登録ボタンタグ
	 -------------------------------------------------------------------------*/
	public function echoButton() {

		if($this -> nId == NO_STRING) {
			echo '<input type="button" id="btnComplete" value="'.VAL_STR_ADMIN_REGISTER.'" class="btn bg-grad px100 hi25">';
		} else {
			echo '<input type="button" id="btnUpdate" value="'.VAL_STR_BUTTON_UPDATE.'" class="btn bg-grad px100 hi25">&emsp;
					<input type="button" id="btnDelete" value="'.VAL_STR_BUTTON_DELETE.'" class="btn bg-grad px100 hi25">';
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パラメータの取得
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	public function echoParam() {

		if($this -> nId == NO_STRING) {
			echo '<a id="btnRegist" class="btn bg-default">&laquo; '.VAL_STR_BUTTON_BACK.'</a>';
		} else {
			echo '<a id="btnDetail" class="btn bg-default">&laquo; '.VAL_STR_BUTTON_BACK.'</a>';
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	: none
	* @return		: 
	-------------------------------------------------------------------------*/
	function getActivity(){

		$type 				 = $this -> getType();
		$nId			 	 = $this -> nId;
		$newTime			 = $this -> exposeTime;	
		$newTitle			 = $this -> title;		
		$newBody			 = $this -> body;		
		$newLanguage		 = $this -> langage;	
		$newSiteFlg			 = $this -> siteFlg;
		$origTime			 = $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_EXPOSE_TIME);	
		$origTitle			 = $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_NEWS_TITLE);		
		$origBody			 = $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_NEWS_BODY);		
		$origLanguage		 = $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_LANGAGE);	
		$origSiteFlg		 = $this -> getColumnData($this -> rs[NO_COUNT], COLUMN_SITE_FLG);
		$detail 			 = array();
   		

   		if($type == TYPE_UPDATE){
   			if($origTime != $newTime){
   				$details[] = 'release date from ['.$origTime.'] to ['.$newTime.']';
   			}

   			if($origTitle != $newTitle){
   				$details[] = 'title from ['.$origTitle.'] to ['.$newTitle.']';
   			}

   			if($origBody != $newBody){
   				$details[] = 'article';
   			}

   			if($origLanguage != $newLanguage){
   				$details[] = 'language from ['.$this -> dispLanguage($origLanguage).'] to ['.$this -> dispLanguage($newLanguage).']';
   			}

   			if($origSiteFlg != $newSiteFlg){
   				$details[] = 'site from ['.$this -> dispSite($origSiteFlg).'] to ['.$this -> dispSite($newSiteFlg).']';
   			}

   			if($details != NULL){
   				$message = 'Edited '. $newTitle .'\'s ' . implode(', <br/>', $details);
   			}else{
   				$message = 'Saved without any changes';
   			}
   		}elseif($type == TYPE_COMPLETE){
   			$message = 'Created '.$newTitle.' notice';
   		}elseif($type == TYPE_DELETE){
   			$message = 'Deleted '.$newTitle.' notice';
   		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 21;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}

	function dispLanguage($language){
		switch ($language) {
			case NO_COUNT:
				$rtn = 'ja';
				break;

			case VAL_INT_1:
				$rtn = 'en';
				break;

			case VAL_INT_2:
				$rtn = 'sc';
				break;

			case VAL_INT_3:
				$rtn = 'tc';
				break;

			case VAL_INT_4:
				$rtn = 'id';
				break;
		}

		return $rtn;
	}

	function dispSite($site){
		switch ($site) {
			case NO_COUNT:
				$rtn = 'iWallet';
				break;

			case VAL_INT_1:
				$rtn = 'D-Wallet';
				break;
		}
		
		return $rtn;
	}


}
?>